/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.util.TimeThread;

public class MonitorData {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private long buildDate = 0L;
    private ConcurrentHashMap<Short, ServerState> LDAPStates = new ConcurrentHashMap();
    private ConcurrentHashMap<Short, ChangeNumber> maxCNs = new ConcurrentHashMap();
    private ConcurrentHashMap<Short, Long> fmd = new ConcurrentHashMap();
    private ConcurrentHashMap<Short, Long> missingChanges = new ConcurrentHashMap();
    private ConcurrentHashMap<Short, Long> fmRSDate = new ConcurrentHashMap();

    public long getApproxDelay(short serverId) {
        Long afmd = this.fmd.get(serverId);
        if (afmd != null && afmd > 0L) {
            return (this.getBuildDate() - afmd) / 1000L;
        }
        return 0L;
    }

    public long getApproxFirstMissingDate(short serverId) {
        Long res = this.fmd.get(serverId);
        if (res != null) {
            return res;
        }
        return 0L;
    }

    public long getMissingChanges(short serverId) {
        Long res = this.missingChanges.get(serverId);
        if (res == null) {
            return 0L;
        }
        return res;
    }

    public void completeComputing() {
        String mds = "";
        for (Short lsiSid : this.LDAPStates.keySet()) {
            ServerState lsiState = this.LDAPStates.get(lsiSid);
            Long lsiMissingChanges = 0L;
            if (lsiState != null) {
                for (Short lsjSid : this.maxCNs.keySet()) {
                    ChangeNumber lsjMaxCN = this.maxCNs.get(lsjSid);
                    ChangeNumber lsiLastCN = lsiState.getMaxChangeNumber(lsjSid);
                    int missingChangesLsiLsj = ChangeNumber.diffSeqNum(lsjMaxCN, lsiLastCN);
                    mds = mds + "+ diff(" + lsjMaxCN + "-" + lsiLastCN + ")=" + missingChangesLsiLsj;
                    lsiMissingChanges = lsiMissingChanges + (long)missingChangesLsiLsj;
                }
            }
            mds = mds + "=" + lsiMissingChanges;
            this.missingChanges.put(lsiSid, lsiMissingChanges);
            if (!DebugLogger.debugEnabled()) continue;
            TRACER.debugInfo("Complete monitor data : Missing changes (" + lsiSid + ")=" + mds);
        }
        this.setBuildDate(TimeThread.getTime());
    }

    public String toString() {
        String mds = "Monitor data=\n";
        mds = mds + "Build date=" + this.getBuildDate();
        for (Short sid : this.fmRSDate.keySet()) {
            mds = mds + "\nRSData(" + sid + ")=\t " + "afmd=" + this.fmRSDate.get(sid);
        }
        for (Short sid : this.maxCNs.keySet()) {
            ChangeNumber cn = this.maxCNs.get(sid);
            mds = mds + "\nmaxCNs(" + sid + ")= " + cn.toString();
        }
        for (Short sid : this.LDAPStates.keySet()) {
            ServerState ss = this.LDAPStates.get(sid);
            mds = mds + "\nLSData(" + sid + ")=\t" + "state=[" + ss.toString() + "] afmd=" + this.getApproxFirstMissingDate(sid);
            if (this.getBuildDate() > 0L) {
                mds = mds + " missingDelay=" + this.getApproxDelay(sid);
            }
            mds = mds + " missingCount=" + this.missingChanges.get(sid);
        }
        mds = mds + "--";
        return mds;
    }

    public void setBuildDate(long buildDate) {
        this.buildDate = buildDate;
    }

    public long getBuildDate() {
        return this.buildDate;
    }

    public void setMaxCNs(ServerState state) {
        for (short sid : state) {
            ChangeNumber newCN = state.getMaxChangeNumber(sid);
            this.setMaxCN(sid, newCN);
        }
    }

    public void setMaxCN(short serverId, ChangeNumber newCN) {
        if (newCN == null) {
            return;
        }
        ChangeNumber currentMaxCN = this.maxCNs.get(serverId);
        if (currentMaxCN == null) {
            this.maxCNs.put(serverId, newCN);
        } else if (newCN.newer(currentMaxCN)) {
            this.maxCNs.replace(serverId, newCN);
        }
    }

    public ChangeNumber getMaxCN(short serverId) {
        return this.maxCNs.get(serverId);
    }

    public ServerState getLDAPServerState(short serverId) {
        return this.LDAPStates.get(serverId);
    }

    public void setLDAPServerState(short serverId, ServerState state) {
        this.LDAPStates.put(serverId, state);
    }

    public void setFirstMissingDate(short serverId, Long newFmd) {
        if (newFmd == null) {
            return;
        }
        Long currentfmd = this.fmd.get(serverId);
        if (currentfmd == null) {
            this.fmd.put(serverId, newFmd);
        } else if (newFmd != 0L && newFmd < currentfmd) {
            this.fmd.replace(serverId, newFmd);
        }
    }
}

