/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.AckMessage;
import org.opends.server.replication.protocol.DoneMessage;
import org.opends.server.replication.protocol.EntryMessage;
import org.opends.server.replication.protocol.ErrorMessage;
import org.opends.server.replication.protocol.InitializeRequestMessage;
import org.opends.server.replication.protocol.InitializeTargetMessage;
import org.opends.server.replication.protocol.MonitorMessage;
import org.opends.server.replication.protocol.MonitorRequestMessage;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ReplServerInfoMessage;
import org.opends.server.replication.protocol.ReplicationMessage;
import org.opends.server.replication.protocol.ResetGenerationId;
import org.opends.server.replication.protocol.RoutableMessage;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.protocol.WindowMessage;
import org.opends.server.replication.protocol.WindowProbe;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.util.StaticUtils;

public class ServerReader
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private short serverId;
    private ProtocolSession session;
    private ServerHandler handler;
    private ReplicationServerDomain replicationServerDomain;

    public ServerReader(ProtocolSession session, short serverId, ServerHandler handler, ReplicationServerDomain replicationServerDomain) {
        super(handler.toString() + " reader");
        this.session = session;
        this.serverId = serverId;
        this.handler = handler;
        this.replicationServerDomain = replicationServerDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block43: {
            Message message;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + (this.handler.isReplicationServer() ? " RS " : " LS") + " reader starting for serverId=" + this.serverId);
            }
            try {
                while (true) {
                    RoutableMessage initializeMsg;
                    ReplicationMessage msg;
                    if ((msg = this.session.receive()) instanceof AckMessage) {
                        AckMessage ack = (AckMessage)msg;
                        this.handler.checkWindow();
                        this.replicationServerDomain.ack(ack, this.serverId);
                        continue;
                    }
                    if (msg instanceof UpdateMessage) {
                        long referenceGenerationId = this.replicationServerDomain.getGenerationId();
                        if (referenceGenerationId > 0L && referenceGenerationId != this.handler.getGenerationId()) {
                            ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_FROM.get(msg.toString(), this.handler.getMonitorInstanceName()));
                            continue;
                        }
                        UpdateMessage update = (UpdateMessage)msg;
                        this.handler.decAndCheckWindow();
                        this.replicationServerDomain.put(update, this.handler);
                        continue;
                    }
                    if (msg instanceof WindowMessage) {
                        WindowMessage windowMsg = (WindowMessage)msg;
                        this.handler.updateWindow(windowMsg);
                        continue;
                    }
                    if (msg instanceof InitializeRequestMessage) {
                        initializeMsg = (InitializeRequestMessage)msg;
                        this.handler.process(initializeMsg);
                        continue;
                    }
                    if (msg instanceof InitializeTargetMessage) {
                        initializeMsg = (InitializeTargetMessage)msg;
                        this.handler.process(initializeMsg);
                        continue;
                    }
                    if (msg instanceof EntryMessage) {
                        EntryMessage entryMsg = (EntryMessage)msg;
                        this.handler.process(entryMsg);
                        continue;
                    }
                    if (msg instanceof DoneMessage) {
                        DoneMessage doneMsg = (DoneMessage)msg;
                        this.handler.process(doneMsg);
                        continue;
                    }
                    if (msg instanceof ErrorMessage) {
                        ErrorMessage errorMsg = (ErrorMessage)msg;
                        this.handler.process(errorMsg);
                        continue;
                    }
                    if (msg instanceof ResetGenerationId) {
                        ResetGenerationId genIdMsg = (ResetGenerationId)msg;
                        this.replicationServerDomain.resetGenerationId(this.handler, genIdMsg);
                        continue;
                    }
                    if (msg instanceof WindowProbe) {
                        WindowProbe windowProbeMsg = (WindowProbe)msg;
                        this.handler.process(windowProbeMsg);
                        continue;
                    }
                    if (msg instanceof ReplServerInfoMessage) {
                        ReplServerInfoMessage infoMsg = (ReplServerInfoMessage)msg;
                        this.handler.receiveReplServerInfo(infoMsg);
                        this.replicationServerDomain.receiveReplServerInfo(infoMsg, this.handler);
                        continue;
                    }
                    if (msg instanceof MonitorRequestMessage) {
                        MonitorRequestMessage replServerMonitorRequestMsg = (MonitorRequestMessage)msg;
                        this.handler.process(replServerMonitorRequestMsg);
                        continue;
                    }
                    if (msg instanceof MonitorMessage) {
                        MonitorMessage replServerMonitorMsg = (MonitorMessage)msg;
                        this.handler.process(replServerMonitorMsg);
                        continue;
                    }
                    if (msg == null) break;
                }
                message = ReplicationMessages.NOTE_READER_NULL_MSG.get(this.handler.toString());
                ErrorLogger.logError(message);
            }
            catch (IOException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " reader IO EXCEPTION for serverID=" + this.serverId + StaticUtils.stackTraceToSingleLineString(e) + " " + e.getLocalizedMessage());
                }
                message = ReplicationMessages.NOTE_SERVER_DISCONNECT.get(this.handler.toString());
                ErrorLogger.logError(message);
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " server reader for serverID=" + this.serverId + " is closing the session");
                }
                try {
                    this.session.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                this.replicationServerDomain.stopServer(this.handler);
                break block43;
            }
            catch (ClassNotFoundException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In RS <" + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " reader CNF EXCEPTION serverID=" + this.serverId + StaticUtils.stackTraceToSingleLineString(e));
                }
                message = ReplicationMessages.ERR_UNKNOWN_MESSAGE.get(this.handler.toString());
                ErrorLogger.logError(message);
                break block43;
                catch (Exception e3) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In RS <" + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " server reader EXCEPTION serverID=" + this.serverId + StaticUtils.stackTraceToSingleLineString(e3));
                    }
                    message = ReplicationMessages.NOTE_READER_EXCEPTION.get(this.handler.toString());
                    ErrorLogger.logError(message);
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " server reader for serverID=" + this.serverId + " is closing the session");
                    }
                    try {
                        this.session.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.replicationServerDomain.stopServer(this.handler);
                    break block43;
                }
                finally {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " server reader for serverID=" + this.serverId + " is closing the session");
                    }
                    try {
                        this.session.close();
                    }
                    catch (IOException e4) {}
                    this.replicationServerDomain.stopServer(this.handler);
                }
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + " server reader for serverID=" + this.serverId + " is closing the session");
            }
            try {
                this.session.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.replicationServerDomain.stopServer(this.handler);
            return;
        }
        if (!DebugLogger.debugEnabled()) return;
        TRACER.debugInfo("In RS " + this.replicationServerDomain.getReplicationServer().getMonitorInstanceName() + (this.handler.isReplicationServer() ? " RS" : " LDAP") + " server reader stopped for serverID=" + this.serverId);
    }
}

