/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import java.net.SocketException;
import java.util.NoSuchElementException;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.replication.server.ServerHandler;
import org.opends.server.util.StaticUtils;

public class ServerWriter
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ProtocolSession session;
    private ServerHandler handler;
    private ReplicationServerDomain replicationServerDomain;
    private short serverId;

    public ServerWriter(ProtocolSession session, short serverId, ServerHandler handler, ReplicationServerDomain replicationServerDomain) {
        super(handler.toString() + " writer");
        this.serverId = serverId;
        this.session = session;
        this.handler = handler;
        this.replicationServerDomain = replicationServerDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (DebugLogger.debugEnabled()) {
            if (this.handler.isReplicationServer()) {
                TRACER.debugInfo("Replication server writer starting " + this.serverId);
            } else {
                TRACER.debugInfo("LDAP server writer starting " + this.serverId);
            }
        }
        try {
            while (true) {
                UpdateMessage update;
                if ((update = this.replicationServerDomain.take(this.handler)) == null) {
                    return;
                }
                long referenceGenerationId = this.replicationServerDomain.getGenerationId();
                if (referenceGenerationId != this.handler.getGenerationId() || referenceGenerationId == -1L || this.handler.getGenerationId() == -1L) {
                    ErrorLogger.logError(ReplicationMessages.ERR_IGNORING_UPDATE_TO.get(this.replicationServerDomain.getReplicationServer().getMonitorInstanceName(), update.getDn(), this.handler.getMonitorInstanceName(), Long.toString(this.handler.getGenerationId()), Long.toString(referenceGenerationId)));
                    continue;
                }
                this.session.publish(update);
                continue;
                break;
            }
        }
        catch (NoSuchElementException e) {
            Message message = ReplicationMessages.NOTE_SERVER_DISCONNECT.get(this.handler.toString());
            ErrorLogger.logError(message);
            return;
        }
        catch (SocketException e) {
            Message message = ReplicationMessages.NOTE_SERVER_DISCONNECT.get(this.handler.toString());
            ErrorLogger.logError(message);
            return;
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_WRITER_UNEXPECTED_EXCEPTION.get(this.handler.toString() + " " + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            return;
        }
        finally {
            try {
                this.session.close();
            }
            catch (IOException e) {}
            this.replicationServerDomain.stopServer(this.handler);
            if (DebugLogger.debugEnabled()) {
                if (this.handler.isReplicationServer()) {
                    TRACER.debugInfo("Replication server writer stopping " + this.serverId);
                } else {
                    TRACER.debugInfo("LDAP server writer stopping " + this.serverId);
                }
            }
        }
    }
}

