/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class IntegerFirstComponentEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "integerFirstComponentMatch";
    }

    public String getOID() {
        return "2.5.13.29";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.27";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(value.value(), buffer, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return new ASN1OctetString(buffer.toString());
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        try {
            int intValue1 = IntegerFirstComponentEqualityMatchingRule.extractIntValue(value1.stringValue());
            int intValue2 = IntegerFirstComponentEqualityMatchingRule.extractIntValue(value2.stringValue());
            return intValue1 == intValue2;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    public int generateHashCode(AttributeValue attributeValue) {
        return 1;
    }

    private static int extractIntValue(String valueString) throws DirectoryException {
        char c;
        int pos;
        int valueLength = valueString.length();
        if (valueLength == 0 || valueString.charAt(0) != '(') {
            try {
                return Integer.parseInt(valueString);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = SchemaMessages.ERR_EMR_INTFIRSTCOMP_NO_INITIAL_PARENTHESIS.get(String.valueOf(valueString));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
            }
        }
        for (pos = 1; pos < valueLength && (c = valueString.charAt(pos)) == ' '; ++pos) {
        }
        if (pos >= valueLength) {
            Message message = SchemaMessages.ERR_EMR_INTFIRSTCOMP_NO_NONSPACE.get(String.valueOf(valueString));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        int startPos = pos++;
        while (pos < valueLength && (c = valueString.charAt(pos)) != ' ') {
            ++pos;
        }
        if (pos >= valueLength) {
            Message message = SchemaMessages.ERR_EMR_INTFIRSTCOMP_NO_SPACE_AFTER_INT.get(String.valueOf(valueString));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        try {
            return Integer.parseInt(valueString.substring(startPos, pos));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = SchemaMessages.ERR_EMR_INTFIRSTCOMP_FIRST_COMPONENT_NOT_INT.get(String.valueOf(valueString));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
    }
}

