/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;

public class UserPasswordEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "ds-mr-user-password-equality";
    }

    public String getOID() {
        return "1.3.6.1.4.1.26027.1.4.3";
    }

    public String getDescription() {
        return "user password matching rule";
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.26027.1.3.1";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        byte[] currentValue = value.value();
        byte[] newValue = new byte[currentValue.length];
        System.arraycopy(currentValue, 0, newValue, 0, currentValue.length);
        return new ASN1OctetString(newValue);
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }

    public ConditionResult valuesMatch(ByteString attributeValue, ByteString assertionValue) {
        String[] userPWComponents;
        try {
            userPWComponents = UserPasswordSyntax.decodeUserPassword(attributeValue.stringValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.FALSE;
        }
        PasswordStorageScheme storageScheme = DirectoryServer.getPasswordStorageScheme(userPWComponents[0]);
        if (storageScheme == null) {
            return ConditionResult.FALSE;
        }
        if (storageScheme.passwordMatches(assertionValue, new ASN1OctetString(userPWComponents[1]))) {
            return ConditionResult.TRUE;
        }
        return ConditionResult.FALSE;
    }

    public int generateHashCode(AttributeValue attributeValue) {
        return 1;
    }
}

