/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.messages.Message;
import org.opends.messages.TaskMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class RestoreTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static Map<String, Message> argDisplayMap = new HashMap<String, Message>();
    private File backupDirectory;
    private String backupID;
    private boolean verifyOnly;
    private RestoreConfig restoreConfig;

    public Message getDisplayName() {
        return TaskMessages.INFO_TASK_RESTORE_NAME.get();
    }

    public Message getAttributeDisplayName(String name) {
        return argDisplayMap.get(name);
    }

    public void initializeTask() throws DirectoryException {
        ClientConnection clientConnection;
        Operation operation = this.getOperation();
        if (operation != null && !(clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.BACKEND_RESTORE, operation)) {
            Message message = TaskMessages.ERR_TASK_RESTORE_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeBackupDirectory = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeType typebackupID = DirectoryServer.getAttributeType("ds-backup-id", true);
        AttributeType typeVerifyOnly = DirectoryServer.getAttributeType("ds-task-restore-verify-only", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeBackupDirectory);
        String backupDirectoryPath = TaskUtils.getSingleValueString(attrList);
        this.backupDirectory = new File(backupDirectoryPath);
        if (!this.backupDirectory.isAbsolute()) {
            this.backupDirectory = new File(DirectoryServer.getServerRoot(), backupDirectoryPath);
        }
        attrList = taskEntry.getAttribute(typebackupID);
        this.backupID = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeVerifyOnly);
        this.verifyOnly = TaskUtils.getBoolean(attrList, false);
    }

    private boolean lockBackend(Backend backend) {
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                Message message = ToolMessages.ERR_RESTOREDB_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                this.logError(message);
                return false;
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_RESTOREDB_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(message);
            return false;
        }
        return true;
    }

    private boolean unlockBackend(Backend backend) {
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                Message message = ToolMessages.WARN_RESTOREDB_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                this.logError(message);
                return false;
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.WARN_RESTOREDB_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(message);
            return false;
        }
        return true;
    }

    public void interruptTask(TaskState interruptState, Message interruptReason) {
        if (TaskState.STOPPED_BY_ADMINISTRATOR.equals((Object)interruptState) && this.restoreConfig != null) {
            this.addLogMessage(TaskMessages.INFO_TASK_STOPPED_BY_ADMIN.get(interruptReason));
            this.setTaskInterruptState(interruptState);
            this.restoreConfig.cancel();
        }
    }

    public boolean isInterruptable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskState runTask() {
        boolean errorsEncountered;
        block31: {
            ConfigEntry configEntry;
            BackupDirectory backupDir;
            try {
                backupDir = BackupDirectory.readBackupDirectoryDescriptor(this.backupDirectory.getPath());
            }
            catch (Exception e) {
                Message message = ToolMessages.ERR_RESTOREDB_CANNOT_READ_BACKUP_DIRECTORY.get(String.valueOf(this.backupDirectory), StaticUtils.getExceptionMessage(e));
                this.logError(message);
                return TaskState.STOPPED_BY_ERROR;
            }
            if (this.backupID != null) {
                BackupInfo backupInfo = backupDir.getBackupInfo(this.backupID);
                if (backupInfo == null) {
                    Message message = ToolMessages.ERR_RESTOREDB_INVALID_BACKUP_ID.get(this.backupID, String.valueOf(this.backupDirectory));
                    this.logError(message);
                    return TaskState.STOPPED_BY_ERROR;
                }
            } else {
                BackupInfo latestBackup = backupDir.getLatestBackup();
                if (latestBackup == null) {
                    Message message = ToolMessages.ERR_RESTOREDB_NO_BACKUPS_IN_DIRECTORY.get(String.valueOf(this.backupDirectory));
                    this.logError(message);
                    return TaskState.STOPPED_BY_ERROR;
                }
                this.backupID = latestBackup.getBackupID();
            }
            DN configEntryDN = backupDir.getConfigEntryDN();
            try {
                configEntry = DirectoryServer.getConfigEntry(configEntryDN);
            }
            catch (ConfigException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ToolMessages.ERR_RESTOREDB_NO_BACKENDS_FOR_DN.get(String.valueOf(this.backupDirectory), configEntryDN.toString());
                this.logError(message);
                return TaskState.STOPPED_BY_ERROR;
            }
            String backendID = TaskUtils.getBackendID(configEntry);
            Backend backend = DirectoryServer.getBackend(backendID);
            if (!backend.supportsRestore()) {
                Message message = ToolMessages.ERR_RESTOREDB_CANNOT_RESTORE.get(backend.getBackendID());
                this.logError(message);
                return TaskState.STOPPED_BY_ERROR;
            }
            this.restoreConfig = new RestoreConfig(backupDir, this.backupID, this.verifyOnly);
            DirectoryServer.notifyRestoreBeginning(backend, this.restoreConfig);
            if (!this.verifyOnly) {
                try {
                    TaskUtils.disableBackend(backendID);
                }
                catch (DirectoryException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    this.logError(e.getMessageObject());
                    return TaskState.STOPPED_BY_ERROR;
                }
            }
            errorsEncountered = false;
            try {
                if (!this.verifyOnly && !this.lockBackend(backend)) break block31;
                try {
                    try {
                        backend.restoreBackup(this.restoreConfig);
                    }
                    catch (DirectoryException de) {
                        DirectoryServer.notifyRestoreEnded(backend, this.restoreConfig, false);
                        Message message = ToolMessages.ERR_RESTOREDB_ERROR_DURING_BACKUP.get(this.backupID, backupDir.getPath(), de.getMessageObject());
                        this.logError(message);
                        errorsEncountered = true;
                    }
                    catch (Exception e) {
                        DirectoryServer.notifyRestoreEnded(backend, this.restoreConfig, false);
                        Message message = ToolMessages.ERR_RESTOREDB_ERROR_DURING_BACKUP.get(this.backupID, backupDir.getPath(), StaticUtils.getExceptionMessage(e));
                        this.logError(message);
                        errorsEncountered = true;
                    }
                }
                finally {
                    if (!this.verifyOnly && !this.unlockBackend(backend)) {
                        errorsEncountered = true;
                    }
                }
            }
            finally {
                if (!this.verifyOnly) {
                    try {
                        TaskUtils.enableBackend(backendID);
                        backend = DirectoryServer.getBackend(backendID);
                    }
                    catch (DirectoryException e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        this.logError(e.getMessageObject());
                        errorsEncountered = true;
                    }
                }
                DirectoryServer.notifyRestoreEnded(backend, this.restoreConfig, true);
            }
        }
        if (errorsEncountered) {
            return TaskState.COMPLETED_WITH_ERRORS;
        }
        return this.getFinalTaskState();
    }

    static {
        argDisplayMap.put("ds-backup-directory-path", TaskMessages.INFO_RESTORE_ARG_BACKUP_DIR.get());
        argDisplayMap.put("ds-backup-id", TaskMessages.INFO_RESTORE_ARG_BACKUP_ID.get());
        argDisplayMap.put("ds-task-restore-verify-only", TaskMessages.INFO_RESTORE_ARG_VERIFY_ONLY.get());
    }
}

