/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public abstract class CommonSchemaElements {
    private final boolean isObsolete;
    private final int hashCode;
    private final Map<String, List<String>> extraProperties;
    private final Map<String, String> names;
    private final String description;
    private final String oid;
    private final String primaryName;
    private final String lowerName;

    protected CommonSchemaElements(String primaryName, Collection<String> names, String oid, String description, boolean isObsolete, Map<String, List<String>> extraProperties) throws NullPointerException {
        if (oid == null) {
            throw new NullPointerException("No oid specified in constructor");
        }
        this.oid = oid;
        this.description = description;
        this.isObsolete = isObsolete;
        this.hashCode = oid.hashCode();
        this.primaryName = primaryName == null ? (names != null && !names.isEmpty() ? names.iterator().next() : null) : primaryName;
        this.lowerName = StaticUtils.toLowerCase(primaryName);
        if (names != null) {
            this.names = new LinkedHashMap<String, String>(names.size());
            this.names.put(this.lowerName, this.primaryName);
            for (String name : names) {
                this.names.put(StaticUtils.toLowerCase(name), name);
            }
        } else {
            this.names = this.primaryName != null ? Collections.singletonMap(this.lowerName, this.primaryName) : Collections.emptyMap();
        }
        this.extraProperties = extraProperties != null ? new LinkedHashMap<String, List<String>>(extraProperties) : Collections.emptyMap();
    }

    public final String getPrimaryName() {
        return this.primaryName;
    }

    public final String getNormalizedPrimaryName() {
        return this.lowerName;
    }

    public final Iterable<String> getNormalizedNames() {
        return this.names.keySet();
    }

    public final Iterable<String> getUserDefinedNames() {
        return this.names.values();
    }

    public final boolean hasName(String lowerName) {
        return this.names.containsKey(lowerName);
    }

    public final String getOID() {
        return this.oid;
    }

    public final String getNameOrOID() {
        if (this.primaryName != null) {
            return this.primaryName;
        }
        return this.oid;
    }

    public final boolean hasNameOrOID(String lowerValue) {
        if (this.names.containsKey(lowerValue)) {
            return true;
        }
        return this.oid.equals(lowerValue);
    }

    public final String getSchemaFile() {
        List<String> values = this.extraProperties.get("X-SCHEMA-FILE");
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public final void setSchemaFile(String schemaFile) {
        this.setExtraProperty("X-SCHEMA-FILE", schemaFile);
    }

    public final String getDescription() {
        return this.description;
    }

    public final boolean isObsolete() {
        return this.isObsolete;
    }

    public final Iterable<String> getExtraPropertyNames() {
        return this.extraProperties.keySet();
    }

    public final Iterable<String> getExtraProperty(String name) {
        return this.extraProperties.get(name);
    }

    public final void setExtraProperty(String name, String value) {
        Validator.ensureNotNull(name);
        if (value == null) {
            this.extraProperties.remove(name);
        } else {
            LinkedList<String> values = new LinkedList<String>();
            values.add(value);
            this.extraProperties.put(name, values);
        }
    }

    public final void setExtraProperty(String name, List<String> values) {
        Validator.ensureNotNull(name);
        if (values == null || values.isEmpty()) {
            this.extraProperties.remove(name);
        } else {
            LinkedList<String> valuesCopy = new LinkedList<String>(values);
            this.extraProperties.put(name, valuesCopy);
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CommonSchemaElements) {
            CommonSchemaElements other = (CommonSchemaElements)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    public final void toString(StringBuilder buffer, boolean includeFileElement) {
        buffer.append("( ");
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            Iterator<String> iterator = this.names.values().iterator();
            String firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        this.toStringContent(buffer);
        if (!this.extraProperties.isEmpty()) {
            for (Map.Entry<String, List<String>> e : this.extraProperties.entrySet()) {
                String property = e.getKey();
                if (!includeFileElement && property.equals("X-SCHEMA-FILE")) continue;
                List<String> valueList = e.getValue();
                buffer.append(" ");
                buffer.append(property);
                if (valueList.size() == 1) {
                    buffer.append(" '");
                    buffer.append(valueList.get(0));
                    buffer.append("'");
                    continue;
                }
                buffer.append(" ( ");
                for (String value : valueList) {
                    buffer.append("'");
                    buffer.append(value);
                    buffer.append("' ");
                }
                buffer.append(")");
            }
        }
        buffer.append(" )");
    }

    protected abstract void toStringContent(StringBuilder var1);
}

