/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.messages.Message;
import org.opends.server.types.DN;
import org.opends.server.types.IdentifiedException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class LDAPException
extends IdentifiedException {
    private static final long serialVersionUID = -7273984376022613884L;
    private final DN matchedDN;
    private final int resultCode;
    private final Message errorMessage;

    public LDAPException(int resultCode, Message message) {
        super(message);
        this.resultCode = resultCode;
        this.errorMessage = null;
        this.matchedDN = null;
    }

    public LDAPException(int resultCode, Message errorMessage, Message message) {
        super(message);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = null;
    }

    public LDAPException(int resultCode, Message message, Throwable cause) {
        super(message, cause);
        this.resultCode = resultCode;
        this.errorMessage = null;
        this.matchedDN = null;
    }

    public LDAPException(int resultCode, Message errorMessage, Message message, Throwable cause) {
        super(message, cause);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = null;
    }

    public LDAPException(int resultCode, Message errorMessage, Message message, DN matchedDN, Throwable cause) {
        super(message, cause);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = matchedDN;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public Message getErrorMessage() {
        return this.errorMessage;
    }

    public DN getMatchedDN() {
        return this.matchedDN;
    }
}

