/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.opends.messages.Message;
import org.opends.messages.UtilityMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class LDAPURL {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String DEFAULT_SCHEME = "ldap";
    public static final int DEFAULT_PORT = 389;
    public static final DN DEFAULT_BASE_DN = DN.nullDN();
    public static final SearchScope DEFAULT_SEARCH_SCOPE = SearchScope.BASE_OBJECT;
    public static final SearchFilter DEFAULT_SEARCH_FILTER = SearchFilter.createPresenceFilter(DirectoryServer.getObjectClassAttributeType());
    private DN baseDN;
    private int port;
    private LinkedHashSet<String> attributes;
    private LinkedList<String> extensions;
    private SearchScope scope;
    private SearchFilter filter;
    private String host;
    private String rawBaseDN;
    private String rawFilter;
    private String scheme;

    public LDAPURL(String scheme, String host, int port, String rawBaseDN, LinkedHashSet<String> attributes, SearchScope scope, String rawFilter, LinkedList<String> extensions) {
        this.host = StaticUtils.toLowerCase(host);
        this.baseDN = null;
        this.filter = null;
        this.scheme = scheme == null ? DEFAULT_SCHEME : StaticUtils.toLowerCase(scheme);
        this.port = port <= 0 || port > 65535 ? 389 : port;
        this.rawBaseDN = rawBaseDN == null ? "" : rawBaseDN;
        this.attributes = attributes == null ? new LinkedHashSet() : attributes;
        this.scope = scope == null ? DEFAULT_SEARCH_SCOPE : scope;
        this.rawFilter = rawFilter == null ? "(objectClass=*)" : rawFilter;
        this.extensions = extensions == null ? new LinkedList() : extensions;
    }

    public LDAPURL(String scheme, String host, int port, DN baseDN, LinkedHashSet<String> attributes, SearchScope scope, SearchFilter filter, LinkedList<String> extensions) {
        this.host = StaticUtils.toLowerCase(host);
        this.scheme = scheme == null ? DEFAULT_SCHEME : StaticUtils.toLowerCase(scheme);
        this.port = port <= 0 || port > 65535 ? 389 : port;
        if (baseDN == null) {
            this.baseDN = DEFAULT_BASE_DN;
            this.rawBaseDN = DEFAULT_BASE_DN.toString();
        } else {
            this.baseDN = baseDN;
            this.rawBaseDN = baseDN.toString();
        }
        this.attributes = attributes == null ? new LinkedHashSet() : attributes;
        this.scope = scope == null ? DEFAULT_SEARCH_SCOPE : scope;
        if (filter == null) {
            this.filter = DEFAULT_SEARCH_FILTER;
            this.rawFilter = DEFAULT_SEARCH_FILTER.toString();
        } else {
            this.filter = filter;
            this.rawFilter = filter.toString();
        }
        this.extensions = extensions == null ? new LinkedList() : extensions;
    }

    public static LDAPURL decode(String url, boolean fullyDecode) throws DirectoryException {
        SearchFilter filter;
        String filterString;
        SearchScope scope;
        String scopeString;
        String attrsString;
        int startPos;
        char c;
        int pos;
        int schemeEndPos = url.indexOf("://");
        if (schemeEndPos < 0) {
            Message message = UtilityMessages.ERR_LDAPURL_NO_COLON_SLASH_SLASH.get(String.valueOf(url));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (schemeEndPos == 0) {
            Message message = UtilityMessages.ERR_LDAPURL_NO_SCHEME.get(String.valueOf(url));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        String scheme = LDAPURL.urlDecode(url.substring(0, schemeEndPos));
        int length = url.length();
        if (length == schemeEndPos + 3) {
            return new LDAPURL(scheme, null, 389, DEFAULT_BASE_DN, null, DEFAULT_SEARCH_SCOPE, DEFAULT_SEARCH_FILTER, null);
        }
        String host = null;
        int port = 389;
        for (pos = startPos = schemeEndPos + 3; pos < length && (c = url.charAt(pos)) != '/'; ++pos) {
        }
        if (pos > startPos) {
            String hostPort = url.substring(startPos, pos);
            int colonPos = hostPort.indexOf(58);
            if (colonPos < 0) {
                host = LDAPURL.urlDecode(hostPort);
            } else {
                if (colonPos == 0) {
                    Message message = UtilityMessages.ERR_LDAPURL_NO_HOST.get(String.valueOf(url));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                if (colonPos == hostPort.length() - 1) {
                    Message message = UtilityMessages.ERR_LDAPURL_NO_PORT.get(String.valueOf(url));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                host = LDAPURL.urlDecode(hostPort.substring(0, colonPos));
                try {
                    port = Integer.parseInt(hostPort.substring(colonPos + 1));
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = UtilityMessages.ERR_LDAPURL_CANNOT_DECODE_PORT.get(String.valueOf(url), hostPort.substring(colonPos + 1));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                if (port <= 0 || port > 65535) {
                    Message message = UtilityMessages.ERR_LDAPURL_INVALID_PORT.get(String.valueOf(url), port);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
            }
        }
        if (++pos > length) {
            return new LDAPURL(scheme, host, port, DEFAULT_BASE_DN, null, DEFAULT_SEARCH_SCOPE, DEFAULT_SEARCH_FILTER, null);
        }
        startPos = pos;
        String baseDNString = null;
        pos = url.indexOf(63, startPos);
        if (pos < 0) {
            baseDNString = url.substring(startPos);
            startPos = length;
        } else {
            baseDNString = url.substring(startPos, pos);
            startPos = pos + 1;
        }
        DN baseDN = fullyDecode ? DN.decode(LDAPURL.urlDecode(baseDNString)) : null;
        if (startPos >= length) {
            if (fullyDecode) {
                return new LDAPURL(scheme, host, port, baseDN, null, DEFAULT_SEARCH_SCOPE, DEFAULT_SEARCH_FILTER, null);
            }
            return new LDAPURL(scheme, host, port, baseDNString, null, DEFAULT_SEARCH_SCOPE, null, null);
        }
        pos = url.indexOf(63, startPos);
        if (pos < 0) {
            attrsString = url.substring(startPos);
            startPos = length;
        } else {
            attrsString = url.substring(startPos, pos);
            startPos = pos + 1;
        }
        LinkedHashSet<String> attributes = new LinkedHashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(attrsString, ",");
        while (tokenizer.hasMoreTokens()) {
            attributes.add(LDAPURL.urlDecode(tokenizer.nextToken()));
        }
        if (startPos >= length) {
            if (fullyDecode) {
                return new LDAPURL(scheme, host, port, baseDN, attributes, DEFAULT_SEARCH_SCOPE, DEFAULT_SEARCH_FILTER, null);
            }
            return new LDAPURL(scheme, host, port, baseDNString, attributes, DEFAULT_SEARCH_SCOPE, null, null);
        }
        pos = url.indexOf(63, startPos);
        if (pos < 0) {
            scopeString = StaticUtils.toLowerCase(LDAPURL.urlDecode(url.substring(startPos)));
            startPos = length;
        } else {
            scopeString = StaticUtils.toLowerCase(LDAPURL.urlDecode(url.substring(startPos, pos)));
            startPos = pos + 1;
        }
        if (scopeString.equals("")) {
            scope = DEFAULT_SEARCH_SCOPE;
        } else if (scopeString.equals("base")) {
            scope = SearchScope.BASE_OBJECT;
        } else if (scopeString.equals("one")) {
            scope = SearchScope.SINGLE_LEVEL;
        } else if (scopeString.equals("sub")) {
            scope = SearchScope.WHOLE_SUBTREE;
        } else if (scopeString.equals("subord") || scopeString.equals("subordinate")) {
            scope = SearchScope.SUBORDINATE_SUBTREE;
        } else {
            Message message = UtilityMessages.ERR_LDAPURL_INVALID_SCOPE_STRING.get(String.valueOf(url), String.valueOf(scopeString));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (startPos >= length) {
            if (fullyDecode) {
                return new LDAPURL(scheme, host, port, baseDN, attributes, scope, DEFAULT_SEARCH_FILTER, null);
            }
            return new LDAPURL(scheme, host, port, baseDNString, attributes, scope, null, null);
        }
        pos = url.indexOf(63, startPos);
        if (pos < 0) {
            filterString = LDAPURL.urlDecode(url.substring(startPos));
            startPos = length;
        } else {
            filterString = LDAPURL.urlDecode(url.substring(startPos, pos));
            startPos = pos + 1;
        }
        if (fullyDecode) {
            filter = filterString.equals("") ? DEFAULT_SEARCH_FILTER : SearchFilter.createFilterFromString(filterString);
            if (startPos >= length) {
                if (fullyDecode) {
                    return new LDAPURL(scheme, host, port, baseDN, attributes, scope, filter, null);
                }
                return new LDAPURL(scheme, host, port, baseDNString, attributes, scope, filterString, null);
            }
        } else {
            filter = null;
        }
        String extensionsString = url.substring(startPos);
        LinkedList<String> extensions = new LinkedList<String>();
        tokenizer = new StringTokenizer(extensionsString, ",");
        while (tokenizer.hasMoreTokens()) {
            extensions.add(LDAPURL.urlDecode(tokenizer.nextToken()));
        }
        if (fullyDecode) {
            return new LDAPURL(scheme, host, port, baseDN, attributes, scope, filter, extensions);
        }
        return new LDAPURL(scheme, host, port, baseDNString, attributes, scope, filterString, extensions);
    }

    private static String urlDecode(String s) throws DirectoryException {
        if (s == null) {
            return "";
        }
        byte[] stringBytes = StaticUtils.getBytes(s);
        int length = stringBytes.length;
        byte[] decodedBytes = new byte[length];
        int pos = 0;
        for (int i = 0; i < length; ++i) {
            if (stringBytes[i] == 37) {
                int b;
                if (i + 2 > length) {
                    Message message = UtilityMessages.ERR_LDAPURL_PERCENT_TOO_CLOSE_TO_END.get(String.valueOf(s), i);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                switch (stringBytes[++i]) {
                    case 48: {
                        b = 0;
                        break;
                    }
                    case 49: {
                        b = 16;
                        break;
                    }
                    case 50: {
                        b = 32;
                        break;
                    }
                    case 51: {
                        b = 48;
                        break;
                    }
                    case 52: {
                        b = 64;
                        break;
                    }
                    case 53: {
                        b = 80;
                        break;
                    }
                    case 54: {
                        b = 96;
                        break;
                    }
                    case 55: {
                        b = 112;
                        break;
                    }
                    case 56: {
                        b = -128;
                        break;
                    }
                    case 57: {
                        b = -112;
                        break;
                    }
                    case 65: 
                    case 97: {
                        b = -96;
                        break;
                    }
                    case 66: 
                    case 98: {
                        b = -80;
                        break;
                    }
                    case 67: 
                    case 99: {
                        b = -64;
                        break;
                    }
                    case 68: 
                    case 100: {
                        b = -48;
                        break;
                    }
                    case 69: 
                    case 101: {
                        b = -32;
                        break;
                    }
                    case 70: 
                    case 102: {
                        b = -16;
                        break;
                    }
                    default: {
                        Message message = UtilityMessages.ERR_LDAPURL_INVALID_HEX_BYTE.get(String.valueOf(s), i);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                }
                switch (stringBytes[++i]) {
                    case 48: {
                        break;
                    }
                    case 49: {
                        b = (byte)(b | 1);
                        break;
                    }
                    case 50: {
                        b = (byte)(b | 2);
                        break;
                    }
                    case 51: {
                        b = (byte)(b | 3);
                        break;
                    }
                    case 52: {
                        b = (byte)(b | 4);
                        break;
                    }
                    case 53: {
                        b = (byte)(b | 5);
                        break;
                    }
                    case 54: {
                        b = (byte)(b | 6);
                        break;
                    }
                    case 55: {
                        b = (byte)(b | 7);
                        break;
                    }
                    case 56: {
                        b = (byte)(b | 8);
                        break;
                    }
                    case 57: {
                        b = (byte)(b | 9);
                        break;
                    }
                    case 65: 
                    case 97: {
                        b = (byte)(b | 0xA);
                        break;
                    }
                    case 66: 
                    case 98: {
                        b = (byte)(b | 0xB);
                        break;
                    }
                    case 67: 
                    case 99: {
                        b = (byte)(b | 0xC);
                        break;
                    }
                    case 68: 
                    case 100: {
                        b = (byte)(b | 0xD);
                        break;
                    }
                    case 69: 
                    case 101: {
                        b = (byte)(b | 0xE);
                        break;
                    }
                    case 70: 
                    case 102: {
                        b = (byte)(b | 0xF);
                        break;
                    }
                    default: {
                        Message message = UtilityMessages.ERR_LDAPURL_INVALID_HEX_BYTE.get(String.valueOf(s), i);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                }
                decodedBytes[pos++] = b;
                continue;
            }
            decodedBytes[pos++] = stringBytes[i];
        }
        try {
            return new String(decodedBytes, 0, pos, "UTF-8");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = UtilityMessages.ERR_LDAPURL_CANNOT_CREATE_UTF8_STRING.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
    }

    private static String urlEncode(String s, boolean isExtension) {
        if (s == null) {
            return "";
        }
        int length = s.length();
        StringBuilder buffer = new StringBuilder(length);
        LDAPURL.urlEncode(s, isExtension, buffer);
        return buffer.toString();
    }

    private static void urlEncode(String s, boolean isExtension, StringBuilder buffer) {
        if (s == null) {
            return;
        }
        int length = s.length();
        block3: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c)) {
                buffer.append(c);
                continue;
            }
            if (c == ',') {
                if (isExtension) {
                    LDAPURL.hexEncode(c, buffer);
                    continue;
                }
                buffer.append(c);
                continue;
            }
            switch (c) {
                case '!': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '@': 
                case '[': 
                case ']': 
                case '_': 
                case '~': {
                    buffer.append(c);
                    continue block3;
                }
                default: {
                    LDAPURL.hexEncode(c, buffer);
                }
            }
        }
    }

    private static void hexEncode(char c, StringBuilder buffer) {
        if ((c & 0xFFFFFFFF) == c) {
            buffer.append('%');
            buffer.append(StaticUtils.byteToHex((byte)c));
        } else {
            buffer.append('%');
            byte b1 = (byte)(c >>> 8 & 0xFF);
            buffer.append(StaticUtils.byteToHex(b1));
            buffer.append('%');
            byte b2 = (byte)(c & 0xFF);
            buffer.append(StaticUtils.byteToHex(b2));
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme == null ? DEFAULT_SCHEME : scheme;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port <= 0 || port > 65535 ? 389 : port;
    }

    public String getRawBaseDN() {
        return this.rawBaseDN;
    }

    public void setRawBaseDN(String rawBaseDN) {
        this.rawBaseDN = rawBaseDN;
        this.baseDN = null;
    }

    public DN getBaseDN() throws DirectoryException {
        if (this.baseDN == null) {
            if (this.rawBaseDN == null || this.rawBaseDN.length() == 0) {
                return DEFAULT_BASE_DN;
            }
            this.baseDN = DN.decode(this.rawBaseDN);
        }
        return this.baseDN;
    }

    public void setBaseDN(DN baseDN) {
        if (baseDN == null) {
            this.baseDN = null;
            this.rawBaseDN = null;
        } else {
            this.baseDN = baseDN;
            this.rawBaseDN = baseDN.toString();
        }
    }

    public LinkedHashSet<String> getAttributes() {
        return this.attributes;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope == null ? DEFAULT_SEARCH_SCOPE : scope;
    }

    public String getRawFilter() {
        return this.rawFilter;
    }

    public void setRawFilter(String rawFilter) {
        this.rawFilter = rawFilter;
        this.filter = null;
    }

    public SearchFilter getFilter() throws DirectoryException {
        if (this.filter == null) {
            this.filter = this.rawFilter == null ? DEFAULT_SEARCH_FILTER : SearchFilter.createFilterFromString(this.rawFilter);
        }
        return this.filter;
    }

    public void setFilter(SearchFilter filter) {
        if (filter == null) {
            this.rawFilter = null;
            this.filter = null;
        } else {
            this.rawFilter = filter.toString();
            this.filter = filter;
        }
    }

    public LinkedList<String> getExtensions() {
        return this.extensions;
    }

    public boolean matchesEntry(Entry entry) throws DirectoryException {
        SearchScope scope = this.getScope();
        if (scope == null) {
            scope = SearchScope.BASE_OBJECT;
        }
        return entry.matchesBaseAndScope(this.getBaseDN(), scope) && this.getFilter().matchesEntry(entry);
    }

    public boolean equals(Object o) {
        LDAPURL url;
        block22: {
            block21: {
                if (o == null) {
                    return false;
                }
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LDAPURL)) {
                    return false;
                }
                url = (LDAPURL)o;
                if (!this.scheme.equals(url.getScheme())) {
                    return false;
                }
                if (this.host == null ? url.getHost() != null : !this.host.equalsIgnoreCase(url.getHost())) {
                    return false;
                }
                if (this.port != url.getPort()) {
                    return false;
                }
                try {
                    DN dn = this.getBaseDN();
                    if (!dn.equals(url.getBaseDN())) {
                        return false;
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    if (!(this.rawBaseDN == null ? url.getRawBaseDN() != null : !this.rawBaseDN.equals(url.getRawBaseDN()))) break block21;
                    return false;
                }
            }
            if (this.scope != url.getScope()) {
                return false;
            }
            try {
                SearchFilter f = this.getFilter();
                if (!f.equals(url.getFilter())) {
                    return false;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (!(this.rawFilter == null ? url.getRawFilter() != null : !this.rawFilter.equals(url.getRawFilter()))) break block22;
                return false;
            }
        }
        if (this.attributes.size() != url.getAttributes().size()) {
            return false;
        }
        LinkedHashSet<String> urlAttrs = url.getAttributes();
        block4: for (String attr : this.attributes) {
            if (urlAttrs.contains(attr)) continue;
            for (String attr2 : urlAttrs) {
                if (!attr.equalsIgnoreCase(attr2)) continue;
                continue block4;
            }
            return false;
        }
        if (this.extensions.size() != url.getExtensions().size()) {
            return false;
        }
        block6: for (String ext : this.extensions) {
            for (String urlExt : url.getExtensions()) {
                if (!ext.equals(urlExt)) continue;
                continue block6;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode;
        block10: {
            block9: {
                hashCode = 0;
                hashCode += this.scheme.hashCode();
                if (this.host != null) {
                    hashCode += StaticUtils.toLowerCase(this.host).hashCode();
                }
                hashCode += this.port;
                try {
                    hashCode += this.getBaseDN().hashCode();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    if (this.rawBaseDN == null) break block9;
                    hashCode += this.rawBaseDN.hashCode();
                }
            }
            hashCode += this.getScope().intValue();
            for (String attr : this.attributes) {
                hashCode += StaticUtils.toLowerCase(attr).hashCode();
            }
            try {
                hashCode += this.getFilter().hashCode();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (this.rawFilter == null) break block10;
                hashCode += this.rawFilter.hashCode();
            }
        }
        for (String ext : this.extensions) {
            hashCode += ext.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, false);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer, boolean baseOnly) {
        Iterator iterator;
        LDAPURL.urlEncode(this.scheme, false, buffer);
        buffer.append("://");
        if (this.host != null) {
            LDAPURL.urlEncode(this.host, false, buffer);
            buffer.append(":");
            buffer.append(this.port);
        }
        buffer.append("/");
        LDAPURL.urlEncode(this.rawBaseDN, false, buffer);
        if (baseOnly) {
            if (!this.extensions.isEmpty()) {
                buffer.append("????");
                Iterator iterator2 = this.extensions.iterator();
                LDAPURL.urlEncode((String)iterator2.next(), true, buffer);
                while (iterator2.hasNext()) {
                    buffer.append(",");
                    LDAPURL.urlEncode((String)iterator2.next(), true, buffer);
                }
            }
            return;
        }
        buffer.append("?");
        if (!this.attributes.isEmpty()) {
            iterator = this.attributes.iterator();
            LDAPURL.urlEncode((String)iterator.next(), false, buffer);
            while (iterator.hasNext()) {
                buffer.append(",");
                LDAPURL.urlEncode((String)iterator.next(), false, buffer);
            }
        }
        buffer.append("?");
        switch (this.scope) {
            case BASE_OBJECT: {
                buffer.append("base");
                break;
            }
            case SINGLE_LEVEL: {
                buffer.append("one");
                break;
            }
            case WHOLE_SUBTREE: {
                buffer.append("sub");
                break;
            }
            case SUBORDINATE_SUBTREE: {
                buffer.append("subordinate");
            }
        }
        buffer.append("?");
        LDAPURL.urlEncode(this.rawFilter, false, buffer);
        if (!this.extensions.isEmpty()) {
            buffer.append("?");
            iterator = this.extensions.iterator();
            LDAPURL.urlEncode((String)iterator.next(), true, buffer);
            while (iterator.hasNext()) {
                buffer.append(",");
                LDAPURL.urlEncode((String)iterator.next(), true, buffer);
            }
        }
    }
}

