/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.messages.UtilityMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class EMailMessage {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private List<String> recipients;
    private LinkedList<MimeBodyPart> attachments;
    private String bodyMIMEType;
    private String sender;
    private String subject;
    private MessageBuilder body;

    public EMailMessage(String sender, String recipient, String subject) {
        this.sender = sender;
        this.subject = subject;
        this.recipients = new ArrayList<String>();
        this.recipients.add(recipient);
        this.body = new MessageBuilder();
        this.attachments = new LinkedList();
        this.bodyMIMEType = "text/plain";
    }

    public EMailMessage(String sender, List<String> recipients, String subject) {
        this.sender = sender;
        this.recipients = recipients;
        this.subject = subject;
        this.body = new MessageBuilder();
        this.attachments = new LinkedList();
        this.bodyMIMEType = "text/plain";
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(ArrayList<String> recipients) {
        this.recipients = recipients;
    }

    public void addRecipient(String recipient) {
        this.recipients.add(recipient);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MessageBuilder getBody() {
        return this.body;
    }

    public void setBody(MessageBuilder body) {
        this.body = body;
    }

    public void setBody(org.opends.messages.Message body) {
        this.body = new MessageBuilder(body);
    }

    public void appendToBody(String text) {
        this.body.append(text);
    }

    public LinkedList<MimeBodyPart> getAttachments() {
        return this.attachments;
    }

    public void addAttachment(MimeBodyPart attachment) {
        this.attachments.add(attachment);
    }

    public void addAttachment(String attachmentText) throws MessagingException {
        MimeBodyPart attachment = new MimeBodyPart();
        attachment.setText(attachmentText);
        this.attachments.add(attachment);
    }

    public void addAttachment(File attachmentFile) throws MessagingException {
        MimeBodyPart attachment = new MimeBodyPart();
        FileDataSource dataSource = new FileDataSource(attachmentFile);
        attachment.setDataHandler(new DataHandler((DataSource)dataSource));
        attachment.setFileName(attachmentFile.getName());
        this.attachments.add(attachment);
    }

    public void send() throws MessagingException {
        this.send(DirectoryServer.getMailServerPropertySets());
    }

    public void send(List<Properties> mailServerPropertySets) throws MessagingException {
        SendFailedException sendException = null;
        for (Properties props : mailServerPropertySets) {
            Session session = Session.getInstance((Properties)props);
            MimeMessage message = new MimeMessage(session);
            message.setSubject(this.subject);
            message.setSentDate(new Date());
            try {
                message.setFrom((Address)new InternetAddress(this.sender));
            }
            catch (MessagingException me) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, me);
                }
                org.opends.messages.Message msg = UtilityMessages.ERR_EMAILMSG_INVALID_SENDER_ADDRESS.get(String.valueOf(this.sender), me.getMessage());
                throw new MessagingException(msg.toString(), (Exception)((Object)me));
            }
            InternetAddress[] recipientAddresses = new InternetAddress[this.recipients.size()];
            for (int i = 0; i < recipientAddresses.length; ++i) {
                String recipient = this.recipients.get(i);
                try {
                    recipientAddresses[i] = new InternetAddress(recipient);
                    continue;
                }
                catch (MessagingException me) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, me);
                    }
                    org.opends.messages.Message msg = UtilityMessages.ERR_EMAILMSG_INVALID_RECIPIENT_ADDRESS.get(String.valueOf(recipient), me.getMessage());
                    throw new MessagingException(msg.toString(), (Exception)((Object)me));
                }
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses);
            if (this.attachments.isEmpty()) {
                message.setText(this.body.toString());
            } else {
                MimeMultipart multiPart = new MimeMultipart();
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setText(this.body.toString());
                multiPart.addBodyPart((BodyPart)bodyPart);
                for (MimeBodyPart attachment : this.attachments) {
                    multiPart.addBodyPart((BodyPart)attachment);
                }
                message.setContent((Multipart)multiPart);
            }
            try {
                Transport.send((Message)message);
                return;
            }
            catch (SendFailedException sfe) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, sfe);
                }
                if (sendException != null) continue;
                sendException = sfe;
            }
        }
        if (sendException == null) {
            org.opends.messages.Message message = UtilityMessages.ERR_EMAILMSG_CANNOT_SEND.get();
            throw new MessagingException(message.toString());
        }
        throw sendException;
    }

    public static void main(String[] args) {
        File f;
        org.opends.messages.Message description = UtilityMessages.INFO_EMAIL_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(EMailMessage.class.getName(), description, false);
        Argument showUsage = null;
        Argument attachFile = null;
        Argument bodyFile = null;
        StringArgument host = null;
        Argument from = null;
        Argument subject = null;
        Argument to = null;
        try {
            host = new StringArgument("host", Character.valueOf('h'), "host", true, true, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), "127.0.0.1", null, UtilityMessages.INFO_EMAIL_HOST_DESCRIPTION.get());
            argParser.addArgument(host);
            from = new StringArgument("from", Character.valueOf('f'), "from", true, false, true, ToolMessages.INFO_ADDRESS_PLACEHOLDER.get(), null, null, UtilityMessages.INFO_EMAIL_FROM_DESCRIPTION.get());
            argParser.addArgument(from);
            to = new StringArgument("to", Character.valueOf('t'), "to", true, true, true, ToolMessages.INFO_ADDRESS_PLACEHOLDER.get(), null, null, UtilityMessages.INFO_EMAIL_TO_DESCRIPTION.get());
            argParser.addArgument(to);
            subject = new StringArgument("subject", Character.valueOf('s'), "subject", true, false, true, ToolMessages.INFO_SUBJECT_PLACEHOLDER.get(), null, null, UtilityMessages.INFO_EMAIL_SUBJECT_DESCRIPTION.get());
            argParser.addArgument(subject);
            bodyFile = new StringArgument("bodyfile", Character.valueOf('b'), "body", true, true, true, ToolMessages.INFO_PATH_PLACEHOLDER.get(), null, null, UtilityMessages.INFO_EMAIL_BODY_DESCRIPTION.get());
            argParser.addArgument(bodyFile);
            attachFile = new StringArgument("attachfile", Character.valueOf('a'), "attach", false, true, true, ToolMessages.INFO_PATH_PLACEHOLDER.get(), null, null, UtilityMessages.INFO_EMAIL_ATTACH_DESCRIPTION.get());
            argParser.addArgument(attachFile);
            showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", UtilityMessages.INFO_EMAIL_HELP_DESCRIPTION.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            System.err.println(ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage()).toString());
            System.exit(1);
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            System.err.println(ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage()).toString());
            System.exit(1);
        }
        if (showUsage.isPresent()) {
            return;
        }
        LinkedList<Properties> mailServerProperties = new LinkedList<Properties>();
        for (String s : host.getValues()) {
            Properties p = new Properties();
            p.setProperty("mail.smtp.host", s);
            mailServerProperties.add(p);
        }
        EMailMessage message = new EMailMessage(from.getValue(), to.getValues(), subject.getValue());
        for (String s : bodyFile.getValues()) {
            try {
                String line;
                f = new File(s);
                if (!f.exists()) {
                    System.err.println(UtilityMessages.ERR_EMAIL_NO_SUCH_BODY_FILE.get(s));
                    System.exit(1);
                }
                BufferedReader reader = new BufferedReader(new FileReader(f));
                while ((line = reader.readLine()) != null) {
                    message.appendToBody(line);
                    message.appendToBody("\r\n");
                }
                reader.close();
            }
            catch (Exception e) {
                System.err.println(UtilityMessages.ERR_EMAIL_CANNOT_PROCESS_BODY_FILE.get(s, StaticUtils.getExceptionMessage(e)));
                System.exit(1);
            }
        }
        if (attachFile.isPresent()) {
            for (String s : attachFile.getValues()) {
                f = new File(s);
                if (!f.exists()) {
                    System.err.println(UtilityMessages.ERR_EMAIL_NO_SUCH_ATTACHMENT_FILE.get(s));
                    System.exit(1);
                }
                try {
                    message.addAttachment(f);
                }
                catch (Exception e) {
                    System.err.println(UtilityMessages.ERR_EMAIL_CANNOT_ATTACH_FILE.get(s, StaticUtils.getExceptionMessage(e)));
                }
            }
        }
        try {
            message.send(mailServerProperties);
        }
        catch (Exception e) {
            System.err.println(UtilityMessages.ERR_EMAIL_CANNOT_SEND_MESSAGE.get(StaticUtils.getExceptionMessage(e)));
            System.exit(1);
        }
    }
}

