/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.HashSet;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.CompareOperationWrapper;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.operation.PostOperationCompareOperation;
import org.opends.server.types.operation.PostResponseCompareOperation;
import org.opends.server.types.operation.PreOperationCompareOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendWorkflowElement;

public class LocalBackendCompareOperation
extends CompareOperationWrapper
implements PreOperationCompareOperation,
PostOperationCompareOperation,
PostResponseCompareOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Backend backend;
    private ClientConnection clientConnection;
    private DN entryDN;
    private Entry entry = null;

    public LocalBackendCompareOperation(CompareOperation compare) {
        super(compare);
        LocalBackendWorkflowElement.attachLocalOperation(compare, this);
    }

    public Entry getEntryToCompare() {
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processLocalCompare(Backend backend) throws CanceledOperationException {
        block28: {
            block33: {
                block32: {
                    block30: {
                        block29: {
                            executePostOpPlugins = false;
                            this.backend = backend;
                            this.clientConnection = this.getClientConnection();
                            pluginConfigManager = DirectoryServer.getPluginConfigManager();
                            clientConnection = this.getClientConnection();
                            this.checkIfCanceled(false);
                            this.entryDN = this.getEntryDN();
                            if (this.entryDN == null) break block28;
                            if (!DirectoryServer.getConfigHandler().handlesEntry(this.entryDN) || clientConnection.hasPrivilege(Privilege.CONFIG_READ, this)) break block29;
                            this.appendErrorMessage(CoreMessages.ERR_COMPARE_CONFIG_INSUFFICIENT_PRIVILEGES.get());
                            this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                            break block28;
                        }
                        this.checkIfCanceled(false);
                        readLock = null;
                        for (i = 0; i < 3 && (readLock = LockManager.lockRead(this.entryDN)) == null; ++i) {
                        }
                        if (readLock != null) break block30;
                        this.setResultCode(DirectoryServer.getServerErrorResultCode());
                        this.appendErrorMessage(CoreMessages.ERR_COMPARE_CANNOT_LOCK_ENTRY.get(String.valueOf(this.entryDN)));
                        break block28;
                    }
                    try {
                        this.entry = DirectoryServer.getEntry(this.entryDN);
                        if (this.entry != null) ** GOTO lbl-1000
                        this.setResultCode(ResultCode.NO_SUCH_OBJECT);
                        this.appendErrorMessage(CoreMessages.ERR_COMPARE_NO_SUCH_ENTRY.get(String.valueOf(this.entryDN)));
                        for (parentDN = this.entryDN.getParentDNInSuffix(); parentDN != null; parentDN = parentDN.getParentDNInSuffix()) {
                            try {
                                if (!DirectoryServer.entryExists(parentDN)) continue;
                                this.setMatchedDN(parentDN);
                            }
                            catch (Exception e) {
                                if (DebugLogger.debugEnabled()) {
                                    LocalBackendCompareOperation.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                                ** GOTO lbl44
                            }
                        }
                        ** GOTO lbl44
                    }
                    catch (DirectoryException de) {
                        block31: {
                            if (!DebugLogger.debugEnabled()) break block31;
                            LocalBackendCompareOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            break block31;
                            catch (Throwable var17_23) {
                                throw var17_23;
                            }
lbl44:
                            // 3 sources

                            LockManager.unlock(this.entryDN, readLock);
                            break block28;
                        }
                        this.setResultCode(de.getResultCode());
                        this.appendErrorMessage(de.getMessageObject());
                        LockManager.unlock(this.entryDN, readLock);
                        break block28;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.handleRequestControls();
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                LocalBackendCompareOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            this.setResponseData(de);
                            LockManager.unlock(this.entryDN, readLock);
                            break block28;
                        }
                    }
                    ** try [egrp 5[TRYBLOCK] [6 : 381->418)] { 
lbl61:
                    // 1 sources

                    if (AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) break block32;
                    this.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                    this.appendErrorMessage(CoreMessages.ERR_COMPARE_AUTHZ_INSUFFICIENT_ACCESS_RIGHTS.get(String.valueOf(this.entryDN)));
                    break block28;
                }
                this.checkIfCanceled(false);
                executePostOpPlugins = true;
                preOpResult = pluginConfigManager.invokePreOperationComparePlugins(this);
                if (preOpResult.continueProcessing()) break block33;
                this.setResultCode(preOpResult.getResultCode());
                this.appendErrorMessage(preOpResult.getErrorMessage());
                this.setMatchedDN(preOpResult.getMatchedDN());
                this.setReferralURLs(preOpResult.getReferralURLs());
                break block28;
            }
            rawAttributeType = this.getRawAttributeType();
            semicolonPos = rawAttributeType.indexOf(59);
            if (semicolonPos > 0) {
                baseName = StaticUtils.toLowerCase(rawAttributeType.substring(0, semicolonPos));
                options = new HashSet<String>();
                nextPos = rawAttributeType.indexOf(59, semicolonPos + 1);
                while (nextPos > 0) {
                    options.add(rawAttributeType.substring(semicolonPos + 1, nextPos));
                    semicolonPos = nextPos;
                    nextPos = rawAttributeType.indexOf(59, semicolonPos + 1);
                }
                options.add(rawAttributeType.substring(semicolonPos + 1));
            } else {
                baseName = StaticUtils.toLowerCase(rawAttributeType);
                options = null;
            }
            attrType = this.getAttributeType();
            if (attrType == null) {
                attrType = DirectoryServer.getAttributeType(baseName, true);
                this.setAttributeType(attrType);
            }
            if ((attrList = this.entry.getAttribute(attrType, options)) == null || attrList.isEmpty()) {
                this.setResultCode(ResultCode.NO_SUCH_ATTRIBUTE);
                if (options == null) {
                    this.appendErrorMessage(CoreMessages.WARN_COMPARE_OP_NO_SUCH_ATTR.get(String.valueOf(this.entryDN), baseName));
                    break block28;
                } else {
                    this.appendErrorMessage(CoreMessages.WARN_COMPARE_OP_NO_SUCH_ATTR_WITH_OPTIONS.get(String.valueOf(this.entryDN), baseName));
                }
                break block28;
            } else {
                value = new AttributeValue(attrType, this.getAssertionValue());
                matchFound = false;
                for (Attribute a : attrList) {
                    if (!a.hasValue(value)) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound) {
                    this.setResultCode(ResultCode.COMPARE_TRUE);
                    break block28;
                } else {
                    this.setResultCode(ResultCode.COMPARE_FALSE);
                }
            }
            break block28;
lbl115:
            // 1 sources

            finally {
                LockManager.unlock(this.entryDN, readLock);
            }
        }
        this.checkIfCanceled(false);
        if (executePostOpPlugins == false) return;
        postOpResult = pluginConfigManager.invokePostOperationComparePlugins(this);
        if (postOpResult.continueProcessing() != false) return;
        this.setResultCode(postOpResult.getResultCode());
        this.appendErrorMessage(postOpResult.getErrorMessage());
        this.setMatchedDN(postOpResult.getMatchedDN());
        this.setReferralURLs(postOpResult.getReferralURLs());
    }

    private void handleRequestControls() throws DirectoryException {
        List<Control> requestControls = this.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            for (int i = 0; i < requestControls.size(); ++i) {
                Entry authorizationEntry;
                Control proxyControl;
                Control c = requestControls.get(i);
                String oid = c.getOID();
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this.entryDN, this, c)) {
                    throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                }
                if (oid.equals("1.3.6.1.1.12")) {
                    LDAPAssertionRequestControl assertControl;
                    if (c instanceof LDAPAssertionRequestControl) {
                        assertControl = (LDAPAssertionRequestControl)c;
                    } else {
                        try {
                            assertControl = LDAPAssertionRequestControl.decodeControl(c);
                            requestControls.set(i, assertControl);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                        }
                    }
                    try {
                        SearchFilter filter = assertControl.getSearchFilter();
                        if (filter.matchesEntry(this.entry)) continue;
                        throw new DirectoryException(ResultCode.ASSERTION_FAILED, CoreMessages.ERR_COMPARE_ASSERTION_FAILED.get(String.valueOf(this.entryDN)));
                    }
                    catch (DirectoryException de) {
                        if (de.getResultCode() == ResultCode.ASSERTION_FAILED) {
                            throw de;
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_COMPARE_CANNOT_PROCESS_ASSERTION_FILTER.get(String.valueOf(this.entryDN), de.getMessageObject()));
                    }
                }
                if (oid.equals("2.16.840.1.113730.3.4.12")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    if (c instanceof ProxiedAuthV1Control) {
                        proxyControl = (ProxiedAuthV1Control)c;
                    } else {
                        try {
                            proxyControl = ProxiedAuthV1Control.decodeControl(c);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                        }
                    }
                    authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.18")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    if (c instanceof ProxiedAuthV2Control) {
                        proxyControl = (ProxiedAuthV2Control)c;
                    } else {
                        try {
                            proxyControl = ProxiedAuthV2Control.decodeControl(c);
                        }
                        catch (LDAPException le) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, le);
                            }
                            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getMessageObject());
                        }
                    }
                    authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (!c.isCritical() || this.backend != null && this.backend.supportsControl(oid)) continue;
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_COMPARE_UNSUPPORTED_CRITICAL_CONTROL.get(String.valueOf(this.entryDN), oid));
            }
        }
    }
}

