/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.Locale;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.ManagedObjectDefinitionI18NResource;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelationDefinitionVisitor;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstantiableRelationDefinition<C extends ConfigurationClient, S extends Configuration>
extends RelationDefinition<C, S> {
    private final PropertyDefinition<?> namingPropertyDefinition;
    private final String pluralName;

    private InstantiableRelationDefinition(RelationDefinition.Common<C, S> common, String pluralName, PropertyDefinition<?> namingPropertyDefinition) {
        super(common);
        this.pluralName = pluralName;
        this.namingPropertyDefinition = namingPropertyDefinition;
    }

    @Override
    public <R, P> R accept(RelationDefinitionVisitor<R, P> v, P p) {
        return v.visitInstantiable(this, p);
    }

    public final PropertyDefinition<?> getNamingPropertyDefinition() {
        return this.namingPropertyDefinition;
    }

    public final String getPluralName() {
        return this.pluralName;
    }

    public final String getUserFriendlyPluralName() {
        return this.getUserFriendlyPluralName(Locale.getDefault());
    }

    public final String getUserFriendlyPluralName(Locale locale) {
        String property = "relation." + this.getName() + ".user-friendly-plural-name";
        return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this.getParentDefinition(), property, locale);
    }

    @Override
    public final void toString(StringBuilder builder) {
        builder.append("name=");
        builder.append(this.getName());
        builder.append(" type=composition parent=");
        builder.append(this.getParentDefinition().getName());
        builder.append(" child=");
        builder.append(this.getChildDefinition().getName());
        builder.append(" child=");
        builder.append(this.getChildDefinition().getName());
        builder.append(" minOccurs=0");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<C extends ConfigurationClient, S extends Configuration>
    extends RelationDefinition.AbstractBuilder<C, S, InstantiableRelationDefinition<C, S>> {
        private PropertyDefinition<?> namingPropertyDefinition;
        private final String pluralName;

        public Builder(AbstractManagedObjectDefinition<?, ?> pd, String name, String pluralName, AbstractManagedObjectDefinition<C, S> cd) {
            super(pd, name, cd);
            this.pluralName = pluralName;
        }

        public final void setNamingProperty(PropertyDefinition<?> namingPropertyDefinition) {
            Validator.ensureNotNull(namingPropertyDefinition);
            this.namingPropertyDefinition = namingPropertyDefinition;
        }

        @Override
        protected InstantiableRelationDefinition<C, S> buildInstance(RelationDefinition.Common<C, S> common) {
            return new InstantiableRelationDefinition(common, this.pluralName, this.namingPropertyDefinition);
        }
    }
}

