/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.ClassLoaderProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManagedObjectDefinitionI18NResource {
    private static final Map<String, ManagedObjectDefinitionI18NResource> INSTANCES = new HashMap<String, ManagedObjectDefinitionI18NResource>();
    private final Map<AbstractManagedObjectDefinition<?, ?>, Map<Locale, ResourceBundle>> resources = new HashMap();
    private final String prefix;

    public static ManagedObjectDefinitionI18NResource getInstance() {
        return ManagedObjectDefinitionI18NResource.getInstance("admin.messages");
    }

    public static ManagedObjectDefinitionI18NResource getInstanceForProfile(String profile) {
        return ManagedObjectDefinitionI18NResource.getInstance("admin.profiles." + profile);
    }

    private static synchronized ManagedObjectDefinitionI18NResource getInstance(String prefix) {
        ManagedObjectDefinitionI18NResource instance = INSTANCES.get(prefix);
        if (instance == null) {
            instance = new ManagedObjectDefinitionI18NResource(prefix);
            INSTANCES.put(prefix, instance);
        }
        return instance;
    }

    private ManagedObjectDefinitionI18NResource(String prefix) {
        this.prefix = prefix;
    }

    public String getMessage(AbstractManagedObjectDefinition<?, ?> d, String key) throws MissingResourceException {
        return this.getMessage(d, key, Locale.getDefault(), (String[])null);
    }

    public String getMessage(AbstractManagedObjectDefinition<?, ?> d, String key, Locale locale) throws MissingResourceException {
        return this.getMessage(d, key, locale, (String[])null);
    }

    public String getMessage(AbstractManagedObjectDefinition<?, ?> d, String key, Locale locale, String ... args) throws MissingResourceException {
        ResourceBundle resource = this.getResourceBundle(d, locale);
        if (args == null) {
            return resource.getString(key);
        }
        MessageFormat mf = new MessageFormat(resource.getString(key));
        return mf.format(args);
    }

    public String getMessage(AbstractManagedObjectDefinition<?, ?> d, String key, String ... args) throws MissingResourceException {
        return this.getMessage(d, key, Locale.getDefault(), args);
    }

    private synchronized ResourceBundle getResourceBundle(AbstractManagedObjectDefinition<?, ?> d, Locale locale) throws MissingResourceException {
        ResourceBundle resourceBundle;
        Map<Locale, ResourceBundle> map = this.resources.get(d);
        if (map == null) {
            map = new HashMap<Locale, ResourceBundle>();
            this.resources.put(d, map);
        }
        if ((resourceBundle = map.get(locale)) == null) {
            String baseName = this.prefix + "." + d.getClass().getName();
            resourceBundle = ResourceBundle.getBundle(baseName, locale, ClassLoaderProvider.getInstance().getClassLoader());
            map.put(locale, resourceBundle);
        }
        return resourceBundle;
    }
}

