/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.TreeSet;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.DurationUnit;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IPAddressMaskPropertyDefinition;
import org.opends.server.admin.IPAddressPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.SizePropertyDefinition;
import org.opends.server.admin.SizeUnit;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.UnknownPropertyDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyDefinitionUsageBuilder {
    private final MyPropertyDefinitionVisitor pimpl;

    public PropertyDefinitionUsageBuilder(boolean isDetailed) {
        this.pimpl = new MyPropertyDefinitionVisitor(isDetailed);
    }

    public String getUsage(PropertyDefinition<?> pd) {
        return pd.accept(this.pimpl, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyPropertyDefinitionVisitor
    extends PropertyDefinitionVisitor<String, Void> {
        private final boolean isDetailed;
        private final NumberFormat numberFormat;

        private MyPropertyDefinitionVisitor(boolean isDetailed) {
            this.isDetailed = isDetailed;
            this.numberFormat = NumberFormat.getNumberInstance();
            this.numberFormat.setGroupingUsed(true);
            this.numberFormat.setMaximumFractionDigits(2);
        }

        @Override
        public String visitAttributeType(AttributeTypePropertyDefinition d, Void p) {
            return "OID";
        }

        @Override
        public String visitBoolean(BooleanPropertyDefinition d, Void p) {
            if (this.isDetailed) {
                return "false | true";
            }
            return "BOOLEAN";
        }

        @Override
        public String visitClass(ClassPropertyDefinition d, Void p) {
            if (this.isDetailed && !d.getInstanceOfInterface().isEmpty()) {
                return "CLASS <= " + d.getInstanceOfInterface().get(0);
            }
            return "CLASS";
        }

        @Override
        public String visitDN(DNPropertyDefinition d, Void p) {
            if (this.isDetailed && d.getBaseDN() != null) {
                return "DN <= " + d.getBaseDN();
            }
            return "DN";
        }

        @Override
        public String visitDuration(DurationPropertyDefinition d, Void p) {
            StringBuilder builder = new StringBuilder();
            DurationUnit unit = d.getBaseUnit();
            if (this.isDetailed && d.getLowerLimit() > 0L) {
                builder.append(DurationUnit.toString(d.getLowerLimit()));
                builder.append(" <= ");
            }
            builder.append("DURATION (");
            builder.append(unit.getShortName());
            builder.append(')');
            if (this.isDetailed) {
                if (d.getUpperLimit() != null) {
                    builder.append(" <= ");
                    builder.append(DurationUnit.toString(d.getUpperLimit()));
                }
                if (d.isAllowUnlimited()) {
                    builder.append(" | unlimited");
                }
            }
            return builder.toString();
        }

        @Override
        public <E extends Enum<E>> String visitEnum(EnumPropertyDefinition<E> d, Void p) {
            if (!this.isDetailed) {
                String name = d.getName();
                int i = name.lastIndexOf(45);
                if (i == -1 || i == name.length() - 1) {
                    return name.toUpperCase();
                }
                return name.substring(i + 1).toUpperCase();
            }
            TreeSet<String> values = new TreeSet<String>();
            for (Enum value : EnumSet.allOf(d.getEnumClass())) {
                values.add(value.toString().trim().toLowerCase());
            }
            boolean isFirst = true;
            StringBuilder builder = new StringBuilder();
            for (String s : values) {
                if (!isFirst) {
                    builder.append(" | ");
                }
                builder.append(s);
                isFirst = false;
            }
            return builder.toString();
        }

        @Override
        public String visitInteger(IntegerPropertyDefinition d, Void p) {
            StringBuilder builder = new StringBuilder();
            if (this.isDetailed) {
                builder.append(d.getLowerLimit());
                builder.append(" <= ");
            }
            builder.append("INTEGER");
            if (this.isDetailed) {
                if (d.getUpperLimit() != null) {
                    builder.append(" <= ");
                    builder.append(d.getUpperLimit());
                } else if (d.isAllowUnlimited()) {
                    builder.append(" | unlimited");
                }
            }
            return builder.toString();
        }

        @Override
        public String visitIPAddress(IPAddressPropertyDefinition d, Void p) {
            return "HOST_NAME";
        }

        @Override
        public String visitIPAddressMask(IPAddressMaskPropertyDefinition d, Void p) {
            return "IP_ADDRESS_MASK";
        }

        @Override
        public String visitSize(SizePropertyDefinition d, Void p) {
            StringBuilder builder = new StringBuilder();
            if (this.isDetailed && d.getLowerLimit() > 0L) {
                SizeUnit unit = SizeUnit.getBestFitUnitExact(d.getLowerLimit());
                builder.append(this.numberFormat.format(unit.fromBytes(d.getLowerLimit())));
                builder.append(' ');
                builder.append(unit.getShortName());
                builder.append(" <= ");
            }
            builder.append("SIZE");
            if (this.isDetailed) {
                if (d.getUpperLimit() != null) {
                    long upperLimit = d.getUpperLimit();
                    SizeUnit unit = SizeUnit.getBestFitUnitExact(upperLimit);
                    if (unit == SizeUnit.BYTES && upperLimit < Long.MAX_VALUE) {
                        unit = SizeUnit.getBestFitUnitExact(upperLimit + 1L);
                        if (unit != SizeUnit.BYTES) {
                            ++upperLimit;
                            builder.append(" < ");
                        } else {
                            builder.append(" <= ");
                        }
                    } else {
                        builder.append(" <= ");
                    }
                    builder.append(this.numberFormat.format(unit.fromBytes(upperLimit)));
                    builder.append(' ');
                    builder.append(unit.getShortName());
                }
                if (d.isAllowUnlimited()) {
                    builder.append(" | unlimited");
                }
            }
            return builder.toString();
        }

        @Override
        public String visitString(StringPropertyDefinition d, Void p) {
            if (d.getPattern() != null) {
                return d.getPatternUsage();
            }
            return "STRING";
        }

        @Override
        public String visitUnknown(PropertyDefinition<?> d, Void p) throws UnknownPropertyDefinitionException {
            return "?";
        }
    }
}

