/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.server.admin.client.cli.DsFrameworkCliParser;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.DsFrameworkCliSubCommandGroup;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.ToolConstants;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsFrameworkCliGlobalAdmin
implements DsFrameworkCliSubCommandGroup {
    private static final String DESCRIPTION_OPTIONS_TITLE = MessageHandler.getMessage(10487031);
    private static final String DESCRIPTION_OPTIONS_READ = MessageHandler.getMessage(10487032);
    private static final String DESCRIPTION_OPTIONS_WRITE = MessageHandler.getMessage(10487033);
    private static final String DESCRIPTION_OPTIONS_MANDATORY = MessageHandler.getMessage(10487034);
    private static final String DESCRIPTION_OPTIONS_SINGLE = MessageHandler.getMessage(10487035);
    private DsFrameworkCliParser argParser;
    private BooleanArgument verboseArg;
    private SubCommand createAdminUserSubCmd;
    private StringArgument createAdminUserUserIdArg;
    private StringArgument createAdminUserSetArg;
    private SubCommand deleteAdminUserSubCmd;
    private StringArgument deleteAdminUserUserIdArg;
    private SubCommand listAdminUserSubCmd;
    private SubCommand getAdminUserPropertiesSubCmd;
    private StringArgument getAdminUserPropertiesUserIdArg;
    private SubCommand setAdminUserPropertiesSubCmd;
    private StringArgument setAdminUserPropertiesUserIdArg;
    private StringArgument setAdminUserPropertiesSetArg;
    private SubCommand listAdminUserPropertiesSubCmd;
    private HashMap<ADSContext.AdministratorProperty, Argument> userAdminProperties;
    private HashSet<ADSContext.AdministratorProperty> readonlyadminUserProperties;
    private HashSet<SubCommand> subCommands = new HashSet();
    private boolean isHidden;
    private String groupName;

    @Override
    public Set<SubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void initializeCliGroup(DsFrameworkCliParser argParser, BooleanArgument verboseArg) throws ArgumentException {
        this.verboseArg = verboseArg;
        this.isHidden = false;
        this.groupName = "admin-user";
        this.argParser = argParser;
        this.createAdminUserSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.CREATE_ADMIN_USER.toString(), 13631555, new Object[0]);
        this.subCommands.add(this.createAdminUserSubCmd);
        this.createAdminUserUserIdArg = new StringArgument("userID", null, "userID", false, true, "{userID}", 13631561, new Object[0]);
        this.createAdminUserSubCmd.addArgument(this.createAdminUserUserIdArg);
        this.createAdminUserSetArg = new StringArgument("set", ToolConstants.OPTION_SHORT_SET, "set", false, true, true, "{PROP:VAL}", null, null, 0xA00440, new Object[0]);
        this.createAdminUserSubCmd.addArgument(this.createAdminUserSetArg);
        this.deleteAdminUserSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.DELETE_ADMIN_USER.toString(), 0xD00044, new Object[0]);
        this.subCommands.add(this.deleteAdminUserSubCmd);
        this.deleteAdminUserUserIdArg = new StringArgument("userID", null, "userID", false, true, "{userID}", 13631561, new Object[0]);
        this.deleteAdminUserSubCmd.addArgument(this.deleteAdminUserUserIdArg);
        this.listAdminUserSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.LIST_ADMIN_USER.toString(), 13631557, new Object[0]);
        this.subCommands.add(this.listAdminUserSubCmd);
        this.getAdminUserPropertiesSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.GET_ADMIN_USER_PROPERTIES.toString(), 13631558, new Object[0]);
        this.subCommands.add(this.getAdminUserPropertiesSubCmd);
        this.getAdminUserPropertiesUserIdArg = new StringArgument("userID", null, "userID", false, true, "{userID}", 13631561, new Object[0]);
        this.getAdminUserPropertiesUserIdArg.setMultiValued(true);
        this.getAdminUserPropertiesSubCmd.addArgument(this.getAdminUserPropertiesUserIdArg);
        this.setAdminUserPropertiesSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.SET_ADMIN_USER_PROPERTIES.toString(), 13631559, new Object[0]);
        this.subCommands.add(this.setAdminUserPropertiesSubCmd);
        this.setAdminUserPropertiesUserIdArg = new StringArgument("userID", null, "userID", false, true, "{userID}", 13631561, new Object[0]);
        this.setAdminUserPropertiesSubCmd.addArgument(this.setAdminUserPropertiesUserIdArg);
        this.setAdminUserPropertiesSetArg = new StringArgument("set", ToolConstants.OPTION_SHORT_SET, "set", false, true, true, "{PROP:VAL}", null, null, 0xA00440, new Object[0]);
        this.setAdminUserPropertiesSubCmd.addArgument(this.setAdminUserPropertiesSetArg);
        this.listAdminUserPropertiesSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.LIST_ADMIN_USER_PROPERTIES.toString(), 13631560, new Object[0]);
        this.subCommands.add(this.listAdminUserPropertiesSubCmd);
        this.userAdminProperties = new HashMap();
        this.readonlyadminUserProperties = new HashSet();
        ADSContext.AdministratorProperty prop = ADSContext.AdministratorProperty.UID;
        String attName = prop.getAttributeName();
        StringArgument arg = new StringArgument(attName, null, prop.getAttributeName(), false, false, true, "", null, null, -1, new Object[0]);
        this.userAdminProperties.put(prop, arg);
        prop = ADSContext.AdministratorProperty.PASSWORD;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, prop.getAttributeName(), false, false, true, "", null, null, -1, new Object[0]);
        this.userAdminProperties.put(prop, arg);
        prop = ADSContext.AdministratorProperty.DESCRIPTION;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, prop.getAttributeName(), false, false, true, "", null, null, -1, new Object[0]);
        this.userAdminProperties.put(prop, arg);
        prop = ADSContext.AdministratorProperty.ADMINISTRATOR_DN;
        attName = prop.getAttributeName();
        arg = new StringArgument(attName, null, prop.getAttributeName(), false, false, true, "", null, null, -1, new Object[0]);
        this.userAdminProperties.put(prop, arg);
        this.readonlyadminUserProperties.add(prop);
    }

    @Override
    public boolean isSubCommand(SubCommand subCmd) {
        return SubCommandNameEnum.isSubCommand(subCmd.getName());
    }

    @Override
    public DsFrameworkCliReturnCode performSubCommand(SubCommand subCmd, OutputStream outStream, OutputStream errStream) throws ADSContextException, ArgumentException {
        DsFrameworkCliReturnCode returnCode;
        InitialContext ctx;
        block24: {
            ADSContext adsCtx = null;
            ctx = null;
            returnCode = DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
            try {
                if (subCmd.getName().equals(this.createAdminUserSubCmd.getName())) {
                    String userId = this.createAdminUserUserIdArg.getValue();
                    Map<ADSContext.AdministratorProperty, Object> map = this.mapSetOptionsToMap(this.createAdminUserSetArg, true);
                    map.put(ADSContext.AdministratorProperty.UID, userId);
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    adsCtx.createAdministrator(map);
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                if (subCmd.getName().equals(this.deleteAdminUserSubCmd.getName())) {
                    String userId = this.deleteAdminUserUserIdArg.getValue();
                    HashMap<ADSContext.AdministratorProperty, String> map = new HashMap<ADSContext.AdministratorProperty, String>();
                    map.put(ADSContext.AdministratorProperty.UID, userId);
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    adsCtx.deleteAdministrator(map);
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                if (subCmd.getName().equals(this.listAdminUserSubCmd.getName())) {
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set adminUserList = adsCtx.readAdministratorRegistry();
                    PrintStream out = new PrintStream(outStream);
                    for (Map user : adminUserList) {
                        out.println(ADSContext.AdministratorProperty.UID.getAttributeName() + ": " + user.get(ADSContext.AdministratorProperty.UID));
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                if (subCmd.getName().equals(this.getAdminUserPropertiesSubCmd.getName())) {
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set adsAdminUserList = adsCtx.readAdministratorRegistry();
                    LinkedList<String> userAdminUserList = this.getAdminUserPropertiesUserIdArg.getValues();
                    PrintStream out = new PrintStream(outStream);
                    for (Map adminUser : adsAdminUserList) {
                        String adminUserID = (String)adminUser.get(ADSContext.AdministratorProperty.UID);
                        if (!userAdminUserList.contains(adminUserID)) continue;
                        out.println(ADSContext.AdministratorProperty.UID.getAttributeName() + ": " + adminUser.get(ADSContext.AdministratorProperty.UID));
                        for (ADSContext.AdministratorProperty ap : adminUser.keySet()) {
                            if (ap.equals((Object)ADSContext.AdministratorProperty.UID)) continue;
                            out.println(ap.getAttributeName() + ": " + adminUser.get(ap));
                        }
                        out.println();
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                if (subCmd.getName().equals(this.setAdminUserPropertiesSubCmd.getName())) {
                    Map<ADSContext.AdministratorProperty, Object> map = this.mapSetOptionsToMap(this.setAdminUserPropertiesSetArg, false);
                    String newServerId = (String)map.get(ADSContext.AdministratorProperty.UID);
                    map.put(ADSContext.AdministratorProperty.UID, this.setAdminUserPropertiesUserIdArg.getValue());
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    adsCtx.updateAdministrator(map, newServerId);
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                if (subCmd.getName().equals(this.listAdminUserPropertiesSubCmd.getName())) {
                    PrintStream out = new PrintStream(outStream);
                    out.println(DESCRIPTION_OPTIONS_TITLE);
                    out.println();
                    out.print(" r -- ");
                    out.println(DESCRIPTION_OPTIONS_READ);
                    out.print(" w -- ");
                    out.println(DESCRIPTION_OPTIONS_WRITE);
                    out.print(" m -- ");
                    out.println(DESCRIPTION_OPTIONS_MANDATORY);
                    out.print(" s -- ");
                    out.println(DESCRIPTION_OPTIONS_SINGLE);
                    out.println();
                    TableBuilder table = new TableBuilder();
                    table.appendHeading(MessageHandler.getMessage(10486779));
                    table.appendHeading(MessageHandler.getMessage(10486782));
                    table.appendHeading(MessageHandler.getMessage(10486781));
                    table.appendHeading(MessageHandler.getMessage(10486975));
                    for (ADSContext.AdministratorProperty adminUserProp : this.userAdminProperties.keySet()) {
                        if (this.userAdminProperties.get(adminUserProp).isHidden()) continue;
                        table.startRow();
                        table.appendCell(adminUserProp.getAttributeName());
                        table.appendCell(this.getPropertyOptionSummary(this.userAdminProperties.get(adminUserProp)));
                        table.appendCell(adminUserProp.getAttributeSyntax());
                        if (this.userAdminProperties.get(adminUserProp).getDefaultValue() != null) {
                            table.appendCell(this.userAdminProperties.get(adminUserProp).getDefaultValue());
                            continue;
                        }
                        table.appendCell("-");
                    }
                    TextTablePrinter printer = new TextTablePrinter(outStream);
                    table.print(printer);
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block24;
                }
                throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED);
            }
            catch (ADSContextException e) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException x) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException x) {
                // empty catch block
            }
        }
        return returnCode;
    }

    private Map<ADSContext.AdministratorProperty, Object> mapSetOptionsToMap(StringArgument propertySetArgument, boolean checkMandatoryProps) throws ArgumentException {
        HashMap<ADSContext.AdministratorProperty, Object> map = new HashMap<ADSContext.AdministratorProperty, Object>();
        for (String m : propertySetArgument.getValues()) {
            String message;
            int sep = m.indexOf(58);
            if (sep < 0) {
                throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(m);
            }
            if (sep == 0) {
                throw ArgumentExceptionFactory.missingNameInPropertyArgument(m);
            }
            String propertyName = m.substring(0, sep);
            String value = m.substring(sep + 1, m.length());
            if (value.length() == 0) {
                throw ArgumentExceptionFactory.missingValueInPropertyArgument(m);
            }
            ADSContext.AdministratorProperty adminUserProperty = ADSContext.getAdminUSerPropFromName((String)propertyName);
            if (adminUserProperty == null) {
                int msgID = 10749116;
                message = MessageHandler.getMessage(msgID, propertyName);
                throw new ArgumentException(msgID, message);
            }
            if (this.userAdminProperties.get(adminUserProperty).isHidden()) {
                int msgID = 10749116;
                message = MessageHandler.getMessage(msgID, propertyName);
                throw new ArgumentException(msgID, message);
            }
            StringBuilder invalidReason = new StringBuilder();
            Argument arg = this.userAdminProperties.get(adminUserProperty);
            if (!arg.valueIsAcceptable(value, invalidReason)) {
                int msgID = 10749118;
                String message2 = MessageHandler.getMessage(msgID, propertyName, value);
                throw new ArgumentException(msgID, message2);
            }
            this.userAdminProperties.get(adminUserProperty).addValue(value);
            map.put(adminUserProperty, value);
        }
        if (!checkMandatoryProps) {
            return map;
        }
        for (ADSContext.AdministratorProperty s : ADSContext.AdministratorProperty.values()) {
            Argument arg = this.userAdminProperties.get(s);
            if (arg.isHidden() || map.containsKey(s) || !arg.isRequired()) continue;
            if (arg.getDefaultValue() == null) {
                int msgID = 10749117;
                String message = MessageHandler.getMessage(msgID, s.getAttributeName());
                throw new ArgumentException(msgID, message);
            }
            map.put(s, arg.getDefaultValue());
        }
        return map;
    }

    private String getPropertyOptionSummary(Argument arg) {
        StringBuilder b = new StringBuilder();
        if (this.readonlyadminUserProperties.contains(ADSContext.getServerPropFromName((String)arg.getName()))) {
            b.append("r-");
        } else {
            b.append("rw");
        }
        if (arg.isRequired()) {
            b.append('m');
        } else {
            b.append('-');
        }
        if (arg.isMultiValued()) {
            b.append('-');
        } else {
            b.append('s');
        }
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SubCommandNameEnum {
        CREATE_ADMIN_USER("create-admin-user"),
        DELETE_ADMIN_USER("delete-admin-user"),
        LIST_ADMIN_USER("list-admin-user"),
        LIST_ADMIN_USER_PROPERTIES("list-admin-user-properties"),
        GET_ADMIN_USER_PROPERTIES("get-admin-user-properties"),
        SET_ADMIN_USER_PROPERTIES("set-admin-user-properties");

        private final String name;
        private static final List<String> nameToSubCmdName;

        private SubCommandNameEnum(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static boolean isSubCommand(String name) {
            return nameToSubCmdName.contains(name);
        }

        static {
            nameToSubCmdName = new ArrayList<String>();
            for (SubCommandNameEnum subCmd : SubCommandNameEnum.values()) {
                nameToSubCmdName.add(subCmd.toString());
            }
        }
    }
}

