/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.util.ApplicationKeyManager;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.server.admin.client.cli.DsFrameworkCliAds;
import org.opends.server.admin.client.cli.DsFrameworkCliGlobalAdmin;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.DsFrameworkCliServer;
import org.opends.server.admin.client.cli.DsFrameworkCliServerGroup;
import org.opends.server.admin.client.cli.DsFrameworkCliSubCommandGroup;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.SelectableCertificateKeyManager;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;

public class DsFrameworkCliParser
extends SubCommandArgumentParser {
    private String EOL = System.getProperty("line.separator");
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private BooleanArgument showUsageArg = null;
    private BooleanArgument useSSLArg = null;
    private BooleanArgument startTLSArg = null;
    private StringArgument hostNameArg = null;
    private IntegerArgument portArg = null;
    private StringArgument bindDnArg = null;
    private FileBasedArgument bindPasswordFileArg = null;
    private StringArgument bindPasswordArg = null;
    private BooleanArgument verboseArg = null;
    private BooleanArgument trustAllArg = null;
    private StringArgument trustStorePathArg = null;
    private StringArgument trustStorePasswordArg = null;
    private FileBasedArgument trustStorePasswordFileArg = null;
    private StringArgument keyStorePathArg = null;
    private StringArgument keyStorePasswordArg = null;
    private FileBasedArgument keyStorePasswordFileArg = null;
    private StringArgument certNicknameArg = null;
    private static final Logger LOG = Logger.getLogger(DsFrameworkCliParser.class.getName());
    public HashSet<DsFrameworkCliSubCommandGroup> cliGroup = new HashSet();

    public DsFrameworkCliParser(String mainClassName, String toolDescription, boolean longArgumentsCaseSensitive) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive);
    }

    public void initializeParser(OutputStream outStream) throws ArgumentException {
        this.initializeGlobalOption(outStream);
        this.cliGroup.add(new DsFrameworkCliAds());
        this.cliGroup.add(new DsFrameworkCliServerGroup());
        this.cliGroup.add(new DsFrameworkCliServer());
        this.cliGroup.add(new DsFrameworkCliGlobalAdmin());
        Comparator<SubCommand> c = new Comparator<SubCommand>(){

            @Override
            public int compare(SubCommand o1, SubCommand o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        TreeSet<SubCommand> allSubCommands = new TreeSet<SubCommand>(c);
        for (DsFrameworkCliSubCommandGroup oneCli : this.cliGroup) {
            oneCli.initializeCliGroup(this, this.verboseArg);
            Set<SubCommand> oneCliSubCmds = oneCli.getSubCommands();
            allSubCommands.addAll(oneCliSubCmds);
            String grpName = oneCli.getGroupName();
            String option = "help-" + grpName;
            BooleanArgument arg = new BooleanArgument(option, null, option, 10486843, grpName);
            this.addGlobalArgument(arg);
            arg.setHidden(oneCli.isHidden());
            TreeSet<SubCommand> subCmds = new TreeSet<SubCommand>(c);
            subCmds.addAll(oneCliSubCmds);
            this.setUsageGroupArgument(arg, subCmds);
        }
        String option = "help-all";
        BooleanArgument arg = new BooleanArgument(option, null, option, 10486844, new Object[0]);
        this.addGlobalArgument(arg);
        this.setUsageGroupArgument(arg, allSubCommands);
    }

    private void initializeGlobalOption(OutputStream outStream) throws ArgumentException {
        this.showUsageArg = new BooleanArgument("showUsage", Character.valueOf('H'), "help", 0xA0007A, new Object[0]);
        this.addGlobalArgument(this.showUsageArg);
        this.setUsageArgument(this.showUsageArg, outStream);
        this.useSSLArg = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", 10485885, new Object[0]);
        this.addGlobalArgument(this.useSSLArg);
        this.startTLSArg = new BooleanArgument("startTLS", Character.valueOf('q'), "useStartTLS", 10485886, new Object[0]);
        this.addGlobalArgument(this.startTLSArg);
        this.hostNameArg = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, "{host}", "localhost", null, 10485880, new Object[0]);
        this.addGlobalArgument(this.hostNameArg);
        this.portArg = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, 10485881, new Object[0]);
        this.addGlobalArgument(this.portArg);
        this.bindDnArg = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", "cn=Directory Manager", null, 0xA00070, new Object[0]);
        this.addGlobalArgument(this.bindDnArg);
        this.bindPasswordArg = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10485873, new Object[0]);
        this.addGlobalArgument(this.bindPasswordArg);
        this.bindPasswordFileArg = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFile}", null, null, 10485874, new Object[0]);
        this.addGlobalArgument(this.bindPasswordFileArg);
        this.trustAllArg = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", 10485871, new Object[0]);
        this.addGlobalArgument(this.trustAllArg);
        this.trustStorePathArg = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10485878, new Object[0]);
        this.addGlobalArgument(this.trustStorePathArg);
        this.trustStorePasswordArg = new StringArgument("trustStorePassword", null, "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, 10486481, new Object[0]);
        this.addGlobalArgument(this.trustStorePasswordArg);
        this.trustStorePasswordFileArg = new FileBasedArgument("truststorepasswordfile", Character.valueOf('U'), "TrustStorePasswordFile", false, false, "{path}", null, null, 10486482, new Object[0]);
        this.addGlobalArgument(this.trustStorePasswordFileArg);
        this.keyStorePathArg = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10485877, new Object[0]);
        this.addGlobalArgument(this.keyStorePathArg);
        this.keyStorePasswordArg = new StringArgument("keyStorePassword", null, "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 0xA00077, new Object[0]);
        this.addGlobalArgument(this.keyStorePasswordArg);
        this.keyStorePasswordFileArg = new FileBasedArgument("keystorepasswordfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, "{path}", null, null, 10486480, new Object[0]);
        this.addGlobalArgument(this.keyStorePasswordFileArg);
        this.certNicknameArg = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, "{nickname}", null, null, 10486565, new Object[0]);
        this.addGlobalArgument(this.certNicknameArg);
        this.verboseArg = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", 10485876, new Object[0]);
        this.addGlobalArgument(this.verboseArg);
    }

    public String getHostName() {
        if (this.hostNameArg.isPresent()) {
            return this.hostNameArg.getValue();
        }
        return this.hostNameArg.getDefaultValue();
    }

    public String getPort() {
        if (this.portArg.isPresent()) {
            return this.portArg.getValue();
        }
        return this.portArg.getDefaultValue();
    }

    public String getBindDN() {
        if (this.bindDnArg.isPresent()) {
            return this.bindDnArg.getValue();
        }
        return this.bindDnArg.getDefaultValue();
    }

    public String getBindPassword(String dn, OutputStream out, OutputStream err) {
        if (this.bindPasswordArg.isPresent()) {
            String bindPasswordValue = this.bindPasswordArg.getValue();
            if (bindPasswordValue != null && bindPasswordValue.equals("-")) {
                try {
                    out.write(MessageHandler.getMessage(10485959, dn).getBytes());
                    char[] pwChars = PasswordReader.readPassword();
                    bindPasswordValue = new String(pwChars);
                }
                catch (Exception ex) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                    }
                    try {
                        err.write(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH).getBytes());
                        err.write(this.EOL.getBytes());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return null;
                }
            }
            return bindPasswordValue;
        }
        if (this.bindPasswordFileArg.isPresent()) {
            return this.bindPasswordFileArg.getValue();
        }
        try {
            out.write(MessageHandler.getMessage(10485959, dn).getBytes());
            char[] pwChars = PasswordReader.readPassword();
            return new String(pwChars);
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            try {
                err.write(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH).getBytes());
                err.write(this.EOL.getBytes());
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
    }

    public DsFrameworkCliReturnCode performSubCommand(OutputStream outStream, OutputStream errStream) throws ADSContextException, ArgumentException {
        SubCommand subCmd = this.getSubCommand();
        for (DsFrameworkCliSubCommandGroup oneCli : this.cliGroup) {
            if (!oneCli.isSubCommand(subCmd)) continue;
            return oneCli.performSubCommand(subCmd, outStream, errStream);
        }
        return DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
    }

    public boolean isVerbose() {
        return this.verboseArg.isPresent();
    }

    public boolean useSSL() {
        return this.useSSLArg.isPresent();
    }

    public boolean startTLS() {
        return this.startTLSArg.isPresent();
    }

    public ApplicationTrustManager getTrustManager() {
        ApplicationTrustManager truststoreManager = null;
        KeyStore truststore = null;
        if (this.trustAllArg.isPresent()) {
            return null;
        }
        if (this.trustStorePathArg.isPresent()) {
            try {
                FileInputStream fos = new FileInputStream(this.trustStorePathArg.getValue());
                String trustStorePasswordStringValue = null;
                char[] trustStorePasswordValue = null;
                if (this.trustStorePasswordArg.isPresent()) {
                    trustStorePasswordStringValue = this.trustStorePasswordArg.getValue();
                } else if (this.trustStorePasswordFileArg.isPresent()) {
                    trustStorePasswordStringValue = this.trustStorePasswordFileArg.getValue();
                }
                if (trustStorePasswordStringValue != null) {
                    trustStorePasswordStringValue = System.getProperty("javax.net.ssl.trustStorePassword");
                }
                if (trustStorePasswordStringValue != null) {
                    trustStorePasswordValue = trustStorePasswordStringValue.toCharArray();
                }
                truststore = KeyStore.getInstance(KeyStore.getDefaultType());
                truststore.load(fos, trustStorePasswordValue);
                fos.close();
            }
            catch (KeyStoreException e) {
                LOG.log(Level.WARNING, "Error with the truststore", e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.log(Level.WARNING, "Error with the truststore", e);
            }
            catch (CertificateException e) {
                LOG.log(Level.WARNING, "Error with the truststore", e);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error with the truststore", e);
            }
        }
        truststoreManager = new ApplicationTrustManager(truststore);
        return truststoreManager;
    }

    public KeyManager getKeyManager() {
        KeyStore keyStore = null;
        String keyStorePasswordStringValue = null;
        char[] keyStorePasswordValue = null;
        if (this.keyStorePathArg.isPresent()) {
            try {
                FileInputStream fos = new FileInputStream(this.keyStorePathArg.getValue());
                if (this.keyStorePasswordArg.isPresent()) {
                    keyStorePasswordStringValue = this.keyStorePasswordArg.getValue();
                } else if (this.keyStorePasswordFileArg.isPresent()) {
                    keyStorePasswordStringValue = this.keyStorePasswordFileArg.getValue();
                }
                if (keyStorePasswordStringValue != null) {
                    keyStorePasswordValue = keyStorePasswordStringValue.toCharArray();
                }
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(fos, keyStorePasswordValue);
                fos.close();
            }
            catch (KeyStoreException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            catch (CertificateException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            char[] password = null;
            if (keyStorePasswordStringValue != null) {
                password = keyStorePasswordStringValue.toCharArray();
            }
            ApplicationKeyManager akm = new ApplicationKeyManager(keyStore, password);
            if (this.certNicknameArg.isPresent()) {
                return new SelectableCertificateKeyManager((X509KeyManager)akm, this.certNicknameArg.getValue());
            }
            return akm;
        }
        return null;
    }

    public int validateGlobalOption(PrintStream err) {
        if (this.bindPasswordArg.isPresent() && this.bindPasswordFileArg.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, this.bindPasswordArg.getLongIdentifier(), this.bindPasswordFileArg.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return DsFrameworkCliReturnCode.CONFLICTING_ARGS.getReturnCode();
        }
        if (this.trustAllArg.isPresent() && this.trustStorePathArg.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, this.trustAllArg.getLongIdentifier(), this.trustStorePathArg.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return DsFrameworkCliReturnCode.CONFLICTING_ARGS.getReturnCode();
        }
        if (this.trustAllArg.isPresent() && this.trustStorePasswordArg.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, this.trustAllArg.getLongIdentifier(), this.trustStorePasswordArg.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return DsFrameworkCliReturnCode.CONFLICTING_ARGS.getReturnCode();
        }
        if (this.trustAllArg.isPresent() && this.trustStorePasswordFileArg.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, this.trustAllArg.getLongIdentifier(), this.trustStorePasswordFileArg.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return DsFrameworkCliReturnCode.CONFLICTING_ARGS.getReturnCode();
        }
        if (this.trustStorePasswordArg.isPresent() && this.trustStorePasswordFileArg.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, this.trustStorePasswordArg.getLongIdentifier(), this.trustStorePasswordFileArg.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return DsFrameworkCliReturnCode.CONFLICTING_ARGS.getReturnCode();
        }
        if (this.startTLSArg.isPresent() && this.useSSLArg.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, this.startTLSArg.getLongIdentifier(), this.useSSLArg.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return DsFrameworkCliReturnCode.CONFLICTING_ARGS.getReturnCode();
        }
        return DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode();
    }

    public InitialLdapContext getContext(OutputStream out, OutputStream err) {
        String host = null;
        String port = null;
        String dn = null;
        String pwd = null;
        InitialLdapContext ctx = null;
        host = this.getHostName();
        port = this.getPort();
        dn = this.getBindDN();
        pwd = this.getBindPassword(dn, out, err);
        if (this.useSSL()) {
            String ldapsUrl = "ldaps://" + host + ":" + port;
            try {
                ctx = ConnectionUtils.createLdapsContext((String)ldapsUrl, (String)dn, (String)pwd, (int)ConnectionUtils.getDefaultLDAPTimeout(), null, (TrustManager)this.getTrustManager(), (KeyManager)this.getKeyManager());
            }
            catch (NamingException e) {
                int msgID = 13959200;
                String message = MessageHandler.getMessage(msgID, host);
                try {
                    err.write(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH).getBytes());
                    err.write(this.EOL.getBytes());
                }
                catch (IOException e1) {
                    // empty catch block
                }
                return null;
            }
        }
        if (this.startTLS()) {
            String ldapUrl = "ldap://" + host + ":" + port;
            try {
                ctx = ConnectionUtils.createStartTLSContext((String)ldapUrl, (String)dn, (String)pwd, (int)ConnectionUtils.getDefaultLDAPTimeout(), null, (TrustManager)this.getTrustManager(), (KeyManager)this.getKeyManager(), null);
            }
            catch (NamingException e) {
                int msgID = 13959200;
                String message = MessageHandler.getMessage(msgID, host);
                try {
                    err.write(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH).getBytes());
                    err.write(this.EOL.getBytes());
                }
                catch (IOException e1) {
                    // empty catch block
                }
                return null;
            }
        }
        String ldapUrl = "ldap://" + host + ":" + port;
        try {
            ctx = ConnectionUtils.createLdapContext((String)ldapUrl, (String)dn, (String)pwd, (int)ConnectionUtils.getDefaultLDAPTimeout(), null);
        }
        catch (NamingException e) {
            int msgID = 13959200;
            String message = MessageHandler.getMessage(msgID, host);
            try {
                err.write(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH).getBytes());
                err.write(this.EOL.getBytes());
            }
            catch (IOException e1) {
                // empty catch block
            }
            return null;
        }
        return ctx;
    }
}

