/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.Rdn;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.server.admin.client.cli.DsFrameworkCliParser;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.DsFrameworkCliSubCommandGroup;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsFrameworkCliServerGroup
implements DsFrameworkCliSubCommandGroup {
    private String EOL = System.getProperty("line.separator");
    DsFrameworkCliParser argParser;
    BooleanArgument verboseArg;
    public SubCommand createGroupSubCmd;
    private StringArgument createGroupDescriptionArg;
    private StringArgument createGroupGroupNameArg;
    private SubCommand modifyGroupSubCmd;
    private StringArgument modifyGroupDescriptionArg;
    private StringArgument modifyGroupGroupIdArg;
    private StringArgument modifyGroupGroupNameArg;
    private SubCommand deleteGroupSubCmd;
    private StringArgument deleteGroupGroupNameArg;
    private SubCommand listGroupSubCmd;
    private SubCommand addToGroupSubCmd;
    private StringArgument addToGroupGroupNameArg;
    private StringArgument addToGoupMemberNameArg;
    private SubCommand removeFromGroupSubCmd;
    private StringArgument removeFromGroupGroupNameArg;
    private StringArgument removeFromGoupMemberNameArg;
    private SubCommand listMembersSubCmd;
    private StringArgument listMembersGroupNameArg;
    private SubCommand listMembershipSubCmd;
    private StringArgument listMembershipMemberNameArg;
    private HashMap<ADSContext.ServerGroupProperty, String> attributeDisplayName;
    private HashSet<SubCommand> subCommands = new HashSet();
    private boolean isHidden;
    private String groupName;

    public String getAttributeDisplayName(ADSContext.ServerGroupProperty prop) {
        return this.attributeDisplayName.get(prop);
    }

    @Override
    public Set<SubCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void initializeCliGroup(DsFrameworkCliParser argParser, BooleanArgument verboseArg) throws ArgumentException {
        this.verboseArg = verboseArg;
        this.isHidden = false;
        this.groupName = "server-group";
        this.argParser = argParser;
        this.createGroupSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.CREATE_GROUP.toString(), 13631507, new Object[0]);
        this.subCommands.add(this.createGroupSubCmd);
        this.createGroupDescriptionArg = new StringArgument("description", Character.valueOf('d'), "description", false, false, true, "{description}", "", null, 13631508, new Object[0]);
        this.createGroupSubCmd.addArgument(this.createGroupDescriptionArg);
        this.createGroupGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, "{group-name}", 13631541, new Object[0]);
        this.createGroupSubCmd.addArgument(this.createGroupGroupNameArg);
        this.modifyGroupSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.MODIFY_GROUP.toString(), 13631509, new Object[0]);
        this.subCommands.add(this.modifyGroupSubCmd);
        this.modifyGroupDescriptionArg = new StringArgument("new-description", Character.valueOf('d'), "description", false, false, true, "{description}", "", null, 13631510, new Object[0]);
        this.modifyGroupSubCmd.addArgument(this.modifyGroupDescriptionArg);
        this.modifyGroupGroupIdArg = new StringArgument("new-groupName", Character.valueOf('n'), "newGroupName", false, false, true, "{group-name}", "", null, 13631511, new Object[0]);
        this.modifyGroupSubCmd.addArgument(this.modifyGroupGroupIdArg);
        this.modifyGroupGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, "{group-name}", 13631542, new Object[0]);
        this.modifyGroupSubCmd.addArgument(this.modifyGroupGroupNameArg);
        this.deleteGroupSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.DELETE_GROUP.toString(), 13631512, new Object[0]);
        this.subCommands.add(this.deleteGroupSubCmd);
        this.deleteGroupGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, "{group-name}", 13631542, new Object[0]);
        this.deleteGroupSubCmd.addArgument(this.deleteGroupGroupNameArg);
        this.listGroupSubCmd = new SubCommand((SubCommandArgumentParser)argParser, "list-groups", 13631513, new Object[0]);
        this.subCommands.add(this.listGroupSubCmd);
        this.addToGroupSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.ADD_TO_GROUP.toString(), 13631514, new Object[0]);
        this.subCommands.add(this.addToGroupSubCmd);
        this.addToGoupMemberNameArg = new StringArgument("memberName", Character.valueOf('m'), "memberName", true, true, "{member-name}", 13631515, new Object[0]);
        this.addToGroupSubCmd.addArgument(this.addToGoupMemberNameArg);
        this.addToGroupGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, "{group-name}", 13631542, new Object[0]);
        this.addToGroupSubCmd.addArgument(this.addToGroupGroupNameArg);
        this.removeFromGroupSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.REMOVE_FROM_GROUP.toString(), 13631516, new Object[0]);
        this.subCommands.add(this.removeFromGroupSubCmd);
        this.removeFromGoupMemberNameArg = new StringArgument("memberName", Character.valueOf('m'), "memberName", true, true, "{member-name}", 0xD0001D, new Object[0]);
        this.removeFromGroupSubCmd.addArgument(this.removeFromGoupMemberNameArg);
        this.removeFromGroupGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, "{group-name}", 13631542, new Object[0]);
        this.removeFromGroupSubCmd.addArgument(this.removeFromGroupGroupNameArg);
        this.listMembersSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.LIST_MEMBERS.toString(), 13631518, new Object[0]);
        this.subCommands.add(this.listMembersSubCmd);
        this.listMembersGroupNameArg = new StringArgument("groupName", Character.valueOf('g'), "groupName", true, true, "{group-name}", 13631542, new Object[0]);
        this.listMembersSubCmd.addArgument(this.listMembersGroupNameArg);
        this.listMembershipSubCmd = new SubCommand((SubCommandArgumentParser)argParser, SubCommandNameEnum.LIST_MEMBERSHIP.toString(), 13631519, new Object[0]);
        this.subCommands.add(this.listMembershipSubCmd);
        this.listMembershipMemberNameArg = new StringArgument("memberName", Character.valueOf('m'), "memberName", true, true, "{member-name}", 13631543, new Object[0]);
        this.listMembershipSubCmd.addArgument(this.listMembershipMemberNameArg);
        this.attributeDisplayName = new HashMap();
        this.attributeDisplayName.put(ADSContext.ServerGroupProperty.UID, "groupName");
        this.attributeDisplayName.put(ADSContext.ServerGroupProperty.DESCRIPTION, "description");
        this.attributeDisplayName.put(ADSContext.ServerGroupProperty.MEMBERS, "memberName");
    }

    @Override
    public boolean isSubCommand(SubCommand subCmd) {
        return SubCommandNameEnum.isSubCommand(subCmd.getName());
    }

    @Override
    public DsFrameworkCliReturnCode performSubCommand(SubCommand subCmd, OutputStream outStream, OutputStream errStream) throws ADSContextException, ArgumentException {
        DsFrameworkCliReturnCode returnCode;
        InitialContext ctx;
        block64: {
            ADSContext adsCtx = null;
            ctx = null;
            returnCode = DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
            try {
                if (subCmd.getName().equals(this.createGroupSubCmd.getName())) {
                    String groupId = this.createGroupGroupNameArg.getValue();
                    HashMap<ADSContext.ServerGroupProperty, String> serverGroupProperties = new HashMap<ADSContext.ServerGroupProperty, String>();
                    serverGroupProperties.put(ADSContext.ServerGroupProperty.UID, groupId);
                    if (this.createGroupDescriptionArg.isPresent()) {
                        serverGroupProperties.put(ADSContext.ServerGroupProperty.DESCRIPTION, this.createGroupDescriptionArg.getValue());
                    }
                    if ((ctx = this.argParser.getContext(outStream, errStream)) == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    adsCtx.createServerGroup(serverGroupProperties);
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block64;
                }
                if (subCmd.getName().equals(this.deleteGroupSubCmd.getName())) {
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    String groupId = this.deleteGroupGroupNameArg.getValue();
                    if (groupId.equals("all-servers")) {
                        return DsFrameworkCliReturnCode.ACCESS_PERMISSION;
                    }
                    HashMap<ADSContext.ServerGroupProperty, String> serverGroupProperties = new HashMap<ADSContext.ServerGroupProperty, String>();
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set serverList = adsCtx.getServerGroupMemberList(groupId);
                    for (String serverId : serverList) {
                        DsFrameworkCliServerGroup.removeServerFromGroup(adsCtx, groupId, serverId.substring(3));
                    }
                    serverGroupProperties.put(ADSContext.ServerGroupProperty.UID, groupId);
                    adsCtx.deleteServerGroup(serverGroupProperties);
                    break block64;
                }
                if (subCmd.getName().equals(this.listGroupSubCmd.getName())) {
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set result = adsCtx.readServerGroupRegistry();
                    StringBuffer buffer = new StringBuffer();
                    if (!this.verboseArg.isPresent()) {
                        for (Map groupProps : result) {
                            buffer.append(groupProps.get(ADSContext.ServerGroupProperty.UID));
                            buffer.append(this.EOL);
                        }
                    } else {
                        int uidLength = 0;
                        for (ADSContext.ServerGroupProperty sgp : ADSContext.ServerGroupProperty.values()) {
                            int cur = this.attributeDisplayName.get(sgp).toString().length();
                            if (cur <= uidLength) continue;
                            uidLength = cur;
                        }
                        ++uidLength;
                        for (Map groupProps : result) {
                            int curLen;
                            buffer.append(this.attributeDisplayName.get(ADSContext.ServerGroupProperty.UID));
                            for (int i = curLen = this.attributeDisplayName.get(ADSContext.ServerGroupProperty.UID).length(); i < uidLength; ++i) {
                                buffer.append(" ");
                            }
                            buffer.append(": ");
                            buffer.append(groupProps.get(ADSContext.ServerGroupProperty.UID));
                            buffer.append(this.EOL);
                            for (ADSContext.ServerGroupProperty propName : ADSContext.ServerGroupProperty.values()) {
                                if (propName.compareTo((Enum)ADSContext.ServerGroupProperty.UID) == 0) continue;
                                buffer.append(this.attributeDisplayName.get(propName));
                                for (int i = curLen = this.attributeDisplayName.get(propName).length(); i < uidLength; ++i) {
                                    buffer.append(" ");
                                }
                                buffer.append(": ");
                                if (propName.compareTo((Enum)ADSContext.ServerGroupProperty.MEMBERS) == 0) {
                                    Set atts = (Set)groupProps.get(propName);
                                    if (atts != null) {
                                        boolean indent = false;
                                        for (Object att : atts) {
                                            if (indent) {
                                                buffer.append(this.EOL);
                                                for (int i = 0; i < uidLength + 2; ++i) {
                                                    buffer.append(" ");
                                                }
                                            } else {
                                                indent = true;
                                            }
                                            buffer.append(att.toString().substring(3));
                                        }
                                    }
                                } else if (groupProps.get(propName) != null) {
                                    buffer.append(groupProps.get(propName));
                                }
                                buffer.append(this.EOL);
                            }
                            buffer.append(this.EOL);
                        }
                    }
                    try {
                        outStream.write(buffer.toString().getBytes());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block64;
                }
                if (subCmd.getName().equals(this.modifyGroupSubCmd.getName())) {
                    String groupId = this.modifyGroupGroupNameArg.getValue();
                    HashMap<ADSContext.ServerGroupProperty, String> serverGroupProperties = new HashMap<ADSContext.ServerGroupProperty, String>();
                    HashSet<ADSContext.ServerGroupProperty> serverGroupPropertiesToRemove = new HashSet<ADSContext.ServerGroupProperty>();
                    Boolean updateRequired = false;
                    Boolean removeRequired = false;
                    if (this.modifyGroupGroupIdArg.isPresent()) {
                        serverGroupProperties.put(ADSContext.ServerGroupProperty.UID, this.modifyGroupGroupIdArg.getValue());
                        updateRequired = true;
                    } else {
                        serverGroupProperties.put(ADSContext.ServerGroupProperty.UID, groupId);
                    }
                    if (this.modifyGroupDescriptionArg.isPresent()) {
                        String newDesc = this.modifyGroupDescriptionArg.getValue();
                        if (newDesc.length() == 0) {
                            serverGroupPropertiesToRemove.add(ADSContext.ServerGroupProperty.DESCRIPTION);
                            removeRequired = true;
                        } else {
                            serverGroupProperties.put(ADSContext.ServerGroupProperty.DESCRIPTION, this.modifyGroupDescriptionArg.getValue());
                            updateRequired = true;
                        }
                    }
                    if (!updateRequired.booleanValue() && !removeRequired.booleanValue()) {
                        returnCode = DsFrameworkCliReturnCode.SUCCESSFUL_NOP;
                    }
                    if ((ctx = this.argParser.getContext(outStream, errStream)) == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    if (updateRequired.booleanValue()) {
                        adsCtx.updateServerGroup(groupId, serverGroupProperties);
                    }
                    if (removeRequired.booleanValue()) {
                        adsCtx.removeServerGroupProp(groupId, serverGroupPropertiesToRemove);
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block64;
                }
                if (subCmd.getName().equals(this.addToGroupSubCmd.getName())) {
                    String groupId = this.addToGroupGroupNameArg.getValue();
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set serverList = adsCtx.readServerRegistry();
                    boolean found = false;
                    Map foundServerProperties = null;
                    for (Map serverProperties : serverList) {
                        String serverId = ADSContext.getServerIdFromServerProperties((Map)serverProperties);
                        if (!this.addToGoupMemberNameArg.getValue().equals(serverId)) continue;
                        found = true;
                        foundServerProperties = serverProperties;
                        break;
                    }
                    if (!found) {
                        throw new ADSContextException(ADSContextException.ErrorType.NOT_YET_REGISTERED);
                    }
                    returnCode = DsFrameworkCliServerGroup.addServerTogroup(adsCtx, groupId, foundServerProperties);
                    break block64;
                }
                if (subCmd.getName().equals(this.removeFromGroupSubCmd.getName())) {
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    returnCode = DsFrameworkCliServerGroup.removeServerFromGroup(adsCtx, this.removeFromGroupGroupNameArg.getValue(), this.removeFromGoupMemberNameArg.getValue());
                    break block64;
                }
                if (subCmd.getName().equals(this.listMembersSubCmd.getName())) {
                    String groupId = this.listMembersGroupNameArg.getValue();
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set memberList = adsCtx.getServerGroupMemberList(groupId);
                    if (memberList == null) {
                        returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    }
                    StringBuffer buffer = new StringBuffer();
                    for (String member : memberList) {
                        buffer.append(member.substring(3));
                        buffer.append(this.EOL);
                    }
                    try {
                        outStream.write(buffer.toString().getBytes());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block64;
                }
                if (subCmd.getName().equals(this.listMembershipSubCmd.getName())) {
                    ctx = this.argParser.getContext(outStream, errStream);
                    if (ctx == null) {
                        return DsFrameworkCliReturnCode.CANNOT_CONNECT_TO_ADS;
                    }
                    adsCtx = new ADSContext((InitialLdapContext)ctx);
                    Set result = adsCtx.readServerGroupRegistry();
                    String MemberId = this.listMembershipMemberNameArg.getValue();
                    StringBuffer buffer = new StringBuffer();
                    block23: for (Map groupProps : result) {
                        String groupId = groupProps.get(ADSContext.ServerGroupProperty.UID).toString();
                        for (ADSContext.ServerGroupProperty propName : groupProps.keySet()) {
                            if (propName.compareTo((Enum)ADSContext.ServerGroupProperty.MEMBERS) != 0) continue;
                            Set atts = (Set)groupProps.get(propName);
                            for (Object att : atts) {
                                if (!att.toString().substring(3).toLowerCase().equals(MemberId.toLowerCase())) continue;
                                buffer.append(groupId);
                                buffer.append(this.EOL);
                                continue block23;
                            }
                            continue block23;
                        }
                    }
                    try {
                        outStream.write(buffer.toString().getBytes());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
                    break block64;
                }
                returnCode = DsFrameworkCliReturnCode.ERROR_UNEXPECTED;
            }
            catch (ADSContextException e) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException x) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException x) {
                // empty catch block
            }
        }
        return returnCode;
    }

    static DsFrameworkCliReturnCode removeServerFromGroup(ADSContext adsCtx, String groupId, String serverId) throws ADSContextException {
        String memberToRemove;
        DsFrameworkCliReturnCode returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
        Set memberList = adsCtx.getServerGroupMemberList(groupId);
        if (memberList == null) {
            returnCode = DsFrameworkCliReturnCode.NOT_YET_REGISTERED;
        }
        if (!memberList.contains(memberToRemove = "cn=" + Rdn.escapeValue(serverId))) {
            returnCode = DsFrameworkCliReturnCode.NOT_YET_REGISTERED;
        }
        memberList.remove(memberToRemove);
        HashMap<ADSContext.ServerGroupProperty, Set> serverGroupProperties = new HashMap<ADSContext.ServerGroupProperty, Set>();
        serverGroupProperties.put(ADSContext.ServerGroupProperty.MEMBERS, memberList);
        adsCtx.updateServerGroup(groupId, serverGroupProperties);
        Set serverList = adsCtx.readServerRegistry();
        boolean found = false;
        Map serverProperties = null;
        for (Map elm : serverList) {
            if (!serverId.equals(elm.get(ADSContext.ServerProperty.ID))) continue;
            found = true;
            serverProperties = elm;
            break;
        }
        if (!found) {
            return DsFrameworkCliReturnCode.SERVER_NOT_REGISTERED;
        }
        Set rawGroupList = (Set)serverProperties.get(ADSContext.ServerProperty.GROUPS);
        HashSet<String> groupList = new HashSet<String>();
        if (rawGroupList != null) {
            for (Object elm : rawGroupList.toArray()) {
                if (groupId.equals(elm)) continue;
                groupList.add(elm.toString());
            }
        }
        serverProperties.put(ADSContext.ServerProperty.GROUPS, groupList);
        adsCtx.updateServer(serverProperties, null);
        return returnCode;
    }

    static DsFrameworkCliReturnCode addServerTogroup(ADSContext adsCtx, String groupId, Map<ADSContext.ServerProperty, Object> map) throws ADSContextException {
        String newMember;
        DsFrameworkCliReturnCode returnCode = DsFrameworkCliReturnCode.SUCCESSFUL;
        String serverId = (String)map.get(ADSContext.ServerProperty.ID);
        HashMap serverGroupProperties = new HashMap();
        HashSet<String> memberList = adsCtx.getServerGroupMemberList(groupId);
        if (memberList == null) {
            memberList = new HashSet<String>();
        }
        if (memberList.contains(newMember = "cn=" + Rdn.escapeValue(serverId))) {
            returnCode = DsFrameworkCliReturnCode.ALREADY_REGISTERED;
        }
        memberList.add(newMember);
        serverGroupProperties.put(ADSContext.ServerGroupProperty.MEMBERS, memberList);
        adsCtx.updateServerGroup(groupId, serverGroupProperties);
        Set rawGroupList = (Set)map.get(ADSContext.ServerProperty.GROUPS);
        HashSet<String> groupList = new HashSet<String>();
        if (rawGroupList != null) {
            for (Object elm : rawGroupList.toArray()) {
                groupList.add(elm.toString());
            }
        }
        groupList.add(groupId);
        map.put(ADSContext.ServerProperty.GROUPS, groupList);
        adsCtx.updateServer(map, null);
        return returnCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SubCommandNameEnum {
        CREATE_GROUP("create-group"),
        DELETE_GROUP("delete-group"),
        MODIFY_GROUP("modify-group"),
        LIST_GROUPS("list-groups"),
        LIST_MEMBERS("list-members"),
        LIST_MEMBERSHIP("list-membership"),
        ADD_TO_GROUP("add-to-group"),
        REMOVE_FROM_GROUP("remove-from-group");

        private final String name;
        private static final List<String> nameToSubCmdName;

        private SubCommandNameEnum(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static boolean isSubCommand(String name) {
            return nameToSubCmdName.contains(name);
        }

        static {
            nameToSubCmdName = new ArrayList<String>();
            for (SubCommandNameEnum subCmd : SubCommandNameEnum.values()) {
                nameToSubCmdName.add(subCmd.toString());
            }
        }
    }
}

