/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.ldap;

import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.opends.server.admin.client.AuthenticationException;
import org.opends.server.admin.client.AuthenticationNotSupportedException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ldap.LDAPConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JNDIDirContextAdaptor
extends LDAPConnection {
    private final DirContext dirContext;

    public static JNDIDirContextAdaptor adapt(DirContext dirContext) {
        return new JNDIDirContextAdaptor(dirContext);
    }

    public static JNDIDirContextAdaptor simpleBind(String host, int port, String name, String password) throws CommunicationException, AuthenticationNotSupportedException, AuthenticationException {
        InitialLdapContext ctx;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + host + ":" + port);
        env.put("java.naming.security.principal", name);
        env.put("java.naming.security.credentials", password);
        try {
            ctx = new InitialLdapContext(env, null);
        }
        catch (javax.naming.CommunicationException e) {
            throw new CommunicationException(e);
        }
        catch (javax.naming.AuthenticationException e) {
            throw new AuthenticationException(e);
        }
        catch (javax.naming.AuthenticationNotSupportedException e) {
            throw new AuthenticationNotSupportedException(e);
        }
        catch (NamingException e) {
            throw new CommunicationException(e);
        }
        return new JNDIDirContextAdaptor(ctx);
    }

    private JNDIDirContextAdaptor(DirContext dirContext) {
        this.dirContext = dirContext;
    }

    @Override
    public void createEntry(LdapName dn, Attributes attributes) throws NamingException {
        this.dirContext.createSubcontext(dn, attributes);
    }

    @Override
    public void deleteSubtree(LdapName dn) throws NamingException {
        for (LdapName child : this.listEntries(dn, null)) {
            this.deleteSubtree(child);
        }
        this.dirContext.destroySubcontext(dn);
    }

    @Override
    public boolean entryExists(LdapName dn) throws NamingException {
        String filter = "(objectClass=*)";
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        try {
            NamingEnumeration<SearchResult> results = this.dirContext.search((Name)dn, filter, controls);
            if (results.hasMore()) {
                return true;
            }
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Collection<LdapName> listEntries(LdapName dn, String filter) throws NamingException {
        if (filter == null) {
            filter = "(objectClass=*)";
        }
        SearchControls controls = new SearchControls();
        controls.setSearchScope(1);
        LinkedList<LdapName> children = new LinkedList<LdapName>();
        NamingEnumeration<SearchResult> results = this.dirContext.search((Name)dn, filter, controls);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            LdapName child = new LdapName(dn.getRdns());
            child.add(new Rdn(sr.getName()));
            children.add(child);
        }
        return children;
    }

    @Override
    public void modifyEntry(LdapName dn, Attributes mods) throws NamingException {
        ModificationItem[] modList = new ModificationItem[mods.size()];
        NamingEnumeration<? extends Attribute> ne = mods.getAll();
        int i = 0;
        while (ne.hasMore()) {
            ModificationItem modItem;
            modList[i] = modItem = new ModificationItem(2, ne.next());
            ++i;
        }
        this.dirContext.modifyAttributes(dn, modList);
    }

    @Override
    public Attributes readEntry(LdapName dn, Collection<String> attrIds) throws NamingException {
        String[] attrIdList = attrIds.toArray(new String[attrIds.size()]);
        return this.dirContext.getAttributes(dn, attrIdList);
    }
}

