/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.DefinitionResolver;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.PropertyIsMandatoryException;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.PropertyNotFoundException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.client.Property;
import org.opends.server.admin.client.PropertySet;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.client.ldap.LDAPNameBuilder;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.RootCfgDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LDAPManagedObject<T extends ConfigurationClient>
implements ManagedObject<T> {
    private final LDAPManagementContext context;
    private final ManagedObjectDefinition<T, ? extends Configuration> definition;
    private boolean existsOnServer;
    private final PropertyDefinition<?> namingPropertyDefinition;
    private ManagedObjectPath<T, ? extends Configuration> path;
    private final PropertySet properties;

    static ManagedObject<RootCfgClient> getRootManagedObject(LDAPManagementContext context) {
        return new LDAPManagedObject<RootCfgClient>(context, RootCfgDefn.getInstance(), ManagedObjectPath.emptyPath(), new PropertySet(), true, null);
    }

    private static <M extends ConfigurationClient, N extends Configuration> ManagedObjectDefinition<? extends M, ? extends N> getEntryDefinition(final LDAPManagementContext context, AbstractManagedObjectDefinition<M, N> d, LdapName dn) throws NamingException, DefinitionDecodingException {
        Attributes attributes = context.getLDAPConnection().readEntry(dn, Collections.singleton("objectclass"));
        Attribute oc = attributes.get("objectclass");
        if (oc == null) {
            throw new DefinitionDecodingException(DefinitionDecodingException.Reason.NO_TYPE_INFORMATION);
        }
        final HashSet<String> objectClasses = new HashSet<String>();
        NamingEnumeration<?> values = oc.getAll();
        while (values.hasMore()) {
            Object value = values.next();
            if (value == null) continue;
            objectClasses.add(value.toString().toLowerCase().trim());
        }
        if (objectClasses.isEmpty()) {
            throw new DefinitionDecodingException(DefinitionDecodingException.Reason.NO_TYPE_INFORMATION);
        }
        DefinitionResolver resolver = new DefinitionResolver(){

            @Override
            public boolean matches(AbstractManagedObjectDefinition<?, ?> d) {
                String objectClass = context.getLDAPProfile().getObjectClass(d);
                return objectClasses.contains(objectClass);
            }
        };
        return d.resolveManagedObjectDefinition(resolver);
    }

    private LDAPManagedObject(LDAPManagementContext context, ManagedObjectDefinition<T, ? extends Configuration> d, ManagedObjectPath<T, ? extends Configuration> path, PropertySet properties, boolean existsOnServer, PropertyDefinition<?> namingPropertyDefinition) {
        this.definition = d;
        this.context = context;
        this.path = path;
        this.properties = properties;
        this.existsOnServer = existsOnServer;
        this.namingPropertyDefinition = namingPropertyDefinition;
    }

    @Override
    public void commit() throws MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException, ManagedObjectAlreadyExistsException {
        LinkedList<PropertyIsMandatoryException> exceptions = new LinkedList<PropertyIsMandatoryException>();
        for (PropertyDefinition<?> pd : this.definition.getAllPropertyDefinitions()) {
            Property<?> p = this.properties.getProperty(pd);
            if (!pd.hasOption(PropertyOption.MANDATORY) || !p.getEffectiveValues().isEmpty()) continue;
            exceptions.add(new PropertyIsMandatoryException(pd));
        }
        if (!exceptions.isEmpty()) {
            throw new MissingMandatoryPropertiesException(exceptions);
        }
        if (this.existsOnServer) {
            this.commitExistingManagedObject();
        } else {
            this.commitNewManagedObject();
        }
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration, CC extends C> ManagedObject<CC> createChild(InstantiableRelationDefinition<C, S> r, ManagedObjectDefinition<CC, ? extends S> d, String name, Collection<DefaultBehaviorException> exceptions) throws IllegalManagedObjectNameException, IllegalArgumentException {
        this.validateRelationDefinition(r);
        if (name.trim().length() == 0) {
            throw new IllegalManagedObjectNameException(name);
        }
        PropertyDefinition<?> pd = r.getNamingPropertyDefinition();
        if (pd != null) {
            try {
                pd.decodeValue(name);
            }
            catch (IllegalPropertyValueStringException e) {
                throw new IllegalManagedObjectNameException(name, pd);
            }
        }
        ManagedObjectPath<C, ? extends S> childPath = this.path.child(r, d, name);
        return this.createNewManagedObject(d, childPath, pd, name, exceptions);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration, CC extends C> ManagedObject<CC> createChild(OptionalRelationDefinition<C, S> r, ManagedObjectDefinition<CC, ? extends S> d, Collection<DefaultBehaviorException> exceptions) throws IllegalArgumentException {
        this.validateRelationDefinition(r);
        ManagedObjectPath<C, ? extends S> childPath = this.path.child(r, d);
        return this.createNewManagedObject(d, childPath, null, null, exceptions);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getChild(InstantiableRelationDefinition<C, S> r, String name) throws IllegalArgumentException, DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        return this.readManagedObject(r.getChildDefinition(), this.path.child(r, name));
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getChild(OptionalRelationDefinition<C, S> r) throws IllegalArgumentException, DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        return this.readManagedObject(r.getChildDefinition(), this.path.child(r));
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getChild(SingletonRelationDefinition<C, S> r) throws IllegalArgumentException, DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        return this.readManagedObject(r.getChildDefinition(), this.path.child(r));
    }

    @Override
    public T getConfiguration() {
        return this.definition.createClientConfiguration(this);
    }

    @Override
    public ManagedObjectDefinition<T, ? extends Configuration> getManagedObjectDefinition() {
        return this.definition;
    }

    @Override
    public ManagedObjectPath<T, ? extends Configuration> getManagedObjectPath() {
        return this.path;
    }

    @Override
    public <P> SortedSet<P> getPropertyDefaultValues(PropertyDefinition<P> pd) throws IllegalArgumentException {
        Property<P> p = this.properties.getProperty(pd);
        return p.getDefaultValues();
    }

    @Override
    public <P> P getPropertyValue(PropertyDefinition<P> pd) throws IllegalArgumentException {
        return this.properties.getPropertyValue(pd);
    }

    @Override
    public <P> SortedSet<P> getPropertyValues(PropertyDefinition<P> pd) throws IllegalArgumentException {
        return this.properties.getPropertyValues((PropertyDefinition)pd);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> boolean hasChild(OptionalRelationDefinition<C, S> r) throws IllegalArgumentException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        ManagedObjectPath<C, S> p = this.path.child(r);
        LdapName dn = LDAPNameBuilder.create(p, this.context.getLDAPProfile());
        return this.entryExists(dn);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> String[] listChildren(InstantiableRelationDefinition<C, S> r) throws IllegalArgumentException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        return this.listChildren(r, r.getChildDefinition());
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> String[] listChildren(InstantiableRelationDefinition<C, S> r, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws IllegalArgumentException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        LdapName dn = LDAPNameBuilder.create(this.path, r, this.context.getLDAPProfile());
        StringBuilder builder = new StringBuilder();
        builder.append("(objectclass=");
        builder.append(this.context.getLDAPProfile().getObjectClass(d));
        builder.append(')');
        String filter = builder.toString();
        ArrayList<String> children = new ArrayList<String>();
        try {
            for (LdapName child : this.context.getLDAPConnection().listEntries(dn, filter)) {
                children.add(child.getRdn(child.size() - 1).getValue().toString());
            }
        }
        catch (NameNotFoundException e) {
        }
        catch (NamingException e) {
            this.adaptNamingException(e);
        }
        return children.toArray(new String[children.size()]);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void removeChild(InstantiableRelationDefinition<C, S> r, String name) throws IllegalArgumentException, ManagedObjectNotFoundException, OperationRejectedException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        ManagedObjectPath<C, S> p = this.path.child(r, name);
        this.removeManagedObject(p);
    }

    @Override
    public <C extends ConfigurationClient, S extends Configuration> void removeChild(OptionalRelationDefinition<C, S> r) throws IllegalArgumentException, ManagedObjectNotFoundException, OperationRejectedException, ConcurrentModificationException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(r);
        this.ensureThisManagedObjectExists();
        ManagedObjectPath<C, S> p = this.path.child(r);
        this.removeManagedObject(p);
    }

    @Override
    public <P> void setPropertyValue(PropertyDefinition<P> pd, P value) throws IllegalPropertyValueException, PropertyIsReadOnlyException, PropertyIsMandatoryException, IllegalArgumentException {
        if (value == null) {
            this.setPropertyValues(pd, Collections.emptySet());
        } else {
            this.setPropertyValues(pd, Collections.singleton(value));
        }
    }

    @Override
    public <P> void setPropertyValues(PropertyDefinition<P> pd, Collection<P> values) throws IllegalPropertyValueException, PropertyIsSingleValuedException, PropertyIsReadOnlyException, PropertyIsMandatoryException, IllegalArgumentException {
        if (pd.hasOption(PropertyOption.MONITORING)) {
            throw new PropertyIsReadOnlyException(pd);
        }
        if (this.existsOnServer && pd.hasOption(PropertyOption.READ_ONLY)) {
            throw new PropertyIsReadOnlyException(pd);
        }
        this.properties.setPropertyValues(pd, values);
        if (pd.equals(this.namingPropertyDefinition)) {
            String newName = pd.encodeValue(values.iterator().next());
            this.path = this.path.rename(newName);
        }
    }

    private void adaptNamingException(NamingException ne) throws CommunicationException, AuthorizationException {
        try {
            throw ne;
        }
        catch (javax.naming.CommunicationException e) {
            throw new CommunicationException(e);
        }
        catch (ServiceUnavailableException e) {
            throw new CommunicationException(e);
        }
        catch (NoPermissionException e) {
            throw new AuthorizationException(e);
        }
        catch (NamingException e) {
            throw new CommunicationException(e);
        }
    }

    private void commitExistingManagedObject() throws ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
        BasicAttributes mods = new BasicAttributes();
        for (PropertyDefinition<?> pd : this.definition.getAllPropertyDefinitions()) {
            Property<?> p = this.properties.getProperty(pd);
            if (!p.isModified()) continue;
            String attrID = this.context.getLDAPProfile().getAttributeName(this.definition, pd);
            BasicAttribute attribute = new BasicAttribute(attrID);
            this.encodeProperty(attribute, pd, this.properties);
            mods.put(attribute);
        }
        if (mods.size() > 0) {
            try {
                LdapName dn = LDAPNameBuilder.create(this.path, this.context.getLDAPProfile());
                this.context.getLDAPConnection().modifyEntry(dn, mods);
            }
            catch (NoPermissionException e) {
                throw new AuthorizationException(e);
            }
            catch (OperationNotSupportedException e) {
                throw new OperationRejectedException(e);
            }
            catch (NamingException e) {
                throw new CommunicationException(e);
            }
        }
        this.properties.commit();
    }

    private void commitNewManagedObject() throws AuthorizationException, CommunicationException, OperationRejectedException, ConcurrentModificationException, ManagedObjectAlreadyExistsException {
        InstantiableRelationDefinition ir;
        LdapName dn;
        LdapName dn2;
        ManagedObjectPath<?, ?> parent = this.path.parent();
        if (!parent.isEmpty() && !this.entryExists(dn2 = LDAPNameBuilder.create(parent, this.context.getLDAPProfile()))) {
            throw new ConcurrentModificationException();
        }
        RelationDefinition<T, ? extends Configuration> r = this.path.getRelationDefinition();
        if (r instanceof InstantiableRelationDefinition && !this.entryExists(dn = LDAPNameBuilder.create(parent, ir = (InstantiableRelationDefinition)r, this.context.getLDAPProfile()))) {
            BasicAttributes attributes = new BasicAttributes();
            BasicAttribute oc = new BasicAttribute("objectClass");
            for (String objectClass : this.context.getLDAPProfile().getInstantiableRelationObjectClasses(ir)) {
                oc.add(objectClass);
            }
            attributes.put(oc);
            Rdn rdn = dn.getRdn(dn.size() - 1);
            attributes.put(rdn.getType(), rdn.getValue().toString());
            try {
                this.context.getLDAPConnection().createEntry(dn, attributes);
            }
            catch (OperationNotSupportedException e) {
                throw new OperationRejectedException(e);
            }
            catch (NamingException e) {
                this.adaptNamingException(e);
            }
        }
        LdapName dn3 = LDAPNameBuilder.create(this.path, this.context.getLDAPProfile());
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute oc = new BasicAttribute("objectclass");
        for (String string : this.context.getLDAPProfile().getObjectClasses(this.definition)) {
            oc.add(string);
        }
        attributes.put(oc);
        if (this.namingPropertyDefinition == null) {
            Rdn rdn = dn3.getRdn(dn3.size() - 1);
            attributes.put(rdn.getType(), rdn.getValue().toString());
        }
        for (PropertyDefinition propertyDefinition : this.definition.getAllPropertyDefinitions()) {
            String attrID = this.context.getLDAPProfile().getAttributeName(this.definition, propertyDefinition);
            BasicAttribute attribute = new BasicAttribute(attrID);
            this.encodeProperty(attribute, propertyDefinition, this.properties);
            if (attribute.size() == 0) continue;
            attributes.put(attribute);
        }
        try {
            this.context.getLDAPConnection().createEntry(dn3, attributes);
        }
        catch (NameAlreadyBoundException e) {
            throw new ManagedObjectAlreadyExistsException();
        }
        catch (OperationNotSupportedException e) {
            throw new OperationRejectedException(e);
        }
        catch (NamingException e) {
            this.adaptNamingException(e);
        }
        this.properties.commit();
        this.existsOnServer = true;
    }

    private <M extends ConfigurationClient, N extends Configuration> ManagedObject<M> createExistingManagedObject(ManagedObjectDefinition<M, N> d, ManagedObjectPath<? super M, ? super N> p, PropertySet properties) {
        RelationDefinition<? super M, ? super N> rd = p.getRelationDefinition();
        PropertyDefinition<?> pd = null;
        if (rd instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition ird = (InstantiableRelationDefinition)rd;
            pd = ird.getNamingPropertyDefinition();
        }
        return new LDAPManagedObject<M>(this.context, d, p.asSubType(d), properties, true, pd);
    }

    private <M extends ConfigurationClient, P> ManagedObject<M> createNewManagedObject(ManagedObjectDefinition<M, ?> d, ManagedObjectPath<M, ?> p, PropertyDefinition<P> namingPropertyDefinition, String name, Collection<DefaultBehaviorException> exceptions) {
        PropertySet childProperties = new PropertySet();
        for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
            try {
                this.createProperty(childProperties, p, pd);
            }
            catch (DefaultBehaviorException e) {
                if (exceptions == null) continue;
                exceptions.add(e);
            }
        }
        if (namingPropertyDefinition != null) {
            P value = namingPropertyDefinition.decodeValue(name);
            childProperties.setPropertyValue(namingPropertyDefinition, value);
        }
        return new LDAPManagedObject<M>(this.context, d, p, childProperties, false, namingPropertyDefinition);
    }

    private <P> void createProperty(PropertySet properties, ManagedObjectPath<?, ?> p, PropertyDefinition<P> pd) throws DefaultBehaviorException {
        try {
            Collection<P> defaultValues = DefaultValueFinder.getDefaultValues(this.context, p, pd, true);
            properties.addProperty(pd, defaultValues, Collections.emptySet());
        }
        catch (DefaultBehaviorException e) {
            properties.addProperty(pd, Collections.emptySet(), Collections.emptySet());
            throw e;
        }
    }

    private <P> void decodeProperty(PropertySet newProperties, ManagedObjectPath<?, ?> p, PropertyDefinition<P> pd, List<String> values) throws PropertyException {
        Collection<Object> defaultValues;
        PropertyException exception = null;
        ArrayList<Object> activeValues = new ArrayList<Object>(values.size());
        for (String value : values) {
            try {
                activeValues.add(pd.decodeValue(value));
            }
            catch (IllegalPropertyValueStringException e) {
                exception = e;
            }
        }
        if (activeValues.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
            exception = new PropertyIsSingleValuedException(pd);
            Object value = activeValues.iterator().next();
            activeValues.clear();
            activeValues.add(value);
        }
        if (activeValues.isEmpty() && pd.hasOption(PropertyOption.MANDATORY) && exception == null) {
            exception = new PropertyIsMandatoryException(pd);
        }
        try {
            defaultValues = DefaultValueFinder.getDefaultValues(this.context, p, pd, false);
        }
        catch (DefaultBehaviorException e) {
            defaultValues = Collections.emptySet();
            exception = e;
        }
        newProperties.addProperty(pd, defaultValues, activeValues);
        if (exception != null) {
            throw exception;
        }
    }

    private <P> void encodeProperty(Attribute attribute, PropertyDefinition<P> pd, PropertySet properties) {
        Property<P> p = properties.getProperty(pd);
        if (pd.hasOption(PropertyOption.MANDATORY)) {
            for (Object value : p.getEffectiveValues()) {
                attribute.add(pd.encodeValue(value));
            }
        } else {
            for (Object value : p.getPendingValues()) {
                attribute.add(pd.encodeValue(value));
            }
        }
    }

    private void ensureThisManagedObjectExists() throws ConcurrentModificationException, CommunicationException, AuthorizationException {
        LdapName dn;
        if (!this.path.isEmpty() && !this.entryExists(dn = LDAPNameBuilder.create(this.path, this.context.getLDAPProfile()))) {
            throw new ConcurrentModificationException();
        }
    }

    private boolean entryExists(LdapName dn) throws CommunicationException, AuthorizationException {
        try {
            return this.context.getLDAPConnection().entryExists(dn);
        }
        catch (NamingException e) {
            this.adaptNamingException(e);
            return false;
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> readManagedObject(AbstractManagedObjectDefinition<C, S> d, ManagedObjectPath<C, S> p) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, AuthorizationException, CommunicationException {
        try {
            LdapName dn = LDAPNameBuilder.create(p, this.context.getLDAPProfile());
            ManagedObjectDefinition<C, S> mod = LDAPManagedObject.getEntryDefinition(this.context, d, dn);
            ArrayList<String> attrIds = new ArrayList<String>();
            for (PropertyDefinition<?> pd : mod.getAllPropertyDefinitions()) {
                String attrId = this.context.getLDAPProfile().getAttributeName(mod, pd);
                attrIds.add(attrId);
            }
            Attributes attributes = this.context.getLDAPConnection().readEntry(dn, attrIds);
            LinkedList<PropertyException> exceptions = new LinkedList<PropertyException>();
            PropertySet newProperties = new PropertySet();
            for (PropertyDefinition<?> pd : mod.getAllPropertyDefinitions()) {
                String attrID = this.context.getLDAPProfile().getAttributeName(mod, pd);
                Attribute attribute = attributes.get(attrID);
                LinkedList<String> values = new LinkedList<String>();
                if (attribute != null && attribute.size() != 0) {
                    NamingEnumeration<?> ldapValues = attribute.getAll();
                    while (ldapValues.hasMore()) {
                        Object obj = ldapValues.next();
                        if (obj == null) continue;
                        values.add(obj.toString());
                    }
                }
                try {
                    this.decodeProperty(newProperties, p, pd, values);
                }
                catch (PropertyException e) {
                    exceptions.add(e);
                }
            }
            ManagedObject<C> mo = this.createExistingManagedObject(mod, p, newProperties);
            if (exceptions.isEmpty()) {
                return mo;
            }
            throw new ManagedObjectDecodingException(mo, exceptions);
        }
        catch (NameNotFoundException e) {
            throw new ManagedObjectNotFoundException();
        }
        catch (NoPermissionException e) {
            throw new AuthorizationException(e);
        }
        catch (NamingException e) {
            throw new CommunicationException(e);
        }
    }

    private void removeManagedObject(ManagedObjectPath<?, ?> p) throws CommunicationException, AuthorizationException, OperationRejectedException, ManagedObjectNotFoundException {
        LdapName dn = LDAPNameBuilder.create(p, this.context.getLDAPProfile());
        if (this.entryExists(dn)) {
            try {
                this.context.getLDAPConnection().deleteSubtree(dn);
            }
            catch (OperationNotSupportedException e) {
                throw new OperationRejectedException(e);
            }
            catch (NamingException e) {
                this.adaptNamingException(e);
            }
        } else {
            throw new ManagedObjectNotFoundException();
        }
    }

    private void validateRelationDefinition(RelationDefinition<?, ?> rd) throws IllegalArgumentException {
        ManagedObjectDefinition<T, Configuration> d = this.getManagedObjectDefinition();
        RelationDefinition<?, ?> tmp = d.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation " + rd.getName() + " is not associated with a " + d.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultValueFinder<T>
    implements DefaultBehaviorProviderVisitor<T, Collection<T>, Void> {
        private final LDAPManagementContext context;
        private DefaultBehaviorException exception = null;
        private final boolean isCreate;
        private final ManagedObjectPath<?, ?> firstPath;
        private ManagedObjectPath<?, ?> nextPath = null;
        private PropertyDefinition<T> nextProperty = null;

        public static <T> Collection<T> getDefaultValues(LDAPManagementContext context, ManagedObjectPath<?, ?> p, PropertyDefinition<T> pd, boolean isCreate) throws DefaultBehaviorException {
            DefaultValueFinder<T> v = new DefaultValueFinder<T>(context, p, isCreate);
            return super.find(p, pd);
        }

        private DefaultValueFinder(LDAPManagementContext context, ManagedObjectPath<?, ?> p, boolean isCreate) {
            this.context = context;
            this.firstPath = p;
            this.isCreate = isCreate;
        }

        @Override
        public Collection<T> visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (DefaultBehaviorException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitAlias(AliasDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        @Override
        public Collection<T> visitDefined(DefinedDefaultBehaviorProvider<T> d, Void p) {
            Collection<String> stringValues = d.getDefaultValues();
            ArrayList<T> values = new ArrayList<T>(stringValues.size());
            for (String stringValue : stringValues) {
                try {
                    values.add(this.nextProperty.decodeValue(stringValue));
                }
                catch (IllegalPropertyValueStringException e) {
                    this.exception = new DefaultBehaviorException(this.nextProperty, (Throwable)e);
                    break;
                }
            }
            return values;
        }

        @Override
        public Collection<T> visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(this.nextPath), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (DefaultBehaviorException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitUndefined(UndefinedDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        private Collection<T> find(ManagedObjectPath<?, ?> p, PropertyDefinition<T> pd) throws DefaultBehaviorException {
            this.nextPath = p;
            this.nextProperty = pd;
            Collection values = (Collection)this.nextProperty.getDefaultBehaviorProvider().accept(this, null);
            if (this.exception != null) {
                throw this.exception;
            }
            if (values.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
                throw new DefaultBehaviorException(pd, (Throwable)new PropertyIsSingleValuedException(pd));
            }
            return values;
        }

        private Collection<T> getInheritedProperty(ManagedObjectPath target, AbstractManagedObjectDefinition<?, ?> d, String propertyName) throws DefaultBehaviorException {
            AbstractManagedObjectDefinition supr = target.getManagedObjectDefinition();
            if (!supr.isParentOf(d)) {
                throw new DefaultBehaviorException(this.nextProperty, (Throwable)new DefinitionDecodingException(DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION));
            }
            PropertyDefinition<T> pd1 = this.nextProperty;
            try {
                PropertyDefinition pd2;
                if (this.isCreate && this.firstPath.equals(target)) {
                    PropertyDefinition pd22;
                    try {
                        PropertyDefinition<?> pdTmp = d.getPropertyDefinition(propertyName);
                        pd22 = (PropertyDefinition)pd1.getClass().cast(pdTmp);
                    }
                    catch (IllegalArgumentException e) {
                        throw new PropertyNotFoundException(propertyName);
                    }
                    catch (ClassCastException e) {
                        throw new PropertyNotFoundException(propertyName);
                    }
                    Collection<T> tmp = this.find(target, pd22);
                    ArrayList<T> values = new ArrayList<T>(tmp.size());
                    for (T value : tmp) {
                        pd1.validateValue(value);
                        values.add(value);
                    }
                    return values;
                }
                LdapName dn = LDAPNameBuilder.create(target, this.context.getLDAPProfile());
                ManagedObjectDefinition mod = LDAPManagedObject.getEntryDefinition(this.context, d, dn);
                try {
                    PropertyDefinition<?> pdTmp = mod.getPropertyDefinition(propertyName);
                    pd2 = (PropertyDefinition)pd1.getClass().cast(pdTmp);
                }
                catch (IllegalArgumentException e) {
                    throw new PropertyNotFoundException(propertyName);
                }
                catch (ClassCastException e) {
                    throw new PropertyNotFoundException(propertyName);
                }
                String attrID = this.context.getLDAPProfile().getAttributeName(mod, pd2);
                Attributes attributes = this.context.getLDAPConnection().readEntry(dn, Collections.singleton(attrID));
                Attribute attr = attributes.get(attrID);
                if (attr == null || attr.size() == 0) {
                    Collection<T> tmp = this.find(target, pd2);
                    ArrayList<T> values = new ArrayList<T>(tmp.size());
                    for (T value : tmp) {
                        pd1.validateValue(value);
                        values.add(value);
                    }
                    return values;
                }
                LinkedList<T> values = new LinkedList<T>();
                NamingEnumeration<?> ne = attr.getAll();
                while (ne.hasMore()) {
                    Object value = ne.next();
                    if (value == null) continue;
                    values.add(pd1.decodeValue(value.toString()));
                }
                return values;
            }
            catch (DefaultBehaviorException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (DefinitionDecodingException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (PropertyNotFoundException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (IllegalPropertyValueException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (IllegalPropertyValueStringException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (NameNotFoundException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)new ManagedObjectNotFoundException());
            }
            catch (NoPermissionException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)new AuthorizationException(e));
            }
            catch (NamingException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)new CommunicationException(e));
            }
        }
    }
}

