/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import java.util.HashMap;
import java.util.Map;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

final class CleanerConfigDeleteListener
implements ConfigDeleteListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Map<DN, ConfigChangeListener> changeListeners = new HashMap<DN, ConfigChangeListener>();
    private final DN dn;

    public CleanerConfigDeleteListener(DN dn) {
        this.dn = dn;
    }

    public void addConfigChangeListener(DN dn, ConfigChangeListener listener) {
        this.changeListeners.put(dn, listener);
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        if (configEntry.getDN().equals(this.dn)) {
            for (Map.Entry<DN, ConfigChangeListener> me : this.changeListeners.entrySet()) {
                ConfigEntry listenerConfigEntry = this.getConfigEntry(me.getKey());
                if (listenerConfigEntry == null) continue;
                listenerConfigEntry.deregisterChangeListener(me.getValue());
            }
            ConfigEntry parentConfigEntry = this.getConfigEntry(this.dn.getParent());
            if (parentConfigEntry != null) {
                parentConfigEntry.deregisterDeleteListener(this);
            }
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder unacceptableReason) {
        return true;
    }

    private ConfigEntry getConfigEntry(DN dn) {
        try {
            ConfigEntry configEntry = DirectoryServer.getConfigEntry(dn);
            if (configEntry != null) {
                return configEntry;
            }
            int msgID = 0xD40004;
            String message = MessageHandler.getMessage(msgID, String.valueOf(dn));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, message, msgID);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 13893635;
            String message = MessageHandler.getMessage(msgID, String.valueOf(dn), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, message, msgID);
        }
        return null;
    }
}

