/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.DecodingException;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.server.AbstractConfigListenerAdaptor;
import org.opends.server.admin.server.CleanerConfigDeleteListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.DNBuilder;
import org.opends.server.admin.server.DependencyConfigChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigChangeListenerAdaptor<S extends Configuration>
extends AbstractConfigListenerAdaptor
implements ConfigChangeListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ServerManagedObject<? extends S> cachedManagedObject;
    private final AbstractManagedObjectDefinition<?, S> d;
    private final Set<DN> dependencies;
    private final DependencyConfigChangeListener dependencyListener;
    private final DN dn;
    private final ConfigurationChangeListener<? super S> listener;
    private final ManagedObjectPath<?, ?> path;

    public ConfigChangeListenerAdaptor(ManagedObjectPath<?, ?> path, AbstractManagedObjectDefinition<?, S> d, ConfigurationChangeListener<? super S> listener) {
        ConfigEntry configEntry;
        this.path = path;
        this.dn = DNBuilder.create(path);
        this.d = d;
        this.listener = listener;
        this.cachedManagedObject = null;
        this.dependencies = new HashSet<DN>();
        this.dependencyListener = new DependencyConfigChangeListener(this.dn, this);
        for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
            Visitor.find(path, pd, this.dependencies);
        }
        CleanerConfigDeleteListener cleaner = new CleanerConfigDeleteListener(this.dn);
        for (DN entryDN : this.dependencies) {
            ConfigEntry configEntry2;
            if (entryDN.equals(this.dn) || (configEntry2 = this.getConfigEntry(entryDN)) == null) continue;
            configEntry2.registerChangeListener(this.dependencyListener);
            cleaner.addConfigChangeListener(entryDN, this.dependencyListener);
        }
        DN parent = this.dn.getParent();
        if (parent != null && (configEntry = this.getConfigEntry(this.dn.getParent())) != null) {
            configEntry.registerDeleteListener(cleaner);
        }
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        return this.applyConfigurationChange(configEntry, configEntry);
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry, ConfigEntry newConfigEntry) {
        this.cachedManagedObject.setConfigEntry(configEntry);
        return this.listener.applyConfigurationChange(this.cachedManagedObject.getConfiguration());
    }

    @Override
    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder unacceptableReason) {
        return this.configChangeIsAcceptable(configEntry, unacceptableReason, configEntry);
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder unacceptableReason, ConfigEntry newConfigEntry) {
        try {
            this.cachedManagedObject = ServerManagedObject.decode(this.path, this.d, configEntry, newConfigEntry);
        }
        catch (DecodingException e) {
            this.generateUnacceptableReason(e, unacceptableReason);
            return false;
        }
        LinkedList<String> reasons = new LinkedList<String>();
        if (this.listener.isConfigurationChangeAcceptable(this.cachedManagedObject.getConfiguration(), reasons)) {
            return true;
        }
        this.generateUnacceptableReason(reasons, unacceptableReason);
        return false;
    }

    ConfigurationChangeListener<? super S> getConfigurationChangeListener() {
        return this.listener;
    }

    private ConfigEntry getConfigEntry(DN dn) {
        try {
            ConfigEntry configEntry = DirectoryServer.getConfigEntry(dn);
            if (configEntry != null) {
                return configEntry;
            }
            int msgID = 0xD40004;
            String message = MessageHandler.getMessage(msgID, String.valueOf(dn));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 13893635;
            String message = MessageHandler.getMessage(msgID, String.valueOf(dn), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Visitor<T>
    implements DefaultBehaviorProviderVisitor<T, Void, ManagedObjectPath<?, ?>> {
        private final Collection<DN> dependencies;

        public static <T> void find(ManagedObjectPath<?, ?> path, PropertyDefinition<T> pd, Collection<DN> dependencies) {
            Visitor<T> v = new Visitor<T>(dependencies);
            DefaultBehaviorProvider<T> db = pd.getDefaultBehaviorProvider();
            db.accept(v, path);
        }

        private Visitor(Collection<DN> dependencies) {
            this.dependencies = dependencies;
        }

        @Override
        public Void visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            ManagedObjectPath<?, ?> next = d.getManagedObjectPath();
            this.dependencies.add(DNBuilder.create(next));
            String propertyName = d.getPropertyName();
            AbstractManagedObjectDefinition<?, ?> mod = d.getManagedObjectDefinition();
            PropertyDefinition<?> pd = mod.getPropertyDefinition(propertyName);
            Visitor.find(next, pd, this.dependencies);
            return null;
        }

        @Override
        public Void visitAlias(AliasDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            return null;
        }

        @Override
        public Void visitDefined(DefinedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            return null;
        }

        @Override
        public Void visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            ManagedObjectPath<?, ?> next = d.getManagedObjectPath(p);
            this.dependencies.add(DNBuilder.create(next));
            String propertyName = d.getPropertyName();
            AbstractManagedObjectDefinition<?, ?> mod = d.getManagedObjectDefinition();
            PropertyDefinition<?> pd = mod.getPropertyDefinition(propertyName);
            Visitor.find(next, pd, this.dependencies);
            return null;
        }

        @Override
        public Void visitUndefined(UndefinedDefaultBehaviorProvider<T> d, ManagedObjectPath<?, ?> p) {
            return null;
        }
    }
}

