/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ResultCode;

final class DelayedConfigAddListener
implements ConfigAddListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final DN parent;
    private final DN child;
    private final ConfigAddListener delayedAddListener;
    private final ConfigDeleteListener delayedDeleteListener;

    public DelayedConfigAddListener(DN child, ConfigAddListener addListener) {
        this.parent = child.getParent();
        this.child = child;
        this.delayedAddListener = addListener;
        this.delayedDeleteListener = null;
    }

    public DelayedConfigAddListener(DN child, ConfigDeleteListener deleteListener) {
        this.parent = child.getParent();
        this.child = child;
        this.delayedAddListener = null;
        this.delayedDeleteListener = deleteListener;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        block6: {
            if (configEntry.getDN().equals(this.child)) {
                if (this.delayedAddListener != null) {
                    configEntry.registerAddListener(this.delayedAddListener);
                }
                if (this.delayedDeleteListener != null) {
                    configEntry.registerDeleteListener(this.delayedDeleteListener);
                }
                try {
                    ConfigEntry myEntry = DirectoryServer.getConfigEntry(this.parent);
                    if (myEntry != null) {
                        myEntry.deregisterAddListener(this);
                    }
                }
                catch (ConfigException e) {
                    if (!DebugLogger.debugEnabled()) break block6;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder unacceptableReason) {
        return true;
    }

    ConfigAddListener getDelayedAddListener() {
        return this.delayedAddListener;
    }

    ConfigDeleteListener getDelayedDeleteListener() {
        return this.delayedDeleteListener;
    }
}

