/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.BackendCfgClient;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BackendCfgDefn
extends ManagedObjectDefinition<BackendCfgClient, BackendCfg> {
    private static final BackendCfgDefn INSTANCE = new BackendCfgDefn();
    private static final DNPropertyDefinition PD_BACKEND_BASE_DN;
    private static final ClassPropertyDefinition PD_BACKEND_CLASS;
    private static final BooleanPropertyDefinition PD_BACKEND_ENABLED;
    private static final StringPropertyDefinition PD_BACKEND_ID;
    private static final EnumPropertyDefinition<BackendWritabilityMode> PD_BACKEND_WRITABILITY_MODE;

    public static BackendCfgDefn getInstance() {
        return INSTANCE;
    }

    private BackendCfgDefn() {
        super("backend", null);
    }

    @Override
    public BackendCfgClient createClientConfiguration(ManagedObject<? extends BackendCfgClient> impl) {
        return new BackendCfgClientImpl(impl);
    }

    @Override
    public BackendCfg createServerConfiguration(ServerManagedObject<? extends BackendCfg> impl) {
        return new BackendCfgServerImpl(impl);
    }

    @Override
    public Class<BackendCfg> getServerConfigurationClass() {
        return BackendCfg.class;
    }

    public DNPropertyDefinition getBackendBaseDNPropertyDefinition() {
        return PD_BACKEND_BASE_DN;
    }

    public ClassPropertyDefinition getBackendClassPropertyDefinition() {
        return PD_BACKEND_CLASS;
    }

    public BooleanPropertyDefinition getBackendEnabledPropertyDefinition() {
        return PD_BACKEND_ENABLED;
    }

    public StringPropertyDefinition getBackendIdPropertyDefinition() {
        return PD_BACKEND_ID;
    }

    public EnumPropertyDefinition<BackendWritabilityMode> getBackendWritabilityModePropertyDefinition() {
        return PD_BACKEND_WRITABILITY_MODE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = DNPropertyDefinition.createBuilder(INSTANCE, "backend-base-dn");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "backend-base-dn"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BACKEND_BASE_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_BASE_DN);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "backend-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "backend-class"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.Backend");
        PD_BACKEND_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_CLASS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "backend-enabled");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "backend-enabled"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BACKEND_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_ENABLED);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "backend-id");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "backend-id"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BACKEND_ID = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_ID);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "backend-writability-mode");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "backend-writability-mode"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(BackendWritabilityMode.class);
        PD_BACKEND_WRITABILITY_MODE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_WRITABILITY_MODE);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BackendCfgServerImpl
    implements BackendCfg {
        private ServerManagedObject<? extends BackendCfg> impl;

        private BackendCfgServerImpl(ServerManagedObject<? extends BackendCfg> impl) {
            this.impl = impl;
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<DN> getBackendBaseDN() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getBackendBaseDNPropertyDefinition());
        }

        @Override
        public String getBackendClass() {
            return this.impl.getPropertyValue(INSTANCE.getBackendClassPropertyDefinition());
        }

        @Override
        public boolean isBackendEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getBackendEnabledPropertyDefinition());
        }

        @Override
        public String getBackendId() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
        }

        @Override
        public BackendWritabilityMode getBackendWritabilityMode() {
            return this.impl.getPropertyValue(INSTANCE.getBackendWritabilityModePropertyDefinition());
        }

        @Override
        public ManagedObjectDefinition<? extends BackendCfgClient, ? extends BackendCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BackendCfgClientImpl
    implements BackendCfgClient {
        private ManagedObject<? extends BackendCfgClient> impl;

        private BackendCfgClientImpl(ManagedObject<? extends BackendCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<DN> getBackendBaseDN() {
            return this.impl.getPropertyValues(INSTANCE.getBackendBaseDNPropertyDefinition());
        }

        @Override
        public void setBackendBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getBackendBaseDNPropertyDefinition(), values);
        }

        @Override
        public String getBackendClass() {
            return this.impl.getPropertyValue(INSTANCE.getBackendClassPropertyDefinition());
        }

        @Override
        public void setBackendClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getBackendClassPropertyDefinition(), value);
        }

        @Override
        public Boolean isBackendEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getBackendEnabledPropertyDefinition());
        }

        @Override
        public void setBackendEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getBackendEnabledPropertyDefinition(), value);
        }

        @Override
        public String getBackendId() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
        }

        @Override
        public void setBackendId(String value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getBackendIdPropertyDefinition(), value);
        }

        @Override
        public BackendWritabilityMode getBackendWritabilityMode() {
            return this.impl.getPropertyValue(INSTANCE.getBackendWritabilityModePropertyDefinition());
        }

        @Override
        public void setBackendWritabilityMode(BackendWritabilityMode value) {
            this.impl.setPropertyValue(INSTANCE.getBackendWritabilityModePropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends BackendCfgClient, ? extends BackendCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BackendWritabilityMode {
        DISABLED("disabled"),
        ENABLED("enabled"),
        INTERNAL_ONLY("internal-only");

        private final String name;

        private BackendWritabilityMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

