/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.SizePropertyDefinition;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.JEBackendCfgClient;
import org.opends.server.admin.std.client.JEIndexCfgClient;
import org.opends.server.admin.std.client.VLVJEIndexCfgClient;
import org.opends.server.admin.std.meta.BackendCfgDefn;
import org.opends.server.admin.std.meta.JEIndexCfgDefn;
import org.opends.server.admin.std.meta.VLVJEIndexCfgDefn;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.JEBackendCfg;
import org.opends.server.admin.std.server.JEIndexCfg;
import org.opends.server.admin.std.server.VLVJEIndexCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JEBackendCfgDefn
extends ManagedObjectDefinition<JEBackendCfgClient, JEBackendCfg> {
    private static final JEBackendCfgDefn INSTANCE = new JEBackendCfgDefn();
    private static final ClassPropertyDefinition PD_BACKEND_CLASS;
    private static final IntegerPropertyDefinition PD_BACKEND_DEADLOCK_RETRY_LIMIT;
    private static final StringPropertyDefinition PD_BACKEND_DIRECTORY;
    private static final BooleanPropertyDefinition PD_BACKEND_ENTRIES_COMPRESSED;
    private static final SizePropertyDefinition PD_BACKEND_IMPORT_BUFFER_SIZE;
    private static final IntegerPropertyDefinition PD_BACKEND_IMPORT_PASS_SIZE;
    private static final IntegerPropertyDefinition PD_BACKEND_IMPORT_QUEUE_SIZE;
    private static final StringPropertyDefinition PD_BACKEND_IMPORT_TEMP_DIRECTORY;
    private static final IntegerPropertyDefinition PD_BACKEND_IMPORT_THREAD_COUNT;
    private static final IntegerPropertyDefinition PD_BACKEND_INDEX_ENTRY_LIMIT;
    private static final StringPropertyDefinition PD_BACKEND_MODE;
    private static final DurationPropertyDefinition PD_BACKEND_PRELOAD_TIME_LIMIT;
    private static final IntegerPropertyDefinition PD_BACKEND_SUBTREE_DELETE_BATCH_SIZE;
    private static final IntegerPropertyDefinition PD_BACKEND_SUBTREE_DELETE_SIZE_LIMIT;
    private static final IntegerPropertyDefinition PD_DATABASE_CACHE_PERCENT;
    private static final SizePropertyDefinition PD_DATABASE_CACHE_SIZE;
    private static final SizePropertyDefinition PD_DATABASE_CHECKPOINTER_BYTES_INTERVAL;
    private static final DurationPropertyDefinition PD_DATABASE_CHECKPOINTER_WAKEUP_INTERVAL;
    private static final IntegerPropertyDefinition PD_DATABASE_CLEANER_MIN_UTILIZATION;
    private static final IntegerPropertyDefinition PD_DATABASE_CLEANER_NUM_THREADS;
    private static final BooleanPropertyDefinition PD_DATABASE_EVICTOR_LRU_ONLY;
    private static final IntegerPropertyDefinition PD_DATABASE_EVICTOR_NODES_PER_SCAN;
    private static final IntegerPropertyDefinition PD_DATABASE_LOCK_NUM_LOCK_TABLES;
    private static final SizePropertyDefinition PD_DATABASE_LOG_FILE_MAX;
    private static final BooleanPropertyDefinition PD_DATABASE_LOGGING_FILE_HANDLER_ON;
    private static final StringPropertyDefinition PD_DATABASE_LOGGING_LEVEL;
    private static final BooleanPropertyDefinition PD_DATABASE_RUN_CLEANER;
    private static final BooleanPropertyDefinition PD_DATABASE_TXN_NO_SYNC;
    private static final BooleanPropertyDefinition PD_DATABASE_TXN_WRITE_NO_SYNC;
    private static final InstantiableRelationDefinition<JEIndexCfgClient, JEIndexCfg> RD_JE_INDEXES;
    private static final InstantiableRelationDefinition<VLVJEIndexCfgClient, VLVJEIndexCfg> RD_VLV_JE_INDEXES;

    public static JEBackendCfgDefn getInstance() {
        return INSTANCE;
    }

    private JEBackendCfgDefn() {
        super("je-backend", BackendCfgDefn.getInstance());
    }

    @Override
    public JEBackendCfgClient createClientConfiguration(ManagedObject<? extends JEBackendCfgClient> impl) {
        return new JEBackendCfgClientImpl(impl);
    }

    @Override
    public JEBackendCfg createServerConfiguration(ServerManagedObject<? extends JEBackendCfg> impl) {
        return new JEBackendCfgServerImpl(impl);
    }

    @Override
    public Class<JEBackendCfg> getServerConfigurationClass() {
        return JEBackendCfg.class;
    }

    public DNPropertyDefinition getBackendBaseDNPropertyDefinition() {
        return BackendCfgDefn.getInstance().getBackendBaseDNPropertyDefinition();
    }

    public ClassPropertyDefinition getBackendClassPropertyDefinition() {
        return PD_BACKEND_CLASS;
    }

    public IntegerPropertyDefinition getBackendDeadlockRetryLimitPropertyDefinition() {
        return PD_BACKEND_DEADLOCK_RETRY_LIMIT;
    }

    public StringPropertyDefinition getBackendDirectoryPropertyDefinition() {
        return PD_BACKEND_DIRECTORY;
    }

    public BooleanPropertyDefinition getBackendEnabledPropertyDefinition() {
        return BackendCfgDefn.getInstance().getBackendEnabledPropertyDefinition();
    }

    public BooleanPropertyDefinition getBackendEntriesCompressedPropertyDefinition() {
        return PD_BACKEND_ENTRIES_COMPRESSED;
    }

    public StringPropertyDefinition getBackendIdPropertyDefinition() {
        return BackendCfgDefn.getInstance().getBackendIdPropertyDefinition();
    }

    public SizePropertyDefinition getBackendImportBufferSizePropertyDefinition() {
        return PD_BACKEND_IMPORT_BUFFER_SIZE;
    }

    public IntegerPropertyDefinition getBackendImportPassSizePropertyDefinition() {
        return PD_BACKEND_IMPORT_PASS_SIZE;
    }

    public IntegerPropertyDefinition getBackendImportQueueSizePropertyDefinition() {
        return PD_BACKEND_IMPORT_QUEUE_SIZE;
    }

    public StringPropertyDefinition getBackendImportTempDirectoryPropertyDefinition() {
        return PD_BACKEND_IMPORT_TEMP_DIRECTORY;
    }

    public IntegerPropertyDefinition getBackendImportThreadCountPropertyDefinition() {
        return PD_BACKEND_IMPORT_THREAD_COUNT;
    }

    public IntegerPropertyDefinition getBackendIndexEntryLimitPropertyDefinition() {
        return PD_BACKEND_INDEX_ENTRY_LIMIT;
    }

    public StringPropertyDefinition getBackendModePropertyDefinition() {
        return PD_BACKEND_MODE;
    }

    public DurationPropertyDefinition getBackendPreloadTimeLimitPropertyDefinition() {
        return PD_BACKEND_PRELOAD_TIME_LIMIT;
    }

    public IntegerPropertyDefinition getBackendSubtreeDeleteBatchSizePropertyDefinition() {
        return PD_BACKEND_SUBTREE_DELETE_BATCH_SIZE;
    }

    public IntegerPropertyDefinition getBackendSubtreeDeleteSizeLimitPropertyDefinition() {
        return PD_BACKEND_SUBTREE_DELETE_SIZE_LIMIT;
    }

    public EnumPropertyDefinition<BackendCfgDefn.BackendWritabilityMode> getBackendWritabilityModePropertyDefinition() {
        return BackendCfgDefn.getInstance().getBackendWritabilityModePropertyDefinition();
    }

    public IntegerPropertyDefinition getDatabaseCachePercentPropertyDefinition() {
        return PD_DATABASE_CACHE_PERCENT;
    }

    public SizePropertyDefinition getDatabaseCacheSizePropertyDefinition() {
        return PD_DATABASE_CACHE_SIZE;
    }

    public SizePropertyDefinition getDatabaseCheckpointerBytesIntervalPropertyDefinition() {
        return PD_DATABASE_CHECKPOINTER_BYTES_INTERVAL;
    }

    public DurationPropertyDefinition getDatabaseCheckpointerWakeupIntervalPropertyDefinition() {
        return PD_DATABASE_CHECKPOINTER_WAKEUP_INTERVAL;
    }

    public IntegerPropertyDefinition getDatabaseCleanerMinUtilizationPropertyDefinition() {
        return PD_DATABASE_CLEANER_MIN_UTILIZATION;
    }

    public IntegerPropertyDefinition getDatabaseCleanerNumThreadsPropertyDefinition() {
        return PD_DATABASE_CLEANER_NUM_THREADS;
    }

    public BooleanPropertyDefinition getDatabaseEvictorLruOnlyPropertyDefinition() {
        return PD_DATABASE_EVICTOR_LRU_ONLY;
    }

    public IntegerPropertyDefinition getDatabaseEvictorNodesPerScanPropertyDefinition() {
        return PD_DATABASE_EVICTOR_NODES_PER_SCAN;
    }

    public IntegerPropertyDefinition getDatabaseLockNumLockTablesPropertyDefinition() {
        return PD_DATABASE_LOCK_NUM_LOCK_TABLES;
    }

    public SizePropertyDefinition getDatabaseLogFileMaxPropertyDefinition() {
        return PD_DATABASE_LOG_FILE_MAX;
    }

    public BooleanPropertyDefinition getDatabaseLoggingFileHandlerOnPropertyDefinition() {
        return PD_DATABASE_LOGGING_FILE_HANDLER_ON;
    }

    public StringPropertyDefinition getDatabaseLoggingLevelPropertyDefinition() {
        return PD_DATABASE_LOGGING_LEVEL;
    }

    public BooleanPropertyDefinition getDatabaseRunCleanerPropertyDefinition() {
        return PD_DATABASE_RUN_CLEANER;
    }

    public BooleanPropertyDefinition getDatabaseTxnNoSyncPropertyDefinition() {
        return PD_DATABASE_TXN_NO_SYNC;
    }

    public BooleanPropertyDefinition getDatabaseTxnWriteNoSyncPropertyDefinition() {
        return PD_DATABASE_TXN_WRITE_NO_SYNC;
    }

    public InstantiableRelationDefinition<JEIndexCfgClient, JEIndexCfg> getJEIndexesRelationDefinition() {
        return RD_JE_INDEXES;
    }

    public InstantiableRelationDefinition<VLVJEIndexCfgClient, VLVJEIndexCfg> getVLVJEIndexesRelationDefinition() {
        return RD_VLV_JE_INDEXES;
    }

    static {
        InstantiableRelationDefinition.Builder<VLVJEIndexCfgClient, VLVJEIndexCfg> builder = ClassPropertyDefinition.createBuilder(INSTANCE, "backend-class");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "backend-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.backends.jeb.BackendImpl");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)((Object)builder)).addInstanceOf("org.opends.server.api.Backend");
        PD_BACKEND_CLASS = (ClassPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_CLASS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "backend-deadlock-retry-limit");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "backend-deadlock-retry-limit"));
        provider = new DefinedDefaultBehaviorProvider("10");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(0);
        PD_BACKEND_DEADLOCK_RETRY_LIMIT = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_DEADLOCK_RETRY_LIMIT);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "backend-directory");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "backend-directory"));
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BACKEND_DIRECTORY = (StringPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_DIRECTORY);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "backend-entries-compressed");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "backend-entries-compressed"));
        provider = new DefinedDefaultBehaviorProvider("false");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_BACKEND_ENTRIES_COMPRESSED = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_ENTRIES_COMPRESSED);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "backend-import-buffer-size");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "backend-import-buffer-size"));
        provider = new DefinedDefaultBehaviorProvider("256mb");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)((Object)builder)).setLowerLimit("10mb");
        PD_BACKEND_IMPORT_BUFFER_SIZE = (SizePropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_IMPORT_BUFFER_SIZE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "backend-import-pass-size");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "backend-import-pass-size"));
        provider = new DefinedDefaultBehaviorProvider("0");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(0);
        PD_BACKEND_IMPORT_PASS_SIZE = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_IMPORT_PASS_SIZE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "backend-import-queue-size");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "backend-import-queue-size"));
        provider = new DefinedDefaultBehaviorProvider("100");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_BACKEND_IMPORT_QUEUE_SIZE = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_IMPORT_QUEUE_SIZE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "backend-import-temp-directory");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "backend-import-temp-directory"));
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BACKEND_IMPORT_TEMP_DIRECTORY = (StringPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_IMPORT_TEMP_DIRECTORY);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "backend-import-thread-count");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "backend-import-thread-count"));
        provider = new DefinedDefaultBehaviorProvider("8");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_BACKEND_IMPORT_THREAD_COUNT = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_IMPORT_THREAD_COUNT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "backend-index-entry-limit");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "backend-index-entry-limit"));
        provider = new DefinedDefaultBehaviorProvider("4000");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(0);
        PD_BACKEND_INDEX_ENTRY_LIMIT = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_INDEX_ENTRY_LIMIT);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "backend-mode");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "backend-mode"));
        provider = new DefinedDefaultBehaviorProvider("700");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)((Object)builder)).setPattern("7[0-7][0-7]", "MODE");
        PD_BACKEND_MODE = (StringPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_MODE);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "backend-preload-time-limit");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "backend-preload-time-limit"));
        provider = new DefinedDefaultBehaviorProvider("0s");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)((Object)builder)).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)((Object)builder)).setLowerLimit("0");
        PD_BACKEND_PRELOAD_TIME_LIMIT = (DurationPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_PRELOAD_TIME_LIMIT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "backend-subtree-delete-batch-size");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "backend-subtree-delete-batch-size"));
        provider = new DefinedDefaultBehaviorProvider("5000");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(0);
        PD_BACKEND_SUBTREE_DELETE_BATCH_SIZE = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_SUBTREE_DELETE_BATCH_SIZE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "backend-subtree-delete-size-limit");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "backend-subtree-delete-size-limit"));
        provider = new DefinedDefaultBehaviorProvider("100000");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(0);
        PD_BACKEND_SUBTREE_DELETE_SIZE_LIMIT = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_BACKEND_SUBTREE_DELETE_SIZE_LIMIT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "database-cache-percent");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "database-cache-percent"));
        provider = new DefinedDefaultBehaviorProvider("10");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(90);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_DATABASE_CACHE_PERCENT = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_CACHE_PERCENT);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "database-cache-size");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "database-cache-size"));
        provider = new DefinedDefaultBehaviorProvider("0 MB");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)((Object)builder)).setLowerLimit("0 MB");
        PD_DATABASE_CACHE_SIZE = (SizePropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_CACHE_SIZE);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "database-checkpointer-bytes-interval");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.SERVER_RESTART, INSTANCE, "database-checkpointer-bytes-interval"));
        provider = new DefinedDefaultBehaviorProvider("20mb");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)((Object)builder)).setUpperLimit("9223372036854775807b");
        ((SizePropertyDefinition.Builder)((Object)builder)).setLowerLimit("0b");
        PD_DATABASE_CHECKPOINTER_BYTES_INTERVAL = (SizePropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_CHECKPOINTER_BYTES_INTERVAL);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "database-checkpointer-wakeup-interval");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "database-checkpointer-wakeup-interval"));
        provider = new DefinedDefaultBehaviorProvider("30s");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)((Object)builder)).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)((Object)builder)).setUpperLimit("4294");
        ((DurationPropertyDefinition.Builder)((Object)builder)).setLowerLimit("1");
        PD_DATABASE_CHECKPOINTER_WAKEUP_INTERVAL = (DurationPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_CHECKPOINTER_WAKEUP_INTERVAL);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "database-cleaner-min-utilization");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "database-cleaner-min-utilization"));
        provider = new DefinedDefaultBehaviorProvider("75");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(90);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(0);
        PD_DATABASE_CLEANER_MIN_UTILIZATION = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_CLEANER_MIN_UTILIZATION);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "database-cleaner-num-threads");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "database-cleaner-num-threads"));
        provider = new DefinedDefaultBehaviorProvider("1");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_DATABASE_CLEANER_NUM_THREADS = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_CLEANER_NUM_THREADS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "database-evictor-lru-only");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "database-evictor-lru-only"));
        provider = new DefinedDefaultBehaviorProvider("true");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DATABASE_EVICTOR_LRU_ONLY = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_EVICTOR_LRU_ONLY);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "database-evictor-nodes-per-scan");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "database-evictor-nodes-per-scan"));
        provider = new DefinedDefaultBehaviorProvider("10");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit(1000);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_DATABASE_EVICTOR_NODES_PER_SCAN = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_EVICTOR_NODES_PER_SCAN);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "database-lock-num-lock-tables");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "database-lock-num-lock-tables"));
        provider = new DefinedDefaultBehaviorProvider("19");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setUpperLimit((Integer)Short.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(1);
        PD_DATABASE_LOCK_NUM_LOCK_TABLES = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_LOCK_NUM_LOCK_TABLES);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "database-log-file-max");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "database-log-file-max"));
        provider = new DefinedDefaultBehaviorProvider("50mb");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)((Object)builder)).setUpperLimit("4gib");
        ((SizePropertyDefinition.Builder)((Object)builder)).setLowerLimit("1mb");
        PD_DATABASE_LOG_FILE_MAX = (SizePropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_LOG_FILE_MAX);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "database-logging-file-handler-on");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "database-logging-file-handler-on"));
        provider = new DefinedDefaultBehaviorProvider("true");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DATABASE_LOGGING_FILE_HANDLER_ON = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_LOGGING_FILE_HANDLER_ON);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "database-logging-level");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "database-logging-level"));
        provider = new DefinedDefaultBehaviorProvider("CONFIG");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DATABASE_LOGGING_LEVEL = (StringPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_LOGGING_LEVEL);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "database-run-cleaner");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "database-run-cleaner"));
        provider = new DefinedDefaultBehaviorProvider("true");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DATABASE_RUN_CLEANER = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_RUN_CLEANER);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "database-txn-no-sync");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "database-txn-no-sync"));
        provider = new DefinedDefaultBehaviorProvider("false");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DATABASE_TXN_NO_SYNC = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_TXN_NO_SYNC);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "database-txn-write-no-sync");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "database-txn-write-no-sync"));
        provider = new DefinedDefaultBehaviorProvider("true");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(provider);
        PD_DATABASE_TXN_WRITE_NO_SYNC = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_TXN_WRITE_NO_SYNC);
        builder = new InstantiableRelationDefinition.Builder<JEIndexCfgClient, JEIndexCfg>(INSTANCE, "je-index", "je-indexes", JEIndexCfgDefn.getInstance());
        builder.setNamingProperty(JEIndexCfgDefn.getInstance().getIndexAttributePropertyDefinition());
        RD_JE_INDEXES = (InstantiableRelationDefinition)builder.getInstance();
        INSTANCE.registerRelationDefinition(RD_JE_INDEXES);
        builder = new InstantiableRelationDefinition.Builder<VLVJEIndexCfgClient, VLVJEIndexCfg>(INSTANCE, "vlv-je-index", "vlv-je-indexes", VLVJEIndexCfgDefn.getInstance());
        builder.setNamingProperty(VLVJEIndexCfgDefn.getInstance().getVLVIndexNamePropertyDefinition());
        RD_VLV_JE_INDEXES = (InstantiableRelationDefinition)builder.getInstance();
        INSTANCE.registerRelationDefinition(RD_VLV_JE_INDEXES);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JEBackendCfgServerImpl
    implements JEBackendCfg {
        private ServerManagedObject<? extends JEBackendCfg> impl;

        private JEBackendCfgServerImpl(ServerManagedObject<? extends JEBackendCfg> impl) {
            this.impl = impl;
        }

        @Override
        public void addJEChangeListener(ConfigurationChangeListener<JEBackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeJEChangeListener(ConfigurationChangeListener<JEBackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<BackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<DN> getBackendBaseDN() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getBackendBaseDNPropertyDefinition());
        }

        @Override
        public String getBackendClass() {
            return this.impl.getPropertyValue(INSTANCE.getBackendClassPropertyDefinition());
        }

        @Override
        public int getBackendDeadlockRetryLimit() {
            return this.impl.getPropertyValue(INSTANCE.getBackendDeadlockRetryLimitPropertyDefinition());
        }

        @Override
        public String getBackendDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getBackendDirectoryPropertyDefinition());
        }

        @Override
        public boolean isBackendEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getBackendEnabledPropertyDefinition());
        }

        @Override
        public boolean isBackendEntriesCompressed() {
            return this.impl.getPropertyValue(INSTANCE.getBackendEntriesCompressedPropertyDefinition());
        }

        @Override
        public String getBackendId() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
        }

        @Override
        public long getBackendImportBufferSize() {
            return this.impl.getPropertyValue(INSTANCE.getBackendImportBufferSizePropertyDefinition());
        }

        @Override
        public int getBackendImportPassSize() {
            return this.impl.getPropertyValue(INSTANCE.getBackendImportPassSizePropertyDefinition());
        }

        @Override
        public int getBackendImportQueueSize() {
            return this.impl.getPropertyValue(INSTANCE.getBackendImportQueueSizePropertyDefinition());
        }

        @Override
        public String getBackendImportTempDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getBackendImportTempDirectoryPropertyDefinition());
        }

        @Override
        public int getBackendImportThreadCount() {
            return this.impl.getPropertyValue(INSTANCE.getBackendImportThreadCountPropertyDefinition());
        }

        @Override
        public int getBackendIndexEntryLimit() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIndexEntryLimitPropertyDefinition());
        }

        @Override
        public String getBackendMode() {
            return this.impl.getPropertyValue(INSTANCE.getBackendModePropertyDefinition());
        }

        @Override
        public long getBackendPreloadTimeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getBackendPreloadTimeLimitPropertyDefinition());
        }

        @Override
        public int getBackendSubtreeDeleteBatchSize() {
            return this.impl.getPropertyValue(INSTANCE.getBackendSubtreeDeleteBatchSizePropertyDefinition());
        }

        @Override
        public int getBackendSubtreeDeleteSizeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getBackendSubtreeDeleteSizeLimitPropertyDefinition());
        }

        @Override
        public BackendCfgDefn.BackendWritabilityMode getBackendWritabilityMode() {
            return this.impl.getPropertyValue(INSTANCE.getBackendWritabilityModePropertyDefinition());
        }

        @Override
        public int getDatabaseCachePercent() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCachePercentPropertyDefinition());
        }

        @Override
        public long getDatabaseCacheSize() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCacheSizePropertyDefinition());
        }

        @Override
        public long getDatabaseCheckpointerBytesInterval() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCheckpointerBytesIntervalPropertyDefinition());
        }

        @Override
        public long getDatabaseCheckpointerWakeupInterval() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCheckpointerWakeupIntervalPropertyDefinition());
        }

        @Override
        public int getDatabaseCleanerMinUtilization() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCleanerMinUtilizationPropertyDefinition());
        }

        @Override
        public int getDatabaseCleanerNumThreads() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCleanerNumThreadsPropertyDefinition());
        }

        @Override
        public boolean isDatabaseEvictorLruOnly() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseEvictorLruOnlyPropertyDefinition());
        }

        @Override
        public int getDatabaseEvictorNodesPerScan() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseEvictorNodesPerScanPropertyDefinition());
        }

        @Override
        public int getDatabaseLockNumLockTables() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseLockNumLockTablesPropertyDefinition());
        }

        @Override
        public long getDatabaseLogFileMax() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseLogFileMaxPropertyDefinition());
        }

        @Override
        public boolean isDatabaseLoggingFileHandlerOn() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseLoggingFileHandlerOnPropertyDefinition());
        }

        @Override
        public String getDatabaseLoggingLevel() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseLoggingLevelPropertyDefinition());
        }

        @Override
        public boolean isDatabaseRunCleaner() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseRunCleanerPropertyDefinition());
        }

        @Override
        public boolean isDatabaseTxnNoSync() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseTxnNoSyncPropertyDefinition());
        }

        @Override
        public boolean isDatabaseTxnWriteNoSync() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseTxnWriteNoSyncPropertyDefinition());
        }

        @Override
        public String[] listJEIndexes() {
            return this.impl.listChildren(INSTANCE.getJEIndexesRelationDefinition());
        }

        @Override
        public JEIndexCfg getJEIndex(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getJEIndexesRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addJEIndexAddListener(ConfigurationAddListener<JEIndexCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getJEIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeJEIndexAddListener(ConfigurationAddListener<JEIndexCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getJEIndexesRelationDefinition(), listener);
        }

        @Override
        public void addJEIndexDeleteListener(ConfigurationDeleteListener<JEIndexCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getJEIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeJEIndexDeleteListener(ConfigurationDeleteListener<JEIndexCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getJEIndexesRelationDefinition(), listener);
        }

        @Override
        public String[] listVLVJEIndexes() {
            return this.impl.listChildren(INSTANCE.getVLVJEIndexesRelationDefinition());
        }

        @Override
        public VLVJEIndexCfg getVLVJEIndex(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getVLVJEIndexesRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addVLVJEIndexAddListener(ConfigurationAddListener<VLVJEIndexCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getVLVJEIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeVLVJEIndexAddListener(ConfigurationAddListener<VLVJEIndexCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getVLVJEIndexesRelationDefinition(), listener);
        }

        @Override
        public void addVLVJEIndexDeleteListener(ConfigurationDeleteListener<VLVJEIndexCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getVLVJEIndexesRelationDefinition(), listener);
        }

        @Override
        public void removeVLVJEIndexDeleteListener(ConfigurationDeleteListener<VLVJEIndexCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getVLVJEIndexesRelationDefinition(), listener);
        }

        @Override
        public ManagedObjectDefinition<? extends JEBackendCfgClient, ? extends JEBackendCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JEBackendCfgClientImpl
    implements JEBackendCfgClient {
        private ManagedObject<? extends JEBackendCfgClient> impl;

        private JEBackendCfgClientImpl(ManagedObject<? extends JEBackendCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<DN> getBackendBaseDN() {
            return this.impl.getPropertyValues(INSTANCE.getBackendBaseDNPropertyDefinition());
        }

        @Override
        public void setBackendBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getBackendBaseDNPropertyDefinition(), values);
        }

        @Override
        public String getBackendClass() {
            return this.impl.getPropertyValue(INSTANCE.getBackendClassPropertyDefinition());
        }

        @Override
        public void setBackendClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getBackendClassPropertyDefinition(), value);
        }

        @Override
        public int getBackendDeadlockRetryLimit() {
            return this.impl.getPropertyValue(INSTANCE.getBackendDeadlockRetryLimitPropertyDefinition());
        }

        @Override
        public void setBackendDeadlockRetryLimit(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getBackendDeadlockRetryLimitPropertyDefinition(), value);
        }

        @Override
        public String getBackendDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getBackendDirectoryPropertyDefinition());
        }

        @Override
        public void setBackendDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getBackendDirectoryPropertyDefinition(), value);
        }

        @Override
        public Boolean isBackendEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getBackendEnabledPropertyDefinition());
        }

        @Override
        public void setBackendEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getBackendEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isBackendEntriesCompressed() {
            return this.impl.getPropertyValue(INSTANCE.getBackendEntriesCompressedPropertyDefinition());
        }

        @Override
        public void setBackendEntriesCompressed(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getBackendEntriesCompressedPropertyDefinition(), value);
        }

        @Override
        public String getBackendId() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIdPropertyDefinition());
        }

        @Override
        public void setBackendId(String value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getBackendIdPropertyDefinition(), value);
        }

        @Override
        public long getBackendImportBufferSize() {
            return this.impl.getPropertyValue(INSTANCE.getBackendImportBufferSizePropertyDefinition());
        }

        @Override
        public void setBackendImportBufferSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getBackendImportBufferSizePropertyDefinition(), value);
        }

        @Override
        public int getBackendImportPassSize() {
            return this.impl.getPropertyValue(INSTANCE.getBackendImportPassSizePropertyDefinition());
        }

        @Override
        public void setBackendImportPassSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getBackendImportPassSizePropertyDefinition(), value);
        }

        @Override
        public int getBackendImportQueueSize() {
            return this.impl.getPropertyValue(INSTANCE.getBackendImportQueueSizePropertyDefinition());
        }

        @Override
        public void setBackendImportQueueSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getBackendImportQueueSizePropertyDefinition(), value);
        }

        @Override
        public String getBackendImportTempDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getBackendImportTempDirectoryPropertyDefinition());
        }

        @Override
        public void setBackendImportTempDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getBackendImportTempDirectoryPropertyDefinition(), value);
        }

        @Override
        public int getBackendImportThreadCount() {
            return this.impl.getPropertyValue(INSTANCE.getBackendImportThreadCountPropertyDefinition());
        }

        @Override
        public void setBackendImportThreadCount(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getBackendImportThreadCountPropertyDefinition(), value);
        }

        @Override
        public int getBackendIndexEntryLimit() {
            return this.impl.getPropertyValue(INSTANCE.getBackendIndexEntryLimitPropertyDefinition());
        }

        @Override
        public void setBackendIndexEntryLimit(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getBackendIndexEntryLimitPropertyDefinition(), value);
        }

        @Override
        public String getBackendMode() {
            return this.impl.getPropertyValue(INSTANCE.getBackendModePropertyDefinition());
        }

        @Override
        public void setBackendMode(String value) {
            this.impl.setPropertyValue(INSTANCE.getBackendModePropertyDefinition(), value);
        }

        @Override
        public long getBackendPreloadTimeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getBackendPreloadTimeLimitPropertyDefinition());
        }

        @Override
        public void setBackendPreloadTimeLimit(Long value) {
            this.impl.setPropertyValue(INSTANCE.getBackendPreloadTimeLimitPropertyDefinition(), value);
        }

        @Override
        public int getBackendSubtreeDeleteBatchSize() {
            return this.impl.getPropertyValue(INSTANCE.getBackendSubtreeDeleteBatchSizePropertyDefinition());
        }

        @Override
        public void setBackendSubtreeDeleteBatchSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getBackendSubtreeDeleteBatchSizePropertyDefinition(), value);
        }

        @Override
        public int getBackendSubtreeDeleteSizeLimit() {
            return this.impl.getPropertyValue(INSTANCE.getBackendSubtreeDeleteSizeLimitPropertyDefinition());
        }

        @Override
        public void setBackendSubtreeDeleteSizeLimit(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getBackendSubtreeDeleteSizeLimitPropertyDefinition(), value);
        }

        @Override
        public BackendCfgDefn.BackendWritabilityMode getBackendWritabilityMode() {
            return this.impl.getPropertyValue(INSTANCE.getBackendWritabilityModePropertyDefinition());
        }

        @Override
        public void setBackendWritabilityMode(BackendCfgDefn.BackendWritabilityMode value) {
            this.impl.setPropertyValue(INSTANCE.getBackendWritabilityModePropertyDefinition(), value);
        }

        @Override
        public int getDatabaseCachePercent() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCachePercentPropertyDefinition());
        }

        @Override
        public void setDatabaseCachePercent(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseCachePercentPropertyDefinition(), value);
        }

        @Override
        public long getDatabaseCacheSize() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCacheSizePropertyDefinition());
        }

        @Override
        public void setDatabaseCacheSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseCacheSizePropertyDefinition(), value);
        }

        @Override
        public long getDatabaseCheckpointerBytesInterval() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCheckpointerBytesIntervalPropertyDefinition());
        }

        @Override
        public void setDatabaseCheckpointerBytesInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseCheckpointerBytesIntervalPropertyDefinition(), value);
        }

        @Override
        public long getDatabaseCheckpointerWakeupInterval() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCheckpointerWakeupIntervalPropertyDefinition());
        }

        @Override
        public void setDatabaseCheckpointerWakeupInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseCheckpointerWakeupIntervalPropertyDefinition(), value);
        }

        @Override
        public int getDatabaseCleanerMinUtilization() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCleanerMinUtilizationPropertyDefinition());
        }

        @Override
        public void setDatabaseCleanerMinUtilization(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseCleanerMinUtilizationPropertyDefinition(), value);
        }

        @Override
        public int getDatabaseCleanerNumThreads() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCleanerNumThreadsPropertyDefinition());
        }

        @Override
        public void setDatabaseCleanerNumThreads(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseCleanerNumThreadsPropertyDefinition(), value);
        }

        @Override
        public boolean isDatabaseEvictorLruOnly() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseEvictorLruOnlyPropertyDefinition());
        }

        @Override
        public void setDatabaseEvictorLruOnly(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseEvictorLruOnlyPropertyDefinition(), value);
        }

        @Override
        public int getDatabaseEvictorNodesPerScan() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseEvictorNodesPerScanPropertyDefinition());
        }

        @Override
        public void setDatabaseEvictorNodesPerScan(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseEvictorNodesPerScanPropertyDefinition(), value);
        }

        @Override
        public int getDatabaseLockNumLockTables() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseLockNumLockTablesPropertyDefinition());
        }

        @Override
        public void setDatabaseLockNumLockTables(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseLockNumLockTablesPropertyDefinition(), value);
        }

        @Override
        public long getDatabaseLogFileMax() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseLogFileMaxPropertyDefinition());
        }

        @Override
        public void setDatabaseLogFileMax(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseLogFileMaxPropertyDefinition(), value);
        }

        @Override
        public boolean isDatabaseLoggingFileHandlerOn() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseLoggingFileHandlerOnPropertyDefinition());
        }

        @Override
        public void setDatabaseLoggingFileHandlerOn(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseLoggingFileHandlerOnPropertyDefinition(), value);
        }

        @Override
        public String getDatabaseLoggingLevel() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseLoggingLevelPropertyDefinition());
        }

        @Override
        public void setDatabaseLoggingLevel(String value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseLoggingLevelPropertyDefinition(), value);
        }

        @Override
        public boolean isDatabaseRunCleaner() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseRunCleanerPropertyDefinition());
        }

        @Override
        public void setDatabaseRunCleaner(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseRunCleanerPropertyDefinition(), value);
        }

        @Override
        public boolean isDatabaseTxnNoSync() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseTxnNoSyncPropertyDefinition());
        }

        @Override
        public void setDatabaseTxnNoSync(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseTxnNoSyncPropertyDefinition(), value);
        }

        @Override
        public boolean isDatabaseTxnWriteNoSync() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseTxnWriteNoSyncPropertyDefinition());
        }

        @Override
        public void setDatabaseTxnWriteNoSync(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseTxnWriteNoSyncPropertyDefinition(), value);
        }

        @Override
        public String[] listJEIndexes() throws ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.listChildren(INSTANCE.getJEIndexesRelationDefinition());
        }

        @Override
        public JEIndexCfgClient getJEIndex(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.getChild(INSTANCE.getJEIndexesRelationDefinition(), name).getConfiguration();
        }

        public <M extends JEIndexCfgClient> M createJEIndex(ManagedObjectDefinition<M, ? extends JEIndexCfg> d, String name, Collection<DefaultBehaviorException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((JEIndexCfgClient)this.impl.createChild(INSTANCE.getJEIndexesRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeJEIndex(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.removeChild(INSTANCE.getJEIndexesRelationDefinition(), name);
        }

        @Override
        public String[] listVLVJEIndexes() throws ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.listChildren(INSTANCE.getVLVJEIndexesRelationDefinition());
        }

        @Override
        public VLVJEIndexCfgClient getVLVJEIndex(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.getChild(INSTANCE.getVLVJEIndexesRelationDefinition(), name).getConfiguration();
        }

        public <M extends VLVJEIndexCfgClient> M createVLVJEIndex(ManagedObjectDefinition<M, ? extends VLVJEIndexCfg> d, String name, Collection<DefaultBehaviorException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((VLVJEIndexCfgClient)this.impl.createChild(INSTANCE.getVLVJEIndexesRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeVLVJEIndex(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.removeChild(INSTANCE.getVLVJEIndexesRelationDefinition(), name);
        }

        @Override
        public ManagedObjectDefinition<? extends JEBackendCfgClient, ? extends JEBackendCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

