/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.PKCS11KeyManagerCfgClient;
import org.opends.server.admin.std.meta.KeyManagerCfgDefn;
import org.opends.server.admin.std.server.KeyManagerCfg;
import org.opends.server.admin.std.server.PKCS11KeyManagerCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PKCS11KeyManagerCfgDefn
extends ManagedObjectDefinition<PKCS11KeyManagerCfgClient, PKCS11KeyManagerCfg> {
    private static final PKCS11KeyManagerCfgDefn INSTANCE = new PKCS11KeyManagerCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_IMPLEMENTATION_CLASS;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN_FILE;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN_PROPERTY;

    public static PKCS11KeyManagerCfgDefn getInstance() {
        return INSTANCE;
    }

    private PKCS11KeyManagerCfgDefn() {
        super("pkcs11-key-manager", KeyManagerCfgDefn.getInstance());
    }

    @Override
    public PKCS11KeyManagerCfgClient createClientConfiguration(ManagedObject<? extends PKCS11KeyManagerCfgClient> impl) {
        return new PKCS11KeyManagerCfgClientImpl(impl);
    }

    @Override
    public PKCS11KeyManagerCfg createServerConfiguration(ServerManagedObject<? extends PKCS11KeyManagerCfg> impl) {
        return new PKCS11KeyManagerCfgServerImpl(impl);
    }

    @Override
    public Class<PKCS11KeyManagerCfg> getServerConfigurationClass() {
        return PKCS11KeyManagerCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return KeyManagerCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaImplementationClassPropertyDefinition() {
        return PD_JAVA_IMPLEMENTATION_CLASS;
    }

    public StringPropertyDefinition getKeyStorePinPropertyDefinition() {
        return PD_KEY_STORE_PIN;
    }

    public StringPropertyDefinition getKeyStorePinEnvironmentVariablePropertyDefinition() {
        return PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE;
    }

    public StringPropertyDefinition getKeyStorePinFilePropertyDefinition() {
        return PD_KEY_STORE_PIN_FILE;
    }

    public StringPropertyDefinition getKeyStorePinPropertyPropertyDefinition() {
        return PD_KEY_STORE_PIN_PROPERTY;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-implementation-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-implementation-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.PKCS11KeyManagerProvider");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.KeyManagerProvider");
        PD_JAVA_IMPLEMENTATION_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_IMPLEMENTATION_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_KEY_STORE_PIN = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin-environment-variable");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin-environment-variable"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN_ENVIRONMENT_VARIABLE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin-file");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_KEY_STORE_PIN_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN_FILE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin-property");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin-property"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_KEY_STORE_PIN_PROPERTY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN_PROPERTY);
        INSTANCE.registerTag(Tag.valueOf("security"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS11KeyManagerCfgServerImpl
    implements PKCS11KeyManagerCfg {
        private ServerManagedObject<? extends PKCS11KeyManagerCfg> impl;

        private PKCS11KeyManagerCfgServerImpl(ServerManagedObject<? extends PKCS11KeyManagerCfg> impl) {
            this.impl = impl;
        }

        @Override
        public void addPKCS11ChangeListener(ConfigurationChangeListener<PKCS11KeyManagerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removePKCS11ChangeListener(ConfigurationChangeListener<PKCS11KeyManagerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<KeyManagerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<KeyManagerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public String getJavaImplementationClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaImplementationClassPropertyDefinition());
        }

        @Override
        public String getKeyStorePin() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyDefinition());
        }

        @Override
        public String getKeyStorePinEnvironmentVariable() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinEnvironmentVariablePropertyDefinition());
        }

        @Override
        public String getKeyStorePinFile() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition());
        }

        @Override
        public String getKeyStorePinProperty() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyPropertyDefinition());
        }

        @Override
        public ManagedObjectDefinition<? extends PKCS11KeyManagerCfgClient, ? extends PKCS11KeyManagerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS11KeyManagerCfgClientImpl
    implements PKCS11KeyManagerCfgClient {
        private ManagedObject<? extends PKCS11KeyManagerCfgClient> impl;

        private PKCS11KeyManagerCfgClientImpl(ManagedObject<? extends PKCS11KeyManagerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaImplementationClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaImplementationClassPropertyDefinition());
        }

        @Override
        public void setJavaImplementationClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaImplementationClassPropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePin() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyDefinition());
        }

        @Override
        public void setKeyStorePin(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinPropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePinEnvironmentVariable() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinEnvironmentVariablePropertyDefinition());
        }

        @Override
        public void setKeyStorePinEnvironmentVariable(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinEnvironmentVariablePropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePinFile() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition());
        }

        @Override
        public void setKeyStorePinFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePinProperty() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinPropertyPropertyDefinition());
        }

        @Override
        public void setKeyStorePinProperty(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinPropertyPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends PKCS11KeyManagerCfgClient, ? extends PKCS11KeyManagerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

