/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.MatchingRule;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EqualityMatchingRule
extends MatchingRule<EqualityMatchingRuleCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public abstract boolean areEqual(ByteString var1, ByteString var2);

    @Override
    public ConditionResult valuesMatch(ByteString attributeValue, ByteString assertionValue) {
        if (this.areEqual(attributeValue, assertionValue)) {
            return ConditionResult.TRUE;
        }
        return ConditionResult.FALSE;
    }

    public int generateHashCode(AttributeValue attributeValue) {
        try {
            return attributeValue.getNormalizedValue().hashCode();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            try {
                return attributeValue.getValue().hashCode();
            }
            catch (Exception e2) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
                return 0;
            }
        }
    }
}

