/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.locks.Lock;
import org.opends.server.admin.std.server.DseeCompatAccessControlHandlerCfg;
import org.opends.server.api.AccessControlHandler;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.authorization.dseecompat.AciContainer;
import org.opends.server.authorization.dseecompat.AciEffectiveRights;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.AciLDAPOperationContainer;
import org.opends.server.authorization.dseecompat.AciList;
import org.opends.server.authorization.dseecompat.AciListenerManager;
import org.opends.server.authorization.dseecompat.AciTargetMatchContext;
import org.opends.server.authorization.dseecompat.EnumAccessType;
import org.opends.server.authorization.dseecompat.EnumEvalReason;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.GetEffectiveRights;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.RDN;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendAddOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendBindOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendCompareOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendDeleteOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyDNOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AciHandler
extends AccessControlHandler<DseeCompatAccessControlHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AciList aciList;
    private AciListenerManager aciListenerMgr;
    static AttributeType aciType = DirectoryServer.getAttributeType("aci");
    static AttributeType globalAciType;
    static AttributeType debugSearchIndex;
    static AttributeType refAttrType;
    static DN debugSearchIndexDN;
    public static final String ORIG_AUTH_ENTRY = "origAuthorizationEntry";
    public static final String ALL_ATTRS_RESOURCE_ENTRY = "allAttrsResourceEntry";
    public static final String ALL_USER_ATTRS_MATCHED = "allUserAttrsMatched";
    public static final String ALL_OP_ATTRS_MATCHED = "allOpAttrsMatched";

    @Override
    public void initializeAccessControlHandler(DseeCompatAccessControlHandlerCfg configuration) throws ConfigException, InitializationException {
        DN configurationDN = configuration.dn();
        this.aciList = new AciList(configurationDN);
        this.aciListenerMgr = new AciListenerManager(this.aciList, configurationDN);
        this.processGlobalAcis(configuration);
        this.processConfigAcis();
    }

    @Override
    public void finalizeAccessControlHandler() {
    }

    private void processGlobalAcis(DseeCompatAccessControlHandlerCfg configuration) throws InitializationException {
        LinkedList<String> failedACIMsgs = new LinkedList<String>();
        SortedSet<String> globalAci = configuration.getGlobalACI();
        try {
            if (globalAci != null) {
                LinkedHashSet<AttributeValue> attVals = new LinkedHashSet<AttributeValue>(globalAci.size());
                for (String aci : globalAci) {
                    attVals.add(new AttributeValue(globalAciType, aci));
                }
                Attribute attr = new Attribute(globalAciType, globalAciType.toString(), attVals);
                Entry e = new Entry(configuration.dn(), null, null, null);
                e.addAttribute(attr, new ArrayList<AttributeValue>());
                int aciCount = this.aciList.addAci(e, false, true, failedACIMsgs);
                if (!failedACIMsgs.isEmpty()) {
                    this.aciListenerMgr.logMsgsSetLockDownMode(failedACIMsgs);
                }
                int msgID = 12582978;
                String message = MessageHandler.getMessage(msgID, Integer.toString(aciCount));
                ErrorLogger.logError(ErrorLogCategory.ACCESS_CONTROL, ErrorLogSeverity.INFORMATIONAL, message, msgID);
            } else {
                int msgID = 12582977;
                String message = MessageHandler.getMessage(msgID);
                ErrorLogger.logError(ErrorLogCategory.ACCESS_CONTROL, ErrorLogSeverity.INFORMATIONAL, message, msgID);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 12582979;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(msgID, message, e);
        }
    }

    private void processConfigAcis() throws InitializationException {
        try {
            DN configDN = DN.decode("cn=config");
            LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
            attrs.add("aci");
            LinkedList<String> failedACIMsgs = new LinkedList<String>();
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            InternalSearchOperation op = conn.processSearch(configDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createFilterFromString("aci=*"), attrs);
            if (op.getSearchEntries().isEmpty()) {
                int msgID = 12582961;
                String message = MessageHandler.getMessage(msgID, String.valueOf(configDN));
                ErrorLogger.logError(ErrorLogCategory.ACCESS_CONTROL, ErrorLogSeverity.INFORMATIONAL, message, msgID);
            } else {
                int validAcis = this.aciList.addAci(op.getSearchEntries(), failedACIMsgs);
                if (!failedACIMsgs.isEmpty()) {
                    this.aciListenerMgr.logMsgsSetLockDownMode(failedACIMsgs);
                }
                int msgID = 12582962;
                String message = MessageHandler.getMessage(msgID, Integer.toString(validAcis), String.valueOf(configDN));
                ErrorLogger.logError(ErrorLogCategory.ACCESS_CONTROL, ErrorLogSeverity.INFORMATIONAL, message, msgID);
            }
        }
        catch (DirectoryException e) {
            int msgID = 0xC00044;
            String message = MessageHandler.getMessage(msgID, StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(msgID, message, e);
        }
    }

    private boolean aciCheckMods(AciLDAPOperationContainer container, LocalBackendModifyOperation operation, boolean skipAccessCheck) {
        Entry resourceEntry = container.getResourceEntry();
        DN dn = resourceEntry.getDN();
        List<Modification> modifications = container.getModifications();
        for (Modification m : modifications) {
            Attribute modAttr = m.getAttribute();
            AttributeType modAttrType = modAttr.getAttributeType();
            if (modAttrType.equals(aciType) && !operation.getClientConnection().hasPrivilege(Privilege.MODIFY_ACL, operation)) {
                int msgID = 12582957;
                String message = MessageHandler.getMessage(msgID, String.valueOf(container.getResourceDN()), String.valueOf(container.getClientDN()));
                ErrorLogger.logError(ErrorLogCategory.ACCESS_CONTROL, ErrorLogSeverity.INFORMATIONAL, message, msgID);
                return false;
            }
            ModificationType modType = m.getModificationType();
            if ((modType == ModificationType.DELETE && modAttr.getValues().isEmpty() || modType == ModificationType.REPLACE || modType == ModificationType.INCREMENT) && resourceEntry.hasAttribute(modAttrType)) {
                container.setCurrentAttributeType(modAttrType);
                List<Attribute> attrList = resourceEntry.getAttribute(modAttrType, modAttr.getOptions());
                for (Attribute a : attrList) {
                    for (AttributeValue v : a.getValues()) {
                        container.setCurrentAttributeValue(v);
                        container.setRights(1024);
                        if (skipAccessCheck || this.accessAllowed(container)) continue;
                        return false;
                    }
                }
            }
            if (!modAttr.hasValue()) continue;
            for (AttributeValue v : modAttr.getValues()) {
                container.setCurrentAttributeType(modAttrType);
                switch (m.getModificationType()) {
                    case ADD: 
                    case REPLACE: {
                        container.setCurrentAttributeValue(v);
                        container.setRights(2048);
                        if (skipAccessCheck || this.accessAllowed(container)) break;
                        return false;
                    }
                    case DELETE: {
                        container.setCurrentAttributeValue(v);
                        container.setRights(1024);
                        if (skipAccessCheck || this.accessAllowed(container)) break;
                        return false;
                    }
                    case INCREMENT: {
                        Entry modifiedEntry = operation.getModifiedEntry();
                        List<Attribute> modifiedAttrs = modifiedEntry.getAttribute(modAttrType, modAttr.getOptions());
                        if (modifiedAttrs == null) break;
                        for (Attribute attr : modifiedAttrs) {
                            for (AttributeValue val : attr.getValues()) {
                                container.setCurrentAttributeValue(val);
                                container.setRights(2048);
                                if (skipAccessCheck || this.accessAllowed(container)) continue;
                                return false;
                            }
                        }
                        break;
                    }
                }
                if (!modAttrType.equals(aciType) && !modAttrType.equals(globalAciType)) continue;
                try {
                    if (modAttrType.equals(globalAciType)) {
                        dn = DN.nullDN();
                    }
                    Aci.decode(v.getValue(), dn);
                }
                catch (AciException ex) {
                    int msgID = 12714031;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(dn), ex.getMessage());
                    ErrorLogger.logError(ErrorLogCategory.ACCESS_CONTROL, ErrorLogSeverity.INFORMATIONAL, message, msgID);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean testApplicableLists(AciEvalContext evalCtx) {
        EnumEvalResult res;
        evalCtx.setEvalReason(EnumEvalReason.NO_REASON);
        LinkedList<Aci> denys = evalCtx.getDenyList();
        LinkedList<Aci> allows = evalCtx.getAllowList();
        if (allows.isEmpty() && (!evalCtx.isGetEffectiveRightsEval() || evalCtx.hasRights(64) || !evalCtx.isTargAttrFilterMatchAciEmpty())) {
            evalCtx.setEvalReason(EnumEvalReason.NO_ALLOW_ACIS);
            evalCtx.setDecidingAci(null);
            return false;
        }
        evalCtx.setDenyEval(true);
        for (Aci denyAci : denys) {
            res = Aci.evaluate(evalCtx, denyAci);
            if (res.equals((Object)EnumEvalResult.FAIL)) {
                evalCtx.setEvalReason(EnumEvalReason.EVALUATED_DENY_ACI);
                evalCtx.setDecidingAci(denyAci);
                return false;
            }
            if (!res.equals((Object)EnumEvalResult.TRUE)) continue;
            if (evalCtx.isGetEffectiveRightsEval() && !evalCtx.hasRights(64) && !evalCtx.isTargAttrFilterMatchAciEmpty()) {
                if (AciEffectiveRights.setTargAttrAci(evalCtx, denyAci, true)) continue;
                evalCtx.setEvalReason(EnumEvalReason.EVALUATED_DENY_ACI);
                evalCtx.setDecidingAci(denyAci);
                return false;
            }
            evalCtx.setEvalReason(EnumEvalReason.EVALUATED_DENY_ACI);
            evalCtx.setDecidingAci(denyAci);
            return false;
        }
        evalCtx.setDenyEval(false);
        for (Aci allowAci : allows) {
            res = Aci.evaluate(evalCtx, allowAci);
            if (!res.equals((Object)EnumEvalResult.TRUE)) continue;
            if (evalCtx.isGetEffectiveRightsEval() && !evalCtx.hasRights(64) && !evalCtx.isTargAttrFilterMatchAciEmpty()) {
                if (AciEffectiveRights.setTargAttrAci(evalCtx, allowAci, false)) continue;
                evalCtx.setEvalReason(EnumEvalReason.EVALUATED_ALLOW_ACI);
                evalCtx.setDecidingAci(allowAci);
                return true;
            }
            evalCtx.setEvalReason(EnumEvalReason.EVALUATED_ALLOW_ACI);
            evalCtx.setDecidingAci(allowAci);
            return true;
        }
        evalCtx.setEvalReason(EnumEvalReason.NO_MATCHED_ALLOWS_ACIS);
        evalCtx.setDecidingAci(null);
        return false;
    }

    private void createApplicableList(LinkedList<Aci> candidates, AciTargetMatchContext targetMatchCtx) {
        LinkedList<Aci> denys = new LinkedList<Aci>();
        LinkedList<Aci> allows = new LinkedList<Aci>();
        for (Aci aci : candidates) {
            if (Aci.isApplicable(aci, targetMatchCtx)) {
                if (aci.hasAccessType(EnumAccessType.DENY)) {
                    denys.add(aci);
                }
                if (aci.hasAccessType(EnumAccessType.ALLOW)) {
                    allows.add(aci);
                }
            }
            if (!targetMatchCtx.getTargAttrFiltersMatch()) continue;
            targetMatchCtx.setTargAttrFiltersMatch(false);
        }
        targetMatchCtx.setAllowList(allows);
        targetMatchCtx.setDenyList(denys);
    }

    private boolean skipAccessCheck(Operation operation) {
        return operation.getClientConnection().hasPrivilege(Privilege.BYPASS_ACL, operation);
    }

    boolean accessAllowed(AciContainer container) {
        DN dn = container.getResourceEntry().getDN();
        if (container.hasRights(2048) || container.hasRights(1024)) {
            container.setRights(container.getRights() | 8);
        }
        if (container.getCurrentAttributeValue() != null && container.hasRights(8) && this.isAttributeDN(container.getCurrentAttributeType())) {
            String DNString = null;
            try {
                DNString = container.getCurrentAttributeValue().getStringValue();
                DN tmpDN = DN.decode(DNString);
                if (tmpDN.equals(container.getClientDN())) {
                    container.setRights(container.getRights() | 0x40);
                }
            }
            catch (DirectoryException ex) {
                int msgID = 12714057;
                String message = MessageHandler.getMessage(msgID, DNString);
                ErrorLogger.logError(ErrorLogCategory.ACCESS_CONTROL, ErrorLogSeverity.INFORMATIONAL, message, msgID);
            }
        }
        if (!container.hasSeenEntry()) {
            if (container.isProxiedAuthorization() && !container.hasRights(128) && !container.hasRights(0x400000)) {
                int currentRights = container.getRights();
                container.setRights(128);
                container.useOrigAuthorizationEntry(true);
                if (!this.accessAllowed(container)) {
                    return false;
                }
                container.setRights(currentRights);
                container.useOrigAuthorizationEntry(false);
            }
            container.setSeenEntry(true);
        }
        LinkedList<Aci> candidates = this.aciList.getCandidateAcis(dn);
        this.createApplicableList(candidates, container);
        boolean ret = this.testApplicableLists(container);
        if (container.isGetEffectiveRightsEval()) {
            AciEffectiveRights.createSummary(container, ret, "main");
        }
        return ret;
    }

    private boolean isAttributeDN(AttributeType attribute) {
        return attribute.getSyntaxOID().equals("1.3.6.1.4.1.1466.115.121.1.12");
    }

    private SearchResultEntry accessAllowedAttrs(AciLDAPOperationContainer container) {
        Entry e = container.getResourceEntry();
        List<AttributeType> typeList = this.getAllAttrs(e);
        for (AttributeType attrType : typeList) {
            if (container.hasAllUserAttributes() && !attrType.isOperational() || container.hasAllOpAttributes() && attrType.isOperational()) continue;
            container.setCurrentAttributeType(attrType);
            if (this.accessAllowed(container)) continue;
            e.removeAttribute(attrType);
        }
        return container.getSearchResultEntry();
    }

    private List<AttributeType> getAllAttrs(Entry e) {
        Map<AttributeType, List<Attribute>> attrMap = e.getUserAttributes();
        Map<AttributeType, List<Attribute>> opAttrMap = e.getOperationalAttributes();
        LinkedList<AttributeType> typeList = new LinkedList<AttributeType>();
        Attribute attr = e.getObjectClassAttribute();
        if (attr != null) {
            AttributeType ocType = attr.getAttributeType();
            typeList.add(ocType);
        }
        typeList.addAll(attrMap.keySet());
        typeList.addAll(opAttrMap.keySet());
        return typeList;
    }

    boolean accessAllowedEntry(AciLDAPOperationContainer container) {
        boolean ret = false;
        container.setIsFirstAttribute(true);
        List<AttributeType> typeList = this.getAllAttrs(container.getResourceEntry());
        for (AttributeType attrType : typeList) {
            container.setCurrentAttributeType(attrType);
            if (!this.accessAllowed(container)) continue;
            if (container.hasEntryTestRule()) {
                container.setCurrentAttributeType(null);
                if (!this.accessAllowed(container) && container.isDenyEval()) {
                    return false;
                }
            }
            return true;
        }
        return ret;
    }

    private boolean testFilter(AciLDAPOperationContainer container, SearchFilter filter) throws DirectoryException {
        boolean ret = true;
        if (debugSearchIndexDN.equals(container.getResourceDN()) && container.getResourceEntry().hasAttribute(debugSearchIndex)) {
            return true;
        }
        switch (filter.getFilterType()) {
            case AND: 
            case OR: {
                for (SearchFilter f : filter.getFilterComponents()) {
                    if (this.testFilter(container, f)) continue;
                    return false;
                }
                break;
            }
            case NOT: {
                ret = false;
                SearchFilter f = filter.getNotComponent();
                if (f.matchesEntry(container.getResourceEntry())) {
                    ret = true;
                }
                if (ret) {
                    ret = this.testFilter(container, f);
                }
                ret = !ret;
                break;
            }
            default: {
                AttributeType attrType = filter.getAttributeType();
                container.setCurrentAttributeType(attrType);
                ret = this.accessAllowed(container);
            }
        }
        return ret;
    }

    private boolean isAllowed(AciLDAPOperationContainer operationContainer, Operation operation) {
        return this.skipAccessCheck(operation) || this.accessAllowed(operationContainer);
    }

    private boolean verifySyntax(Entry entry, Operation operation, DN clientDN) {
        if (entry.hasOperationalAttribute(aciType)) {
            if (!operation.getClientConnection().hasPrivilege(Privilege.MODIFY_ACL, operation)) {
                int msgID = 0xC0002C;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), String.valueOf(clientDN));
                ErrorLogger.logError(ErrorLogCategory.ACCESS_CONTROL, ErrorLogSeverity.INFORMATIONAL, message, msgID);
                return false;
            }
            List<Attribute> attributeList = entry.getOperationalAttribute(aciType, null);
            for (Attribute attribute : attributeList) {
                for (AttributeValue value : attribute.getValues()) {
                    try {
                        DN dn = entry.getDN();
                        Aci.decode(value.getValue(), dn);
                    }
                    catch (AciException ex) {
                        int msgID = 12714030;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(entry.getDN()), ex.getMessage());
                        ErrorLogger.logError(ErrorLogCategory.ACCESS_CONTROL, ErrorLogSeverity.INFORMATIONAL, message, msgID);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean isAllowed(LocalBackendAddOperation operation) {
        AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(operation, 32);
        boolean ret = this.isAllowed(operationContainer, operation);
        if (ret) {
            ret = this.verifySyntax(operation.getEntryToAdd(), operation, operationContainer.getClientDN());
        }
        return ret;
    }

    @Override
    public boolean isAllowed(LocalBackendCompareOperation operation) {
        AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(operation, 1);
        String rawAttributeType = operation.getRawAttributeType();
        int semicolonPosition = rawAttributeType.indexOf(59);
        String baseName = semicolonPosition > 0 ? StaticUtils.toLowerCase(rawAttributeType.substring(0, semicolonPosition)) : StaticUtils.toLowerCase(rawAttributeType);
        AttributeType attributeType = DirectoryServer.getAttributeType(baseName);
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(baseName);
        }
        AttributeValue attributeValue = new AttributeValue(attributeType, operation.getAssertionValue());
        operationContainer.setCurrentAttributeType(attributeType);
        operationContainer.setCurrentAttributeValue(attributeValue);
        return this.isAllowed(operationContainer, operation);
    }

    @Override
    public boolean isAllowed(LocalBackendDeleteOperation operation) {
        AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(operation, 16);
        return this.isAllowed(operationContainer, operation);
    }

    @Override
    public boolean isAllowed(LocalBackendModifyOperation operation) {
        AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(operation, 0);
        return this.aciCheckMods(operationContainer, operation, this.skipAccessCheck(operation));
    }

    @Override
    public boolean maySend(SearchOperation operation, SearchResultEntry entry) {
        AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(operation, 2, entry);
        boolean ret = this.skipAccessCheck(operation);
        if (!ret) {
            try {
                ret = this.testFilter(operationContainer, operation.getFilter());
            }
            catch (DirectoryException ex) {
                ret = false;
            }
            if (ret) {
                operationContainer.clearEvalAttributes(0);
                operationContainer.setRights(4);
                ret = this.accessAllowedEntry(operationContainer);
                if (ret) {
                    if (!operationContainer.hasEvalUserAttributes()) {
                        operation.setAttachment(ALL_USER_ATTRS_MATCHED, ALL_USER_ATTRS_MATCHED);
                    }
                    if (!operationContainer.hasEvalOpAttributes()) {
                        operation.setAttachment(ALL_OP_ATTRS_MATCHED, ALL_OP_ATTRS_MATCHED);
                    }
                }
            }
        }
        operation.setAttachment(ALL_ATTRS_RESOURCE_ENTRY, entry);
        return ret;
    }

    @Override
    public SearchResultEntry filterEntry(SearchOperation operation, SearchResultEntry entry) {
        AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(operation, 4, entry);
        operationContainer.setSeenEntry(true);
        boolean skipCheck = this.skipAccessCheck(operation);
        SearchResultEntry returnEntry = !skipCheck ? this.accessAllowedAttrs(operationContainer) : entry;
        if (operationContainer.hasGetEffectiveRightsControl()) {
            returnEntry = AciEffectiveRights.addRightsToEntry(this, operation.getAttributes(), operationContainer, returnEntry, skipCheck);
        }
        return returnEntry;
    }

    private boolean aciCheckRDNs(LocalBackendModifyDNOperation operation, RDN oldRDN, RDN newRDN) {
        AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(operation, 8, operation.getOriginalEntry());
        boolean ret = this.accessAllowed(operationContainer);
        if (ret) {
            ret = this.checkRDN(2048, newRDN, operationContainer);
        }
        if (ret && operation.deleteOldRDN()) {
            ret = this.checkRDN(1024, oldRDN, operationContainer);
        }
        return ret;
    }

    private boolean checkRDN(int right, RDN rdn, AciContainer container) {
        boolean ret = false;
        int numAVAs = rdn.getNumValues();
        container.setRights(right);
        for (int i = 0; i < numAVAs; ++i) {
            AttributeType type = rdn.getAttributeType(i);
            AttributeValue value = rdn.getAttributeValue(i);
            container.setCurrentAttributeType(type);
            container.setCurrentAttributeValue(value);
            ret = this.accessAllowed(container);
            if (!ret) break;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean aciCheckSuperiorEntry(DN superiorDN, LocalBackendModifyDNOperation op) throws DirectoryException {
        boolean ret = false;
        Lock entryLock = null;
        for (int i = 0; i < 3 && (entryLock = LockManager.lockRead(superiorDN)) == null; ++i) {
        }
        if (entryLock == null) {
            int msgID = 12714056;
            String message = MessageHandler.getMessage(msgID, String.valueOf(superiorDN));
            ErrorLogger.logError(ErrorLogCategory.ACCESS_CONTROL, ErrorLogSeverity.INFORMATIONAL, message, msgID);
            return false;
        }
        try {
            Entry superiorEntry = DirectoryServer.getEntry(superiorDN);
            if (superiorEntry != null) {
                AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(op, 256, superiorEntry);
                ret = this.accessAllowed(operationContainer);
            }
        }
        finally {
            LockManager.unlock(superiorDN, entryLock);
        }
        return ret;
    }

    @Override
    public boolean isAllowed(LocalBackendModifyDNOperation operation) {
        boolean ret = true;
        RDN oldRDN = operation.getOriginalEntry().getDN().getRDN();
        RDN newRDN = operation.getNewRDN();
        if (!this.skipAccessCheck(operation)) {
            DN newSuperiorDN = operation.getNewSuperior();
            if (newSuperiorDN != null) {
                try {
                    ret = this.aciCheckSuperiorEntry(newSuperiorDN, operation);
                }
                catch (DirectoryException ex) {
                    ret = false;
                }
            }
            boolean rdnEquals = oldRDN.equals(newRDN);
            if (ret && !rdnEquals) {
                ret = this.aciCheckRDNs(operation, oldRDN, newRDN);
            }
            if (ret && newSuperiorDN != null) {
                AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(operation, 512, operation.getOriginalEntry());
                if (!rdnEquals) {
                    operationContainer.setSeenEntry(true);
                }
                ret = this.accessAllowed(operationContainer);
            }
        }
        return ret;
    }

    @Override
    public boolean isAllowed(DN entryDN, Operation op, Control control) {
        boolean ret = this.skipAccessCheck(op);
        if (!ret) {
            Entry e = new Entry(entryDN, null, null, null);
            AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(op, e, control, 16388);
            ret = this.accessAllowed(operationContainer);
        }
        if (control.getOID().equals("2.16.840.1.113730.3.4.18") || control.getOID().equals("2.16.840.1.113730.3.4.12")) {
            op.setAttachment(ORIG_AUTH_ENTRY, op.getAuthorizationEntry());
        } else if (control.getOID().equals("1.3.6.1.4.1.42.2.27.9.5.2")) {
            try {
                GetEffectiveRights getEffectiveRightsControl = GetEffectiveRights.decodeControl(control);
                op.setAttachment("1.3.6.1.4.1.42.2.27.9.5.2", getEffectiveRightsControl);
            }
            catch (LDAPException le) {
                int msgID = 12714078;
                String message = MessageHandler.getMessage(msgID, le.getMessage());
                ErrorLogger.logError(ErrorLogCategory.ACCESS_CONTROL, ErrorLogSeverity.INFORMATIONAL, message, msgID);
                ret = false;
            }
        }
        return ret;
    }

    @Override
    public boolean isAllowed(ExtendedOperation operation) {
        boolean ret = this.skipAccessCheck(operation);
        if (!ret) {
            Entry e = new Entry(operation.getAuthorizationDN(), null, null, null);
            AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(operation, e, 32772);
            ret = this.accessAllowed(operationContainer);
        }
        return ret;
    }

    @Override
    public boolean maySend(DN dn, SearchOperation operation, SearchResultReference reference) {
        boolean ret = this.skipAccessCheck(operation);
        if (!ret) {
            Entry e = new Entry(dn, null, null, null);
            LinkedHashSet<AttributeValue> vals = new LinkedHashSet<AttributeValue>();
            List<String> URLStrings = reference.getReferralURLs();
            for (String URLString : URLStrings) {
                vals.add(new AttributeValue(refAttrType, URLString));
            }
            Attribute attr = new Attribute(refAttrType, "ref", vals);
            e.addAttribute(attr, null);
            SearchResultEntry se = new SearchResultEntry(e);
            AciLDAPOperationContainer operationContainer = new AciLDAPOperationContainer(operation, 4, se);
            operationContainer.setCurrentAttributeType(refAttrType);
            ret = this.accessAllowed(operationContainer);
        }
        return ret;
    }

    @Override
    public boolean isAllowed(LocalBackendBindOperation bindOperation) {
        return true;
    }

    @Override
    public boolean isAllowed(LocalBackendSearchOperation searchOperation) {
        return true;
    }

    static {
        if (aciType == null) {
            aciType = DirectoryServer.getDefaultAttributeType("aci");
        }
        if ((globalAciType = DirectoryServer.getAttributeType("ds-cfg-global-aci")) == null) {
            globalAciType = DirectoryServer.getDefaultAttributeType("ds-cfg-global-aci");
        }
        if ((debugSearchIndex = DirectoryServer.getAttributeType("debugsearchindex")) == null) {
            debugSearchIndex = DirectoryServer.getDefaultAttributeType("debugsearchindex");
        }
        if ((refAttrType = DirectoryServer.getAttributeType("ref")) == null) {
            refAttrType = DirectoryServer.getDefaultAttributeType("ref");
        }
        try {
            debugSearchIndexDN = DN.decode("cn=debugsearch");
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
    }
}

