/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.SearchFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargAttrFilterList {
    private int mask = 0;
    private LinkedHashMap<AttributeType, SearchFilter> attrFilterList;
    private static int expectedGroupCount = 2;
    private static int attributePos = 1;
    private static int filterPos = 2;
    private static final String filterListSeperator = "\\s*&&\\s*";
    private static final String attributeFilter = "((?i)[a-z\\d]{1}[[a-z]\\d-_.;]*(?-i)|\\*{1}|\\+{1})\\s*:{1}\\s*(\\({1}.*\\){1})";

    public TargAttrFilterList(int mask, LinkedHashMap<AttributeType, SearchFilter> attrFilterList) {
        this.mask = mask;
        this.attrFilterList = attrFilterList;
    }

    public static TargAttrFilterList decode(int mask, String expression) throws AciException {
        String[] subExpressions;
        LinkedHashMap<AttributeType, SearchFilter> attrFilterList = new LinkedHashMap<AttributeType, SearchFilter>();
        for (String subs : subExpressions = expression.split(filterListSeperator, -1)) {
            SearchFilter filter;
            Pattern pattern = Pattern.compile(attributeFilter);
            Matcher matcher = pattern.matcher(subs);
            if (!matcher.find() || matcher.groupCount() != expectedGroupCount) {
                int msgID = 12714040;
                String message = MessageHandler.getMessage(msgID, expression);
                throw new AciException(msgID, message);
            }
            String attributeName = matcher.group(attributePos).toLowerCase();
            int semicolon = attributeName.indexOf(59);
            if (semicolon != -1) {
                attributeName = attributeName.substring(0, semicolon);
            }
            String filterString = matcher.group(filterPos);
            AttributeType attributeType = DirectoryServer.getAttributeType(attributeName);
            if (attributeType == null) {
                attributeType = DirectoryServer.getDefaultAttributeType(attributeName);
            }
            try {
                filter = SearchFilter.createFilterFromString(filterString);
                attrFilterList.put(attributeType, filter);
            }
            catch (DirectoryException ex) {
                String er = ex.getErrorMessage();
                int msgID = 12714041;
                String message = MessageHandler.getMessage(msgID, filterString, er);
                throw new AciException(msgID, message);
            }
            TargAttrFilterList.verifyFilterComponents(filter, attributeType);
        }
        return new TargAttrFilterList(mask, attrFilterList);
    }

    private static void verifyFilterComponents(SearchFilter filter, AttributeType type) throws AciException {
        switch (filter.getFilterType()) {
            case AND: 
            case OR: {
                for (SearchFilter f : filter.getFilterComponents()) {
                    TargAttrFilterList.verifyFilterComponents(f, type);
                }
                break;
            }
            case NOT: {
                SearchFilter f = filter.getNotComponent();
                TargAttrFilterList.verifyFilterComponents(f, type);
                break;
            }
            default: {
                AttributeType attrType = filter.getAttributeType();
                if (attrType.equals(type)) break;
                int msgID = 12714042;
                String message = MessageHandler.getMessage(msgID, filter.toString());
                throw new AciException(msgID, message);
            }
        }
    }

    public int getMask() {
        return this.mask;
    }

    public boolean hasMask(int mask) {
        return (this.mask & mask) != 0;
    }

    public LinkedHashMap<AttributeType, SearchFilter> getAttributeTypeFilterList() {
        return this.attrFilterList;
    }
}

