/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.HashSet;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.AciTargetMatchContext;
import org.opends.server.authorization.dseecompat.EnumTargetOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetControl {
    private HashSet<String> controlOIDS = new HashSet();
    private EnumTargetOperator op = EnumTargetOperator.EQUALITY;

    private TargetControl(EnumTargetOperator op, HashSet<String> controlOIDS) {
        this.controlOIDS = controlOIDS;
        this.op = op;
    }

    public static TargetControl decode(EnumTargetOperator operator, String expr) throws AciException {
        HashSet<String> controlOIDs = Aci.decodeOID(expr, 12714075);
        return new TargetControl(operator, controlOIDs);
    }

    public boolean isApplicable(AciTargetMatchContext matchCtx) {
        if (matchCtx.getControlOID() == null) {
            return false;
        }
        boolean ret = false;
        for (String oid : this.controlOIDS) {
            if (!oid.equals("*") && !matchCtx.getControlOID().equals(oid)) continue;
            ret = true;
            break;
        }
        if (this.op.equals((Object)EnumTargetOperator.NOT_EQUALITY)) {
            ret = !ret;
        }
        return ret;
    }
}

