/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.server.JEBackendCfg;
import org.opends.server.admin.std.server.JEIndexCfg;
import org.opends.server.admin.std.server.VLVJEIndexCfg;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.EntryCache;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.BufferedIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.DataConfig;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.EntryIDSetSorter;
import org.opends.server.backends.jeb.ID2CIndexer;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.ID2SIndexer;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexFilter;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.State;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.PagedResultsControl;
import org.opends.server.controls.ServerSideSortRequestControl;
import org.opends.server.controls.ServerSideSortResponseControl;
import org.opends.server.controls.VLVRequestControl;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelledOperationException;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LockType;
import org.opends.server.types.Modification;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchScope;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryContainer
implements ConfigurationChangeListener<JEBackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String ID2ENTRY_DATABASE_NAME = "id2entry";
    public static final String DN2ID_DATABASE_NAME = "dn2id";
    public static final String ID2CHILDREN_DATABASE_NAME = "id2children";
    public static final String ID2SUBTREE_DATABASE_NAME = "id2subtree";
    public static final String REFERRAL_DATABASE_NAME = "referral";
    public static final String STATE_DATABASE_NAME = "state";
    public static final String ATTR_DEBUG_SEARCH_INDEX = "debugsearchindex";
    public AttributeJEIndexCfgManager attributeJEIndexCfgManager;
    public VLVJEIndexCfgManager vlvJEIndexCfgManager;
    private Backend backend;
    private RootContainer rootContainer;
    private DN baseDN;
    private JEBackendCfg config;
    private Environment env;
    private DN2ID dn2id;
    private ID2Entry id2entry;
    private Index id2children;
    private Index id2subtree;
    private DN2URI dn2uri;
    private State state;
    private HashMap<AttributeType, AttributeIndex> attrIndexMap;
    private HashMap<String, VLVIndex> vlvIndexMap;
    private int deadlockRetryLimit;
    private int subtreeDeleteSizeLimit;
    private int subtreeDeleteBatchSize;
    private int indexEntryLimit;
    private String databasePrefix;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final Lock sharedLock = this.lock.readLock();
    final Lock exclusiveLock = this.lock.writeLock();

    public EntryContainer(DN baseDN, String databasePrefix, Backend backend, JEBackendCfg config, Environment env, RootContainer rootContainer) throws ConfigException {
        this.backend = backend;
        this.baseDN = baseDN;
        this.config = config;
        this.env = env;
        this.rootContainer = rootContainer;
        StringBuilder builder = new StringBuilder(databasePrefix.length());
        for (int i = 0; i < databasePrefix.length(); ++i) {
            char ch = databasePrefix.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                builder.append(ch);
                continue;
            }
            builder.append('_');
        }
        this.databasePrefix = builder.toString();
        this.deadlockRetryLimit = config.getBackendDeadlockRetryLimit();
        this.subtreeDeleteSizeLimit = config.getBackendSubtreeDeleteSizeLimit();
        this.subtreeDeleteBatchSize = config.getBackendSubtreeDeleteBatchSize();
        this.indexEntryLimit = config.getBackendIndexEntryLimit();
        this.attrIndexMap = new HashMap();
        this.vlvIndexMap = new HashMap();
        config.addJEChangeListener(this);
        this.attributeJEIndexCfgManager = new AttributeJEIndexCfgManager();
        config.addJEIndexAddListener(this.attributeJEIndexCfgManager);
        config.addJEIndexDeleteListener(this.attributeJEIndexCfgManager);
        this.vlvJEIndexCfgManager = new VLVJEIndexCfgManager();
        config.addVLVJEIndexAddListener(this.vlvJEIndexCfgManager);
        config.addVLVJEIndexDeleteListener(this.vlvJEIndexCfgManager);
    }

    public void open() throws DatabaseException, ConfigException {
        try {
            DataConfig entryDataConfig = new DataConfig();
            entryDataConfig.setCompressed(this.config.isBackendEntriesCompressed());
            this.id2entry = new ID2Entry(this.databasePrefix + "_" + ID2ENTRY_DATABASE_NAME, entryDataConfig, this.env, this);
            this.id2entry.open();
            this.dn2id = new DN2ID(this.databasePrefix + "_" + DN2ID_DATABASE_NAME, this.env, this);
            this.dn2id.open();
            this.state = new State(this.databasePrefix + "_" + STATE_DATABASE_NAME, this.env, this);
            this.state.open();
            this.id2children = new Index(this.databasePrefix + "_" + ID2CHILDREN_DATABASE_NAME, new ID2CIndexer(), this.state, this.indexEntryLimit, 0, this.env, this);
            this.id2children.open();
            this.id2subtree = new Index(this.databasePrefix + "_" + ID2SUBTREE_DATABASE_NAME, new ID2SIndexer(), this.state, this.indexEntryLimit, 0, this.env, this);
            this.id2subtree.open();
            this.dn2uri = new DN2URI(this.databasePrefix + "_" + REFERRAL_DATABASE_NAME, this.env, this);
            this.dn2uri.open();
            for (String idx : this.config.listJEIndexes()) {
                JEIndexCfg indexCfg = this.config.getJEIndex(idx);
                AttributeIndex index = new AttributeIndex(indexCfg, this.state, this.env, this);
                index.open();
                this.attrIndexMap.put(indexCfg.getIndexAttribute(), index);
            }
            for (String idx : this.config.listVLVJEIndexes()) {
                VLVJEIndexCfg vlvIndexCfg = this.config.getVLVJEIndex(idx);
                VLVIndex vlvIndex = new VLVIndex(vlvIndexCfg, this.state, this.env, this);
                vlvIndex.open();
                this.vlvIndexMap.put(vlvIndexCfg.getVLVIndexName().toLowerCase(), vlvIndex);
            }
        }
        catch (DatabaseException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.close();
            throw de;
        }
    }

    public void close() throws DatabaseException {
        ArrayList<DatabaseContainer> databases = new ArrayList<DatabaseContainer>();
        this.listDatabases(databases);
        for (DatabaseContainer db : databases) {
            db.close();
        }
        this.config.removeJEChangeListener(this);
        this.config.removeJEIndexAddListener(this.attributeJEIndexCfgManager);
        this.config.removeJEIndexDeleteListener(this.attributeJEIndexCfgManager);
        this.config.removeVLVJEIndexDeleteListener(this.vlvJEIndexCfgManager);
        this.config.removeVLVJEIndexDeleteListener(this.vlvJEIndexCfgManager);
    }

    public DN2ID getDN2ID() {
        return this.dn2id;
    }

    public ID2Entry getID2Entry() {
        return this.id2entry;
    }

    public DN2URI getDN2URI() {
        return this.dn2uri;
    }

    public Index getID2Children() {
        return this.id2children;
    }

    public Index getID2Subtree() {
        return this.id2subtree;
    }

    public AttributeIndex getAttributeIndex(AttributeType attrType) {
        return this.attrIndexMap.get(attrType);
    }

    public VLVIndex getVLVIndex(String vlvIndexName) {
        return this.vlvIndexMap.get(vlvIndexName);
    }

    public Collection<AttributeIndex> getAttributeIndexes() {
        return this.attrIndexMap.values();
    }

    public Collection<VLVIndex> getVLVIndexes() {
        return this.vlvIndexMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryID getHighestEntryID() throws DatabaseException {
        EntryID entryID = new EntryID(0L);
        Cursor cursor = this.id2entry.openCursor(null, null);
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        try {
            OperationStatus status = cursor.getLast(key, data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                entryID = new EntryID(key);
            }
        }
        finally {
            cursor.close();
        }
        return entryID;
    }

    public void search(SearchOperation searchOperation) throws DirectoryException, DatabaseException, JebException {
        boolean candidatesAreInScope;
        EntryIDSet entryIDList;
        StringBuilder debugBuffer;
        ServerSideSortRequestControl sortRequest;
        PagedResultsControl pageRequest;
        block45: {
            DN baseDN = searchOperation.getBaseDN();
            SearchScope searchScope = searchOperation.getScope();
            List<Control> controls = searchOperation.getRequestControls();
            pageRequest = null;
            sortRequest = null;
            VLVRequestControl vlvRequest = null;
            if (controls != null) {
                for (Control control : controls) {
                    if (control.getOID().equals("1.2.840.113556.1.4.319")) {
                        if (pageRequest != null) continue;
                        try {
                            pageRequest = new PagedResultsControl(control.isCritical(), control.getValue());
                        }
                        catch (LDAPException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, e.getMessage(), e.getMessageID(), e);
                        }
                        if (vlvRequest == null) continue;
                        int msgID = 8585360;
                        String message = MessageHandler.getMessage(msgID);
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                    }
                    if (control.getOID().equals("1.2.840.113556.1.4.473")) {
                        if (sortRequest != null) continue;
                        try {
                            sortRequest = ServerSideSortRequestControl.decodeControl(control);
                            continue;
                        }
                        catch (LDAPException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, e.getMessage(), e.getMessageID(), e);
                        }
                    }
                    if (!control.getOID().equals("2.16.840.1.113730.3.4.9") || vlvRequest != null) continue;
                    try {
                        vlvRequest = VLVRequestControl.decodeControl(control);
                    }
                    catch (LDAPException e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, e.getMessage(), e.getMessageID(), e);
                    }
                    if (pageRequest == null) continue;
                    int msgID = 8585360;
                    String message = MessageHandler.getMessage(msgID);
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
            }
            if (pageRequest != null && pageRequest.getSize() == 0) {
                PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, new ASN1OctetString());
                searchOperation.getResponseControls().add(control);
                return;
            }
            if (searchScope == SearchScope.BASE_OBJECT) {
                Entry baseEntry;
                block44: {
                    baseEntry = null;
                    try {
                        baseEntry = this.getEntry(baseDN);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block44;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                if (baseEntry == null) {
                    this.dn2uri.targetEntryReferrals(searchOperation.getBaseDN(), searchOperation.getScope());
                    int messageID = 8585262;
                    String message = MessageHandler.getMessage(messageID, baseDN.toString());
                    DN matchedDN = this.getMatchedDN(baseDN);
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, messageID, matchedDN, null);
                }
                if (!EntryContainer.isManageDsaITOperation(searchOperation)) {
                    this.dn2uri.checkTargetForReferral(baseEntry, searchOperation.getScope());
                }
                if (searchOperation.getFilter().matchesEntry(baseEntry)) {
                    searchOperation.returnEntry(baseEntry, null);
                }
                if (pageRequest != null) {
                    Control control;
                    control = new PagedResultsControl(pageRequest.isCritical(), 0, new ASN1OctetString());
                    searchOperation.getResponseControls().add(control);
                }
                return;
            }
            debugBuffer = null;
            if (searchOperation.getAttributes().contains(ATTR_DEBUG_SEARCH_INDEX)) {
                debugBuffer = new StringBuilder();
            }
            entryIDList = null;
            candidatesAreInScope = false;
            if (sortRequest != null) {
                for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
                    try {
                        entryIDList = vlvIndex.evaluate(null, searchOperation, sortRequest, vlvRequest, debugBuffer);
                        if (entryIDList == null) continue;
                        searchOperation.addResponseControl(new ServerSideSortResponseControl(0, null));
                        candidatesAreInScope = true;
                        break;
                    }
                    catch (DirectoryException de) {
                        searchOperation.addResponseControl(new ServerSideSortResponseControl(de.getResultCode().getIntValue(), null));
                        if (!sortRequest.isCritical()) continue;
                        throw de;
                    }
                }
            }
            if (entryIDList == null) {
                IndexFilter indexFilter = new IndexFilter(this, searchOperation, debugBuffer);
                entryIDList = indexFilter.evaluate();
                if (entryIDList.size() > 10) {
                    EntryIDSet scopeList;
                    EntryID baseID = this.dn2id.get(null, baseDN);
                    if (baseID == null) {
                        int messageID = 8585262;
                        String message = MessageHandler.getMessage(messageID, baseDN.toString());
                        DN matchedDN = this.getMatchedDN(baseDN);
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, messageID, matchedDN, null);
                    }
                    DatabaseEntry baseIDData = baseID.getDatabaseEntry();
                    if (searchScope == SearchScope.SINGLE_LEVEL) {
                        scopeList = this.id2children.readKey(baseIDData, null, LockMode.DEFAULT);
                    } else {
                        scopeList = this.id2subtree.readKey(baseIDData, null, LockMode.DEFAULT);
                        if (searchScope == SearchScope.WHOLE_SUBTREE) {
                            scopeList.add(baseID);
                        }
                    }
                    entryIDList.retainAll(scopeList);
                    if (debugBuffer != null) {
                        debugBuffer.append(" scope=");
                        debugBuffer.append((Object)searchScope);
                        scopeList.toString(debugBuffer);
                    }
                    if (scopeList.isDefined()) {
                        candidatesAreInScope = true;
                    }
                }
                if (sortRequest != null) {
                    try {
                        entryIDList = EntryIDSetSorter.sort(this, entryIDList, searchOperation, sortRequest.getSortOrder(), vlvRequest);
                        searchOperation.addResponseControl(new ServerSideSortResponseControl(0, null));
                    }
                    catch (DirectoryException de) {
                        searchOperation.addResponseControl(new ServerSideSortResponseControl(de.getResultCode().getIntValue(), null));
                        if (!sortRequest.isCritical()) break block45;
                        throw de;
                    }
                }
            }
        }
        if (debugBuffer != null) {
            debugBuffer.append(" final=");
            entryIDList.toString(debugBuffer);
            AttributeSyntax syntax = DirectoryServer.getDefaultStringSyntax();
            AttributeType attrType = DirectoryServer.getDefaultAttributeType(ATTR_DEBUG_SEARCH_INDEX, syntax);
            ASN1OctetString valueString = new ASN1OctetString(debugBuffer.toString());
            LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>();
            values.add(new AttributeValue(valueString, (ByteString)valueString));
            Attribute attr = new Attribute(attrType, ATTR_DEBUG_SEARCH_INDEX, values);
            Entry debugEntry = new Entry(DN.decode("cn=debugsearch"), null, null, null);
            debugEntry.addAttribute(attr, new ArrayList<AttributeValue>());
            searchOperation.returnEntry(debugEntry, null);
            return;
        }
        if (entryIDList.isDefined()) {
            this.searchIndexed(entryIDList, candidatesAreInScope, searchOperation, pageRequest);
        } else {
            String message;
            for (VirtualAttributeRule rule : DirectoryServer.getVirtualAttributes()) {
                if (!rule.getProvider().isSearchable(rule, searchOperation)) continue;
                rule.getProvider().processSearch(rule, searchOperation);
                return;
            }
            ClientConnection clientConnection = searchOperation.getClientConnection();
            if (!clientConnection.hasPrivilege(Privilege.UNINDEXED_SEARCH, searchOperation)) {
                int msgID = 8585361;
                message = MessageHandler.getMessage(msgID);
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
            }
            if (sortRequest != null) {
                searchOperation.addResponseControl(new ServerSideSortResponseControl(53, null));
                if (sortRequest.isCritical()) {
                    int msgID = 8585356;
                    message = MessageHandler.getMessage(msgID);
                    throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, message, msgID);
                }
            }
            this.searchNotIndexed(searchOperation, pageRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchNotIndexed(SearchOperation searchOperation, PagedResultsControl pageRequest) throws DirectoryException {
        block35: {
            byte[] begin;
            EntryCache entryCache = DirectoryServer.getEntryCache();
            DN baseDN = searchOperation.getBaseDN();
            SearchScope searchScope = searchOperation.getScope();
            boolean manageDsaIT = EntryContainer.isManageDsaITOperation(searchOperation);
            if (pageRequest == null || pageRequest.getCookie().value().length == 0) {
                Entry baseEntry;
                block34: {
                    baseEntry = null;
                    try {
                        baseEntry = this.getEntry(baseDN);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block34;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                if (baseEntry == null) {
                    this.dn2uri.targetEntryReferrals(searchOperation.getBaseDN(), searchOperation.getScope());
                    int messageID = 8585262;
                    String message = MessageHandler.getMessage(messageID, baseDN.toString());
                    DN matchedDN = this.getMatchedDN(baseDN);
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, messageID, matchedDN, null);
                }
                if (!manageDsaIT) {
                    this.dn2uri.checkTargetForReferral(baseEntry, searchOperation.getScope());
                }
                if (searchScope == SearchScope.WHOLE_SUBTREE && searchOperation.getFilter().matchesEntry(baseEntry)) {
                    searchOperation.returnEntry(baseEntry, null);
                }
                if (!manageDsaIT && !this.dn2uri.returnSearchReferences(searchOperation) && pageRequest != null) {
                    PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, new ASN1OctetString());
                    searchOperation.getResponseControls().add(control);
                }
            }
            byte[] suffix = StaticUtils.getBytes("," + baseDN.toNormalizedString());
            byte[] end = (byte[])suffix.clone();
            end[0] = (byte)(end[0] + 1);
            if (pageRequest != null && pageRequest.getCookie().value().length != 0) {
                try {
                    DN lastDN = DN.decode(pageRequest.getCookie());
                    begin = StaticUtils.getBytes(lastDN.toNormalizedString());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    int msgID = 8585327;
                    String str = StaticUtils.bytesToHex(pageRequest.getCookie().value());
                    String msg = MessageHandler.getMessage(msgID, str);
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg, msgID, e);
                }
            } else {
                begin = suffix;
            }
            DatabaseEntry data = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry(begin);
            ArrayList<Lock> lockList = new ArrayList<Lock>(1);
            int lookthroughCount = 0;
            int lookthroughLimit = searchOperation.getClientConnection().getLookthroughLimit();
            try {
                Cursor cursor = this.dn2id.openCursor(null, null);
                try {
                    OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                    while (status == OperationStatus.SUCCESS) {
                        if (lookthroughLimit > 0 && lookthroughCount > lookthroughLimit) {
                            searchOperation.setResultCode(ResultCode.ADMIN_LIMIT_EXCEEDED);
                            searchOperation.appendErrorMessage(MessageHandler.getMessage(8388735, lookthroughLimit));
                            return;
                        }
                        int cmp = this.dn2id.getComparator().compare(key.getData(), end);
                        if (cmp >= 0) {
                            break;
                        }
                        EntryID entryID = new EntryID(data);
                        DN dn = DN.decode(new ASN1OctetString(key.getData()));
                        boolean isInScope = true;
                        if (searchScope == SearchScope.SINGLE_LEVEL && dn.getNumComponents() != baseDN.getNumComponents() + 1) {
                            isInScope = false;
                        }
                        if (isInScope) {
                            Entry entry = null;
                            Entry cacheEntry = null;
                            lockList.clear();
                            cacheEntry = entryCache.getEntry(this.backend, entryID.longValue(), LockType.NONE, lockList);
                            if (cacheEntry == null) {
                                GetEntryByIDOperation operation = new GetEntryByIDOperation(entryID);
                                this.invokeTransactedOperation(operation);
                                entry = operation.getEntry();
                            } else {
                                entry = cacheEntry;
                            }
                            if (entry != null) {
                                ++lookthroughCount;
                                if ((manageDsaIT || entry.getReferralURLs() == null) && searchOperation.getFilter().matchesEntry(entry)) {
                                    if (pageRequest != null && searchOperation.getEntriesSent() == pageRequest.getSize()) {
                                        ASN1OctetString cookie = new ASN1OctetString(key.getData());
                                        PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, cookie);
                                        searchOperation.getResponseControls().add(control);
                                        return;
                                    }
                                    if (!searchOperation.returnEntry(entry, null)) {
                                        return;
                                    }
                                }
                            }
                        }
                        status = cursor.getNext(key, data, LockMode.DEFAULT);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            catch (DatabaseException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            catch (JebException e) {
                if (!DebugLogger.debugEnabled()) break block35;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        if (pageRequest != null) {
            PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, new ASN1OctetString());
            searchOperation.getResponseControls().add(control);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void searchIndexed(EntryIDSet entryIDList, boolean candidatesAreInScope, SearchOperation searchOperation, PagedResultsControl pageRequest) throws DirectoryException {
        EntryCache entryCache = DirectoryServer.getEntryCache();
        SearchScope searchScope = searchOperation.getScope();
        DN baseDN = searchOperation.getBaseDN();
        boolean manageDsaIT = EntryContainer.isManageDsaITOperation(searchOperation);
        boolean continueSearch = true;
        EntryID begin = null;
        if (pageRequest != null && pageRequest.getCookie().value().length != 0) {
            try {
                begin = new EntryID(new DatabaseEntry(pageRequest.getCookie().value()));
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 8585327;
                String str = StaticUtils.bytesToHex(pageRequest.getCookie().value());
                String msg = MessageHandler.getMessage(msgID, str);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg, msgID, e);
            }
        } else if (!manageDsaIT) {
            continueSearch = this.dn2uri.returnSearchReferences(searchOperation);
        }
        int lookthroughLimit = searchOperation.getClientConnection().getLookthroughLimit();
        if (lookthroughLimit > 0 && entryIDList.size() > lookthroughLimit) {
            searchOperation.setResultCode(ResultCode.ADMIN_LIMIT_EXCEEDED);
            searchOperation.appendErrorMessage(MessageHandler.getMessage(8388735, lookthroughLimit));
            continueSearch = false;
        }
        if (continueSearch) {
            ArrayList<Lock> lockList = new ArrayList<Lock>();
            Iterator<EntryID> iterator = entryIDList.iterator(begin);
            while (iterator.hasNext()) {
                Entry cacheEntry;
                Entry entry;
                EntryID id;
                block32: {
                    id = iterator.next();
                    entry = null;
                    cacheEntry = null;
                    lockList.clear();
                    cacheEntry = entryCache.getEntry(this.backend, id.longValue(), LockType.NONE, lockList);
                    if (cacheEntry == null) {
                        GetEntryByIDOperation operation = new GetEntryByIDOperation(id);
                        try {
                            this.invokeTransactedOperation(operation);
                            entry = operation.getEntry();
                            break block32;
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            for (Lock lock : lockList) {
                                lock.unlock();
                            }
                            continue;
                        }
                    }
                    entry = cacheEntry;
                }
                if (entry == null) continue;
                boolean isInScope = false;
                DN entryDN = entry.getDN();
                if (candidatesAreInScope) {
                    isInScope = true;
                } else if (searchScope == SearchScope.SINGLE_LEVEL) {
                    if (entryDN.getNumComponents() == baseDN.getNumComponents() + 1 && entryDN.isDescendantOf(baseDN)) {
                        isInScope = true;
                    }
                } else if (searchScope == SearchScope.WHOLE_SUBTREE) {
                    if (entryDN.isDescendantOf(baseDN)) {
                        isInScope = true;
                    }
                } else if (searchScope == SearchScope.SUBORDINATE_SUBTREE && entryDN.getNumComponents() > baseDN.getNumComponents() && entryDN.isDescendantOf(baseDN)) {
                    isInScope = true;
                }
                if (cacheEntry == null) {
                    entryCache.putEntryIfAbsent(entry, this.backend, id.longValue());
                }
                if (!isInScope || !manageDsaIT && entry.getReferralURLs() != null || !searchOperation.getFilter().matchesEntry(entry)) continue;
                if (pageRequest != null && searchOperation.getEntriesSent() == pageRequest.getSize()) {
                    byte[] cookieBytes = id.getDatabaseEntry().getData();
                    ASN1OctetString cookie = new ASN1OctetString(cookieBytes);
                    PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, cookie);
                    searchOperation.getResponseControls().add(control);
                    return;
                }
                if (searchOperation.returnEntry(entry, null)) continue;
                break;
            }
        }
        if (searchOperation.getEntriesSent() == 0 && searchOperation.getReferencesSent() == 0) {
            this.dn2uri.targetEntryReferrals(searchOperation.getBaseDN(), searchOperation.getScope());
            if (!this.entryExists(baseDN)) {
                int messageID = 8585262;
                String message = MessageHandler.getMessage(messageID, baseDN.toString());
                DN matchedDN = this.getMatchedDN(baseDN);
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, messageID, matchedDN, null);
            }
        }
        if (pageRequest == null) return;
        PagedResultsControl control = new PagedResultsControl(pageRequest.isCritical(), 0, new ASN1OctetString());
        searchOperation.getResponseControls().add(control);
    }

    public void addEntry(Entry entry, AddOperation addOperation) throws DatabaseException, DirectoryException, JebException {
        AddEntryTransaction operation = new AddEntryTransaction(entry);
        this.invokeTransactedOperation(operation);
    }

    private void invokeTransactedOperation(TransactedOperation operation) throws DatabaseException, DirectoryException, JebException {
        boolean completed = false;
        int retryRemaining = this.deadlockRetryLimit;
        while (!completed) {
            Transaction txn = operation.beginOperationTransaction();
            try {
                operation.invokeOperation(txn);
                EntryContainer.transactionCommit(txn);
                completed = true;
            }
            catch (DeadlockException deadlockException) {
                EntryContainer.transactionAbort(txn);
                if (retryRemaining-- <= 0) {
                    throw deadlockException;
                }
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, deadlockException);
            }
            catch (DatabaseException databaseException) {
                EntryContainer.transactionAbort(txn);
                throw databaseException;
            }
            catch (DirectoryException directoryException) {
                EntryContainer.transactionAbort(txn);
                throw directoryException;
            }
            catch (JebException jebException) {
                EntryContainer.transactionAbort(txn);
                throw jebException;
            }
            catch (Exception e) {
                EntryContainer.transactionAbort(txn);
                int messageID = 8585244;
                String message = MessageHandler.getMessage(messageID);
                throw new JebException(messageID, message, e);
            }
        }
        operation.postCommitAction();
    }

    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException, DatabaseException, JebException {
        DeleteEntryTransaction operation = new DeleteEntryTransaction(entryDN, deleteOperation);
        boolean isComplete = false;
        while (!isComplete) {
            String message;
            this.invokeTransactedOperation(operation);
            if (operation.adminSizeLimitExceeded()) {
                message = MessageHandler.getMessage(8847392, operation.getDeletedEntryCount());
                throw new DirectoryException(ResultCode.ADMIN_LIMIT_EXCEEDED, message, 8847392);
            }
            if (operation.batchSizeExceeded()) {
                operation.resetBatchSize();
                continue;
            }
            isComplete = true;
            message = MessageHandler.getMessage(8847393, operation.getDeletedEntryCount());
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(message);
            deleteOperation.setErrorMessage(errorMessage);
        }
    }

    private void deleteLeaf(BufferedIndex id2cBuffered, BufferedIndex id2sBuffered, Transaction txn, DN leafDN, EntryID leafID) throws DatabaseException, DirectoryException, JebException {
        Entry entry = this.id2entry.get(txn, leafID);
        if (entry == null) {
            int msgID = 8650763;
            String msg = MessageHandler.getMessage(msgID, leafID.toString());
            throw new JebException(msgID, msg);
        }
        if (!this.dn2id.remove(txn, leafDN)) {
            int msgID = 0x830030;
            String message = MessageHandler.getMessage(msgID, leafDN.toString());
            DN matchedDN = this.getMatchedDN(this.baseDN);
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, matchedDN, null);
        }
        this.dn2uri.deleteEntry(txn, entry);
        if (!this.id2entry.remove(txn, leafID)) {
            int msgID = 8650763;
            String msg = MessageHandler.getMessage(msgID, leafID.toString());
            throw new JebException(msgID, msg);
        }
        this.indexRemoveEntry(txn, entry, leafID);
        byte[] keyID = leafID.getDatabaseEntry().getData();
        EntryIDSet children = id2cBuffered.get(keyID);
        if (!children.isDefined()) {
            id2cBuffered.remove(keyID);
        } else if (children.size() != 0) {
            int msgID = 8585268;
            String message = MessageHandler.getMessage(msgID, leafDN.toString());
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, message, msgID);
        }
        EntryIDSet subordinates = id2sBuffered.get(keyID);
        if (!subordinates.isDefined()) {
            id2sBuffered.remove(keyID);
        } else if (subordinates.size() != 0) {
            int msgID = 8585268;
            String message = MessageHandler.getMessage(msgID, leafDN.toString());
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, message, msgID);
        }
        boolean isParent = true;
        DN dn = this.getParentWithinBase(leafDN);
        while (dn != null) {
            EntryID nodeID = this.dn2id.get(txn, dn);
            if (nodeID == null) {
                int msgID = 8650762;
                String msg = MessageHandler.getMessage(msgID, dn.toNormalizedString());
                throw new JebException(msgID, msg);
            }
            DatabaseEntry nodeIDData = nodeID.getDatabaseEntry();
            if (isParent) {
                id2cBuffered.removeID(nodeIDData.getData(), leafID);
                isParent = false;
            }
            id2sBuffered.removeID(nodeIDData.getData(), leafID);
            dn = this.getParentWithinBase(dn);
        }
    }

    private void deleteTarget(boolean manageDsaIT, BufferedIndex id2cBuffered, BufferedIndex id2sBuffered, Transaction txn, DN leafDN) throws DatabaseException, DirectoryException, JebException {
        EntryID leafID = this.dn2id.get(txn, leafDN);
        if (leafID == null) {
            int msgID = 0x830030;
            String message = MessageHandler.getMessage(msgID, leafDN.toString());
            DN matchedDN = this.getMatchedDN(this.baseDN);
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, matchedDN, null);
        }
        Entry entry = this.id2entry.get(txn, leafID);
        if (entry == null) {
            int msgID = 8650763;
            String msg = MessageHandler.getMessage(msgID, leafID.toString());
            throw new JebException(msgID, msg);
        }
        if (!manageDsaIT) {
            this.dn2uri.checkTargetForReferral(entry, null);
        }
        if (!this.dn2id.remove(txn, leafDN)) {
            int msgID = 0x830030;
            String message = MessageHandler.getMessage(msgID, leafDN.toString());
            DN matchedDN = this.getMatchedDN(this.baseDN);
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, matchedDN, null);
        }
        this.dn2uri.deleteEntry(txn, entry);
        if (!this.id2entry.remove(txn, leafID)) {
            int msgID = 8650763;
            String msg = MessageHandler.getMessage(msgID, leafID.toString());
            throw new JebException(msgID, msg);
        }
        this.indexRemoveEntry(txn, entry, leafID);
        boolean isParent = true;
        DN dn = this.getParentWithinBase(leafDN);
        while (dn != null) {
            EntryID nodeID = this.dn2id.get(txn, dn);
            if (nodeID == null) {
                int msgID = 8650762;
                String msg = MessageHandler.getMessage(msgID, dn.toNormalizedString());
                throw new JebException(msgID, msg);
            }
            DatabaseEntry nodeIDData = nodeID.getDatabaseEntry();
            if (isParent) {
                id2cBuffered.removeID(nodeIDData.getData(), leafID);
                isParent = false;
            }
            id2sBuffered.removeID(nodeIDData.getData(), leafID);
            dn = this.getParentWithinBase(dn);
        }
    }

    public boolean entryExists(DN entryDN) throws DirectoryException {
        EntryID id;
        block3: {
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null && entryCache.containsEntry(entryDN)) {
                return true;
            }
            id = null;
            try {
                id = this.dn2id.get(null, entryDN);
            }
            catch (DatabaseException e) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return id != null;
    }

    public Entry getEntry(DN entryDN) throws JebException, DatabaseException, DirectoryException {
        EntryCache entryCache = DirectoryServer.getEntryCache();
        Entry entry = null;
        if (entryCache != null) {
            entry = entryCache.getEntry(entryDN);
        }
        if (entry == null) {
            GetEntryByDNOperation operation = new GetEntryByDNOperation(entryDN);
            this.invokeTransactedOperation(operation);
            entry = operation.getEntry();
            if (entry != null && entryCache != null) {
                entryCache.putEntryIfAbsent(entry, this.backend, operation.getEntryID().longValue());
            }
        }
        return entry;
    }

    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DatabaseException, DirectoryException, JebException {
        ReplaceEntryTransaction operation = new ReplaceEntryTransaction(entry, modifyOperation);
        this.invokeTransactedOperation(operation);
    }

    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DatabaseException, JebException, DirectoryException, CancelledOperationException {
        RenameEntryTransaction operation = new RenameEntryTransaction(currentDN, entry, modifyDNOperation);
        this.invokeTransactedOperation(operation);
    }

    public static DN modDN(DN oldDN, int oldSuffixLen, DN newSuffixDN) {
        int i;
        int oldDNNumComponents = oldDN.getNumComponents();
        int oldDNKeepComponents = oldDNNumComponents - oldSuffixLen;
        int newSuffixDNComponents = newSuffixDN.getNumComponents();
        RDN[] newDNComponents = new RDN[oldDNKeepComponents + newSuffixDNComponents];
        for (i = 0; i < oldDNKeepComponents; ++i) {
            newDNComponents[i] = oldDN.getRDN(i);
        }
        i = oldDNKeepComponents;
        for (int j = 0; j < newSuffixDNComponents; ++j) {
            newDNComponents[i] = newSuffixDN.getRDN(j);
            ++i;
        }
        return new DN(newDNComponents);
    }

    private void indexInsertEntry(Transaction txn, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.addEntry(txn, entryID, entry);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.addEntry(txn, entryID, entry);
        }
    }

    private void indexRemoveEntry(Transaction txn, Entry entry, EntryID entryID) throws DatabaseException, DirectoryException, JebException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.removeEntry(txn, entryID, entry);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.removeEntry(txn, entryID, entry);
        }
    }

    private void indexModifications(Transaction txn, Entry oldEntry, Entry newEntry, EntryID entryID, List<Modification> mods) throws DatabaseException, DirectoryException, JebException {
        for (AttributeIndex index : this.attrIndexMap.values()) {
            boolean attributeModified = false;
            for (Modification mod : mods) {
                Attribute modAttr = mod.getAttribute();
                AttributeType modAttrType = modAttr.getAttributeType();
                if (!modAttrType.equals(index.getAttributeType())) continue;
                attributeModified = true;
                break;
            }
            if (!attributeModified) continue;
            index.modifyEntry(txn, entryID, oldEntry, newEntry, mods);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            vlvIndex.modifyEntry(txn, entryID, oldEntry, newEntry, mods);
        }
    }

    public long getEntryCount() throws DatabaseException {
        return this.id2entry.getRecordCount();
    }

    public int getEntryLimitExceededCount() {
        int count = 0;
        count += this.id2children.getEntryLimitExceededCount();
        count += this.id2subtree.getEntryLimitExceededCount();
        for (AttributeIndex index : this.attrIndexMap.values()) {
            count = (int)((long)count + index.getEntryLimitExceededCount());
        }
        return count;
    }

    public void listDatabases(List<DatabaseContainer> dbList) {
        dbList.add(this.dn2id);
        dbList.add(this.id2entry);
        dbList.add(this.dn2uri);
        dbList.add(this.id2children);
        dbList.add(this.id2subtree);
        dbList.add(this.state);
        for (AttributeIndex index : this.attrIndexMap.values()) {
            index.listDatabases(dbList);
        }
        for (VLVIndex vlvIndex : this.vlvIndexMap.values()) {
            dbList.add(vlvIndex);
        }
    }

    public static boolean isManageDsaITOperation(Operation operation) {
        List<Control> controls;
        if (operation != null && (controls = operation.getRequestControls()) != null) {
            for (Control control : controls) {
                if (!control.getOID().equals("2.16.840.1.113730.3.4.2")) continue;
                return true;
            }
        }
        return false;
    }

    public Transaction beginTransaction() throws DatabaseException {
        Transaction parentTxn = null;
        TransactionConfig txnConfig = null;
        Transaction txn = this.env.beginTransaction(parentTxn, txnConfig);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("beginTransaction", "begin txnid=" + txn.getId());
        }
        return txn;
    }

    public static void transactionCommit(Transaction txn) throws DatabaseException {
        if (txn != null) {
            txn.commit();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("commit txnid=%d", txn.getId());
            }
        }
    }

    public static void transactionAbort(Transaction txn) throws DatabaseException {
        if (txn != null) {
            txn.abort();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("abort txnid=%d", txn.getId());
            }
        }
    }

    public void delete() throws DatabaseException {
        ArrayList<DatabaseContainer> databases = new ArrayList<DatabaseContainer>();
        this.listDatabases(databases);
        for (DatabaseContainer db : databases) {
            db.close();
        }
        if (this.env.getConfig().getTransactional()) {
            Transaction txn = this.beginTransaction();
            try {
                for (DatabaseContainer db : databases) {
                    this.env.removeDatabase(txn, db.getName());
                }
                EntryContainer.transactionCommit(txn);
            }
            catch (DatabaseException de) {
                EntryContainer.transactionAbort(txn);
                throw de;
            }
        } else {
            for (DatabaseContainer db : databases) {
                this.env.removeDatabase(null, db.getName());
            }
        }
    }

    public void deleteDatabase(DatabaseContainer database) throws DatabaseException {
        if (database == this.state) {
            return;
        }
        database.close();
        if (this.env.getConfig().getTransactional()) {
            Transaction txn = this.beginTransaction();
            try {
                this.env.removeDatabase(txn, database.getName());
                if (database instanceof Index) {
                    this.state.removeIndexTrustState(txn, (Index)database);
                }
                EntryContainer.transactionCommit(txn);
            }
            catch (DatabaseException de) {
                EntryContainer.transactionAbort(txn);
                throw de;
            }
        } else {
            this.env.removeDatabase(null, database.getName());
            if (database instanceof Index) {
                this.state.removeIndexTrustState(null, (Index)database);
            }
        }
    }

    public void deleteAttributeIndex(AttributeIndex index) throws DatabaseException {
        index.close();
        if (this.env.getConfig().getTransactional()) {
            Transaction txn = this.beginTransaction();
            try {
                if (index.equalityIndex != null) {
                    this.env.removeDatabase(txn, index.equalityIndex.getName());
                    this.state.removeIndexTrustState(txn, index.equalityIndex);
                }
                if (index.presenceIndex != null) {
                    this.env.removeDatabase(txn, index.presenceIndex.getName());
                    this.state.removeIndexTrustState(txn, index.presenceIndex);
                }
                if (index.substringIndex != null) {
                    this.env.removeDatabase(txn, index.substringIndex.getName());
                    this.state.removeIndexTrustState(txn, index.substringIndex);
                }
                if (index.orderingIndex != null) {
                    this.env.removeDatabase(txn, index.orderingIndex.getName());
                    this.state.removeIndexTrustState(txn, index.orderingIndex);
                }
                if (index.approximateIndex != null) {
                    this.env.removeDatabase(txn, index.approximateIndex.getName());
                    this.state.removeIndexTrustState(txn, index.approximateIndex);
                }
                EntryContainer.transactionCommit(txn);
            }
            catch (DatabaseException de) {
                EntryContainer.transactionAbort(txn);
                throw de;
            }
        } else {
            if (index.equalityIndex != null) {
                this.env.removeDatabase(null, index.equalityIndex.getName());
                this.state.removeIndexTrustState(null, index.equalityIndex);
            }
            if (index.presenceIndex != null) {
                this.env.removeDatabase(null, index.presenceIndex.getName());
                this.state.removeIndexTrustState(null, index.presenceIndex);
            }
            if (index.substringIndex != null) {
                this.env.removeDatabase(null, index.substringIndex.getName());
                this.state.removeIndexTrustState(null, index.substringIndex);
            }
            if (index.orderingIndex != null) {
                this.env.removeDatabase(null, index.orderingIndex.getName());
                this.state.removeIndexTrustState(null, index.orderingIndex);
            }
            if (index.approximateIndex != null) {
                this.env.removeDatabase(null, index.approximateIndex.getName());
                this.state.removeIndexTrustState(null, index.approximateIndex);
            }
        }
    }

    public String getDatabasePrefix() {
        return this.databasePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDatabasePrefix(String newDatabasePrefix) throws DatabaseException, JebException {
        block13: {
            ArrayList<DatabaseContainer> databases = new ArrayList<DatabaseContainer>();
            this.listDatabases(databases);
            StringBuilder builder = new StringBuilder(newDatabasePrefix.length());
            for (int i = 0; i < newDatabasePrefix.length(); ++i) {
                char ch = newDatabasePrefix.charAt(i);
                if (Character.isLetterOrDigit(ch)) {
                    builder.append(ch);
                    continue;
                }
                builder.append('_');
            }
            newDatabasePrefix = builder.toString();
            for (DatabaseContainer db : databases) {
                db.close();
            }
            try {
                if (this.env.getConfig().getTransactional()) {
                    Transaction txn = this.beginTransaction();
                    try {
                        String newName;
                        String oldName;
                        for (DatabaseContainer db : databases) {
                            oldName = db.getName();
                            newName = oldName.replace(this.databasePrefix, newDatabasePrefix);
                            this.env.renameDatabase(txn, oldName, newName);
                        }
                        EntryContainer.transactionCommit(txn);
                        for (DatabaseContainer db : databases) {
                            oldName = db.getName();
                            newName = oldName.replace(this.databasePrefix, newDatabasePrefix);
                            db.setName(newName);
                        }
                        this.databasePrefix = newDatabasePrefix;
                        break block13;
                    }
                    catch (Exception e) {
                        EntryContainer.transactionAbort(txn);
                        int messageID = 8585244;
                        String message = MessageHandler.getMessage(messageID);
                        throw new JebException(messageID, message, e);
                    }
                }
                for (DatabaseContainer db : databases) {
                    String oldName = db.getName();
                    String newName = oldName.replace(this.databasePrefix, newDatabasePrefix);
                    this.env.renameDatabase(null, oldName, newName);
                    db.setName(newName);
                }
                this.databasePrefix = newDatabasePrefix;
            }
            finally {
                for (DatabaseContainer db : databases) {
                    db.open();
                }
            }
        }
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public DN getParentWithinBase(DN dn) {
        if (dn.equals(this.baseDN)) {
            return null;
        }
        return dn.getParent();
    }

    @Override
    public synchronized boolean isConfigurationChangeAcceptable(JEBackendCfg cfg, List<String> unacceptableReasons) {
        return true;
    }

    @Override
    public synchronized ConfigChangeResult applyConfigurationChange(JEBackendCfg cfg) {
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        if (this.config.getBackendIndexEntryLimit() != cfg.getBackendIndexEntryLimit()) {
            String message;
            int msgID;
            if (this.id2children.setIndexEntryLimit(cfg.getBackendIndexEntryLimit())) {
                adminActionRequired = true;
                msgID = 8847508;
                message = MessageHandler.getMessage(msgID, this.id2children.getName());
                messages.add(message);
            }
            if (this.id2subtree.setIndexEntryLimit(cfg.getBackendIndexEntryLimit())) {
                adminActionRequired = true;
                msgID = 8847508;
                message = MessageHandler.getMessage(msgID, this.id2subtree.getName());
                messages.add(message);
            }
        }
        DataConfig entryDataConfig = new DataConfig();
        entryDataConfig.setCompressed(cfg.isBackendEntriesCompressed());
        this.id2entry.setDataConfig(entryDataConfig);
        this.config = cfg;
        this.deadlockRetryLimit = this.config.getBackendDeadlockRetryLimit();
        this.subtreeDeleteSizeLimit = this.config.getBackendSubtreeDeleteSizeLimit();
        this.subtreeDeleteBatchSize = this.config.getBackendSubtreeDeleteBatchSize();
        this.indexEntryLimit = this.config.getBackendIndexEntryLimit();
        return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
    }

    public EnvironmentConfig getEnvironmentConfig() throws DatabaseException {
        return this.env.getConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long clear() throws DatabaseException {
        long count;
        block10: {
            ArrayList<DatabaseContainer> databases = new ArrayList<DatabaseContainer>();
            this.listDatabases(databases);
            count = 0L;
            for (DatabaseContainer db : databases) {
                db.close();
            }
            try {
                if (this.env.getConfig().getTransactional()) {
                    Transaction txn = this.beginTransaction();
                    try {
                        for (DatabaseContainer db : databases) {
                            count += this.env.truncateDatabase(txn, db.getName(), true);
                        }
                        EntryContainer.transactionCommit(txn);
                        break block10;
                    }
                    catch (DatabaseException de) {
                        EntryContainer.transactionAbort(txn);
                        throw de;
                    }
                }
                for (DatabaseContainer db : databases) {
                    count += this.env.truncateDatabase(null, db.getName(), true);
                }
            }
            finally {
                for (DatabaseContainer db : databases) {
                    db.open();
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long clearDatabase(DatabaseContainer database) throws DatabaseException {
        long count;
        block7: {
            count = 0L;
            database.close();
            try {
                if (this.env.getConfig().getTransactional()) {
                    Transaction txn = this.beginTransaction();
                    try {
                        count = this.env.truncateDatabase(txn, database.getName(), true);
                        EntryContainer.transactionCommit(txn);
                        break block7;
                    }
                    catch (DatabaseException de) {
                        EntryContainer.transactionAbort(txn);
                        throw de;
                    }
                }
                count = this.env.truncateDatabase(null, database.getName(), true);
            }
            finally {
                database.open();
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Cleared %d existing records from the database %s", count, database.getName());
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long clearAttributeIndex(AttributeIndex index) throws DatabaseException {
        long count;
        block17: {
            count = 0L;
            index.close();
            try {
                if (this.env.getConfig().getTransactional()) {
                    Transaction txn = this.beginTransaction();
                    try {
                        if (index.equalityIndex != null) {
                            count += this.env.truncateDatabase(txn, index.equalityIndex.getName(), true);
                        }
                        if (index.presenceIndex != null) {
                            count += this.env.truncateDatabase(txn, index.presenceIndex.getName(), true);
                        }
                        if (index.substringIndex != null) {
                            count += this.env.truncateDatabase(txn, index.substringIndex.getName(), true);
                        }
                        if (index.orderingIndex != null) {
                            count += this.env.truncateDatabase(txn, index.orderingIndex.getName(), true);
                        }
                        if (index.approximateIndex != null) {
                            count += this.env.truncateDatabase(txn, index.approximateIndex.getName(), true);
                        }
                        EntryContainer.transactionCommit(txn);
                        break block17;
                    }
                    catch (DatabaseException de) {
                        EntryContainer.transactionAbort(txn);
                        throw de;
                    }
                }
                if (index.equalityIndex != null) {
                    count += this.env.truncateDatabase(null, index.equalityIndex.getName(), true);
                }
                if (index.presenceIndex != null) {
                    count += this.env.truncateDatabase(null, index.presenceIndex.getName(), true);
                }
                if (index.substringIndex != null) {
                    count += this.env.truncateDatabase(null, index.substringIndex.getName(), true);
                }
                if (index.orderingIndex != null) {
                    count += this.env.truncateDatabase(null, index.orderingIndex.getName(), true);
                }
                if (index.approximateIndex != null) {
                    count += this.env.truncateDatabase(null, index.approximateIndex.getName(), true);
                }
            }
            finally {
                index.open();
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Cleared %d existing records from the index %s", count, index.getAttributeType().getNameOrOID());
        }
        return count;
    }

    private DN getMatchedDN(DN baseDN) throws DirectoryException {
        DN matchedDN = null;
        for (DN parentDN = baseDN.getParentDNInSuffix(); parentDN != null && parentDN.isDescendantOf(this.getBaseDN()); parentDN = parentDN.getParentDNInSuffix()) {
            if (!this.entryExists(parentDN)) continue;
            matchedDN = parentDN;
            break;
        }
        return matchedDN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyReverseComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] a, byte[] b) {
            int ai = a.length - 1;
            for (int bi = b.length - 1; ai >= 0 && bi >= 0; --ai, --bi) {
                if (a[ai] > b[bi]) {
                    return 1;
                }
                if (a[ai] >= b[bi]) continue;
                return -1;
            }
            if (a.length == b.length) {
                return 0;
            }
            if (a.length > b.length) {
                return 1;
            }
            return -1;
        }
    }

    private class RenameEntryTransaction
    implements TransactedOperation {
        private DN oldApexDN;
        private DN oldSuperiorDN;
        private DN newSuperiorDN;
        private Entry newApexEntry;
        private ModifyDNOperation modifyDNOperation;
        private BufferedIndex id2cBuffered;
        private BufferedIndex id2sBuffered;

        public RenameEntryTransaction(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) {
            this.oldApexDN = currentDN;
            this.oldSuperiorDN = EntryContainer.this.getParentWithinBase(currentDN);
            this.newSuperiorDN = EntryContainer.this.getParentWithinBase(entry.getDN());
            this.newApexEntry = entry;
            this.modifyDNOperation = modifyDNOperation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeOperation(Transaction txn) throws DatabaseException, DirectoryException, JebException {
            DN requestedNewSuperiorDN = null;
            if (this.modifyDNOperation != null) {
                requestedNewSuperiorDN = this.modifyDNOperation.getNewSuperior();
            }
            if (EntryContainer.this.dn2id.get(txn, this.newApexEntry.getDN()) != null) {
                int msgID = 8585269;
                String message = MessageHandler.getMessage(msgID, this.newApexEntry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            EntryID oldApexID = EntryContainer.this.dn2id.get(txn, this.oldApexDN);
            if (oldApexID == null) {
                EntryContainer.this.dn2uri.targetEntryReferrals(this.oldApexDN, null);
                int messageID = 8585266;
                String message = MessageHandler.getMessage(messageID, this.oldApexDN.toString());
                DN matchedDN = EntryContainer.this.getMatchedDN(EntryContainer.this.baseDN);
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, messageID, matchedDN, null);
            }
            Entry oldApexEntry = EntryContainer.this.id2entry.get(txn, oldApexID);
            if (oldApexEntry == null) {
                int msgID = 8650763;
                String msg = MessageHandler.getMessage(msgID, oldApexID.toString());
                throw new JebException(msgID, msg);
            }
            if (!EntryContainer.isManageDsaITOperation(this.modifyDNOperation)) {
                EntryContainer.this.dn2uri.checkTargetForReferral(oldApexEntry, null);
            }
            this.id2cBuffered = new BufferedIndex(EntryContainer.this.id2children, txn);
            this.id2sBuffered = new BufferedIndex(EntryContainer.this.id2subtree, txn);
            EntryID newApexID = oldApexID;
            if (this.newSuperiorDN != null) {
                EntryID newSuperiorID = EntryContainer.this.dn2id.get(txn, this.newSuperiorDN);
                if (newSuperiorID == null) {
                    int msgID = 8585270;
                    String msg = MessageHandler.getMessage(msgID, this.newSuperiorDN.toString());
                    DN matchedDN = EntryContainer.this.getMatchedDN(EntryContainer.this.baseDN);
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, msg, msgID, matchedDN, null);
                }
                if (newSuperiorID.compareTo(oldApexID) > 0) {
                    newApexID = EntryContainer.this.rootContainer.getNextEntryID();
                }
            }
            if (requestedNewSuperiorDN != null) {
                this.moveApexEntry(txn, oldApexID, newApexID, oldApexEntry, this.newApexEntry);
            } else {
                this.renameApexEntry(txn, oldApexID, oldApexEntry, this.newApexEntry);
            }
            byte[] suffix = StaticUtils.getBytes("," + this.oldApexDN.toNormalizedString());
            byte[] end = (byte[])suffix.clone();
            end[0] = (byte)(end[0] + 1);
            byte[] begin = suffix;
            DatabaseEntry data = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry(begin);
            Cursor cursor = EntryContainer.this.dn2id.openCursor(txn, null);
            try {
                OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.RMW);
                while (status == OperationStatus.SUCCESS && EntryContainer.this.dn2id.getComparator().compare(key.getData(), begin) <= 0) {
                    status = cursor.getNext(key, data, LockMode.RMW);
                }
                while (status == OperationStatus.SUCCESS) {
                    int cmp = EntryContainer.this.dn2id.getComparator().compare(key.getData(), end);
                    if (cmp >= 0) {
                        break;
                    }
                    EntryID oldID = new EntryID(data);
                    Entry oldEntry = EntryContainer.this.id2entry.get(txn, oldID);
                    DN newDN = EntryContainer.modDN(oldEntry.getDN(), this.oldApexDN.getNumComponents(), this.newApexEntry.getDN());
                    if (requestedNewSuperiorDN != null) {
                        EntryID newID = oldID;
                        if (!newApexID.equals(oldApexID)) {
                            newID = EntryContainer.this.rootContainer.getNextEntryID();
                        }
                        this.moveSubordinateEntry(txn, oldID, newID, oldEntry, newDN);
                    } else {
                        this.renameSubordinateEntry(txn, oldID, oldEntry, newDN);
                    }
                    status = cursor.getNext(key, data, LockMode.RMW);
                }
            }
            finally {
                cursor.close();
            }
            this.id2cBuffered.flush();
            this.id2sBuffered.flush();
        }

        public Transaction beginOperationTransaction() throws DatabaseException {
            return EntryContainer.this.beginTransaction();
        }

        private void moveApexEntry(Transaction txn, EntryID oldID, EntryID newID, Entry oldEntry, Entry newEntry) throws JebException, DirectoryException, DatabaseException {
            EntryCache entryCache;
            EntryID nodeID;
            DN oldDN = oldEntry.getDN();
            DN newDN = newEntry.getDN();
            DN newParentDN = EntryContainer.this.getParentWithinBase(newDN);
            EntryContainer.this.dn2id.remove(txn, oldDN);
            if (!EntryContainer.this.dn2id.insert(txn, newDN, newID)) {
                int msgID = 8585269;
                String message = MessageHandler.getMessage(msgID, newDN.toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            EntryContainer.this.dn2uri.replaceEntry(txn, oldEntry, newEntry);
            if (!newID.equals(oldID) || this.modifyDNOperation == null) {
                EntryContainer.this.id2entry.remove(txn, oldID);
                EntryContainer.this.indexRemoveEntry(txn, oldEntry, oldID);
                EntryContainer.this.indexInsertEntry(txn, newEntry, newID);
            } else {
                EntryContainer.this.indexModifications(txn, oldEntry, newEntry, oldID, this.modifyDNOperation.getModifications());
            }
            EntryContainer.this.id2entry.put(txn, newID, newEntry);
            DN oldParentDN = EntryContainer.this.getParentWithinBase(oldDN);
            if (oldParentDN != null) {
                EntryID currentParentID = EntryContainer.this.dn2id.get(txn, oldParentDN);
                this.id2cBuffered.removeID(currentParentID.getDatabaseEntry().getData(), oldID);
            }
            if (newParentDN != null) {
                EntryID parentID = EntryContainer.this.dn2id.get(txn, newParentDN);
                this.id2cBuffered.insertID(EntryContainer.this.indexEntryLimit, parentID.getDatabaseEntry().getData(), newID);
            }
            DN dn = EntryContainer.this.getParentWithinBase(oldDN);
            while (dn != null) {
                nodeID = EntryContainer.this.dn2id.get(txn, dn);
                this.id2sBuffered.removeID(nodeID.getDatabaseEntry().getData(), oldID);
                dn = EntryContainer.this.getParentWithinBase(dn);
            }
            dn = newParentDN;
            while (dn != null) {
                nodeID = EntryContainer.this.dn2id.get(txn, dn);
                this.id2sBuffered.insertID(EntryContainer.this.indexEntryLimit, nodeID.getDatabaseEntry().getData(), newID);
                dn = EntryContainer.this.getParentWithinBase(dn);
            }
            if (!newID.equals(oldID)) {
                this.id2cBuffered.remove(oldID.getDatabaseEntry().getData());
                this.id2sBuffered.remove(oldID.getDatabaseEntry().getData());
            }
            if ((entryCache = DirectoryServer.getEntryCache()) != null) {
                entryCache.removeEntry(oldDN);
            }
        }

        private void renameApexEntry(Transaction txn, EntryID entryID, Entry oldEntry, Entry newEntry) throws DirectoryException, DatabaseException, JebException {
            DN oldDN = oldEntry.getDN();
            DN newDN = newEntry.getDN();
            EntryContainer.this.dn2id.remove(txn, oldDN);
            if (!EntryContainer.this.dn2id.insert(txn, newDN, entryID)) {
                int msgID = 8585269;
                String message = MessageHandler.getMessage(msgID, newDN.toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            EntryContainer.this.dn2uri.replaceEntry(txn, oldEntry, newEntry);
            EntryContainer.this.id2entry.put(txn, entryID, newEntry);
            if (this.modifyDNOperation == null) {
                EntryContainer.this.indexRemoveEntry(txn, oldEntry, entryID);
                EntryContainer.this.indexInsertEntry(txn, newEntry, entryID);
            } else {
                EntryContainer.this.indexModifications(txn, oldEntry, newEntry, entryID, this.modifyDNOperation.getModifications());
            }
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.removeEntry(oldDN);
            }
        }

        private void moveSubordinateEntry(Transaction txn, EntryID oldID, EntryID newID, Entry oldEntry, DN newDN) throws JebException, DirectoryException, DatabaseException {
            EntryID nodeID;
            DN oldDN = oldEntry.getDN();
            DN newParentDN = EntryContainer.this.getParentWithinBase(newDN);
            EntryContainer.this.dn2id.remove(txn, oldDN);
            if (!EntryContainer.this.dn2id.insert(txn, newDN, newID)) {
                int msgID = 8585269;
                String message = MessageHandler.getMessage(msgID, newDN.toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            EntryContainer.this.dn2uri.deleteEntry(txn, oldEntry);
            if (!newID.equals(oldID)) {
                EntryContainer.this.id2entry.remove(txn, oldID);
                for (AttributeIndex index : EntryContainer.this.attrIndexMap.values()) {
                    index.removeEntry(txn, oldID, oldEntry);
                    index.addEntry(txn, newID, oldEntry);
                }
            }
            oldEntry.setDN(newDN);
            EntryContainer.this.dn2uri.addEntry(txn, oldEntry);
            EntryContainer.this.id2entry.put(txn, newID, oldEntry);
            if (!newID.equals(oldID)) {
                this.id2cBuffered.remove(oldID.getDatabaseEntry().getData());
                this.id2sBuffered.remove(oldID.getDatabaseEntry().getData());
                if (newParentDN != null) {
                    EntryID parentID = EntryContainer.this.dn2id.get(txn, newParentDN);
                    this.id2cBuffered.insertID(EntryContainer.this.indexEntryLimit, parentID.getDatabaseEntry().getData(), newID);
                }
            }
            DN dn = this.oldSuperiorDN;
            while (dn != null) {
                nodeID = EntryContainer.this.dn2id.get(txn, dn);
                this.id2sBuffered.removeID(nodeID.getDatabaseEntry().getData(), oldID);
                dn = EntryContainer.this.getParentWithinBase(dn);
            }
            dn = newParentDN;
            while (dn != null) {
                if (!newID.equals(oldID) || dn.isAncestorOf(this.newSuperiorDN)) {
                    nodeID = EntryContainer.this.dn2id.get(txn, dn);
                    this.id2sBuffered.insertID(EntryContainer.this.indexEntryLimit, nodeID.getDatabaseEntry().getData(), newID);
                }
                dn = EntryContainer.this.getParentWithinBase(dn);
            }
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.removeEntry(oldDN);
            }
        }

        private void renameSubordinateEntry(Transaction txn, EntryID entryID, Entry oldEntry, DN newDN) throws DirectoryException, DatabaseException {
            DN oldDN = oldEntry.getDN();
            EntryContainer.this.dn2id.remove(txn, oldDN);
            if (!EntryContainer.this.dn2id.insert(txn, newDN, entryID)) {
                int msgID = 8585269;
                String message = MessageHandler.getMessage(msgID, newDN.toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            EntryContainer.this.dn2uri.deleteEntry(txn, oldEntry);
            oldEntry.setDN(newDN);
            EntryContainer.this.dn2uri.addEntry(txn, oldEntry);
            EntryContainer.this.id2entry.put(txn, entryID, oldEntry);
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.removeEntry(oldDN);
            }
        }

        public void postCommitAction() {
        }
    }

    private class ReplaceEntryTransaction
    implements TransactedOperation {
        private Entry entry;
        private ModifyOperation modifyOperation;
        private EntryID entryID = null;

        public ReplaceEntryTransaction(Entry entry, ModifyOperation modifyOperation) {
            this.entry = entry;
            this.modifyOperation = modifyOperation;
        }

        public Transaction beginOperationTransaction() throws DatabaseException {
            return EntryContainer.this.beginTransaction();
        }

        public void invokeOperation(Transaction txn) throws DatabaseException, DirectoryException, JebException {
            List<Modification> mods;
            this.entryID = EntryContainer.this.dn2id.get(txn, this.entry.getDN());
            if (this.entryID == null) {
                int msgID = 8585265;
                String message = MessageHandler.getMessage(msgID, this.entry.getDN().toString());
                DN matchedDN = EntryContainer.this.getMatchedDN(EntryContainer.this.baseDN);
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, matchedDN, null);
            }
            Entry originalEntry = EntryContainer.this.id2entry.get(txn, this.entryID);
            if (originalEntry == null) {
                int msgID = 8650763;
                String msg = MessageHandler.getMessage(msgID, this.entryID.toString());
                throw new JebException(msgID, msg);
            }
            if (!EntryContainer.isManageDsaITOperation(this.modifyOperation)) {
                EntryContainer.this.dn2uri.checkTargetForReferral(originalEntry, null);
            }
            if (this.modifyOperation != null) {
                mods = this.modifyOperation.getModifications();
                EntryContainer.this.dn2uri.modifyEntry(txn, originalEntry, this.entry, mods);
            } else {
                EntryContainer.this.dn2uri.replaceEntry(txn, originalEntry, this.entry);
            }
            EntryContainer.this.id2entry.put(txn, this.entryID, this.entry);
            if (this.modifyOperation != null) {
                mods = this.modifyOperation.getModifications();
                EntryContainer.this.indexModifications(txn, originalEntry, this.entry, this.entryID, mods);
            } else {
                EntryContainer.this.indexRemoveEntry(txn, originalEntry, this.entryID);
                EntryContainer.this.indexInsertEntry(txn, this.entry, this.entryID);
            }
        }

        public void postCommitAction() {
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.putEntry(this.entry, EntryContainer.this.backend, this.entryID.longValue());
            }
        }
    }

    private class GetEntryByIDOperation
    implements TransactedOperation {
        private Entry entry = null;
        private EntryID entryID;

        public GetEntryByIDOperation(EntryID entryID) {
            this.entryID = entryID;
        }

        public Entry getEntry() {
            return this.entry;
        }

        public EntryID getEntryID() {
            return this.entryID;
        }

        public Transaction beginOperationTransaction() throws DatabaseException {
            return null;
        }

        public void invokeOperation(Transaction txn) throws DatabaseException, DirectoryException, JebException {
            this.entry = EntryContainer.this.id2entry.get(txn, this.entryID);
        }

        public void postCommitAction() {
        }
    }

    private class GetEntryByDNOperation
    implements TransactedOperation {
        private Entry entry = null;
        private EntryID entryID = null;
        DN entryDN;

        public GetEntryByDNOperation(DN entryDN) {
            this.entryDN = entryDN;
        }

        public Entry getEntry() {
            return this.entry;
        }

        public EntryID getEntryID() {
            return this.entryID;
        }

        public Transaction beginOperationTransaction() throws DatabaseException {
            return null;
        }

        public void invokeOperation(Transaction txn) throws DatabaseException, DirectoryException, JebException {
            this.entryID = EntryContainer.this.dn2id.get(txn, this.entryDN);
            if (this.entryID == null) {
                EntryContainer.this.dn2uri.targetEntryReferrals(this.entryDN, null);
                return;
            }
            this.entry = EntryContainer.this.id2entry.get(txn, this.entryID);
            if (this.entry == null) {
                int msgID = 8650763;
                String msg = MessageHandler.getMessage(msgID, this.entryID.toString());
                throw new JebException(msgID, msg);
            }
        }

        public void postCommitAction() {
        }
    }

    private class DeleteEntryTransaction
    implements TransactedOperation {
        private DN entryDN;
        private DeleteOperation deleteOperation;
        private ArrayList<DN> deletedDNList;
        private boolean adminSizeLimitExceeded = false;
        private boolean batchSizeExceeded = false;
        private int countDeletedDN;

        public DeleteEntryTransaction(DN entryDN, DeleteOperation deleteOperation) {
            this.entryDN = entryDN;
            this.deleteOperation = deleteOperation;
            this.deletedDNList = new ArrayList();
        }

        public boolean adminSizeLimitExceeded() {
            return this.adminSizeLimitExceeded;
        }

        public boolean batchSizeExceeded() {
            return this.batchSizeExceeded;
        }

        public void resetBatchSize() {
            this.batchSizeExceeded = false;
            this.deletedDNList.clear();
        }

        public int getDeletedEntryCount() {
            return this.countDeletedDN;
        }

        public Transaction beginOperationTransaction() throws DatabaseException {
            return EntryContainer.this.beginTransaction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeOperation(Transaction txn) throws DatabaseException, DirectoryException, JebException {
            EntryContainer.this.dn2uri.targetEntryReferrals(this.entryDN, null);
            int adminSizeLimit = EntryContainer.this.subtreeDeleteSizeLimit;
            int deleteBatchSize = EntryContainer.this.subtreeDeleteBatchSize;
            boolean isSubtreeDelete = false;
            List<Control> controls = this.deleteOperation.getRequestControls();
            if (controls != null) {
                for (Control control : controls) {
                    if (!control.getOID().equals("1.2.840.113556.1.4.805")) continue;
                    isSubtreeDelete = true;
                }
            }
            byte[] suffix = StaticUtils.getBytes("," + this.entryDN.toNormalizedString());
            byte[] begin = (byte[])suffix.clone();
            begin[0] = (byte)(begin[0] + 1);
            byte[] end = suffix;
            DatabaseEntry data = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry(begin);
            BufferedIndex id2cBuffered = new BufferedIndex(EntryContainer.this.id2children, txn);
            BufferedIndex id2sBuffered = new BufferedIndex(EntryContainer.this.id2subtree, txn);
            Cursor cursor = EntryContainer.this.dn2id.openCursor(txn, null);
            try {
                OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                if (status == OperationStatus.NOTFOUND) {
                    status = cursor.getLast(key, data, LockMode.DEFAULT);
                }
                while (status == OperationStatus.SUCCESS && EntryContainer.this.dn2id.getComparator().compare(key.getData(), begin) >= 0) {
                    status = cursor.getPrev(key, data, LockMode.DEFAULT);
                }
                while (status == OperationStatus.SUCCESS) {
                    int cmp = EntryContainer.this.dn2id.getComparator().compare(key.getData(), end);
                    if (cmp < 0) {
                        break;
                    }
                    if (!isSubtreeDelete) {
                        int msgID = 8585268;
                        String message = MessageHandler.getMessage(msgID, this.entryDN.toString());
                        throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, message, msgID);
                    }
                    if (adminSizeLimit > 0 && this.countDeletedDN >= adminSizeLimit) {
                        this.adminSizeLimitExceeded = true;
                        break;
                    }
                    if (deleteBatchSize > 0 && this.deletedDNList.size() >= deleteBatchSize) {
                        this.batchSizeExceeded = true;
                        break;
                    }
                    EntryID entryID = new EntryID(data);
                    DN subordinateDN = DN.decode(new ASN1OctetString(key.getData()));
                    EntryContainer.this.deleteLeaf(id2cBuffered, id2sBuffered, txn, subordinateDN, entryID);
                    this.deletedDNList.add(subordinateDN);
                    ++this.countDeletedDN;
                    status = cursor.getPrev(key, data, LockMode.DEFAULT);
                }
            }
            finally {
                cursor.close();
            }
            if (!this.adminSizeLimitExceeded && !this.batchSizeExceeded) {
                if (adminSizeLimit > 0 && this.countDeletedDN >= adminSizeLimit) {
                    this.adminSizeLimitExceeded = true;
                } else if (deleteBatchSize > 0 && this.deletedDNList.size() >= deleteBatchSize) {
                    this.batchSizeExceeded = true;
                } else {
                    boolean manageDsaIT = isSubtreeDelete ? true : EntryContainer.isManageDsaITOperation(this.deleteOperation);
                    EntryContainer.this.deleteTarget(manageDsaIT, id2cBuffered, id2sBuffered, txn, this.entryDN);
                    this.deletedDNList.add(this.entryDN);
                    ++this.countDeletedDN;
                }
            }
            id2cBuffered.flush();
            id2sBuffered.flush();
        }

        public void postCommitAction() {
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                for (DN dn : this.deletedDNList) {
                    entryCache.removeEntry(dn);
                }
            }
        }
    }

    private class AddEntryTransaction
    implements TransactedOperation {
        private Entry entry;
        DN parentDN;
        EntryID entryID = null;

        public Transaction beginOperationTransaction() throws DatabaseException {
            return EntryContainer.this.beginTransaction();
        }

        public AddEntryTransaction(Entry entry) {
            this.entry = entry;
            this.parentDN = EntryContainer.this.getParentWithinBase(entry.getDN());
        }

        public void invokeOperation(Transaction txn) throws DatabaseException, DirectoryException, JebException {
            if (EntryContainer.this.dn2id.get(txn, this.entry.getDN()) != null) {
                int msgID = 0x830033;
                String message = MessageHandler.getMessage(msgID, this.entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            EntryID parentID = null;
            if (this.parentDN != null) {
                EntryContainer.this.dn2uri.targetEntryReferrals(this.entry.getDN(), null);
                parentID = EntryContainer.this.dn2id.get(txn, this.parentDN);
                if (parentID == null) {
                    int msgID = 8585263;
                    String message = MessageHandler.getMessage(msgID, this.entry.getDN().toString());
                    DN matchedDN = EntryContainer.this.getMatchedDN(EntryContainer.this.baseDN);
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, matchedDN, null);
                }
            }
            if (this.entryID == null) {
                this.entryID = EntryContainer.this.rootContainer.getNextEntryID();
            }
            if (!EntryContainer.this.dn2id.insert(txn, this.entry.getDN(), this.entryID)) {
                int msgID = 0x830033;
                String message = MessageHandler.getMessage(msgID, this.entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            if (!EntryContainer.this.dn2uri.addEntry(txn, this.entry)) {
                int msgID = 0x830033;
                String message = MessageHandler.getMessage(msgID, this.entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            if (!EntryContainer.this.id2entry.insert(txn, this.entryID, this.entry)) {
                int msgID = 0x830033;
                String message = MessageHandler.getMessage(msgID, this.entry.getDN().toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message, msgID);
            }
            EntryContainer.this.indexInsertEntry(txn, this.entry, this.entryID);
            if (this.parentDN != null) {
                EntryContainer.this.id2children.insertID(txn, parentID.getDatabaseEntry(), this.entryID);
                EntryContainer.this.id2subtree.insertID(txn, parentID.getDatabaseEntry(), this.entryID);
                DN dn = EntryContainer.this.getParentWithinBase(this.parentDN);
                while (dn != null) {
                    EntryID nodeID = EntryContainer.this.dn2id.get(txn, dn);
                    if (nodeID == null) {
                        int msgID = 8650762;
                        String msg = MessageHandler.getMessage(msgID, dn.toNormalizedString());
                        throw new JebException(msgID, msg);
                    }
                    EntryContainer.this.id2subtree.insertID(txn, nodeID.getDatabaseEntry(), this.entryID);
                    dn = EntryContainer.this.getParentWithinBase(dn);
                }
            }
        }

        public void postCommitAction() {
            EntryCache entryCache = DirectoryServer.getEntryCache();
            if (entryCache != null) {
                entryCache.putEntry(this.entry, EntryContainer.this.backend, this.entryID.longValue());
            }
        }
    }

    private static interface TransactedOperation {
        public Transaction beginOperationTransaction() throws DatabaseException;

        public void invokeOperation(Transaction var1) throws DatabaseException, DirectoryException, JebException;

        public void postCommitAction();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VLVJEIndexCfgManager
    implements ConfigurationAddListener<VLVJEIndexCfg>,
    ConfigurationDeleteListener<VLVJEIndexCfg> {
        @Override
        public boolean isConfigurationAddAcceptable(VLVJEIndexCfg cfg, List<String> unacceptableReasons) {
            return true;
        }

        @Override
        public ConfigChangeResult applyConfigurationAdd(VLVJEIndexCfg cfg) {
            boolean adminActionRequired = false;
            ArrayList<String> messages = new ArrayList<String>();
            try {
                VLVIndex vlvIndex = new VLVIndex(cfg, EntryContainer.this.state, EntryContainer.this.env, EntryContainer.this);
                vlvIndex.open();
                EntryContainer.this.vlvIndexMap.put(cfg.getVLVIndexName().toLowerCase(), vlvIndex);
            }
            catch (Exception e) {
                messages.add(StaticUtils.stackTraceToSingleLineString(e));
                ConfigChangeResult ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                return ccr;
            }
            adminActionRequired = true;
            int msgID = 8847510;
            messages.add(MessageHandler.getMessage(msgID, cfg.getVLVIndexName()));
            return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
        }

        @Override
        public boolean isConfigurationDeleteAcceptable(VLVJEIndexCfg cfg, List<String> unacceptableReasons) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConfigChangeResult applyConfigurationDelete(VLVJEIndexCfg cfg) {
            boolean adminActionRequired = false;
            ArrayList<String> messages = new ArrayList<String>();
            EntryContainer.this.exclusiveLock.lock();
            try {
                VLVIndex vlvIndex = (VLVIndex)EntryContainer.this.vlvIndexMap.get(cfg.getVLVIndexName().toLowerCase());
                vlvIndex.close();
                EntryContainer.this.deleteDatabase(vlvIndex);
                EntryContainer.this.vlvIndexMap.remove(cfg.getVLVIndexName());
            }
            catch (DatabaseException de) {
                ConfigChangeResult ccr;
                messages.add(StaticUtils.stackTraceToSingleLineString(de));
                ConfigChangeResult configChangeResult = ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                return configChangeResult;
            }
            finally {
                EntryContainer.this.exclusiveLock.unlock();
            }
            return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeJEIndexCfgManager
    implements ConfigurationAddListener<JEIndexCfg>,
    ConfigurationDeleteListener<JEIndexCfg> {
        @Override
        public boolean isConfigurationAddAcceptable(JEIndexCfg cfg, List<String> unacceptableReasons) {
            return true;
        }

        @Override
        public ConfigChangeResult applyConfigurationAdd(JEIndexCfg cfg) {
            boolean adminActionRequired = false;
            ArrayList<String> messages = new ArrayList<String>();
            try {
                AttributeIndex index = new AttributeIndex(cfg, EntryContainer.this.state, EntryContainer.this.env, EntryContainer.this);
                index.open();
                EntryContainer.this.attrIndexMap.put(cfg.getIndexAttribute(), index);
            }
            catch (Exception e) {
                messages.add(StaticUtils.stackTraceToSingleLineString(e));
                ConfigChangeResult ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                return ccr;
            }
            adminActionRequired = true;
            int msgID = 8847510;
            messages.add(MessageHandler.getMessage(msgID, cfg.getIndexAttribute().getNameOrOID()));
            return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
        }

        @Override
        public synchronized boolean isConfigurationDeleteAcceptable(JEIndexCfg cfg, List<String> unacceptableReasons) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConfigChangeResult applyConfigurationDelete(JEIndexCfg cfg) {
            boolean adminActionRequired = false;
            ArrayList<String> messages = new ArrayList<String>();
            EntryContainer.this.exclusiveLock.lock();
            try {
                AttributeIndex index = (AttributeIndex)EntryContainer.this.attrIndexMap.get(cfg.getIndexAttribute());
                EntryContainer.this.deleteAttributeIndex(index);
                EntryContainer.this.attrIndexMap.remove(cfg.getIndexAttribute());
            }
            catch (DatabaseException de) {
                ConfigChangeResult ccr;
                messages.add(StaticUtils.stackTraceToSingleLineString(de));
                ConfigChangeResult configChangeResult = ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), adminActionRequired, messages);
                return configChangeResult;
            }
            finally {
                EntryContainer.this.exclusiveLock.unlock();
            }
            return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
        }
    }
}

