/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.util.LDIFException;
import org.opends.server.util.StaticUtils;

public class ExportJob {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private LDIFExportConfig exportConfig;
    private long progressInterval = 10000L;
    private long exportedCount = 0L;
    private long skippedCount = 0L;

    public ExportJob(LDIFExportConfig exportConfig) {
        this.exportConfig = exportConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLDIF(RootContainer rootContainer) throws IOException, LDIFException, DatabaseException, JebException {
        List<DN> includeBranches = this.exportConfig.getIncludeBranches();
        ArrayList<EntryContainer> exportContainers = new ArrayList<EntryContainer>();
        for (EntryContainer entryContainer : rootContainer.getEntryContainers()) {
            DN baseDN = entryContainer.getBaseDN();
            if (includeBranches == null || includeBranches.isEmpty()) {
                exportContainers.add(entryContainer);
                continue;
            }
            for (DN includeBranch : includeBranches) {
                if (!includeBranch.isDescendantOf(baseDN) && !includeBranch.isAncestorOf(baseDN)) continue;
                exportContainers.add(entryContainer);
            }
        }
        long startTime = System.currentTimeMillis();
        Timer timer = new Timer();
        ProgressTask progressTask = new ProgressTask();
        timer.scheduleAtFixedRate((TimerTask)progressTask, this.progressInterval, this.progressInterval);
        try {
            for (EntryContainer exportContainer : exportContainers) {
                exportContainer.sharedLock.lock();
                try {
                    this.exportContainer(exportContainer);
                }
                finally {
                    exportContainer.sharedLock.unlock();
                }
            }
        }
        finally {
            timer.cancel();
        }
        long finishTime = System.currentTimeMillis();
        long totalTime = finishTime - startTime;
        float rate = 0.0f;
        if (totalTime > 0L) {
            rate = 1000.0f * (float)this.exportedCount / (float)totalTime;
        }
        int msgID = 8388695;
        String message = MessageHandler.getMessage(msgID, this.exportedCount, this.skippedCount, totalTime / 1000L, Float.valueOf(rate));
        ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportContainer(EntryContainer entryContainer) throws DatabaseException, IOException, LDIFException {
        ID2Entry id2entry = entryContainer.getID2Entry();
        Cursor cursor = id2entry.openCursor(null, new CursorConfig());
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = cursor.getFirst(key, data, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                block13: {
                    EntryID entryID = null;
                    try {
                        entryID = new EntryID(key);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            TRACER.debugError("Malformed id2entry ID %s.%n", StaticUtils.bytesToHex(key.getData()));
                        }
                        ++this.skippedCount;
                        break block13;
                    }
                    if (entryID.longValue() != 0L) {
                        Entry entry = null;
                        try {
                            entry = JebFormat.entryFromDatabase(data.getData());
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                TRACER.debugError("Malformed id2entry record for ID %d:%n%s%n", entryID.longValue(), StaticUtils.bytesToHex(data.getData()));
                            }
                            ++this.skippedCount;
                            break block13;
                        }
                        if (entry.toLDIF(this.exportConfig)) {
                            ++this.exportedCount;
                        } else {
                            ++this.skippedCount;
                        }
                    }
                }
                status = cursor.getNext(key, data, LockMode.DEFAULT);
            }
        }
        finally {
            cursor.close();
        }
    }

    class ProgressTask
    extends TimerTask {
        private long previousCount = 0L;
        private long previousTime = System.currentTimeMillis();

        public void run() {
            long latestCount = ExportJob.this.exportedCount;
            long deltaCount = latestCount - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
            int msgID = 0x800058;
            String message = MessageHandler.getMessage(msgID, latestCount, ExportJob.this.skippedCount, Float.valueOf(rate));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
            this.previousCount = latestCount;
            this.previousTime = latestTime;
        }
    }
}

