/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.server.admin.std.server.JEBackendCfg;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.util.LDIFReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportContext {
    private DN baseDN;
    private List<DN> includeBranches;
    private List<DN> excludeBranches;
    private JEBackendCfg config;
    private LDIFImportConfig ldifImportConfig;
    private LDIFReader ldifReader;
    private EntryContainer entryContainer;
    private EntryContainer srcEntryContainer;
    private long bufferSize;
    private BlockingQueue<Entry> queue;
    private AtomicLong entryInsertCount = new AtomicLong(0L);
    private DN parentDN;
    private ArrayList<EntryID> IDs;

    public BlockingQueue<Entry> getQueue() {
        return this.queue;
    }

    public void setQueue(BlockingQueue<Entry> queue) {
        this.queue = queue;
    }

    public void setBaseDN(DN baseDN) {
        this.baseDN = baseDN;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public void setConfig(JEBackendCfg config) {
        this.config = config;
    }

    public JEBackendCfg getConfig() {
        return this.config;
    }

    public void setLDIFImportConfig(LDIFImportConfig ldifImportConfig) {
        this.ldifImportConfig = ldifImportConfig;
    }

    public LDIFImportConfig getLDIFImportConfig() {
        return this.ldifImportConfig;
    }

    public void setLDIFReader(LDIFReader ldifReader) {
        this.ldifReader = ldifReader;
    }

    public LDIFReader getLDIFReader() {
        return this.ldifReader;
    }

    public void setEntryContainer(EntryContainer entryContainer) {
        this.entryContainer = entryContainer;
    }

    public EntryContainer getEntryContainer() {
        return this.entryContainer;
    }

    public void setSrcEntryContainer(EntryContainer srcEntryContainer) {
        this.srcEntryContainer = srcEntryContainer;
    }

    public EntryContainer getSrcEntryContainer() {
        return this.srcEntryContainer;
    }

    public long getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(long bufferSize) {
        this.bufferSize = bufferSize;
    }

    public long getEntryInsertCount() {
        return this.entryInsertCount.get();
    }

    public void incrEntryInsertCount(long delta) {
        this.entryInsertCount.getAndAdd(delta);
    }

    public DN getParentDN() {
        return this.parentDN;
    }

    public void setParentDN(DN parentDN) {
        this.parentDN = parentDN;
    }

    public ArrayList<EntryID> getIDs() {
        return this.IDs;
    }

    public void setIDs(ArrayList<EntryID> IDs) {
        this.IDs = IDs;
    }

    public List<DN> getExcludeBranches() {
        return this.excludeBranches;
    }

    public void setExcludeBranches(List<DN> excludeBranches) {
        this.excludeBranches = excludeBranches == null ? new ArrayList<DN>(0) : excludeBranches;
    }

    public List<DN> getIncludeBranches() {
        return this.includeBranches;
    }

    public void setIncludeBranches(List<DN> includeBranches) {
        this.includeBranches = includeBranches == null ? new ArrayList<DN>(0) : includeBranches;
    }
}

