/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.opends.server.admin.std.server.JEBackendCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.backends.jeb.Longs;
import org.opends.server.backends.jeb.MergeReader;
import org.opends.server.backends.jeb.MergeValue;
import org.opends.server.backends.jeb.OctetStringKeyComparator;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexMergeThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int INPUT_STREAM_BUFFER_SIZE = 65536;
    JEBackendCfg config;
    LDIFImportConfig ldifImportConfig;
    Indexer indexer;
    Index index;
    int entryLimit;
    String indexName;
    private boolean replaceExisting = false;
    private WeakHashMap<Integer, LinkedList<byte[]>> arrayMap = new WeakHashMap();
    private FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File d, String name) {
            return name.startsWith(IndexMergeThread.this.index.getName());
        }
    };

    IndexMergeThread(JEBackendCfg config, LDIFImportConfig ldifImportConfig, Index index, int entryLimit) {
        super("Index Merge Thread " + index.getName());
        this.config = config;
        this.ldifImportConfig = ldifImportConfig;
        this.indexer = index.indexer;
        this.index = index;
        this.entryLimit = entryLimit;
        this.replaceExisting = ldifImportConfig.appendToExistingData() && ldifImportConfig.replaceExistingEntries();
    }

    @Override
    public void run() {
        block2: {
            try {
                this.merge();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public void merge() throws Exception {
        OctetStringKeyComparator comparator = new OctetStringKeyComparator(this.indexer.getComparator());
        TreeMap<ASN1OctetString, MergeValue> inputs = new TreeMap<ASN1OctetString, MergeValue>(comparator);
        File tempDir = StaticUtils.getFileForPath(this.config.getBackendImportTempDirectory());
        File[] files = tempDir.listFiles(this.filter);
        if (files == null || files.length == 0) {
            if (DebugLogger.debugEnabled()) {
                int msgID = 8388706;
                String message = MessageHandler.getMessage(msgID, this.index.getName());
                TRACER.debugInfo(message);
            }
            if (!this.ldifImportConfig.appendToExistingData()) {
                this.index.setTrusted(null, true);
            }
            return;
        }
        if (DebugLogger.debugEnabled()) {
            int msgID = 8388707;
            String message = MessageHandler.getMessage(msgID, files.length, this.index.getName());
            TRACER.debugInfo(message);
        }
        MergeReader[] readers = new MergeReader[files.length];
        Transaction txn = null;
        DatabaseEntry dbKey = new DatabaseEntry();
        DatabaseEntry dbData = new DatabaseEntry();
        byte[] mergedBytes = new byte[]{};
        Longs merged = new Longs();
        try {
            try {
                for (int i = 0; i < files.length; ++i) {
                    BufferedInputStream bufferedStream = new BufferedInputStream(new FileInputStream(files[i]), 65536);
                    DataInputStream dis = new DataInputStream(bufferedStream);
                    readers[i] = new MergeReader(dis);
                    this.readNext(inputs, readers, i);
                }
                try {
                    block7: while (true) {
                        MergeValue mv;
                        block36: {
                            List<Longs> delValues;
                            List<Longs> addValues;
                            byte[] keyBytes;
                            block35: {
                                ASN1OctetString lowest = inputs.firstKey();
                                mv = (MergeValue)inputs.remove(lowest);
                                keyBytes = mv.getKey();
                                dbKey.setData(keyBytes);
                                addValues = mv.getAddValues();
                                delValues = mv.getDelValues();
                                merged.clear();
                                if (!this.ldifImportConfig.appendToExistingData() || this.index.read(txn, dbKey, dbData, LockMode.RMW) != OperationStatus.SUCCESS) break block35;
                                if (dbData.getSize() == 0) break block36;
                                merged.decode(dbData.getData());
                            }
                            for (Longs l : addValues) {
                                merged.addAll(l);
                            }
                            if (this.replaceExisting) {
                                for (Longs l : delValues) {
                                    merged.deleteAll(l);
                                }
                            }
                            if (merged.size() > this.entryLimit) {
                                this.index.writeKey(txn, dbKey, new EntryIDSet());
                            } else {
                                mergedBytes = merged.encode(mergedBytes);
                                dbData.setData(mergedBytes);
                                dbData.setSize(merged.encodedSize());
                                this.index.put(txn, dbKey, dbData);
                            }
                            LinkedList<Object> arrayList = this.arrayMap.get(keyBytes.length);
                            if (arrayList == null) {
                                arrayList = new LinkedList();
                                this.arrayMap.put(keyBytes.length, arrayList);
                            }
                            arrayList.add(keyBytes);
                        }
                        int[] arr$ = mv.getReaders();
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (true) {
                            if (i$ >= len$) continue block7;
                            int r = arr$[i$];
                            this.readNext(inputs, readers, r);
                            ++i$;
                        }
                        break;
                    }
                }
                catch (NoSuchElementException e) {
                    if (!this.ldifImportConfig.appendToExistingData()) {
                        this.index.setTrusted(txn, true);
                    }
                    Object var21_28 = null;
                    if (readers != null) {
                        for (MergeReader r : readers) {
                            if (r == null) continue;
                            r.dataInputStream.close();
                        }
                    }
                    if (files != null) {
                        for (File f : files) {
                            f.delete();
                        }
                    }
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var21_29 = null;
            if (readers != null) {
                for (MergeReader r : readers) {
                    if (r == null) continue;
                    r.dataInputStream.close();
                }
            }
            if (files != null) {
                for (File f : files) {
                    f.delete();
                }
            }
            throw throwable;
        }
        if (DebugLogger.debugEnabled()) {
            int msgID = 8388708;
            String message = MessageHandler.getMessage(msgID, this.index.getName());
            TRACER.debugInfo(message);
        }
    }

    private void readNext(TreeMap<ASN1OctetString, MergeValue> inputs, MergeReader[] readers, int reader) throws IOException {
        ASN1OctetString mk;
        MergeValue mv;
        byte[] keyBytes;
        int len;
        MergeReader mergeReader = readers[reader];
        DataInputStream dataInputStream = mergeReader.dataInputStream;
        try {
            len = dataInputStream.readInt();
        }
        catch (EOFException e) {
            return;
        }
        LinkedList<Object> arrayList = this.arrayMap.get(len);
        if (arrayList == null) {
            keyBytes = new byte[len];
            arrayList = new LinkedList();
            this.arrayMap.put(len, arrayList);
        } else {
            keyBytes = arrayList.isEmpty() ? new byte[len] : arrayList.removeFirst();
        }
        dataInputStream.readFully(keyBytes);
        Longs addData = mergeReader.addData;
        addData.decode(dataInputStream);
        Longs delData = mergeReader.delData;
        if (this.replaceExisting) {
            delData.decode(dataInputStream);
        }
        if ((mv = inputs.get(mk = new ASN1OctetString(keyBytes))) == null) {
            mv = new MergeValue(readers.length, this.entryLimit);
            mv.setKey(keyBytes);
            inputs.put(mk, mv);
        } else {
            arrayList.add(keyBytes);
        }
        mv.mergeData(reader, addData, delData);
    }
}

