/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderingIndexer
extends Indexer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType attributeType;
    private OrderingMatchingRule orderingRule;

    public OrderingIndexer(AttributeType attributeType) {
        this.attributeType = attributeType;
        this.orderingRule = attributeType.getOrderingMatchingRule();
    }

    public String toString() {
        return this.attributeType.getNameOrOID() + ".ordering";
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return this.orderingRule;
    }

    @Override
    public void indexEntry(Transaction txn, Entry entry, Set<ASN1OctetString> keys) {
        List<Attribute> attrList = entry.getAttribute(this.attributeType);
        if (attrList != null) {
            this.indexAttribute(attrList, keys);
        }
    }

    @Override
    public void replaceEntry(Transaction txn, Entry oldEntry, Entry newEntry, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) {
        List<Attribute> attrList = oldEntry.getAttribute(this.attributeType);
        HashSet<ASN1OctetString> oldSet = new HashSet<ASN1OctetString>();
        this.indexAttribute(attrList, oldSet);
        attrList = newEntry.getAttribute(this.attributeType);
        HashSet<ASN1OctetString> newSet = new HashSet<ASN1OctetString>();
        this.indexAttribute(attrList, newSet);
        HashSet<ASN1OctetString> removeSet = new HashSet<ASN1OctetString>(oldSet);
        removeSet.removeAll(newSet);
        for (ASN1OctetString k : removeSet) {
            delKeys.add(k);
        }
        HashSet<ASN1OctetString> addSet = new HashSet<ASN1OctetString>(newSet);
        addSet.removeAll(oldSet);
        for (ASN1OctetString k : addSet) {
            addKeys.add(k);
        }
    }

    @Override
    public void modifyEntry(Transaction txn, Entry oldEntry, Entry newEntry, List<Modification> mods, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) throws DatabaseException {
        List<Attribute> beforeList = oldEntry.getAttribute(this.attributeType);
        block5: for (Modification mod : mods) {
            Attribute modAttr = mod.getAttribute();
            AttributeType modAttrType = modAttr.getAttributeType();
            if (!modAttrType.equals(this.attributeType)) continue;
            switch (mod.getModificationType()) {
                case REPLACE: 
                case INCREMENT: {
                    if (beforeList != null) {
                        for (Attribute attr : beforeList) {
                            if (!attr.hasOptions(modAttr.getOptions())) continue;
                            this.indexValues(attr.getValues(), delKeys);
                        }
                    }
                    this.indexValues(modAttr.getValues(), addKeys);
                    break;
                }
                case ADD: {
                    this.indexValues(modAttr.getValues(), addKeys);
                    break;
                }
                case DELETE: {
                    if (!modAttr.hasValue()) {
                        if (beforeList == null) break;
                        for (Attribute attr : beforeList) {
                            if (!attr.hasOptions(modAttr.getOptions())) continue;
                            this.indexValues(attr.getValues(), delKeys);
                        }
                        continue block5;
                    }
                    this.indexValues(modAttr.getValues(), delKeys);
                }
            }
        }
    }

    private void indexValues(Set<AttributeValue> values, Set<ASN1OctetString> keys) {
        if (values == null) {
            return;
        }
        for (AttributeValue value : values) {
            try {
                byte[] keyBytes = this.orderingRule.normalizeValue(value.getValue()).value();
                keys.add(new ASN1OctetString(keyBytes));
            }
            catch (DirectoryException e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private void indexAttribute(List<Attribute> attrList, Set<ASN1OctetString> keys) {
        if (attrList == null) {
            return;
        }
        for (Attribute attr : attrList) {
            this.indexValues(attr.getValues(), keys);
        }
    }
}

