/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceIndexer
extends Indexer {
    private static final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();
    private AttributeType attributeType;

    public PresenceIndexer(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public String toString() {
        return this.attributeType.getNameOrOID() + ".presence";
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return comparator;
    }

    @Override
    public void indexEntry(Transaction txn, Entry entry, Set<ASN1OctetString> keys) throws DatabaseException {
        List<Attribute> attrList = entry.getAttribute(this.attributeType);
        if (attrList != null && !attrList.isEmpty()) {
            keys.add(new ASN1OctetString(AttributeIndex.presenceKey.getData()));
        }
    }

    @Override
    public void replaceEntry(Transaction txn, Entry oldEntry, Entry newEntry, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) throws DatabaseException {
        List<Attribute> beforeList = oldEntry.getAttribute(this.attributeType);
        List<Attribute> afterList = newEntry.getAttribute(this.attributeType);
        if (beforeList == null || beforeList.isEmpty()) {
            if (afterList != null && !afterList.isEmpty()) {
                addKeys.add(new ASN1OctetString(AttributeIndex.presenceKey.getData()));
            }
        } else if (afterList == null || afterList.isEmpty()) {
            delKeys.add(new ASN1OctetString(AttributeIndex.presenceKey.getData()));
        }
    }

    @Override
    public void modifyEntry(Transaction txn, Entry oldEntry, Entry newEntry, List<Modification> mods, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) throws DatabaseException {
        this.replaceEntry(txn, oldEntry, newEntry, addKeys, delKeys);
    }
}

