/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Transaction;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opends.server.admin.std.server.JEBackendCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.SortValues;
import org.opends.server.backends.jeb.SortValuesSet;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.SortKey;
import org.opends.server.util.StaticUtils;

public class VLVIndexMergeThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int INPUT_STREAM_BUFFER_SIZE = 65536;
    JEBackendCfg config;
    LDIFImportConfig ldifImportConfig;
    VLVIndex vlvIndex;
    String indexName;
    private boolean replaceExisting = false;
    private List<DataInputStream> addDataStreams;
    private List<DataInputStream> delDataStreams;
    private HashMap<DataInputStream, SortValues> lastAddValues = new HashMap();
    private HashMap<DataInputStream, SortValues> lastDelValues = new HashMap();
    private FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File d, String name) {
            return name.startsWith(VLVIndexMergeThread.this.vlvIndex.getName());
        }
    };

    VLVIndexMergeThread(JEBackendCfg config, LDIFImportConfig ldifImportConfig, VLVIndex vlvIndex) {
        super("Index Merge Thread " + vlvIndex.getName());
        this.config = config;
        this.ldifImportConfig = ldifImportConfig;
        this.vlvIndex = vlvIndex;
        this.replaceExisting = ldifImportConfig.appendToExistingData() && ldifImportConfig.replaceExistingEntries();
        this.addDataStreams = new ArrayList<DataInputStream>();
        this.delDataStreams = new ArrayList<DataInputStream>();
        this.lastAddValues = new HashMap();
        this.lastDelValues = new HashMap();
    }

    public void run() {
        try {
            this.merge();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge() throws Exception {
        File tempDir = StaticUtils.getFileForPath(this.config.getBackendImportTempDirectory());
        File[] files = tempDir.listFiles(this.filter);
        if (files == null || files.length == 0) {
            int msgID = 8388706;
            String message = MessageHandler.getMessage(msgID, this.vlvIndex.getName());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
            return;
        }
        if (DebugLogger.debugEnabled()) {
            int msgID = 8388707;
            String message = MessageHandler.getMessage(msgID, files.length, this.vlvIndex.getName());
            TRACER.debugInfo(message);
        }
        Transaction txn = null;
        try {
            SortValues maxKey;
            for (int i = 0; i < files.length; ++i) {
                BufferedInputStream bufferedStream = new BufferedInputStream(new FileInputStream(files[i]), 65536);
                DataInputStream dis = new DataInputStream(bufferedStream);
                if (files[i].getName().endsWith("_add")) {
                    this.addDataStreams.add(dis);
                    continue;
                }
                if (!files[i].getName().endsWith("_del")) continue;
                this.delDataStreams.add(dis);
            }
            do {
                SortValuesSet currentSet = null;
                maxKey = null;
                SortValues addValue = this.readNextAdd(maxKey);
                if (this.replaceExisting) {
                    SortValues delValue = this.readNextDel(maxKey);
                    if (delValue != null && currentSet == null) {
                        currentSet = addValue == null || delValue.compareTo(addValue) < 0 ? this.vlvIndex.getSortValuesSet(txn, delValue.getEntryID(), delValue.getValues()) : this.vlvIndex.getSortValuesSet(txn, addValue.getEntryID(), addValue.getValues());
                        maxKey = currentSet.getKeySortValues();
                    }
                    while (delValue != null) {
                        currentSet.remove(delValue.getEntryID(), delValue.getValues());
                        delValue = this.readNextDel(maxKey);
                    }
                }
                if (addValue != null) {
                    if (currentSet == null) {
                        currentSet = this.vlvIndex.getSortValuesSet(txn, addValue.getEntryID(), addValue.getValues());
                        maxKey = currentSet.getKeySortValues();
                    }
                    while (addValue != null) {
                        currentSet.add(addValue.getEntryID(), addValue.getValues());
                        if (currentSet.size() > this.vlvIndex.getSortedSetCapacity()) {
                            SortValuesSet splitSortValuesSet = currentSet.split(currentSet.size() / 2);
                            SortValues newKey = currentSet.getKeySortValues();
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("SortValuesSet with key %s has reached the entry size of %d. Spliting into two sets with  keys %s and %s.", maxKey, currentSet.size(), newKey, maxKey);
                            }
                            if (addValue.compareTo(newKey) < 0) {
                                this.vlvIndex.putSortValuesSet(txn, splitSortValuesSet);
                                maxKey = newKey;
                            } else {
                                this.vlvIndex.putSortValuesSet(txn, currentSet);
                                currentSet = splitSortValuesSet;
                            }
                        }
                        addValue = this.readNextAdd(maxKey);
                    }
                }
                this.vlvIndex.putSortValuesSet(txn, currentSet);
            } while (maxKey != null);
            if (!this.ldifImportConfig.appendToExistingData()) {
                this.vlvIndex.setTrusted(txn, true);
            }
        }
        finally {
            for (DataInputStream stream : this.addDataStreams) {
                stream.close();
            }
            for (DataInputStream stream : this.delDataStreams) {
                stream.close();
            }
            if (files != null) {
                for (File f : files) {
                    f.delete();
                }
            }
        }
        if (DebugLogger.debugEnabled()) {
            int msgID = 8388708;
            String message = MessageHandler.getMessage(msgID, this.vlvIndex.getName());
            TRACER.debugInfo(message);
        }
    }

    private SortValues readNextAdd(SortValues maxValues) throws IOException {
        for (DataInputStream dataInputStream : this.addDataStreams) {
            if (this.lastAddValues.get(dataInputStream) != null) continue;
            try {
                SortKey[] sortKeys = this.vlvIndex.sortOrder.getSortKeys();
                EntryID id = new EntryID(dataInputStream.readLong());
                AttributeValue[] attrValues = new AttributeValue[sortKeys.length];
                for (int i = 0; i < sortKeys.length; ++i) {
                    byte[] valueBytes;
                    SortKey sortKey = sortKeys[i];
                    int length = dataInputStream.readInt();
                    if (length <= 0 || length != dataInputStream.read(valueBytes = new byte[length], 0, length)) continue;
                    attrValues[i] = new AttributeValue(sortKey.getAttributeType(), (ByteString)new ASN1OctetString(valueBytes));
                }
                this.lastAddValues.put(dataInputStream, new SortValues(id, attrValues, this.vlvIndex.sortOrder));
            }
            catch (EOFException e) {}
        }
        Map.Entry<DataInputStream, SortValues> smallestEntry = null;
        for (Map.Entry<DataInputStream, SortValues> entry : this.lastAddValues.entrySet()) {
            if (smallestEntry != null && entry.getValue().compareTo(smallestEntry.getValue()) >= 0) continue;
            smallestEntry = entry;
        }
        if (smallestEntry != null) {
            SortValues smallestValues = (SortValues)smallestEntry.getValue();
            if (maxValues == null || smallestValues.compareTo(maxValues) <= 0) {
                this.lastAddValues.remove(smallestEntry.getKey());
                return smallestValues;
            }
        }
        return null;
    }

    private SortValues readNextDel(SortValues maxValues) throws IOException {
        for (DataInputStream dataInputStream : this.delDataStreams) {
            if (this.lastDelValues.get(dataInputStream) != null) continue;
            try {
                EntryID id = new EntryID(dataInputStream.readLong());
                AttributeValue[] attrValues = new AttributeValue[this.vlvIndex.sortOrder.getSortKeys().length];
                int i = 0;
                for (SortKey sortKey : this.vlvIndex.sortOrder.getSortKeys()) {
                    byte[] valueBytes;
                    int length = dataInputStream.readInt();
                    if (length <= 0 || length != dataInputStream.read(valueBytes = new byte[length], 0, length)) continue;
                    attrValues[i] = new AttributeValue(sortKey.getAttributeType(), (ByteString)new ASN1OctetString(valueBytes));
                }
                this.lastDelValues.put(dataInputStream, new SortValues(id, attrValues, this.vlvIndex.sortOrder));
            }
            catch (EOFException e) {}
        }
        Map.Entry<DataInputStream, SortValues> smallestEntry = null;
        for (Map.Entry<DataInputStream, SortValues> entry : this.lastDelValues.entrySet()) {
            if (smallestEntry != null && entry.getValue().compareTo(smallestEntry.getValue()) >= 0) continue;
            smallestEntry = entry;
        }
        if (smallestEntry != null) {
            SortValues smallestValues = (SortValues)smallestEntry.getValue();
            if (maxValues == null || smallestValues.compareTo(maxValues) <= 0) {
                this.lastDelValues.remove(smallestEntry.getKey());
                return smallestValues;
            }
        }
        return null;
    }
}

