/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.TaskBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.backends.task.RecurringTask;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.CancelledOperationException;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskBackend
extends Backend
implements ConfigurationChangeListener<TaskBackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private TaskBackendCfg currentConfig;
    private DN configEntryDN;
    private DN recurringTaskParentDN;
    private DN scheduledTaskParentDN;
    private DN taskRootDN;
    private DN[] baseDNs;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private long retentionTime;
    private String notificationSenderAddress;
    private String taskBackingFile;
    private TaskScheduler taskScheduler;

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        Validator.ensureNotNull(config);
        Validator.ensureTrue(config instanceof TaskBackendCfg);
        TaskBackendCfg cfg = (TaskBackendCfg)config;
        DN[] baseDNs = new DN[cfg.getBackendBaseDN().size()];
        cfg.getBackendBaseDN().toArray(baseDNs);
        ConfigEntry configEntry = DirectoryServer.getConfigEntry(cfg.dn());
        this.configEntryDN = configEntry.getDN();
        if (baseDNs == null || baseDNs.length == 0) {
            int msgID = 9699440;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        if (baseDNs.length > 1) {
            int msgID = 9699441;
            String message = MessageHandler.getMessage(msgID);
            throw new ConfigException(msgID, message);
        }
        this.baseDNs = baseDNs;
        this.taskRootDN = baseDNs[0];
        String recurringTaskBaseString = "cn=Recurring Tasks," + this.taskRootDN.toString();
        try {
            this.recurringTaskParentDN = DN.decode(recurringTaskBaseString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699442;
            String message = MessageHandler.getMessage(msgID, String.valueOf(recurringTaskBaseString), StaticUtils.getExceptionMessage(e));
            throw new ConfigException(msgID, message, e);
        }
        String scheduledTaskBaseString = "cn=Scheduled Tasks," + this.taskRootDN.toString();
        try {
            this.scheduledTaskParentDN = DN.decode(scheduledTaskBaseString);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699443;
            String message = MessageHandler.getMessage(msgID, String.valueOf(scheduledTaskBaseString), StaticUtils.getExceptionMessage(e));
            throw new ConfigException(msgID, message, e);
        }
        this.retentionTime = cfg.getTaskRetentionTime();
        this.notificationSenderAddress = cfg.getNotificationSenderAddress();
        if (this.notificationSenderAddress == null) {
            try {
                this.notificationSenderAddress = "opends-task-notification@" + InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                this.notificationSenderAddress = "opends-task-notification@opends.org";
            }
        }
        this.taskBackingFile = cfg.getTaskBackingFile();
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        this.currentConfig = cfg;
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        this.taskScheduler = new TaskScheduler(this);
        this.taskScheduler.start();
        this.currentConfig.addTaskChangeListener(this);
        try {
            DirectoryServer.registerBaseDN(this.taskRootDN, this, true, false);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9765074;
            String message = MessageHandler.getMessage(msgID, this.taskRootDN.toString(), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(msgID, message, e);
        }
    }

    @Override
    public void finalizeBackend() {
        block8: {
            block7: {
                block6: {
                    this.currentConfig.removeTaskChangeListener(this);
                    try {
                        this.taskScheduler.stopScheduler();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block6;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                try {
                    int msgID = 0x90009C;
                    String message = MessageHandler.getMessage(msgID);
                    this.taskScheduler.interruptRunningTasks(TaskState.STOPPED_BY_SHUTDOWN, message, true);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block7;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            try {
                DirectoryServer.deregisterBaseDN(this.taskRootDN, false);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        if (this.taskScheduler != null) {
            return this.taskScheduler.getEntryCount();
        }
        return -1L;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        if (entryDN == null) {
            return null;
        }
        if (entryDN.equals(this.taskRootDN)) {
            return this.taskScheduler.getTaskRootEntry();
        }
        if (entryDN.equals(this.scheduledTaskParentDN)) {
            return this.taskScheduler.getScheduledTaskParentEntry();
        }
        if (entryDN.equals(this.recurringTaskParentDN)) {
            return this.taskScheduler.getRecurringTaskParentEntry();
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            return null;
        }
        if (parentDN.equals(this.scheduledTaskParentDN)) {
            return this.taskScheduler.getScheduledTaskEntry(entryDN);
        }
        if (parentDN.equals(this.recurringTaskParentDN)) {
            return this.taskScheduler.getRecurringTaskEntry(entryDN);
        }
        return null;
    }

    @Override
    public boolean entryExists(DN entryDN) throws DirectoryException {
        if (entryDN == null) {
            return false;
        }
        if (entryDN.equals(this.taskRootDN) || entryDN.equals(this.scheduledTaskParentDN) || entryDN.equals(this.recurringTaskParentDN)) {
            return true;
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            return false;
        }
        if (parentDN.equals(this.scheduledTaskParentDN)) {
            return this.taskScheduler.getScheduledTaskEntry(entryDN) != null;
        }
        if (parentDN.equals(this.recurringTaskParentDN)) {
            return this.taskScheduler.getRecurringTaskEntry(entryDN) != null;
        }
        return false;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        Entry e = entry.duplicate(false);
        DN entryDN = e.getDN();
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            int msgID = 9699458;
            String message = MessageHandler.getMessage(msgID, String.valueOf(this.scheduledTaskParentDN), String.valueOf(this.recurringTaskParentDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
        }
        if (parentDN.equals(this.scheduledTaskParentDN)) {
            Task task = this.taskScheduler.entryToScheduledTask(e, addOperation);
            this.taskScheduler.scheduleTask(task, true);
            return;
        }
        if (parentDN.equals(this.recurringTaskParentDN)) {
            RecurringTask recurringTask = this.taskScheduler.entryToRecurringTask(e);
            this.taskScheduler.addRecurringTask(recurringTask, true);
            return;
        }
        int msgID = 9699458;
        String message = MessageHandler.getMessage(msgID, String.valueOf(this.scheduledTaskParentDN), String.valueOf(this.recurringTaskParentDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            int msgID = 9699492;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
        }
        if (parentDN.equals(this.scheduledTaskParentDN)) {
            Task t = this.taskScheduler.getScheduledTask(entryDN);
            if (t == null) {
                int msgID = 9699493;
                String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
            }
            TaskState state = t.getTaskState();
            if (TaskState.isPending(state)) {
                this.taskScheduler.removePendingTask(t.getTaskID());
                return;
            }
            if (TaskState.isDone(t.getTaskState())) {
                this.taskScheduler.removeCompletedTask(t.getTaskID());
                return;
            }
            int msgID = 9699494;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
        }
        if (!parentDN.equals(this.recurringTaskParentDN)) {
            int msgID = 9699492;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
        }
        RecurringTask rt = this.taskScheduler.getRecurringTask(entryDN);
        if (rt == null) {
            int msgID = 9699495;
            String message = MessageHandler.getMessage(msgID, String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
        }
        this.taskScheduler.removeRecurringTask(rt.getRecurringTaskID());
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, "Modify operations are not yet supported in the task backend", 1);
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        int msgID = 9699459;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException, CancelledOperationException {
        Entry e;
        boolean searchRoot = false;
        boolean searchScheduledParent = false;
        boolean searchScheduledTasks = false;
        boolean searchRecurringParent = false;
        boolean searchRecurringTasks = false;
        DN baseDN = searchOperation.getBaseDN();
        SearchScope searchScope = searchOperation.getScope();
        SearchFilter searchFilter = searchOperation.getFilter();
        if (baseDN.equals(this.taskRootDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    searchRoot = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    searchScheduledParent = true;
                    searchRecurringParent = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    searchRoot = true;
                    searchScheduledParent = true;
                    searchRecurringParent = true;
                    searchScheduledTasks = true;
                    searchRecurringTasks = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    searchScheduledParent = true;
                    searchRecurringParent = true;
                    searchScheduledTasks = true;
                    searchRecurringTasks = true;
                }
            }
        } else if (baseDN.equals(this.scheduledTaskParentDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    searchScheduledParent = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    searchScheduledTasks = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    searchScheduledParent = true;
                    searchScheduledTasks = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    searchScheduledTasks = true;
                }
            }
        } else if (baseDN.equals(this.recurringTaskParentDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    searchRecurringParent = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    searchRecurringTasks = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    searchRecurringParent = true;
                    searchRecurringTasks = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    searchRecurringTasks = true;
                }
            }
        } else {
            DN parentDN = baseDN.getParentDNInSuffix();
            if (parentDN == null) {
                int msgID = 9699496;
                String message = MessageHandler.getMessage(msgID, String.valueOf(baseDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
            }
            if (parentDN.equals(this.scheduledTaskParentDN)) {
                Lock lock = this.taskScheduler.readLockEntry(baseDN);
                try {
                    Entry e2 = this.taskScheduler.getScheduledTaskEntry(baseDN);
                    if (e2 == null) {
                        int msgID = 9699497;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(baseDN));
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, this.scheduledTaskParentDN, null);
                    }
                    if ((searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) && searchFilter.matchesEntry(e2)) {
                        searchOperation.returnEntry(e2, null);
                    }
                    return;
                }
                finally {
                    this.taskScheduler.unlockEntry(baseDN, lock);
                }
            }
            if (parentDN.equals(this.recurringTaskParentDN)) {
                Lock lock = this.taskScheduler.readLockEntry(baseDN);
                try {
                    Entry e3 = this.taskScheduler.getRecurringTaskEntry(baseDN);
                    if (e3 == null) {
                        int msgID = 9699498;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(baseDN));
                        throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID, this.recurringTaskParentDN, null);
                    }
                    if ((searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) && searchFilter.matchesEntry(e3)) {
                        searchOperation.returnEntry(e3, null);
                    }
                    return;
                }
                finally {
                    this.taskScheduler.unlockEntry(baseDN, lock);
                }
            }
            int msgID = 9699496;
            String message = MessageHandler.getMessage(msgID, String.valueOf(baseDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, msgID);
        }
        if (searchRoot && searchFilter.matchesEntry(e = this.taskScheduler.getTaskRootEntry()) && !searchOperation.returnEntry(e, null)) {
            return;
        }
        if (searchScheduledParent && searchFilter.matchesEntry(e = this.taskScheduler.getScheduledTaskParentEntry()) && !searchOperation.returnEntry(e, null)) {
            return;
        }
        if (searchScheduledTasks && !this.taskScheduler.searchScheduledTasks(searchOperation)) {
            return;
        }
        if (searchRecurringParent && searchFilter.matchesEntry(e = this.taskScheduler.getRecurringTaskParentEntry()) && !searchOperation.returnEntry(e, null)) {
            return;
        }
        if (searchRecurringTasks && !this.taskScheduler.searchRecurringTasks(searchOperation)) {
            return;
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return true;
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        int msgID = 9699483;
        String message = MessageHandler.getMessage(msgID);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
    }

    @Override
    public boolean supportsBackup() {
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return true;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
    }

    @Override
    public boolean supportsRestore() {
        return true;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
    }

    @Override
    public boolean isConfigurationAcceptable(Configuration configuration, List<String> unacceptableReasons) {
        TaskBackendCfg config = (TaskBackendCfg)configuration;
        return TaskBackend.isConfigAcceptable(config, unacceptableReasons, null);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(TaskBackendCfg configEntry, List<String> unacceptableReasons) {
        return TaskBackend.isConfigAcceptable(configEntry, unacceptableReasons, this.taskBackingFile);
    }

    private static boolean isConfigAcceptable(TaskBackendCfg config, List<String> unacceptableReasons, String taskBackingFile) {
        boolean configIsAcceptable = true;
        try {
            String tmpBackingFile = config.getTaskBackingFile();
            if (taskBackingFile == null || !taskBackingFile.equals(tmpBackingFile)) {
                File f = StaticUtils.getFileForPath(tmpBackingFile);
                if (f.exists()) {
                    if (taskBackingFile != null) {
                        int msgID = 9699449;
                        unacceptableReasons.add(MessageHandler.getMessage(msgID, tmpBackingFile));
                        configIsAcceptable = false;
                    }
                } else {
                    File p = f.getParentFile();
                    if (p == null) {
                        int msgID = 9699450;
                        unacceptableReasons.add(MessageHandler.getMessage(msgID, tmpBackingFile));
                        configIsAcceptable = false;
                    } else if (!p.exists()) {
                        int msgID = 9699451;
                        unacceptableReasons.add(MessageHandler.getMessage(msgID, p.getPath(), tmpBackingFile));
                        configIsAcceptable = false;
                    } else if (!p.isDirectory()) {
                        int msgID = 9699452;
                        unacceptableReasons.add(MessageHandler.getMessage(msgID, p.getPath(), tmpBackingFile));
                        configIsAcceptable = false;
                    }
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 9699453;
            unacceptableReasons.add(MessageHandler.getMessage(msgID, "ds-cfg-task-backing-file", StaticUtils.getExceptionMessage(e)));
            configIsAcceptable = false;
        }
        return configIsAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(TaskBackendCfg configEntry) {
        String tmpNotificationAddress;
        int msgID;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        String tmpBackingFile = this.taskBackingFile;
        try {
            tmpBackingFile = configEntry.getTaskBackingFile();
            if (!this.taskBackingFile.equals(tmpBackingFile)) {
                File f = StaticUtils.getFileForPath(tmpBackingFile);
                if (f.exists()) {
                    int msgID2 = 9699449;
                    messages.add(MessageHandler.getMessage(msgID2, tmpBackingFile));
                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                } else {
                    File p = f.getParentFile();
                    if (p == null) {
                        msgID = 9699450;
                        messages.add(MessageHandler.getMessage(msgID, tmpBackingFile));
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    } else if (!p.exists()) {
                        msgID = 9699451;
                        messages.add(MessageHandler.getMessage(msgID, tmpBackingFile));
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    } else if (!p.isDirectory()) {
                        msgID = 9699452;
                        messages.add(MessageHandler.getMessage(msgID, tmpBackingFile));
                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                    }
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID3 = 9699453;
            messages.add(MessageHandler.getMessage(msgID3, "ds-cfg-task-backing-file", StaticUtils.getExceptionMessage(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        long tmpRetentionTime = configEntry.getTaskRetentionTime();
        if (resultCode == ResultCode.SUCCESS) {
            if (this.retentionTime != tmpRetentionTime) {
                this.retentionTime = tmpRetentionTime;
                msgID = 0x900080;
                messages.add(MessageHandler.getMessage(msgID, this.retentionTime));
            }
            if (!this.taskBackingFile.equals(tmpBackingFile)) {
                this.taskBackingFile = tmpBackingFile;
                this.taskScheduler.writeState();
                msgID = 9437313;
                messages.add(MessageHandler.getMessage(msgID, this.taskBackingFile));
            }
        }
        if ((tmpNotificationAddress = configEntry.getNotificationSenderAddress()) == null) {
            try {
                tmpNotificationAddress = "opends-task-notification@" + InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Exception e) {
                tmpNotificationAddress = "opends-task-notification@opends.org";
            }
        }
        this.notificationSenderAddress = tmpNotificationAddress;
        this.currentConfig = configEntry;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    public DN getConfigEntryDN() {
        return this.configEntryDN;
    }

    public String getTaskBackingFile() {
        File f = StaticUtils.getFileForPath(this.taskBackingFile);
        return f.getPath();
    }

    public String getNotificationSenderAddress() {
        return this.notificationSenderAddress;
    }

    public long getRetentionTime() {
        return this.retentionTime;
    }

    public DN getTaskRootDN() {
        return this.taskRootDN;
    }

    public DN getRecurringTasksParentDN() {
        return this.recurringTaskParentDN;
    }

    public DN getScheduledTasksParentDN() {
        return this.scheduledTaskParentDN;
    }

    public Task getScheduledTask(DN taskEntryDN) {
        return this.taskScheduler.getScheduledTask(taskEntryDN);
    }

    public RecurringTask getRecurringTask(DN taskEntryDN) {
        return this.taskScheduler.getRecurringTask(taskEntryDN);
    }
}

