/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanConfigAttribute
extends ConfigAttribute {
    private boolean activeValue;
    private boolean pendingValue;

    public BooleanConfigAttribute(String name, String description, boolean requiresAdminAction) {
        super(name, description, true, false, requiresAdminAction);
    }

    public BooleanConfigAttribute(String name, String description, boolean requiresAdminAction, boolean value) {
        super(name, description, true, false, requiresAdminAction, BooleanConfigAttribute.getValueSet(value));
        this.activeValue = value;
        this.pendingValue = value;
    }

    public BooleanConfigAttribute(String name, String description, boolean requiresAdminAction, boolean activeValue, boolean pendingValue) {
        super(name, description, true, false, requiresAdminAction, BooleanConfigAttribute.getValueSet(activeValue), true, BooleanConfigAttribute.getValueSet(pendingValue));
        this.activeValue = activeValue;
        this.pendingValue = pendingValue;
    }

    @Override
    public String getDataType() {
        return "Boolean";
    }

    @Override
    public AttributeSyntax getSyntax() {
        return DirectoryServer.getDefaultBooleanSyntax();
    }

    public boolean activeValue() {
        return this.activeValue;
    }

    public boolean pendingValue() {
        if (this.hasPendingValues()) {
            return this.pendingValue;
        }
        return this.activeValue;
    }

    public void setValue(boolean booleanValue) {
        if (this.requiresAdminAction()) {
            this.pendingValue = booleanValue;
            this.setPendingValues(BooleanConfigAttribute.getValueSet(booleanValue));
        } else {
            this.activeValue = booleanValue;
            this.setActiveValues(BooleanConfigAttribute.getValueSet(booleanValue));
        }
    }

    private static LinkedHashSet<AttributeValue> getValueSet(boolean booleanValue) {
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
        if (booleanValue) {
            valueSet.add(new AttributeValue(new ASN1OctetString("true"), (ByteString)new ASN1OctetString("true")));
        } else {
            valueSet.add(new AttributeValue(new ASN1OctetString("false"), (ByteString)new ASN1OctetString("false")));
        }
        return valueSet;
    }

    @Override
    public void applyPendingValues() {
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeValue = this.pendingValue;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue value, StringBuilder rejectReason) {
        String stringValue = value.getStringValue();
        if (stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("false")) {
            return true;
        }
        rejectReason.append(MessageHandler.getMessage(0x330007, this.getName(), stringValue));
        return false;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> valueStrings, boolean allowFailures) throws ConfigException {
        if (valueStrings == null || valueStrings.isEmpty()) {
            int msgID = 0x330001;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        Iterator<String> iterator = valueStrings.iterator();
        String valueString = iterator.next().toLowerCase();
        if (iterator.hasNext()) {
            int msgID = 0x330001;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1")) {
            return BooleanConfigAttribute.getValueSet(true);
        }
        if (valueString.equals("false") || valueString.equals("no") || valueString.equals("off") || valueString.equals("0")) {
            return BooleanConfigAttribute.getValueSet(false);
        }
        int msgID = 0x330007;
        String message = MessageHandler.getMessage(msgID, this.getName(), valueString);
        throw new ConfigException(msgID, message);
    }

    @Override
    public List<String> activeValuesToStrings() {
        ArrayList<String> valueStrings = new ArrayList<String>(1);
        valueStrings.add(String.valueOf(this.activeValue));
        return valueStrings;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        if (this.hasPendingValues()) {
            ArrayList<String> valueStrings = new ArrayList<String>(1);
            valueStrings.add(String.valueOf(this.pendingValue));
            return valueStrings;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> attributeList) throws ConfigException {
        boolean activeValue = false;
        boolean pendingValue = false;
        boolean activeValueSet = false;
        boolean pendingValueSet = false;
        for (Attribute a : attributeList) {
            String valueString;
            Iterator iterator;
            String message;
            LinkedHashSet<AttributeValue> values;
            String message2;
            if (a.hasOptions()) {
                if (a.hasOption("pending")) {
                    if (pendingValueSet) {
                        int msgID = 0x330040;
                        message2 = MessageHandler.getMessage(msgID, a.getName());
                        throw new ConfigException(msgID, message2);
                    }
                    values = a.getValues();
                    if (values.isEmpty()) {
                        int msgID = 0x330001;
                        message = MessageHandler.getMessage(msgID, a.getName());
                        throw new ConfigException(msgID, message);
                    }
                    iterator = values.iterator();
                    valueString = ((AttributeValue)iterator.next()).getStringValue().toLowerCase();
                    if (valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1")) {
                        pendingValue = true;
                        pendingValueSet = true;
                    } else if (valueString.equals("false") || valueString.equals("no") || valueString.equals("off") || valueString.equals("0")) {
                        pendingValue = false;
                        pendingValueSet = true;
                    } else {
                        int msgID = 0x330007;
                        String message3 = MessageHandler.getMessage(msgID, this.getName(), valueString);
                        throw new ConfigException(msgID, message3);
                    }
                    if (!iterator.hasNext()) continue;
                    int msgID = 0x330003;
                    String message4 = MessageHandler.getMessage(msgID, a.getName());
                    throw new ConfigException(msgID, message4);
                }
                int msgID = 3342366;
                message2 = MessageHandler.getMessage(msgID, a.getName());
                throw new ConfigException(msgID, message2);
            }
            if (activeValueSet) {
                int msgID = 3342401;
                message2 = MessageHandler.getMessage(msgID, a.getName());
                throw new ConfigException(msgID, message2);
            }
            values = a.getValues();
            if (values.isEmpty()) {
                int msgID = 0x330001;
                message = MessageHandler.getMessage(msgID, a.getName());
                throw new ConfigException(msgID, message);
            }
            iterator = values.iterator();
            valueString = ((AttributeValue)iterator.next()).getStringValue().toLowerCase();
            if (valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1")) {
                activeValue = true;
                activeValueSet = true;
            } else if (valueString.equals("false") || valueString.equals("no") || valueString.equals("off") || valueString.equals("0")) {
                activeValue = false;
                activeValueSet = true;
            } else {
                int msgID = 0x330007;
                String message5 = MessageHandler.getMessage(msgID, this.getName(), valueString);
                throw new ConfigException(msgID, message5);
            }
            if (!iterator.hasNext()) continue;
            int msgID = 0x330003;
            String message6 = MessageHandler.getMessage(msgID, a.getName());
            throw new ConfigException(msgID, message6);
        }
        if (!activeValueSet) {
            int msgID = 3342402;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (pendingValueSet) {
            return new BooleanConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), activeValue, pendingValue);
        }
        return new BooleanConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), activeValue);
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        return new javax.management.Attribute(this.getName(), this.activeValue);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        return new javax.management.Attribute(this.getName() + ";" + "pending", this.pendingValue);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        attributeList.add(new javax.management.Attribute(this.getName(), this.activeValue));
        if (this.requiresAdminAction() && this.pendingValue != this.activeValue) {
            String name = this.getName() + ";" + "pending";
            attributeList.add(new javax.management.Attribute(name, this.pendingValue));
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> attributeInfoList) {
        attributeInfoList.add(new MBeanAttributeInfo(this.getName(), Boolean.class.getName(), this.getDescription(), true, true, false));
        if (this.requiresAdminAction()) {
            String name = this.getName() + ";" + "pending";
            attributeInfoList.add(new MBeanAttributeInfo(name, Boolean.class.getName(), this.getDescription(), true, false, false));
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        return new MBeanParameterInfo(this.getName(), Boolean.TYPE.getName(), this.getDescription());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setValue(javax.management.Attribute jmxAttribute) throws ConfigException {
        Object value = jmxAttribute.getValue();
        if (value instanceof Boolean) {
            this.setValue((Boolean)value);
            return;
        }
        if (!(value instanceof String)) {
            int msgID = 0x330007;
            String message = MessageHandler.getMessage(msgID, this.getName(), value.getClass().getName() + ":" + String.valueOf(value));
            throw new ConfigException(msgID, message);
        }
        String stringValue = ((String)value).toLowerCase();
        if (stringValue.equals("true") || stringValue.equals("yes") || stringValue.equals("on") || stringValue.equals("1")) {
            this.setValue(true);
            return;
        }
        if (!(stringValue.equals("false") || stringValue.equals("no") || stringValue.equals("off") || stringValue.equals("0"))) {
            int msgID = 0x330007;
            String message = MessageHandler.getMessage(msgID, this.getName(), stringValue);
            throw new ConfigException(msgID, message);
        }
        this.setValue(false);
    }

    @Override
    public ConfigAttribute duplicate() {
        return new BooleanConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), this.activeValue, this.pendingValue);
    }
}

