/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerConfigAttribute
extends ConfigAttribute {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private List<Long> activeValues;
    private List<Long> pendingValues;
    private boolean hasLowerBound;
    private boolean hasUpperBound;
    private long lowerBound;
    private long upperBound;

    public IntegerConfigAttribute(String name, String description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, boolean hasLowerBound, long lowerBound, boolean hasUpperBound, long upperBound) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction);
        this.hasLowerBound = hasLowerBound;
        this.lowerBound = lowerBound;
        this.hasUpperBound = hasUpperBound;
        this.upperBound = upperBound;
        this.activeValues = new ArrayList<Long>();
        this.pendingValues = this.activeValues;
    }

    public IntegerConfigAttribute(String name, String description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, boolean hasLowerBound, long lowerBound, boolean hasUpperBound, long upperBound, long value) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, IntegerConfigAttribute.getValueSet(value));
        this.hasLowerBound = hasLowerBound;
        this.lowerBound = lowerBound;
        this.hasUpperBound = hasUpperBound;
        this.upperBound = upperBound;
        this.activeValues = new ArrayList<Long>(1);
        this.activeValues.add(value);
        this.pendingValues = this.activeValues;
    }

    public IntegerConfigAttribute(String name, String description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, boolean hasLowerBound, long lowerBound, boolean hasUpperBound, long upperBound, List<Long> values) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, IntegerConfigAttribute.getValueSet(values));
        this.hasLowerBound = hasLowerBound;
        this.lowerBound = lowerBound;
        this.hasUpperBound = hasUpperBound;
        this.upperBound = upperBound;
        if (values == null) {
            this.activeValues = new ArrayList<Long>();
            this.pendingValues = this.activeValues;
        } else {
            this.activeValues = values;
            this.pendingValues = this.activeValues;
        }
    }

    public IntegerConfigAttribute(String name, String description, boolean isRequired, boolean isMultiValued, boolean requiresAdminAction, boolean hasLowerBound, long lowerBound, boolean hasUpperBound, long upperBound, List<Long> activeValues, List<Long> pendingValues) {
        super(name, description, isRequired, isMultiValued, requiresAdminAction, IntegerConfigAttribute.getValueSet(activeValues), pendingValues != null, IntegerConfigAttribute.getValueSet(pendingValues));
        this.hasLowerBound = hasLowerBound;
        this.lowerBound = lowerBound;
        this.hasUpperBound = hasUpperBound;
        this.upperBound = upperBound;
        this.activeValues = activeValues == null ? new ArrayList<Long>() : activeValues;
        this.pendingValues = pendingValues == null ? this.activeValues : pendingValues;
    }

    @Override
    public String getDataType() {
        return "Integer";
    }

    @Override
    public AttributeSyntax getSyntax() {
        return DirectoryServer.getDefaultIntegerSyntax();
    }

    public long activeValue() throws ConfigException {
        if (this.activeValues == null || this.activeValues.isEmpty()) {
            int msgID = 0x330008;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (this.activeValues.size() > 1) {
            int msgID = 0x330009;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        return this.activeValues.get(0);
    }

    public int activeIntValue() throws ConfigException {
        if (this.activeValues == null || this.activeValues.isEmpty()) {
            int msgID = 0x330008;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (this.activeValues.size() > 1) {
            int msgID = 0x330009;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        long longValue = this.activeValues.get(0);
        int intValue = (int)longValue;
        if ((long)intValue == longValue) {
            return intValue;
        }
        int msgID = 0x33000A;
        String message = MessageHandler.getMessage(msgID, this.getName());
        throw new ConfigException(msgID, message);
    }

    public List<Long> activeValues() {
        return this.activeValues;
    }

    public long pendingValue() throws ConfigException {
        if (!this.hasPendingValues()) {
            return this.activeValue();
        }
        if (this.pendingValues == null || this.pendingValues.isEmpty()) {
            int msgID = 0x330008;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (this.pendingValues.size() > 1) {
            int msgID = 0x330009;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        return this.pendingValues.get(0);
    }

    public int pendingIntValue() throws ConfigException {
        if (!this.hasPendingValues()) {
            return this.activeIntValue();
        }
        if (this.pendingValues == null || this.pendingValues.isEmpty()) {
            int msgID = 0x330008;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (this.pendingValues.size() > 1) {
            int msgID = 0x330009;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        long longValue = this.pendingValues.get(0);
        int intValue = (int)longValue;
        if ((long)intValue == longValue) {
            return intValue;
        }
        int msgID = 0x33000A;
        String message = MessageHandler.getMessage(msgID, this.getName());
        throw new ConfigException(msgID, message);
    }

    public List<Long> pendingValues() {
        if (!this.hasPendingValues()) {
            return this.activeValues;
        }
        return this.pendingValues;
    }

    public boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public void setValue(long value) throws ConfigException {
        if (this.hasLowerBound && value < this.lowerBound) {
            int msgID = 0x33000C;
            String message = MessageHandler.getMessage(msgID, this.getName(), value, this.lowerBound);
            throw new ConfigException(msgID, message);
        }
        if (this.hasUpperBound && value > this.upperBound) {
            int msgID = 0x33000D;
            String message = MessageHandler.getMessage(msgID, this.getName(), value, this.upperBound);
            throw new ConfigException(msgID, message);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = new ArrayList<Long>(1);
            this.pendingValues.add(value);
            this.setPendingValues(IntegerConfigAttribute.getValueSet(value));
        } else {
            this.activeValues.clear();
            this.activeValues.add(value);
            this.pendingValues = this.activeValues;
            this.setActiveValues(IntegerConfigAttribute.getValueSet(value));
        }
    }

    public void setValues(List<Long> values) throws ConfigException {
        if (values == null || values.isEmpty()) {
            if (this.isRequired()) {
                int msgID = 0x330001;
                String message = MessageHandler.getMessage(msgID, this.getName());
                throw new ConfigException(msgID, message);
            }
            if (this.requiresAdminAction()) {
                this.setPendingValues(new LinkedHashSet<AttributeValue>(0));
                this.pendingValues = new ArrayList<Long>();
            } else {
                this.setActiveValues(new LinkedHashSet<AttributeValue>(0));
                this.activeValues.clear();
            }
        }
        int numValues = values.size();
        if (!this.isMultiValued() && numValues > 1) {
            int msgID = 0x330003;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(numValues);
        for (long value : values) {
            String message;
            if (this.hasLowerBound && value < this.lowerBound) {
                int msgID = 0x33000C;
                message = MessageHandler.getMessage(msgID, this.getName(), value, this.lowerBound);
                throw new ConfigException(msgID, message);
            }
            if (this.hasUpperBound && value > this.upperBound) {
                int msgID = 0x33000D;
                message = MessageHandler.getMessage(msgID, this.getName(), value, this.upperBound);
                throw new ConfigException(msgID, message);
            }
            String valueString = String.valueOf(value);
            AttributeValue attrValue = new AttributeValue(new ASN1OctetString(valueString), (ByteString)new ASN1OctetString(valueString));
            if (valueSet.contains(attrValue)) {
                int msgID = 0x330005;
                String message2 = MessageHandler.getMessage(msgID, this.getName(), valueString);
                throw new ConfigException(msgID, message2);
            }
            valueSet.add(attrValue);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = values;
            this.setPendingValues(valueSet);
        } else {
            this.activeValues = values;
            this.pendingValues = this.activeValues;
            this.setActiveValues(valueSet);
        }
    }

    private static LinkedHashSet<AttributeValue> getValueSet(long value) {
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
        String valueString = String.valueOf(value);
        valueSet.add(new AttributeValue(new ASN1OctetString(valueString), (ByteString)new ASN1OctetString(valueString)));
        return valueSet;
    }

    private static LinkedHashSet<AttributeValue> getValueSet(List<Long> values) {
        if (values == null) {
            return null;
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(values.size());
        for (long value : values) {
            String valueString = String.valueOf(value);
            valueSet.add(new AttributeValue(new ASN1OctetString(valueString), (ByteString)new ASN1OctetString(valueString)));
        }
        return valueSet;
    }

    @Override
    public void applyPendingValues() {
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeValues = this.pendingValues;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue value, StringBuilder rejectReason) {
        long longValue;
        String stringValue = value.getStringValue();
        try {
            longValue = Long.parseLong(stringValue);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            rejectReason.append(MessageHandler.getMessage(0x33000B, stringValue, String.valueOf(e)));
            return false;
        }
        if (this.hasLowerBound && longValue < this.lowerBound) {
            rejectReason.append(MessageHandler.getMessage(0x33000C, this.getName(), longValue, this.lowerBound));
            return false;
        }
        if (this.hasUpperBound && longValue > this.upperBound) {
            rejectReason.append(MessageHandler.getMessage(0x33000D, this.getName(), longValue, this.upperBound));
            return false;
        }
        return true;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> valueStrings, boolean allowFailures) throws ConfigException {
        if (valueStrings == null || valueStrings.isEmpty()) {
            if (this.isRequired()) {
                int msgID = 0x330001;
                String message = MessageHandler.getMessage(msgID, this.getName());
                throw new ConfigException(msgID, message);
            }
            return new LinkedHashSet<AttributeValue>();
        }
        int numValues = valueStrings.size();
        if (!this.isMultiValued() && numValues > 1) {
            int msgID = 0x330003;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(numValues);
        for (String valueString : valueStrings) {
            long longValue;
            try {
                longValue = Long.parseLong(valueString);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 0x33000E;
                String message = MessageHandler.getMessage(msgID, valueString, this.getName(), String.valueOf(e));
                if (allowFailures) {
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, message, msgID);
                    continue;
                }
                throw new ConfigException(msgID, message);
            }
            if (this.hasLowerBound && longValue < this.lowerBound) {
                int msgID = 0x33000C;
                String message = MessageHandler.getMessage(msgID, this.getName(), longValue, this.lowerBound);
                if (allowFailures) {
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, message, msgID);
                    continue;
                }
                throw new ConfigException(msgID, message);
            }
            if (this.hasUpperBound && longValue > this.upperBound) {
                int msgID = 0x33000D;
                String message = MessageHandler.getMessage(msgID, this.getName(), longValue, this.upperBound);
                if (allowFailures) {
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, message, msgID);
                    continue;
                }
                throw new ConfigException(msgID, message);
            }
            valueSet.add(new AttributeValue(new ASN1OctetString(valueString), (ByteString)new ASN1OctetString(valueString)));
        }
        if (this.isRequired() && valueSet.isEmpty()) {
            int msgID = 0x330001;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        return valueSet;
    }

    @Override
    public List<String> activeValuesToStrings() {
        ArrayList<String> valueStrings = new ArrayList<String>(this.activeValues.size());
        for (long l : this.activeValues) {
            valueStrings.add(String.valueOf(l));
        }
        return valueStrings;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        if (this.hasPendingValues()) {
            ArrayList<String> valueStrings = new ArrayList<String>(this.pendingValues.size());
            for (long l : this.pendingValues) {
                valueStrings.add(String.valueOf(l));
            }
            return valueStrings;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> attributeList) throws ConfigException {
        ArrayList<Long> activeValues = null;
        ArrayList<Long> pendingValues = null;
        for (Attribute a : attributeList) {
            long longValue;
            String message;
            int numValues;
            String message2;
            int msgID;
            LinkedHashSet<AttributeValue> values;
            if (a.hasOptions()) {
                if (a.hasOption("pending")) {
                    if (pendingValues != null) {
                        int msgID2 = 0x330040;
                        String message3 = MessageHandler.getMessage(msgID2, a.getName());
                        throw new ConfigException(msgID2, message3);
                    }
                    values = a.getValues();
                    if (values.isEmpty()) {
                        if (this.isRequired()) {
                            msgID = 0x330001;
                            message2 = MessageHandler.getMessage(msgID, a.getName());
                            throw new ConfigException(msgID, message2);
                        }
                        pendingValues = new ArrayList(0);
                        continue;
                    }
                    numValues = values.size();
                    if (numValues > 1 && !this.isMultiValued()) {
                        int msgID3 = 0x330003;
                        message = MessageHandler.getMessage(msgID3, a.getName());
                        throw new ConfigException(msgID3, message);
                    }
                    pendingValues = new ArrayList(numValues);
                    for (AttributeValue v : values) {
                        try {
                            longValue = Long.parseLong(v.getStringValue());
                        }
                        catch (Exception e) {
                            int msgID4 = 0x33000E;
                            String message4 = MessageHandler.getMessage(msgID4, v.getStringValue(), a.getName(), String.valueOf(e));
                            throw new ConfigException(msgID4, message4, e);
                        }
                        if (this.hasLowerBound && longValue < this.lowerBound) {
                            int msgID5 = 0x33000C;
                            String message5 = MessageHandler.getMessage(msgID5, a.getName(), longValue, this.lowerBound);
                            throw new ConfigException(msgID5, message5);
                        }
                        if (this.hasUpperBound && longValue > this.upperBound) {
                            int msgID6 = 0x33000D;
                            String message6 = MessageHandler.getMessage(msgID6, a.getName(), longValue, this.upperBound);
                            throw new ConfigException(msgID6, message6);
                        }
                        pendingValues.add(longValue);
                    }
                    continue;
                }
                int msgID7 = 3342366;
                String message7 = MessageHandler.getMessage(msgID7, a.getName());
                throw new ConfigException(msgID7, message7);
            }
            if (activeValues != null) {
                int msgID8 = 3342401;
                String message8 = MessageHandler.getMessage(msgID8, a.getName());
                throw new ConfigException(msgID8, message8);
            }
            values = a.getValues();
            if (values.isEmpty()) {
                if (this.isRequired()) {
                    msgID = 0x330001;
                    message2 = MessageHandler.getMessage(msgID, a.getName());
                    throw new ConfigException(msgID, message2);
                }
                activeValues = new ArrayList<Long>(0);
                continue;
            }
            numValues = values.size();
            if (numValues > 1 && !this.isMultiValued()) {
                int msgID9 = 0x330003;
                message = MessageHandler.getMessage(msgID9, a.getName());
                throw new ConfigException(msgID9, message);
            }
            activeValues = new ArrayList(numValues);
            for (AttributeValue v : values) {
                try {
                    longValue = Long.parseLong(v.getStringValue());
                }
                catch (Exception e) {
                    int msgID10 = 0x33000E;
                    String message9 = MessageHandler.getMessage(msgID10, v.getStringValue(), a.getName(), String.valueOf(e));
                    throw new ConfigException(msgID10, message9, e);
                }
                if (this.hasLowerBound && longValue < this.lowerBound) {
                    int msgID11 = 0x33000C;
                    String message10 = MessageHandler.getMessage(msgID11, a.getName(), longValue, this.lowerBound);
                    throw new ConfigException(msgID11, message10);
                }
                if (this.hasUpperBound && longValue > this.upperBound) {
                    int msgID12 = 0x33000D;
                    String message11 = MessageHandler.getMessage(msgID12, a.getName(), longValue, this.upperBound);
                    throw new ConfigException(msgID12, message11);
                }
                activeValues.add(longValue);
            }
        }
        if (activeValues == null) {
            int msgID = 3342402;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (pendingValues == null) {
            pendingValues = activeValues;
        }
        return new IntegerConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.hasLowerBound, this.lowerBound, this.hasUpperBound, this.upperBound, activeValues, pendingValues);
    }

    private javax.management.Attribute _toJMXAttribute(boolean pending) {
        String name;
        List<Long> requestedValues;
        if (pending) {
            requestedValues = this.pendingValues;
            name = this.getName() + ";" + "pending";
        } else {
            requestedValues = this.activeValues;
            name = this.getName();
        }
        if (this.isMultiValued()) {
            long[] values = new long[requestedValues.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = requestedValues.get(i);
            }
            return new javax.management.Attribute(name, values);
        }
        if (requestedValues.isEmpty()) {
            return null;
        }
        return new javax.management.Attribute(name, requestedValues.get(0));
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        return this._toJMXAttribute(false);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        return this._toJMXAttribute(true);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        if (this.activeValues.size() > 0) {
            if (this.isMultiValued()) {
                long[] values = new long[this.activeValues.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.activeValues.get(i);
                }
                attributeList.add(new javax.management.Attribute(this.getName(), values));
            } else {
                attributeList.add(new javax.management.Attribute(this.getName(), this.activeValues.get(0)));
            }
        } else if (this.isMultiValued()) {
            attributeList.add(new javax.management.Attribute(this.getName(), new String[0]));
        } else {
            attributeList.add(new javax.management.Attribute(this.getName(), null));
        }
        if (this.requiresAdminAction() && this.pendingValues != null && this.pendingValues != this.activeValues) {
            String name = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                long[] values = new long[this.pendingValues.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.pendingValues.get(i);
                }
                attributeList.add(new javax.management.Attribute(name, values));
            } else if (!this.pendingValues.isEmpty()) {
                attributeList.add(new javax.management.Attribute(name, this.pendingValues.get(0)));
            }
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> attributeInfoList) {
        if (this.isMultiValued()) {
            attributeInfoList.add(new MBeanAttributeInfo(this.getName(), "[J", this.getDescription(), true, true, false));
        } else {
            attributeInfoList.add(new MBeanAttributeInfo(this.getName(), Long.class.getName(), this.getDescription(), true, true, false));
        }
        if (this.requiresAdminAction()) {
            String name = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                attributeInfoList.add(new MBeanAttributeInfo(name, "[J", this.getDescription(), true, false, false));
            } else {
                attributeInfoList.add(new MBeanAttributeInfo(name, Long.class.getName(), this.getDescription(), true, false, false));
            }
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        if (this.isMultiValued()) {
            return new MBeanParameterInfo(this.getName(), "[J", this.getDescription());
        }
        return new MBeanParameterInfo(this.getName(), Long.TYPE.getName(), this.getDescription());
    }

    @Override
    public void setValue(javax.management.Attribute jmxAttribute) throws ConfigException {
        Object value = jmxAttribute.getValue();
        if (value instanceof Long) {
            this.setValue((Long)value);
        } else if (value instanceof Integer) {
            this.setValue(((Integer)value).intValue());
        } else if (value instanceof String) {
            try {
                this.setValue(Long.parseLong((String)value));
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 0x33000E;
                String message = MessageHandler.getMessage(msgID, String.valueOf(value), this.getName(), String.valueOf(e));
                throw new ConfigException(msgID, message, e);
            }
        } else if (value.getClass().isArray()) {
            String componentType = value.getClass().getComponentType().getName();
            int length = Array.getLength(value);
            try {
                if (componentType.equals(Long.class.getName())) {
                    ArrayList<Long> values = new ArrayList<Long>();
                    for (int i = 0; i < length; ++i) {
                        values.add(Array.getLong(value, i));
                    }
                    this.setValues(values);
                }
                if (componentType.equals(Integer.class.getName())) {
                    ArrayList<Long> values = new ArrayList<Long>();
                    for (int i = 0; i < length; ++i) {
                        values.add(Long.valueOf(Array.getInt(value, i)));
                    }
                    this.setValues(values);
                }
                if (componentType.equals(String.class.getName())) {
                    ArrayList<Long> values = new ArrayList<Long>();
                    for (int i = 0; i < length; ++i) {
                        String s = (String)Array.get(value, i);
                        values.add(Long.parseLong(s));
                    }
                    this.setValues(values);
                }
                int msgID = 0x330044;
                String message = MessageHandler.getMessage(msgID, componentType);
                throw new ConfigException(msgID, message);
            }
            catch (ConfigException ce) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ce);
                }
                throw ce;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 0x33000E;
                String message = MessageHandler.getMessage(msgID, componentType + "[" + length + "]", this.getName(), String.valueOf(e));
                throw new ConfigException(msgID, message, e);
            }
        } else {
            int msgID = 0x330043;
            String message = MessageHandler.getMessage(msgID, String.valueOf(value), this.getName(), value.getClass().getName());
            throw new ConfigException(msgID, message);
        }
    }

    @Override
    public ConfigAttribute duplicate() {
        return new IntegerConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.hasLowerBound, this.lowerBound, this.hasUpperBound, this.upperBound, this.activeValues, this.pendingValues);
    }
}

