/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerWithUnitConfigAttribute
extends ConfigAttribute {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean hasLowerBound;
    private boolean hasUpperBound;
    private HashMap<String, Double> units;
    private long activeCalculatedValue;
    private long activeIntValue;
    private long lowerBound;
    private long pendingCalculatedValue;
    private long pendingIntValue;
    private long upperBound;
    private String activeUnit;
    private String pendingUnit;

    public IntegerWithUnitConfigAttribute(String name, String description, boolean requiresAdminAction, HashMap<String, Double> units, boolean hasLowerBound, long lowerBound, boolean hasUpperBound, long upperBound) {
        super(name, description, true, false, requiresAdminAction);
        this.units = units;
        this.hasLowerBound = hasLowerBound;
        this.lowerBound = lowerBound;
        this.hasUpperBound = hasUpperBound;
        this.upperBound = upperBound;
    }

    public IntegerWithUnitConfigAttribute(String name, String description, boolean requiresAdminAction, HashMap<String, Double> units, boolean hasLowerBound, long lowerBound, boolean hasUpperBound, long upperBound, long intValue, String selectedUnit) {
        super(name, description, true, false, requiresAdminAction, IntegerWithUnitConfigAttribute.getValueSet(intValue, selectedUnit));
        this.units = units;
        this.hasLowerBound = hasLowerBound;
        this.lowerBound = lowerBound;
        this.hasUpperBound = hasUpperBound;
        this.upperBound = upperBound;
        this.activeIntValue = intValue;
        this.activeUnit = selectedUnit;
        this.pendingIntValue = this.activeIntValue;
        this.pendingUnit = this.activeUnit;
        if (units.containsKey(selectedUnit)) {
            this.activeCalculatedValue = (long)((double)this.activeIntValue * units.get(selectedUnit));
        }
        this.pendingCalculatedValue = this.activeCalculatedValue;
    }

    public IntegerWithUnitConfigAttribute(String name, String description, boolean requiresAdminAction, HashMap<String, Double> units, boolean hasLowerBound, long lowerBound, boolean hasUpperBound, long upperBound, long activeIntValue, String activeSelectedUnit, long pendingIntValue, String pendingSelectedUnit) {
        super(name, description, true, false, requiresAdminAction, IntegerWithUnitConfigAttribute.getValueSet(activeIntValue, activeSelectedUnit), pendingSelectedUnit != null, IntegerWithUnitConfigAttribute.getValueSet(pendingIntValue, pendingSelectedUnit));
        this.units = units;
        this.hasLowerBound = hasLowerBound;
        this.lowerBound = lowerBound;
        this.hasUpperBound = hasUpperBound;
        this.upperBound = upperBound;
        this.activeIntValue = activeIntValue;
        this.activeUnit = activeSelectedUnit;
        if (pendingSelectedUnit == null) {
            this.pendingIntValue = activeIntValue;
            this.pendingUnit = this.activeUnit;
        } else {
            this.pendingIntValue = pendingIntValue;
            this.pendingUnit = pendingSelectedUnit;
        }
        if (units.containsKey(this.activeUnit)) {
            this.activeCalculatedValue = (long)((double)activeIntValue * units.get(this.activeUnit));
        }
        if (units.containsKey(this.pendingUnit)) {
            this.pendingCalculatedValue = (long)((double)pendingIntValue * units.get(this.pendingUnit));
        }
    }

    @Override
    public String getDataType() {
        return "IntegerWithUnit";
    }

    @Override
    public AttributeSyntax getSyntax() {
        return DirectoryServer.getDefaultStringSyntax();
    }

    public long activeIntValue() {
        return this.activeIntValue;
    }

    public String activeUnit() {
        return this.activeUnit;
    }

    public long activeCalculatedValue() {
        return this.activeCalculatedValue;
    }

    public long pendingIntValue() {
        if (this.hasPendingValues()) {
            return this.pendingIntValue;
        }
        return this.activeIntValue;
    }

    public String pendingUnit() {
        if (this.hasPendingValues()) {
            return this.pendingUnit;
        }
        return this.activeUnit;
    }

    public long pendingCalculatedValue() {
        if (this.hasPendingValues()) {
            return this.pendingCalculatedValue;
        }
        return this.activeCalculatedValue;
    }

    public HashMap<String, Double> getUnits() {
        return this.units;
    }

    public boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public void setValue(long intValue, String unit) throws ConfigException {
        if (unit == null || !this.units.containsKey(unit)) {
            int msgID = 0x330013;
            String message = MessageHandler.getMessage(msgID, unit, this.getName());
            throw new ConfigException(msgID, message);
        }
        long calculatedValue = (long)((double)intValue * this.units.get(unit));
        if (this.hasLowerBound && calculatedValue < this.lowerBound) {
            int msgID = 0x33000C;
            String message = MessageHandler.getMessage(msgID, this.getName(), calculatedValue, this.lowerBound);
            throw new ConfigException(msgID, message);
        }
        if (this.hasUpperBound && calculatedValue > this.upperBound) {
            int msgID = 0x33000D;
            String message = MessageHandler.getMessage(msgID, this.getName(), calculatedValue, this.upperBound);
            throw new ConfigException(msgID, message);
        }
        if (this.requiresAdminAction()) {
            this.pendingCalculatedValue = calculatedValue;
            this.pendingIntValue = intValue;
            this.pendingUnit = unit;
            this.setPendingValues(IntegerWithUnitConfigAttribute.getValueSet(intValue, unit));
        } else {
            this.activeCalculatedValue = calculatedValue;
            this.activeIntValue = intValue;
            this.activeUnit = unit;
            this.setActiveValues(IntegerWithUnitConfigAttribute.getValueSet(intValue, unit));
        }
    }

    public void setValue(String value) throws ConfigException {
        long longValue;
        int spacePos = value.indexOf(32);
        if (spacePos <= 0) {
            int msgID = 3342356;
            String message = MessageHandler.getMessage(msgID, String.valueOf(value), this.getName());
            throw new ConfigException(msgID, message);
        }
        try {
            longValue = Long.parseLong(value.substring(0, spacePos));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 3342357;
            String message = MessageHandler.getMessage(msgID, String.valueOf(value), this.getName(), String.valueOf(e));
            throw new ConfigException(msgID, message, e);
        }
        this.setValue(longValue, value.substring(spacePos + 1));
    }

    private static LinkedHashSet<AttributeValue> getValueSet(long intValue, String unit) {
        if (unit == null) {
            return null;
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
        String valueString = intValue + " " + unit;
        valueSet.add(new AttributeValue(new ASN1OctetString(valueString), (ByteString)new ASN1OctetString(valueString)));
        return valueSet;
    }

    @Override
    public void applyPendingValues() {
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeCalculatedValue = this.pendingCalculatedValue;
        this.activeIntValue = this.pendingIntValue;
        this.activeUnit = this.pendingUnit;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue value, StringBuilder rejectReason) {
        String lowerValue = value.getStringValue().toLowerCase();
        return this.valueIsAcceptable(lowerValue, rejectReason);
    }

    public boolean valueIsAcceptable(String lowerValue, StringBuilder rejectReason) {
        long longValue;
        int spacePos = lowerValue.indexOf(32);
        if (spacePos < 0) {
            rejectReason.append(MessageHandler.getMessage(3342356, lowerValue, this.getName()));
            return false;
        }
        try {
            longValue = Long.parseLong(lowerValue.substring(0, spacePos));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            rejectReason.append(MessageHandler.getMessage(0x33000E, lowerValue, this.getName(), String.valueOf(e)));
            return false;
        }
        String unit = lowerValue.substring(spacePos + 1);
        if (!this.units.containsKey(unit)) {
            rejectReason.append(MessageHandler.getMessage(0x330013, unit, this.getName()));
            return false;
        }
        double multiplier = this.units.get(unit);
        long calculatedValue = (long)((double)longValue * multiplier);
        if (this.hasLowerBound && calculatedValue < this.lowerBound) {
            rejectReason.append(MessageHandler.getMessage(0x33000C, this.getName(), calculatedValue, this.lowerBound));
            return false;
        }
        if (this.hasUpperBound && calculatedValue > this.upperBound) {
            rejectReason.append(MessageHandler.getMessage(0x33000D, this.getName(), calculatedValue, this.upperBound));
            return false;
        }
        return true;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> valueStrings, boolean allowFailures) throws ConfigException {
        if (valueStrings == null || valueStrings.isEmpty()) {
            if (this.isRequired()) {
                int msgID = 0x330001;
                String message = MessageHandler.getMessage(msgID, this.getName());
                throw new ConfigException(msgID, message);
            }
            return new LinkedHashSet<AttributeValue>();
        }
        int numValues = valueStrings.size();
        if (!this.isMultiValued() && numValues > 1) {
            int msgID = 0x330003;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(numValues);
        for (String valueString : valueStrings) {
            if (valueString == null || valueString.length() == 0) {
                int msgID = 0x330011;
                String message = MessageHandler.getMessage(msgID, this.getName());
                if (allowFailures) {
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, message, msgID);
                    continue;
                }
                throw new ConfigException(msgID, message);
            }
            StringBuilder rejectReason = new StringBuilder();
            if (!this.valueIsAcceptable(valueString.toLowerCase(), rejectReason)) {
                int msgID = 3342358;
                String message = MessageHandler.getMessage(msgID, valueString, this.getName(), rejectReason.toString());
                if (allowFailures) {
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, message, msgID);
                    continue;
                }
                throw new ConfigException(msgID, message);
            }
            valueSet.add(new AttributeValue(new ASN1OctetString(valueString), (ByteString)new ASN1OctetString(valueString)));
        }
        if (this.isRequired() && valueSet.isEmpty()) {
            int msgID = 0x330001;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        return valueSet;
    }

    @Override
    public List<String> activeValuesToStrings() {
        ArrayList<String> valueStrings = new ArrayList<String>(1);
        valueStrings.add(this.activeIntValue + " " + this.activeUnit);
        return valueStrings;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        if (this.hasPendingValues()) {
            ArrayList<String> valueStrings = new ArrayList<String>(1);
            valueStrings.add(this.pendingIntValue + " " + this.pendingUnit);
            return valueStrings;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> attributeList) throws ConfigException {
        long activeIntValue = 0L;
        long pendingIntValue = 0L;
        String activeUnit = null;
        String pendingUnit = null;
        for (Attribute a : attributeList) {
            double multiplier;
            String valueString;
            Iterator iterator;
            String message;
            LinkedHashSet<AttributeValue> values;
            String message2;
            if (a.hasOptions()) {
                if (a.hasOption("pending")) {
                    if (pendingUnit != null) {
                        int msgID = 0x330040;
                        message2 = MessageHandler.getMessage(msgID, a.getName());
                        throw new ConfigException(msgID, message2);
                    }
                    values = a.getValues();
                    if (values.isEmpty()) {
                        int msgID = 0x330001;
                        message = MessageHandler.getMessage(msgID, a.getName());
                        throw new ConfigException(msgID, message);
                    }
                    iterator = values.iterator();
                    valueString = ((AttributeValue)iterator.next()).getStringValue();
                    if (iterator.hasNext()) {
                        int msgID = 0x330003;
                        String message3 = MessageHandler.getMessage(msgID, a.getName());
                        throw new ConfigException(msgID, message3);
                    }
                    try {
                        int spacePos = valueString.indexOf(32);
                        pendingIntValue = Long.parseLong(valueString.substring(0, spacePos));
                        pendingUnit = valueString.substring(spacePos + 1).trim();
                    }
                    catch (Exception e) {
                        int msgID = 3342357;
                        String message4 = MessageHandler.getMessage(msgID, valueString, a.getName(), String.valueOf(e));
                        throw new ConfigException(msgID, message4);
                    }
                    if (!this.units.containsKey(pendingUnit)) {
                        int msgID = 0x330013;
                        String message5 = MessageHandler.getMessage(msgID, pendingUnit, a.getName());
                        throw new ConfigException(msgID, message5);
                    }
                    multiplier = this.units.get(activeUnit);
                    this.pendingCalculatedValue = (long)(multiplier * (double)pendingIntValue);
                    if (this.hasLowerBound && this.pendingCalculatedValue < this.lowerBound) {
                        int msgID = 0x33000C;
                        String message6 = MessageHandler.getMessage(msgID, a.getName(), this.pendingCalculatedValue, this.lowerBound);
                        throw new ConfigException(msgID, message6);
                    }
                    if (!this.hasUpperBound || this.pendingCalculatedValue <= this.upperBound) continue;
                    int msgID = 0x33000D;
                    String message7 = MessageHandler.getMessage(msgID, a.getName(), this.pendingCalculatedValue, this.upperBound);
                    throw new ConfigException(msgID, message7);
                }
                int msgID = 3342366;
                message2 = MessageHandler.getMessage(msgID, a.getName());
                throw new ConfigException(msgID, message2);
            }
            if (activeUnit != null) {
                int msgID = 3342401;
                message2 = MessageHandler.getMessage(msgID, a.getName());
                throw new ConfigException(msgID, message2);
            }
            values = a.getValues();
            if (values.isEmpty()) {
                int msgID = 0x330001;
                message = MessageHandler.getMessage(msgID, a.getName());
                throw new ConfigException(msgID, message);
            }
            iterator = values.iterator();
            valueString = ((AttributeValue)iterator.next()).getStringValue();
            if (iterator.hasNext()) {
                int msgID = 0x330003;
                String message8 = MessageHandler.getMessage(msgID, a.getName());
                throw new ConfigException(msgID, message8);
            }
            try {
                int spacePos = valueString.indexOf(32);
                activeIntValue = Long.parseLong(valueString.substring(0, spacePos));
                activeUnit = valueString.substring(spacePos + 1).trim();
            }
            catch (Exception e) {
                int msgID = 3342357;
                String message9 = MessageHandler.getMessage(msgID, valueString, a.getName(), String.valueOf(e));
                throw new ConfigException(msgID, message9);
            }
            if (!this.units.containsKey(activeUnit)) {
                int msgID = 0x330013;
                String message10 = MessageHandler.getMessage(msgID, activeUnit, a.getName());
                throw new ConfigException(msgID, message10);
            }
            multiplier = this.units.get(activeUnit);
            this.activeCalculatedValue = (long)(multiplier * (double)activeIntValue);
            if (this.hasLowerBound && this.activeCalculatedValue < this.lowerBound) {
                int msgID = 0x33000C;
                String message11 = MessageHandler.getMessage(msgID, a.getName(), this.activeCalculatedValue, this.lowerBound);
                throw new ConfigException(msgID, message11);
            }
            if (!this.hasUpperBound || this.activeCalculatedValue <= this.upperBound) continue;
            int msgID = 0x33000D;
            String message12 = MessageHandler.getMessage(msgID, a.getName(), this.activeCalculatedValue, this.upperBound);
            throw new ConfigException(msgID, message12);
        }
        if (activeUnit == null) {
            int msgID = 3342402;
            String message = MessageHandler.getMessage(msgID, this.getName());
            throw new ConfigException(msgID, message);
        }
        if (pendingUnit == null) {
            pendingIntValue = activeIntValue;
            pendingUnit = activeUnit;
        }
        return new IntegerWithUnitConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), this.units, this.hasLowerBound, this.lowerBound, this.hasUpperBound, this.upperBound, activeIntValue, activeUnit, pendingIntValue, pendingUnit);
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        return new javax.management.Attribute(this.getName(), this.activeIntValue + " " + this.activeUnit);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        return new javax.management.Attribute(this.getName() + ";" + "pending", this.pendingIntValue + " " + this.pendingUnit);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        String activeValue = this.activeIntValue + " " + this.activeUnit;
        attributeList.add(new javax.management.Attribute(this.getName(), activeValue));
        if (this.requiresAdminAction() && this.pendingCalculatedValue != this.activeCalculatedValue) {
            String name = this.getName() + ";" + "pending";
            String pendingValue = this.pendingIntValue + " " + this.pendingUnit;
            attributeList.add(new javax.management.Attribute(name, pendingValue));
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> attributeInfoList) {
        attributeInfoList.add(new MBeanAttributeInfo(this.getName(), String.class.getName(), this.getDescription(), true, true, false));
        if (this.requiresAdminAction()) {
            String name = this.getName() + ";" + "pending";
            attributeInfoList.add(new MBeanAttributeInfo(name, String.class.getName(), this.getDescription(), true, false, false));
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        return new MBeanParameterInfo(this.getName(), String.class.getName(), this.getDescription());
    }

    @Override
    public void setValue(javax.management.Attribute jmxAttribute) throws ConfigException {
        Object value = jmxAttribute.getValue();
        if (!(value instanceof String)) {
            int msgID = 3342408;
            String message = MessageHandler.getMessage(msgID, String.valueOf(value), this.getName(), value.getClass().getName());
            throw new ConfigException(msgID, message);
        }
        this.setValue((String)value);
    }

    @Override
    public ConfigAttribute duplicate() {
        return new IntegerWithUnitConfigAttribute(this.getName(), this.getDescription(), this.requiresAdminAction(), this.units, this.hasLowerBound, this.lowerBound, this.hasUpperBound, this.upperBound, this.activeIntValue, this.activeUnit, this.pendingIntValue, this.pendingUnit);
    }
}

