/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Long;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.StaticUtils;

public class EntryChangeNotificationControl
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN previousDN;
    private long changeNumber;
    private PersistentSearchChangeType changeType;

    public EntryChangeNotificationControl(PersistentSearchChangeType changeType, long changeNumber) {
        super("2.16.840.1.113730.3.4.7", false, EntryChangeNotificationControl.encodeValue(changeType, null, changeNumber));
        this.changeType = changeType;
        this.changeNumber = changeNumber;
        this.previousDN = null;
    }

    public EntryChangeNotificationControl(PersistentSearchChangeType changeType, DN previousDN, long changeNumber) {
        super("2.16.840.1.113730.3.4.7", false, EntryChangeNotificationControl.encodeValue(changeType, previousDN, changeNumber));
        this.changeType = changeType;
        this.previousDN = previousDN;
        this.changeNumber = changeNumber;
    }

    public EntryChangeNotificationControl(String oid, boolean isCritical, PersistentSearchChangeType changeType, DN previousDN, long changeNumber) {
        super(oid, isCritical, EntryChangeNotificationControl.encodeValue(changeType, previousDN, changeNumber));
        this.changeType = changeType;
        this.previousDN = previousDN;
        this.changeNumber = changeNumber;
    }

    private EntryChangeNotificationControl(String oid, boolean isCritical, PersistentSearchChangeType changeType, DN previousDN, long changeNumber, ASN1OctetString encodedValue) {
        super(oid, isCritical, encodedValue);
        this.changeType = changeType;
        this.previousDN = previousDN;
        this.changeNumber = changeNumber;
    }

    private static ASN1OctetString encodeValue(PersistentSearchChangeType changeType, DN previousDN, long changeNumber) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(new ASN1Enumerated(changeType.intValue()));
        if (previousDN != null) {
            elements.add(new ASN1OctetString(previousDN.toString()));
        }
        if (changeNumber > 0L) {
            elements.add(new ASN1Long(changeNumber));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EntryChangeNotificationControl decodeControl(Control control) throws LDAPException {
        if (!control.hasValue()) {
            int msgID = 2294068;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        DN previousDN = null;
        long changeNumber = -1L;
        try {
            ArrayList<ASN1Element> elements = ASN1Sequence.decodeAsSequence(control.getValue().value()).elements();
            if (elements.size() < 1 || elements.size() > 3) {
                int msgID = 2294069;
                String message = MessageHandler.getMessage(msgID, elements.size());
                throw new LDAPException(2, msgID, message);
            }
            int changeTypeValue = elements.get(0).decodeAsEnumerated().intValue();
            PersistentSearchChangeType changeType = PersistentSearchChangeType.valueOf(changeTypeValue);
            if (elements.size() == 2) {
                ASN1Element e = elements.get(1);
                if (e.getType() == 4) {
                    if (changeType != PersistentSearchChangeType.MODIFY_DN) {
                        int msgID = 2294070;
                        String message = MessageHandler.getMessage(msgID, String.valueOf((Object)changeType));
                        throw new LDAPException(2, msgID, message);
                    }
                    ASN1OctetString rawPreviousDN = e.decodeAsOctetString();
                    previousDN = DN.decode(rawPreviousDN);
                    return new EntryChangeNotificationControl(control.getOID(), control.isCritical(), changeType, previousDN, changeNumber, control.getValue());
                }
                if (e.getType() == 2) {
                    changeNumber = e.decodeAsLong().longValue();
                    return new EntryChangeNotificationControl(control.getOID(), control.isCritical(), changeType, previousDN, changeNumber, control.getValue());
                }
                int msgID = 2294071;
                String message = MessageHandler.getMessage(msgID, StaticUtils.byteToHex(e.getType()));
                throw new LDAPException(2, msgID, message);
            }
            if (elements.size() != 3) return new EntryChangeNotificationControl(control.getOID(), control.isCritical(), changeType, previousDN, changeNumber, control.getValue());
            if (changeType != PersistentSearchChangeType.MODIFY_DN) {
                int msgID = 2294070;
                String message = MessageHandler.getMessage(msgID, String.valueOf((Object)changeType));
                throw new LDAPException(2, msgID, message);
            }
            ASN1OctetString rawPreviousDN = elements.get(1).decodeAsOctetString();
            previousDN = DN.decode(rawPreviousDN);
            changeNumber = elements.get(2).decodeAsLong().longValue();
            return new EntryChangeNotificationControl(control.getOID(), control.isCritical(), changeType, previousDN, changeNumber, control.getValue());
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2294072;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, msgID, message, e);
        }
    }

    public PersistentSearchChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(PersistentSearchChangeType changeType) {
        this.changeType = changeType;
        this.setValue(EntryChangeNotificationControl.encodeValue(changeType, this.previousDN, this.changeNumber));
    }

    public DN getPreviousDN() {
        return this.previousDN;
    }

    public void setPreviousDN(DN previousDN) {
        this.previousDN = previousDN;
        this.setValue(EntryChangeNotificationControl.encodeValue(this.changeType, previousDN, this.changeNumber));
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public void setChangeNumber(long changeNumber) {
        this.changeNumber = changeNumber;
        this.setValue(EntryChangeNotificationControl.encodeValue(this.changeType, this.previousDN, changeNumber));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("EntryChangeNotificationControl(changeType=");
        buffer.append(this.changeType.toString());
        if (this.previousDN != null) {
            buffer.append(",previousDN=\"");
            buffer.append(this.previousDN.toString());
            buffer.append("\"");
        }
        if (this.changeNumber > 0L) {
            buffer.append(",changeNumber=");
            buffer.append(this.changeNumber);
        }
        buffer.append(")");
    }
}

