/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ObjectClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPPostReadRequestControl
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean returnAllOperationalAttrs;
    private boolean returnAllUserAttrs;
    private LinkedHashSet<String> rawAttributes;
    private LinkedHashSet<AttributeType> requestedAttributes;

    public LDAPPostReadRequestControl(boolean isCritical, LinkedHashSet<String> rawAttributes) {
        super("1.3.6.1.1.13.2", isCritical, LDAPPostReadRequestControl.encodeAttributes(rawAttributes));
        this.rawAttributes = rawAttributes == null ? new LinkedHashSet(0) : rawAttributes;
        this.requestedAttributes = null;
        this.returnAllOperationalAttrs = false;
        this.returnAllUserAttrs = false;
    }

    public LDAPPostReadRequestControl(String oid, boolean isCritical, LinkedHashSet<String> rawAttributes) {
        super(oid, isCritical, LDAPPostReadRequestControl.encodeAttributes(rawAttributes));
        this.rawAttributes = rawAttributes == null ? new LinkedHashSet(0) : rawAttributes;
        this.requestedAttributes = null;
        this.returnAllOperationalAttrs = false;
        this.returnAllUserAttrs = false;
    }

    private LDAPPostReadRequestControl(String oid, boolean isCritical, LinkedHashSet<String> rawAttributes, ASN1OctetString encodedValue) {
        super(oid, isCritical, encodedValue);
        this.rawAttributes = rawAttributes == null ? new LinkedHashSet(0) : rawAttributes;
        this.requestedAttributes = null;
        this.returnAllOperationalAttrs = false;
        this.returnAllUserAttrs = false;
    }

    public static LDAPPostReadRequestControl decodeControl(Control control) throws LDAPException {
        if (!control.hasValue()) {
            int msgID = 2294047;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        LinkedHashSet<String> rawAttributes = new LinkedHashSet<String>();
        try {
            ASN1Sequence attrSequence = ASN1Sequence.decodeAsSequence(control.getValue().value());
            for (ASN1Element e : attrSequence.elements()) {
                rawAttributes.add(e.decodeAsOctetString().stringValue());
            }
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            int msgID = 2294048;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            throw new LDAPException(2, msgID, message, ae);
        }
        return new LDAPPostReadRequestControl(control.getOID(), control.isCritical(), rawAttributes, control.getValue());
    }

    private static ASN1OctetString encodeAttributes(LinkedHashSet<String> rawAttributes) {
        if (rawAttributes == null) {
            return new ASN1OctetString(new ASN1Sequence().encode());
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(rawAttributes.size());
        for (String attr : rawAttributes) {
            elements.add(new ASN1OctetString(attr));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public LinkedHashSet<String> getRawAttributes() {
        return this.rawAttributes;
    }

    public void setRawAttributes(LinkedHashSet<String> rawAttributes) {
        this.rawAttributes = rawAttributes == null ? new LinkedHashSet() : rawAttributes;
        this.setValue(LDAPPostReadRequestControl.encodeAttributes(rawAttributes));
        this.requestedAttributes = null;
    }

    public LinkedHashSet<AttributeType> getRequestedAttributes() {
        if (this.requestedAttributes == null) {
            this.returnAllOperationalAttrs = false;
            this.returnAllUserAttrs = this.rawAttributes.size() == 0;
            this.requestedAttributes = new LinkedHashSet(this.rawAttributes.size());
            for (String attr : this.rawAttributes) {
                if ((attr = attr.toLowerCase()).equals("*")) {
                    this.returnAllUserAttrs = true;
                    continue;
                }
                if (attr.equals("+")) {
                    this.returnAllOperationalAttrs = true;
                    continue;
                }
                if (attr.startsWith("@")) {
                    String ocName = attr.substring(1);
                    ObjectClass oc = DirectoryServer.getObjectClass(ocName);
                    if (oc == null) continue;
                    this.requestedAttributes.addAll(oc.getOptionalAttributeChain());
                    this.requestedAttributes.addAll(oc.getRequiredAttributeChain());
                    continue;
                }
                AttributeType at = DirectoryServer.getAttributeType(attr);
                if (at == null) {
                    at = DirectoryServer.getDefaultAttributeType(attr);
                }
                this.requestedAttributes.add(at);
            }
        }
        return this.requestedAttributes;
    }

    public boolean returnAllUserAttributes() {
        if (this.requestedAttributes == null) {
            this.getRequestedAttributes();
        }
        return this.returnAllUserAttrs;
    }

    public boolean returnAllOperationalAttributes() {
        if (this.requestedAttributes == null) {
            this.getRequestedAttributes();
        }
        return this.returnAllOperationalAttrs;
    }

    public boolean allowsAttribute(AttributeType attrType) {
        if (this.requestedAttributes == null) {
            this.getRequestedAttributes();
        }
        if (this.requestedAttributes.contains(attrType)) {
            return true;
        }
        if (attrType.isOperational()) {
            return this.returnAllOperationalAttrs;
        }
        return this.returnAllUserAttrs;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPPostReadRequestControl(criticality=");
        buffer.append(this.isCritical());
        buffer.append(",attrs=\"");
        if (!this.rawAttributes.isEmpty()) {
            Iterator iterator = this.rawAttributes.iterator();
            buffer.append((String)iterator.next());
            while (iterator.hasNext()) {
                buffer.append(",");
                buffer.append((String)iterator.next());
            }
        }
        buffer.append("\")");
    }
}

