/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.SearchResultEntry;

public class LDAPPreReadResponseControl
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private SearchResultEntry searchEntry;

    public LDAPPreReadResponseControl(SearchResultEntry searchEntry) {
        super("1.3.6.1.1.13.1", false, LDAPPreReadResponseControl.encodeEntry(searchEntry));
        this.searchEntry = searchEntry;
    }

    public LDAPPreReadResponseControl(String oid, boolean isCritical, SearchResultEntry searchEntry) {
        super(oid, isCritical, LDAPPreReadResponseControl.encodeEntry(searchEntry));
        this.searchEntry = searchEntry;
    }

    private LDAPPreReadResponseControl(String oid, boolean isCritical, SearchResultEntry searchEntry, ASN1OctetString encodedValue) {
        super(oid, isCritical, encodedValue);
        this.searchEntry = searchEntry;
    }

    public static LDAPPreReadResponseControl decodeControl(Control control) throws LDAPException {
        SearchResultEntry searchEntry;
        if (!control.hasValue()) {
            int msgID = 2294049;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        ASN1OctetString controlValue = control.getValue();
        try {
            ASN1Element element = ASN1Element.decode(controlValue.value());
            SearchResultEntryProtocolOp searchResultEntryProtocolOp = SearchResultEntryProtocolOp.decodeSearchEntry(element);
            searchEntry = searchResultEntryProtocolOp.toSearchResultEntry();
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            int msgID = 2294050;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            throw new LDAPException(2, msgID, message, ae);
        }
        catch (LDAPException le) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            int msgID = 2294050;
            String message = MessageHandler.getMessage(msgID, le.getMessage());
            throw new LDAPException(2, msgID, message, le);
        }
        return new LDAPPreReadResponseControl(control.getOID(), control.isCritical(), searchEntry, controlValue);
    }

    private static ASN1OctetString encodeEntry(SearchResultEntry searchEntry) {
        SearchResultEntryProtocolOp protocolOp = new SearchResultEntryProtocolOp(searchEntry);
        return new ASN1OctetString(protocolOp.encode().encode());
    }

    public SearchResultEntry getSearchEntry() {
        return this.searchEntry;
    }

    public void setSearchEntry(SearchResultEntry searchEntry) {
        this.searchEntry = searchEntry;
        this.setValue(LDAPPreReadResponseControl.encodeEntry(searchEntry));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDAPPreReadResponseControl(criticality=");
        buffer.append(this.isCritical());
        buffer.append(",entry=");
        this.searchEntry.toSingleLineString(buffer);
        buffer.append(")");
    }
}

