/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;

public class PagedResultsControl
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private int size;
    private ASN1OctetString cookie;

    public PagedResultsControl(boolean isCritical, int size, ASN1OctetString cookie) {
        super("1.2.840.113556.1.4.319", isCritical);
        this.size = size;
        this.cookie = cookie;
        this.setValue(this.encode());
    }

    public PagedResultsControl(boolean isCritical, ASN1OctetString value) throws LDAPException {
        super("1.2.840.113556.1.4.319", isCritical, value);
        ArrayList<ASN1Element> elements;
        if (value == null) {
            int msgID = 2294038;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        try {
            ASN1Element sequence = ASN1Element.decode(value.value());
            elements = sequence.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2294039;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        int numElements = elements.size();
        if (numElements != 2) {
            int msgID = 2294040;
            String message = MessageHandler.getMessage(msgID, numElements);
            throw new LDAPException(2, msgID, message);
        }
        try {
            this.size = elements.get(0).decodeAsInteger().intValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2294041;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            this.cookie = elements.get(1).decodeAsOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2294042;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
    }

    public ASN1OctetString encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1Integer(this.size));
        elements.add(this.cookie);
        ASN1Sequence sequence = new ASN1Sequence(elements);
        return new ASN1OctetString(sequence.encode());
    }

    public int getSize() {
        return this.size;
    }

    public ASN1OctetString getCookie() {
        return this.cookie;
    }
}

