/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.StaticUtils;

public class PasswordExpiringControl
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private int secondsUntilExpiration;

    public PasswordExpiringControl(int secondsUntilExpiration) {
        super("2.16.840.1.113730.3.4.5", false, new ASN1OctetString(String.valueOf(secondsUntilExpiration)));
        this.secondsUntilExpiration = secondsUntilExpiration;
    }

    public PasswordExpiringControl(String oid, boolean isCritical, int secondsUntilExpiration) {
        super(oid, isCritical, new ASN1OctetString(String.valueOf(secondsUntilExpiration)));
        this.secondsUntilExpiration = secondsUntilExpiration;
    }

    private PasswordExpiringControl(String oid, boolean isCritical, int secondsUntilExpiration, ASN1OctetString encodedValue) {
        super(oid, isCritical, encodedValue);
        this.secondsUntilExpiration = secondsUntilExpiration;
    }

    public static PasswordExpiringControl decodeControl(Control control) throws LDAPException {
        int secondsUntilExpiration;
        if (!control.hasValue()) {
            int msgID = 2359639;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        try {
            secondsUntilExpiration = Integer.parseInt(control.getValue().stringValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2359640;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, msgID, message);
        }
        return new PasswordExpiringControl(control.getOID(), control.isCritical(), secondsUntilExpiration, control.getValue());
    }

    public int getSecondsUntilExpiration() {
        return this.secondsUntilExpiration;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("PasswordExpiringControl(secondsUntilExpiration=");
        buffer.append(this.secondsUntilExpiration);
        buffer.append(")");
    }
}

