/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.StaticUtils;

public class PasswordPolicyResponseControl
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final byte TYPE_WARNING_ELEMENT = -96;
    public static final byte TYPE_ERROR_ELEMENT = -127;
    private int warningValue;
    private PasswordPolicyErrorType errorType;
    private PasswordPolicyWarningType warningType;

    public PasswordPolicyResponseControl() {
        super("1.3.6.1.4.1.42.2.27.8.5.1", false, PasswordPolicyResponseControl.encodeValue(null, -1, null));
        this.warningType = null;
        this.errorType = null;
        this.warningValue = -1;
    }

    public PasswordPolicyResponseControl(PasswordPolicyWarningType warningType, int warningValue, PasswordPolicyErrorType errorType) {
        super("1.3.6.1.4.1.42.2.27.8.5.1", false, PasswordPolicyResponseControl.encodeValue(warningType, warningValue, errorType));
        this.warningType = warningType;
        this.warningValue = warningValue;
        this.errorType = errorType;
    }

    public PasswordPolicyResponseControl(String oid, boolean isCritical, PasswordPolicyWarningType warningType, int warningValue, PasswordPolicyErrorType errorType) {
        super(oid, isCritical, PasswordPolicyResponseControl.encodeValue(warningType, warningValue, errorType));
        this.warningType = warningType;
        this.warningValue = warningValue;
        this.errorType = errorType;
    }

    private PasswordPolicyResponseControl(String oid, boolean isCritical, PasswordPolicyWarningType warningType, int warningValue, PasswordPolicyErrorType errorType, ASN1OctetString encodedValue) {
        super(oid, isCritical, encodedValue);
        this.warningType = warningType;
        this.warningValue = warningValue;
        this.errorType = errorType;
    }

    private static ASN1OctetString encodeValue(PasswordPolicyWarningType warningType, int warningValue, PasswordPolicyErrorType errorType) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        if (warningType != null) {
            ASN1Integer warningInteger = new ASN1Integer(warningType.getType(), warningValue);
            elements.add(new ASN1Element(-96, warningInteger.encode()));
        }
        if (errorType != null) {
            elements.add(new ASN1Enumerated(-127, errorType.intValue()));
        }
        ASN1Sequence valueSequence = new ASN1Sequence(elements);
        return new ASN1OctetString(valueSequence.encode());
    }

    public static PasswordPolicyResponseControl decodeControl(Control control) throws LDAPException {
        ASN1OctetString controlValue = control.getValue();
        if (controlValue == null) {
            int msgID = 2359651;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        try {
            PasswordPolicyWarningType warningType = null;
            PasswordPolicyErrorType errorType = null;
            int warningValue = -1;
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(controlValue.value());
            block8: for (ASN1Element e : valueSequence.elements()) {
                switch (e.getType()) {
                    case -96: {
                        ASN1Integer integerElement = ASN1Integer.decodeAsInteger(e.value());
                        warningValue = integerElement.intValue();
                        warningType = PasswordPolicyWarningType.valueOf(integerElement.getType());
                        if (warningType != null) continue block8;
                        int msgID = 2359652;
                        String message = MessageHandler.getMessage(msgID, StaticUtils.byteToHex(integerElement.getType()));
                        throw new LDAPException(2, msgID, message);
                    }
                    case -127: {
                        int errorValue = e.decodeAsEnumerated().intValue();
                        errorType = PasswordPolicyErrorType.valueOf(errorValue);
                        if (errorType != null) continue block8;
                        int msgID = 2359653;
                        String message = MessageHandler.getMessage(msgID, errorValue);
                        throw new LDAPException(2, msgID, message);
                    }
                }
                int msgID = 2359654;
                String message = MessageHandler.getMessage(msgID, StaticUtils.byteToHex(e.getType()));
                throw new LDAPException(2, msgID, message);
            }
            return new PasswordPolicyResponseControl(control.getOID(), control.isCritical(), warningType, warningValue, errorType, controlValue);
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            int msgID = 2359655;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            throw new LDAPException(2, msgID, message);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2359655;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, msgID, message);
        }
    }

    public PasswordPolicyWarningType getWarningType() {
        return this.warningType;
    }

    public int getWarningValue() {
        return this.warningValue;
    }

    public PasswordPolicyErrorType getErrorType() {
        return this.errorType;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("PasswordPolicyResponseControl(");
        if (this.warningType != null) {
            buffer.append(this.warningType.toString());
            buffer.append("=");
            buffer.append(this.warningValue);
            if (this.errorType != null) {
                buffer.append(", ");
            }
        }
        if (this.errorType != null) {
            buffer.append(this.errorType.toString());
        }
        buffer.append(")");
    }
}

