/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import java.util.Set;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSearchControl
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean changesOnly;
    private boolean returnECs;
    private Set<PersistentSearchChangeType> changeTypes;

    public PersistentSearchControl(Set<PersistentSearchChangeType> changeTypes, boolean changesOnly, boolean returnECs) {
        super("2.16.840.1.113730.3.4.3", true, PersistentSearchControl.encodeValue(changeTypes, changesOnly, returnECs));
        this.changeTypes = changeTypes;
        this.changesOnly = changesOnly;
        this.returnECs = returnECs;
    }

    public PersistentSearchControl(String oid, boolean isCritical, Set<PersistentSearchChangeType> changeTypes, boolean changesOnly, boolean returnECs) {
        super(oid, isCritical, PersistentSearchControl.encodeValue(changeTypes, changesOnly, returnECs));
        this.changeTypes = changeTypes;
        this.changesOnly = changesOnly;
        this.returnECs = returnECs;
    }

    private PersistentSearchControl(String oid, boolean isCritical, Set<PersistentSearchChangeType> changeTypes, boolean changesOnly, boolean returnECs, ASN1OctetString encodedValue) {
        super(oid, isCritical, encodedValue);
        this.changeTypes = changeTypes;
        this.changesOnly = changesOnly;
        this.returnECs = returnECs;
    }

    private static ASN1OctetString encodeValue(Set<PersistentSearchChangeType> changeTypes, boolean changesOnly, boolean returnECs) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(new ASN1Integer(PersistentSearchChangeType.changeTypesToInt(changeTypes)));
        elements.add(new ASN1Boolean(changesOnly));
        elements.add(new ASN1Boolean(returnECs));
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public static PersistentSearchControl decodeControl(Control control) throws LDAPException {
        boolean returnECs;
        boolean changesOnly;
        Set<PersistentSearchChangeType> changeTypes;
        if (!control.hasValue()) {
            int msgID = 2294065;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        try {
            ArrayList<ASN1Element> elements = ASN1Sequence.decodeAsSequence(control.getValue().value()).elements();
            if (elements.size() != 3) {
                int msgID = 2294066;
                String message = MessageHandler.getMessage(msgID, elements.size());
                throw new LDAPException(2, msgID, message);
            }
            int changeTypesValue = elements.get(0).decodeAsInteger().intValue();
            changeTypes = PersistentSearchChangeType.intToTypes(changeTypesValue);
            changesOnly = elements.get(1).decodeAsBoolean().booleanValue();
            returnECs = elements.get(2).decodeAsBoolean().booleanValue();
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2294067;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new PersistentSearchControl(control.getOID(), control.isCritical(), changeTypes, changesOnly, returnECs, control.getValue());
    }

    public Set<PersistentSearchChangeType> getChangeTypes() {
        return this.changeTypes;
    }

    public void setChangeTypes(Set<PersistentSearchChangeType> changeTypes) {
        this.changeTypes = changeTypes;
        this.setValue(PersistentSearchControl.encodeValue(changeTypes, this.changesOnly, this.returnECs));
    }

    public boolean getChangesOnly() {
        return this.changesOnly;
    }

    public void setChangesOnly(boolean changesOnly) {
        this.changesOnly = changesOnly;
        this.setValue(PersistentSearchControl.encodeValue(this.changeTypes, changesOnly, this.returnECs));
    }

    public boolean getReturnECs() {
        return this.returnECs;
    }

    public void setReturnECs(boolean returnECs) {
        this.returnECs = returnECs;
        this.setValue(PersistentSearchControl.encodeValue(this.changeTypes, this.changesOnly, returnECs));
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("PersistentSearchControl(changeTypes=\"");
        PersistentSearchChangeType.changeTypesToString(this.changeTypes, buffer);
        buffer.append("\",changesOnly=");
        buffer.append(this.changesOnly);
        buffer.append(",returnECs=");
        buffer.append(this.returnECs);
        buffer.append(")");
    }
}

