/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.NetworkGroup;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.Workflow;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostResponseDeleteOperation;
import org.opends.server.types.operation.PreParseDeleteOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendDeleteOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteOperationBasis
extends AbstractOperation
implements PreParseDeleteOperation,
DeleteOperation,
PostResponseDeleteOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString rawEntryDN;
    private CancelRequest cancelRequest;
    private DN entryDN;
    private DN proxiedAuthorizationDN;
    private List<Control> responseControls;
    private long changeNumber;

    public DeleteOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, ByteString rawEntryDN) {
        super(clientConnection, operationID, messageID, requestControls);
        this.rawEntryDN = rawEntryDN;
        this.entryDN = null;
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.changeNumber = -1L;
    }

    public DeleteOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, DN entryDN) {
        super(clientConnection, operationID, messageID, requestControls);
        this.entryDN = entryDN;
        this.rawEntryDN = new ASN1OctetString(entryDN.toString());
        this.responseControls = new ArrayList<Control>();
        this.cancelRequest = null;
        this.changeNumber = -1L;
    }

    @Override
    public final ByteString getRawEntryDN() {
        return this.rawEntryDN;
    }

    @Override
    public final void setRawEntryDN(ByteString rawEntryDN) {
        this.rawEntryDN = rawEntryDN;
        this.entryDN = null;
    }

    @Override
    public final DN getEntryDN() {
        try {
            if (this.entryDN == null) {
                this.entryDN = DN.decode(this.rawEntryDN);
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResultCode(de.getResultCode());
            this.appendErrorMessage(de.getErrorMessage());
            this.setMatchedDN(de.getMatchedDN());
            this.setReferralURLs(de.getReferralURLs());
        }
        return this.entryDN;
    }

    @Override
    public final long getChangeNumber() {
        return this.changeNumber;
    }

    @Override
    public final void setChangeNumber(long changeNumber) {
        this.changeNumber = changeNumber;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.DELETE;
    }

    @Override
    public final void disconnectClient(DisconnectReason disconnectReason, boolean sendNotification, String message, int messageID) {
        this.setCancelResult(CancelResult.CANCELED);
        this.clientConnection.disconnect(disconnectReason, sendNotification, message, messageID);
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"entryDN", String.valueOf(this.rawEntryDN)}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        StringBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"processingTime", processingTime}};
    }

    @Override
    public DN getProxiedAuthorizationDN() {
        return this.proxiedAuthorizationDN;
    }

    @Override
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    @Override
    public final CancelResult cancel(CancelRequest cancelRequest) {
        this.cancelRequest = cancelRequest;
        CancelResult cancelResult = this.getCancelResult();
        long stopWaitingTime = System.currentTimeMillis() + 5000L;
        while (cancelResult == null && System.currentTimeMillis() < stopWaitingTime) {
            block4: {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            cancelResult = this.getCancelResult();
        }
        if (cancelResult == null) {
            cancelResult = CancelResult.CANNOT_CANCEL;
        }
        return cancelResult;
    }

    @Override
    public final CancelRequest getCancelRequest() {
        return this.cancelRequest;
    }

    @Override
    public boolean setCancelRequest(CancelRequest cancelRequest) {
        this.cancelRequest = cancelRequest;
        return true;
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("DeleteOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", dn=");
        buffer.append(this.rawEntryDN);
        buffer.append(")");
    }

    @Override
    public void setProxiedAuthorizationDN(DN proxiedAuthorizationDN) {
        this.proxiedAuthorizationDN = proxiedAuthorizationDN;
    }

    @Override
    public final void run() {
        this.setResultCode(ResultCode.UNDEFINED);
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        this.setProcessingStartTime();
        if (this.cancelRequest != null) {
            this.indicateCancelled(this.cancelRequest);
            this.setProcessingStopTime();
            return;
        }
        boolean workflowExecuted = false;
        PreParsePluginResult preParseResult = pluginConfigManager.invokePreParseDeletePlugins(this);
        if (preParseResult.connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            int msgID = 262368;
            this.appendErrorMessage(MessageHandler.getMessage(msgID));
            this.setProcessingStopTime();
            AccessLogger.logDeleteRequest(this);
            AccessLogger.logDeleteResponse(this);
            pluginConfigManager.invokePostResponseDeletePlugins(this);
            return;
        }
        if (preParseResult.sendResponseImmediately()) {
            AccessLogger.logDeleteRequest(this);
        } else if (!preParseResult.skipCoreProcessing()) {
            DN entryDN;
            AccessLogger.logDeleteRequest(this);
            if (this.cancelRequest == null && (entryDN = this.getEntryDN()) != null) {
                NetworkGroup ng = this.getClientConnection().getNetworkGroup();
                Workflow workflow = ng.getWorkflowCandidate(entryDN);
                if (workflow == null) {
                    this.updateOperationErrMsgAndResCode();
                } else {
                    workflow.execute(this);
                    workflowExecuted = true;
                }
            }
        }
        if (this.getCancelResult() == CancelResult.CANCELED) {
            this.setProcessingStopTime();
            AccessLogger.logDeleteResponse(this);
            return;
        }
        if (this.cancelRequest != null) {
            this.indicateCancelled(this.cancelRequest);
            this.setProcessingStopTime();
            AccessLogger.logDeleteResponse(this);
            this.invokePostResponsePlugins(workflowExecuted);
            return;
        }
        this.setCancelResult(CancelResult.TOO_LATE);
        this.setProcessingStopTime();
        this.getClientConnection().sendResponse(this);
        AccessLogger.logDeleteResponse(this);
        this.notifyPersistentSearches(workflowExecuted);
        this.invokePostResponsePlugins(workflowExecuted);
    }

    private void invokePostResponsePlugins(boolean workflowExecuted) {
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        if (workflowExecuted) {
            List localOperations = (List)this.getAttachment("LocalBackendOperations");
            if (localOperations != null) {
                for (Object localOp : localOperations) {
                    LocalBackendDeleteOperation localOperation = (LocalBackendDeleteOperation)localOp;
                    pluginConfigManager.invokePostResponseDeletePlugins(localOperation);
                }
            }
        } else {
            pluginConfigManager.invokePostResponseDeletePlugins(this);
        }
    }

    private void notifyPersistentSearches(boolean workflowExecuted) {
        if (!workflowExecuted) {
            return;
        }
        List localOperations = (List)this.getAttachment("LocalBackendOperations");
        if (localOperations != null) {
            for (Object localOp : localOperations) {
                LocalBackendDeleteOperation localOperation = (LocalBackendDeleteOperation)localOp;
                if (this.getResultCode() != ResultCode.SUCCESS) continue;
                for (PersistentSearch persistentSearch : DirectoryServer.getPersistentSearches()) {
                    try {
                        persistentSearch.processDelete(localOperation, localOperation.getEntryToDelete());
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        int msgID = 262533;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(persistentSearch), StaticUtils.getExceptionMessage(e));
                        ErrorLogger.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                        DirectoryServer.deregisterPersistentSearch(persistentSearch);
                    }
                }
            }
        }
    }

    private void updateOperationErrMsgAndResCode() {
        this.setResultCode(ResultCode.NO_SUCH_OBJECT);
        this.appendErrorMessage(MessageHandler.getMessage(196849, String.valueOf(this.getEntryDN())));
    }

    @Override
    public Entry getEntryToDelete() {
        return null;
    }
}

