/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.ApproximateMatchingRuleCfgDefn;
import org.opends.server.admin.std.meta.EqualityMatchingRuleCfgDefn;
import org.opends.server.admin.std.meta.OrderingMatchingRuleCfgDefn;
import org.opends.server.admin.std.meta.SubstringMatchingRuleCfgDefn;
import org.opends.server.admin.std.server.ApproximateMatchingRuleCfg;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.admin.std.server.MatchingRuleCfg;
import org.opends.server.admin.std.server.OrderingMatchingRuleCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.SubstringMatchingRuleCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingRuleConfigManager
implements ConfigurationChangeListener<MatchingRuleCfg>,
ConfigurationAddListener<MatchingRuleCfg>,
ConfigurationDeleteListener<MatchingRuleCfg> {
    private ConcurrentHashMap<DN, MatchingRule> matchingRules = new ConcurrentHashMap();

    public void initializeMatchingRules() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addMatchingRuleAddListener(this);
        rootConfiguration.addMatchingRuleDeleteListener(this);
        for (String name : rootConfiguration.listMatchingRules()) {
            MatchingRuleCfg mrConfiguration = rootConfiguration.getMatchingRule(name);
            mrConfiguration.addChangeListener(this);
            if (!mrConfiguration.isEnabled()) continue;
            String className = mrConfiguration.getMatchingRuleClass();
            try {
                MatchingRule matchingRule = this.loadMatchingRule(className, mrConfiguration, true);
                try {
                    DirectoryServer.registerMatchingRule(matchingRule, false);
                    this.matchingRules.put(mrConfiguration.dn(), matchingRule);
                }
                catch (DirectoryException de) {
                    int msgID = 3276973;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(mrConfiguration.dn()), de.getErrorMessage());
                    ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                }
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, ie.getMessage(), ie.getMessageID());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(MatchingRuleCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getMatchingRuleClass();
            try {
                this.loadMatchingRule(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(MatchingRuleCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        MatchingRule matchingRule = null;
        String className = configuration.getMatchingRuleClass();
        try {
            matchingRule = this.loadMatchingRule(className, configuration, true);
            try {
                DirectoryServer.registerMatchingRule(matchingRule, false);
                this.matchingRules.put(configuration.dn(), matchingRule);
            }
            catch (DirectoryException de) {
                int msgID = 3276973;
                String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), de.getErrorMessage());
                messages.add(message);
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessage());
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(MatchingRuleCfg configuration, List<String> unacceptableReasons) {
        boolean configAcceptable = true;
        MatchingRule matchingRule = this.matchingRules.get(configuration.dn());
        if (matchingRule != null) {
            String oid = matchingRule.getOID();
            for (AttributeType at : DirectoryServer.getAttributeTypes().values()) {
                ApproximateMatchingRule amr = at.getApproximateMatchingRule();
                if (amr != null && oid.equals(amr.getOID())) {
                    int msgID = 3277470;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getName(), at.getNameOrOID());
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                    continue;
                }
                EqualityMatchingRule emr = at.getEqualityMatchingRule();
                if (emr != null && oid.equals(emr.getOID())) {
                    int msgID = 3277470;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getName(), at.getNameOrOID());
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                    continue;
                }
                OrderingMatchingRule omr = at.getOrderingMatchingRule();
                if (omr != null && oid.equals(omr.getOID())) {
                    int msgID = 3277470;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getName(), at.getNameOrOID());
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                    continue;
                }
                SubstringMatchingRule smr = at.getSubstringMatchingRule();
                if (smr == null || !oid.equals(smr.getOID())) continue;
                int msgID = 3277470;
                String message = MessageHandler.getMessage(msgID, matchingRule.getName(), at.getNameOrOID());
                unacceptableReasons.add(message);
                configAcceptable = false;
            }
            for (MatchingRuleUse mru : DirectoryServer.getMatchingRuleUses().values()) {
                if (!oid.equals(mru.getMatchingRule().getOID())) continue;
                int msgID = 3277471;
                String message = MessageHandler.getMessage(msgID, matchingRule.getName(), mru.getName());
                unacceptableReasons.add(message);
                configAcceptable = false;
            }
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(MatchingRuleCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        MatchingRule matchingRule = this.matchingRules.remove(configuration.dn());
        if (matchingRule != null) {
            DirectoryServer.deregisterMatchingRule(matchingRule);
            matchingRule.finalizeMatchingRule();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(MatchingRuleCfg configuration, List<String> unacceptableReasons) {
        boolean configAcceptable = true;
        if (configuration.isEnabled()) {
            String className = configuration.getMatchingRuleClass();
            try {
                this.loadMatchingRule(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessage());
                configAcceptable = false;
            }
        } else {
            MatchingRule matchingRule = this.matchingRules.get(configuration.dn());
            if (matchingRule != null) {
                String oid = matchingRule.getOID();
                for (AttributeType at : DirectoryServer.getAttributeTypes().values()) {
                    ApproximateMatchingRule amr = at.getApproximateMatchingRule();
                    if (amr != null && oid.equals(amr.getOID())) {
                        int msgID = 3277472;
                        String message = MessageHandler.getMessage(msgID, matchingRule.getName(), at.getNameOrOID());
                        unacceptableReasons.add(message);
                        configAcceptable = false;
                        continue;
                    }
                    EqualityMatchingRule emr = at.getEqualityMatchingRule();
                    if (emr != null && oid.equals(emr.getOID())) {
                        int msgID = 3277472;
                        String message = MessageHandler.getMessage(msgID, matchingRule.getName(), at.getNameOrOID());
                        unacceptableReasons.add(message);
                        configAcceptable = false;
                        continue;
                    }
                    OrderingMatchingRule omr = at.getOrderingMatchingRule();
                    if (omr != null && oid.equals(omr.getOID())) {
                        int msgID = 3277472;
                        String message = MessageHandler.getMessage(msgID, matchingRule.getName(), at.getNameOrOID());
                        unacceptableReasons.add(message);
                        configAcceptable = false;
                        continue;
                    }
                    SubstringMatchingRule smr = at.getSubstringMatchingRule();
                    if (smr == null || !oid.equals(smr.getOID())) continue;
                    int msgID = 3277472;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getName(), at.getNameOrOID());
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                }
                for (MatchingRuleUse mru : DirectoryServer.getMatchingRuleUses().values()) {
                    if (!oid.equals(mru.getMatchingRule().getOID())) continue;
                    int msgID = 3277473;
                    String message = MessageHandler.getMessage(msgID, matchingRule.getName(), mru.getName());
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                }
            }
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(MatchingRuleCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        MatchingRule existingRule = this.matchingRules.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingRule != null) {
                DirectoryServer.deregisterMatchingRule(existingRule);
                MatchingRule rule = this.matchingRules.remove(configuration.dn());
                if (rule != null) {
                    rule.finalizeMatchingRule();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getMatchingRuleClass();
        if (existingRule != null) {
            if (!className.equals(existingRule.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        MatchingRule matchingRule = null;
        try {
            matchingRule = this.loadMatchingRule(className, configuration, true);
            try {
                DirectoryServer.registerMatchingRule(matchingRule, false);
                this.matchingRules.put(configuration.dn(), matchingRule);
            }
            catch (DirectoryException de) {
                int msgID = 3276973;
                String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), de.getErrorMessage());
                messages.add(message);
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessage());
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private MatchingRule loadMatchingRule(String className, MatchingRuleCfg configuration, boolean initialize) throws InitializationException {
        try {
            Method method;
            ClassPropertyDefinition propertyDefinition;
            ManagedObjectDefinition definition;
            MatchingRule matchingRule = null;
            if (configuration instanceof ApproximateMatchingRuleCfg) {
                definition = ApproximateMatchingRuleCfgDefn.getInstance();
                propertyDefinition = ((ApproximateMatchingRuleCfgDefn)definition).getMatchingRuleClassPropertyDefinition();
                Class<ApproximateMatchingRule> approximateMatchingRuleClass = propertyDefinition.loadClass(className, ApproximateMatchingRule.class);
                matchingRule = approximateMatchingRuleClass.newInstance();
            } else if (configuration instanceof EqualityMatchingRuleCfg) {
                definition = EqualityMatchingRuleCfgDefn.getInstance();
                propertyDefinition = ((EqualityMatchingRuleCfgDefn)definition).getMatchingRuleClassPropertyDefinition();
                Class<EqualityMatchingRule> equalityMatchingRuleClass = propertyDefinition.loadClass(className, EqualityMatchingRule.class);
                matchingRule = equalityMatchingRuleClass.newInstance();
            } else if (configuration instanceof OrderingMatchingRuleCfg) {
                definition = OrderingMatchingRuleCfgDefn.getInstance();
                propertyDefinition = ((OrderingMatchingRuleCfgDefn)definition).getMatchingRuleClassPropertyDefinition();
                Class<OrderingMatchingRule> orderingMatchingRuleClass = propertyDefinition.loadClass(className, OrderingMatchingRule.class);
                matchingRule = orderingMatchingRuleClass.newInstance();
            } else if (configuration instanceof SubstringMatchingRuleCfg) {
                definition = SubstringMatchingRuleCfgDefn.getInstance();
                propertyDefinition = ((SubstringMatchingRuleCfgDefn)definition).getMatchingRuleClassPropertyDefinition();
                Class<SubstringMatchingRule> substringMatchingRuleClass = propertyDefinition.loadClass(className, SubstringMatchingRule.class);
                matchingRule = substringMatchingRuleClass.newInstance();
            } else {
                throw new AssertionError((Object)("Unsupported matching rule type:  " + className + " with config type " + configuration.getClass().getName()));
            }
            if (initialize) {
                method = matchingRule.getClass().getMethod("initializeMatchingRule", configuration.definition().getServerConfigurationClass());
                method.invoke((Object)matchingRule, configuration);
            } else {
                method = matchingRule.getClass().getMethod("isConfigurationAcceptable", MatchingRuleCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)matchingRule, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((String)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((String)iterator.next());
                        }
                    }
                    int msgID = 3343024;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(msgID, message);
                }
            }
            return matchingRule;
        }
        catch (Exception e) {
            int msgID = 3408044;
            String message = MessageHandler.getMessage(msgID, className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(msgID, message, e);
        }
    }
}

