/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.SynchronizationProviderCfgDefn;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizationProviderConfigManager
implements ConfigurationChangeListener<SynchronizationProviderCfg>,
ConfigurationAddListener<SynchronizationProviderCfg>,
ConfigurationDeleteListener<SynchronizationProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConcurrentHashMap<DN, SynchronizationProvider<SynchronizationProviderCfg>> registeredProviders = new ConcurrentHashMap();

    public void initializeSynchronizationProviders() throws ConfigException, InitializationException {
        ServerManagementContext context = ServerManagementContext.getInstance();
        RootCfg root = context.getRootConfiguration();
        root.addSynchronizationProviderAddListener(this);
        root.addSynchronizationProviderDeleteListener(this);
        for (String name : root.listSynchronizationProviders()) {
            SynchronizationProviderCfg config = root.getSynchronizationProvider(name);
            config.addChangeListener(this);
            if (!config.isEnabled()) continue;
            SynchronizationProvider<SynchronizationProviderCfg> provider = this.getSynchronizationProvider(config);
            DirectoryServer.registerSynchronizationProvider(provider);
            this.registeredProviders.put(config.dn(), provider);
        }
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SynchronizationProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        DN dn = configuration.dn();
        SynchronizationProvider<SynchronizationProviderCfg> provider = this.registeredProviders.get(dn);
        if (provider == null) {
            if (configuration.isEnabled()) {
                try {
                    provider = this.getSynchronizationProvider(configuration);
                    DirectoryServer.registerSynchronizationProvider(provider);
                    this.registeredProviders.put(configuration.dn(), provider);
                }
                catch (ConfigException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        messages.add(e.getMessage());
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    int msgID = 3473873;
                    messages.add(MessageHandler.getMessage(msgID, String.valueOf(configuration.getJavaImplementationClass()), String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        } else if (configuration.isEnabled()) {
            String className = configuration.getJavaImplementationClass();
            if (!className.equals(provider.getClass().getName())) {
                adminActionRequired = true;
            }
        } else {
            DirectoryServer.deregisterSynchronizationProvider(provider);
            provider.finalizeSynchronizationProvider();
            this.registeredProviders.remove(dn);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SynchronizationProviderCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            return this.isJavaClassAcceptable(configuration, unacceptableReasons);
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(SynchronizationProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<String> messages = new ArrayList<String>();
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            try {
                SynchronizationProvider<SynchronizationProviderCfg> provider = this.getSynchronizationProvider(configuration);
                DirectoryServer.registerSynchronizationProvider(provider);
                this.registeredProviders.put(configuration.dn(), provider);
            }
            catch (ConfigException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    messages.add(e.getMessage());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 3473873;
                messages.add(MessageHandler.getMessage(msgID, String.valueOf(configuration.getJavaImplementationClass()), String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e)));
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationAddAcceptable(SynchronizationProviderCfg configuration, List<String> unacceptableReasons) {
        if (configuration.isEnabled()) {
            return this.isJavaClassAcceptable(configuration, unacceptableReasons);
        }
        return true;
    }

    private SynchronizationProvider<SynchronizationProviderCfg> getSynchronizationProvider(SynchronizationProviderCfg configuration) throws ConfigException {
        SynchronizationProvider provider;
        Class<SynchronizationProvider> theClass;
        String className = configuration.getJavaImplementationClass();
        SynchronizationProviderCfgDefn d = SynchronizationProviderCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaImplementationClassPropertyDefinition();
        try {
            theClass = pd.loadClass(className, SynchronizationProvider.class);
        }
        catch (Exception e) {
            int msgID = 3473871;
            String message = MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(msgID, message, e);
        }
        try {
            provider = theClass.newInstance();
        }
        catch (Exception e) {
            int msgID = 3473872;
            String message = MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(msgID, message, e);
        }
        try {
            provider.initializeSynchronizationProvider(configuration);
        }
        catch (Exception e) {
            int msgID = 3473873;
            String message = MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(msgID, message, e);
        }
        return provider;
    }

    private boolean isJavaClassAcceptable(SynchronizationProviderCfg configuration, List<String> unacceptableReasons) {
        Class<SynchronizationProvider> theClass;
        String className = configuration.getJavaImplementationClass();
        SynchronizationProviderCfgDefn d = SynchronizationProviderCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaImplementationClassPropertyDefinition();
        SynchronizationProvider provider = null;
        try {
            theClass = pd.loadClass(className, SynchronizationProvider.class);
            provider = theClass.newInstance();
        }
        catch (Exception e) {
            int msgID = 3473871;
            String message = MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            unacceptableReasons.add(message);
            return false;
        }
        try {
            Method method = theClass.getMethod("isConfigurationAcceptable", SynchronizationProviderCfg.class, List.class);
            Boolean acceptable = (Boolean)method.invoke((Object)provider, configuration, unacceptableReasons);
            if (!acceptable.booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            int msgID = 3473872;
            String message = MessageHandler.getMessage(msgID, String.valueOf(className), String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(SynchronizationProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        DN dn = configuration.dn();
        SynchronizationProvider<SynchronizationProviderCfg> provider = this.registeredProviders.get(dn);
        if (provider != null) {
            DirectoryServer.deregisterSynchronizationProvider(provider);
            provider.finalizeSynchronizationProvider();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(SynchronizationProviderCfg configuration, List<String> unacceptableReasons) {
        return true;
    }
}

